/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.client.AbstractClientScanner;
import org.apache.hadoop.hbase.client.HConnection;
import org.apache.hadoop.hbase.client.HConnectionManager;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.ScannerCallable;
import org.apache.hadoop.hbase.client.ScannerTimeoutException;
import org.apache.hadoop.hbase.client.metrics.ScanMetrics;
import org.apache.hadoop.hbase.exceptions.DoNotRetryIOException;
import org.apache.hadoop.hbase.exceptions.NotServingRegionException;
import org.apache.hadoop.hbase.exceptions.OutOfOrderScannerNextException;
import org.apache.hadoop.hbase.exceptions.RegionServerStoppedException;
import org.apache.hadoop.hbase.exceptions.UnknownScannerException;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.generated.MapReduceProtos;
import org.apache.hadoop.hbase.util.Bytes;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class ClientScanner
extends AbstractClientScanner {
    private final Log LOG = LogFactory.getLog(this.getClass());
    private Scan scan;
    private boolean closed = false;
    private HRegionInfo currentRegion = null;
    private ScannerCallable callable = null;
    private final LinkedList<Result> cache = new LinkedList();
    private final int caching;
    private long lastNext;
    private Result lastResult = null;
    private ScanMetrics scanMetrics = null;
    private final long maxScannerResultSize;
    private final HConnection connection;
    private final byte[] tableName;
    private final int scannerTimeout;
    private boolean scanMetricsPublished = false;

    public ClientScanner(Configuration conf, Scan scan, byte[] tableName) throws IOException {
        this(conf, scan, tableName, HConnectionManager.getConnection(conf));
    }

    public ClientScanner(Configuration conf, Scan scan, byte[] tableName, HConnection connection) throws IOException {
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug((Object)("Scan table=" + Bytes.toString((byte[])tableName) + ", startRow=" + Bytes.toStringBinary((byte[])scan.getStartRow())));
        }
        this.scan = scan;
        this.tableName = tableName;
        this.lastNext = System.currentTimeMillis();
        this.connection = connection;
        this.maxScannerResultSize = scan.getMaxResultSize() > 0L ? scan.getMaxResultSize() : conf.getLong(HConstants.HBASE_CLIENT_SCANNER_MAX_RESULT_SIZE_KEY, HConstants.DEFAULT_HBASE_CLIENT_SCANNER_MAX_RESULT_SIZE);
        this.scannerTimeout = conf.getInt(HConstants.HBASE_CLIENT_SCANNER_TIMEOUT_PERIOD, HConstants.DEFAULT_HBASE_CLIENT_SCANNER_TIMEOUT_PERIOD);
        byte[] enableMetrics = scan.getAttribute("scan.attributes.metrics.enable");
        if (enableMetrics != null && Bytes.toBoolean((byte[])enableMetrics)) {
            this.scanMetrics = new ScanMetrics();
        }
        this.caching = this.scan.getCaching() > 0 ? this.scan.getCaching() : conf.getInt(HConstants.HBASE_CLIENT_SCANNER_CACHING, HConstants.DEFAULT_HBASE_CLIENT_SCANNER_CACHING);
        this.nextScanner(false);
    }

    protected HConnection getConnection() {
        return this.connection;
    }

    protected byte[] getTableName() {
        return this.tableName;
    }

    protected Scan getScan() {
        return this.scan;
    }

    protected long getTimestamp() {
        return this.lastNext;
    }

    private boolean checkScanStopRow(byte[] endKey) {
        byte[] stopRow;
        int cmp;
        return this.scan.getStopRow().length > 0 && (cmp = Bytes.compareTo((byte[])(stopRow = this.scan.getStopRow()), (int)0, (int)stopRow.length, (byte[])endKey, (int)0, (int)endKey.length)) <= 0;
    }

    private boolean nextScanner(boolean done) throws IOException {
        byte[] localStartKey;
        if (this.callable != null) {
            this.callable.setClose();
            this.callable.withRetries();
            this.callable = null;
        }
        if (this.currentRegion != null) {
            byte[] endKey = this.currentRegion.getEndKey();
            if (endKey == null || Bytes.equals((byte[])endKey, (byte[])HConstants.EMPTY_BYTE_ARRAY) || this.checkScanStopRow(endKey) || done) {
                this.close();
                if (this.LOG.isDebugEnabled()) {
                    this.LOG.debug((Object)("Finished region=" + this.currentRegion));
                }
                return false;
            }
            localStartKey = endKey;
            if (this.LOG.isDebugEnabled()) {
                this.LOG.debug((Object)("Finished with region " + this.currentRegion));
            }
        } else {
            localStartKey = this.scan.getStartRow();
        }
        if (this.LOG.isDebugEnabled() && this.currentRegion != null) {
            this.LOG.debug((Object)("Advancing internal scanner to startKey at '" + Bytes.toStringBinary((byte[])localStartKey) + "'"));
        }
        try {
            this.callable = this.getScannerCallable(localStartKey);
            this.callable.withRetries();
            this.currentRegion = this.callable.getHRegionInfo();
            if (this.scanMetrics != null) {
                this.scanMetrics.countOfRegions.incrementAndGet();
            }
        }
        catch (IOException e) {
            this.close();
            throw e;
        }
        return true;
    }

    protected ScannerCallable getScannerCallable(byte[] localStartKey) {
        this.scan.setStartRow(localStartKey);
        ScannerCallable s = new ScannerCallable(this.getConnection(), this.getTableName(), this.scan, this.scanMetrics);
        s.setCaching(this.caching);
        return s;
    }

    private void writeScanMetrics() {
        if (this.scanMetrics == null || this.scanMetricsPublished) {
            return;
        }
        MapReduceProtos.ScanMetrics pScanMetrics = ProtobufUtil.toScanMetrics(this.scanMetrics);
        this.scan.setAttribute("scan.attributes.metrics.data", pScanMetrics.toByteArray());
        this.scanMetricsPublished = true;
    }

    @Override
    public Result next() throws IOException {
        if (this.cache.size() == 0 && this.closed) {
            return null;
        }
        if (this.cache.size() == 0) {
            Result[] values = null;
            long remainingResultSize = this.maxScannerResultSize;
            int countdown = this.caching;
            boolean skipFirst = false;
            boolean retryAfterOutOfOrderException = true;
            do {
                try {
                    values = (Result[])this.callable.withRetries();
                    if (skipFirst && values != null && values.length == 1) {
                        skipFirst = false;
                        values = (Result[])this.callable.withRetries();
                    }
                    retryAfterOutOfOrderException = true;
                }
                catch (DoNotRetryIOException e) {
                    if (e instanceof UnknownScannerException) {
                        long timeout = this.lastNext + (long)this.scannerTimeout;
                        if (timeout < System.currentTimeMillis()) {
                            long elapsed = System.currentTimeMillis() - this.lastNext;
                            ScannerTimeoutException ex = new ScannerTimeoutException(elapsed + "ms passed since the last invocation, " + "timeout is currently set to " + this.scannerTimeout);
                            ex.initCause((Throwable)((Object)e));
                            throw ex;
                        }
                    } else {
                        Throwable cause = e.getCause();
                        if (!(cause != null && cause instanceof NotServingRegionException || cause != null && cause instanceof RegionServerStoppedException || e instanceof OutOfOrderScannerNextException)) {
                            throw e;
                        }
                    }
                    if (this.lastResult != null) {
                        this.scan.setStartRow(this.lastResult.getRow());
                        skipFirst = true;
                    }
                    if (e instanceof OutOfOrderScannerNextException) {
                        if (retryAfterOutOfOrderException) {
                            retryAfterOutOfOrderException = false;
                        } else {
                            throw new DoNotRetryIOException("Failed after retry of OutOfOrderScannerNextException: was there a rpc timeout?", (Throwable)((Object)e));
                        }
                    }
                    this.currentRegion = null;
                    this.callable = null;
                    continue;
                }
                long currentTime = System.currentTimeMillis();
                if (this.scanMetrics != null) {
                    this.scanMetrics.sumOfMillisSecBetweenNexts.addAndGet(currentTime - this.lastNext);
                }
                this.lastNext = currentTime;
                if (values == null || values.length <= 0) continue;
                int i = 0;
                if (skipFirst) {
                    skipFirst = false;
                    --countdown;
                    i = 1;
                }
                while (i < values.length) {
                    Result rs = values[i];
                    this.cache.add(rs);
                    for (KeyValue kv : rs.raw()) {
                        remainingResultSize -= kv.heapSize();
                    }
                    --countdown;
                    this.lastResult = rs;
                    ++i;
                }
            } while (remainingResultSize > 0L && countdown > 0 && this.nextScanner(values == null));
        }
        if (this.cache.size() > 0) {
            return this.cache.poll();
        }
        this.writeScanMetrics();
        return null;
    }

    @Override
    public Result[] next(int nbRows) throws IOException {
        Result next;
        ArrayList<Result> resultSets = new ArrayList<Result>(nbRows);
        for (int i = 0; i < nbRows && (next = this.next()) != null; ++i) {
            resultSets.add(next);
        }
        return resultSets.toArray(new Result[resultSets.size()]);
    }

    @Override
    public void close() {
        if (!this.scanMetricsPublished) {
            this.writeScanMetrics();
        }
        if (this.callable != null) {
            this.callable.setClose();
            try {
                this.callable.withRetries();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.callable = null;
        }
        this.closed = true;
    }

    long currentScannerId() {
        return this.callable == null ? -1L : this.callable.scannerId;
    }

    HRegionInfo currentRegionInfo() {
        return this.currentRegion;
    }
}

