/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import com.google.protobuf.ByteString;
import com.google.protobuf.RpcController;
import com.google.protobuf.ServiceException;
import java.io.Closeable;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.SocketTimeoutException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.ClusterStatus;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HBaseIOException;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.catalog.CatalogTracker;
import org.apache.hadoop.hbase.catalog.MetaReader;
import org.apache.hadoop.hbase.client.HConnection;
import org.apache.hadoop.hbase.client.HConnectionManager;
import org.apache.hadoop.hbase.client.MasterAdminKeepAliveConnection;
import org.apache.hadoop.hbase.client.MasterMonitorKeepAliveConnection;
import org.apache.hadoop.hbase.client.MetaScanner;
import org.apache.hadoop.hbase.client.NoServerForRegionException;
import org.apache.hadoop.hbase.client.RegionOfflineException;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.ZooKeeperKeepAliveConnection;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.exceptions.FailedLogCloseException;
import org.apache.hadoop.hbase.exceptions.HBaseSnapshotException;
import org.apache.hadoop.hbase.exceptions.MasterNotRunningException;
import org.apache.hadoop.hbase.exceptions.NotServingRegionException;
import org.apache.hadoop.hbase.exceptions.RegionException;
import org.apache.hadoop.hbase.exceptions.RestoreSnapshotException;
import org.apache.hadoop.hbase.exceptions.SnapshotCreationException;
import org.apache.hadoop.hbase.exceptions.TableExistsException;
import org.apache.hadoop.hbase.exceptions.TableNotEnabledException;
import org.apache.hadoop.hbase.exceptions.TableNotFoundException;
import org.apache.hadoop.hbase.exceptions.UnknownRegionException;
import org.apache.hadoop.hbase.exceptions.UnknownSnapshotException;
import org.apache.hadoop.hbase.exceptions.ZooKeeperConnectionException;
import org.apache.hadoop.hbase.ipc.CoprocessorRpcChannel;
import org.apache.hadoop.hbase.ipc.MasterCoprocessorRpcChannel;
import org.apache.hadoop.hbase.ipc.PayloadCarryingRpcController;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.RequestConverter;
import org.apache.hadoop.hbase.protobuf.ResponseConverter;
import org.apache.hadoop.hbase.protobuf.generated.AdminProtos;
import org.apache.hadoop.hbase.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.protobuf.generated.MasterAdminProtos;
import org.apache.hadoop.hbase.protobuf.generated.MasterMonitorProtos;
import org.apache.hadoop.hbase.snapshot.ClientSnapshotDescriptionUtils;
import org.apache.hadoop.hbase.util.Addressing;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.util.StringUtils;
import org.apache.zookeeper.KeeperException;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class HBaseAdmin
implements Abortable,
Closeable {
    private static final Log LOG = LogFactory.getLog(HBaseAdmin.class);
    private HConnection connection;
    private volatile Configuration conf;
    private final long pause;
    private final int numRetries;
    private final int retryLongerMultiplier;
    private boolean aborted;

    public HBaseAdmin(Configuration c) throws MasterNotRunningException, ZooKeeperConnectionException, IOException {
        this(HConnectionManager.getConnection(new Configuration(c)));
    }

    public HBaseAdmin(HConnection connection) throws MasterNotRunningException, ZooKeeperConnectionException {
        this.conf = connection.getConfiguration();
        this.connection = connection;
        this.pause = this.conf.getLong("hbase.client.pause", 1000L);
        this.numRetries = this.conf.getInt("hbase.client.retries.number", 10);
        this.retryLongerMultiplier = this.conf.getInt("hbase.client.retries.longer.multiplier", 10);
    }

    private synchronized CatalogTracker getCatalogTracker() throws ZooKeeperConnectionException, IOException {
        CatalogTracker ct = null;
        try {
            ct = new CatalogTracker(this.conf);
            ct.start();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IOException("Interrupted", e);
        }
        return ct;
    }

    private void cleanupCatalogTracker(CatalogTracker ct) {
        ct.stop();
    }

    @Override
    public void abort(String why, Throwable e) {
        this.aborted = true;
        throw new RuntimeException(why, e);
    }

    @Override
    public boolean isAborted() {
        return this.aborted;
    }

    public HConnection getConnection() {
        return this.connection;
    }

    public boolean isMasterRunning() throws MasterNotRunningException, ZooKeeperConnectionException {
        return this.connection.isMasterRunning();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean tableExists(String tableName) throws IOException {
        boolean b = false;
        CatalogTracker ct = this.getCatalogTracker();
        try {
            b = MetaReader.tableExists(ct, tableName);
        }
        finally {
            this.cleanupCatalogTracker(ct);
        }
        return b;
    }

    public boolean tableExists(byte[] tableName) throws IOException {
        return this.tableExists(Bytes.toString((byte[])tableName));
    }

    public HTableDescriptor[] listTables() throws IOException {
        return this.connection.listTables();
    }

    public HTableDescriptor[] listTables(Pattern pattern) throws IOException {
        HTableDescriptor[] tables;
        LinkedList<HTableDescriptor> matched = new LinkedList<HTableDescriptor>();
        for (HTableDescriptor table : tables = this.listTables()) {
            if (!pattern.matcher(table.getNameAsString()).matches()) continue;
            matched.add(table);
        }
        return matched.toArray(new HTableDescriptor[matched.size()]);
    }

    public HTableDescriptor[] listTables(String regex) throws IOException {
        return this.listTables(Pattern.compile(regex));
    }

    public HTableDescriptor getTableDescriptor(byte[] tableName) throws TableNotFoundException, IOException {
        return this.connection.getHTableDescriptor(tableName);
    }

    private long getPauseTime(int tries) {
        int triesCount = tries;
        if (triesCount >= HConstants.RETRY_BACKOFF.length) {
            triesCount = HConstants.RETRY_BACKOFF.length - 1;
        }
        return this.pause * (long)HConstants.RETRY_BACKOFF[triesCount];
    }

    public void createTable(HTableDescriptor desc) throws IOException {
        this.createTable(desc, null);
    }

    public void createTable(HTableDescriptor desc, byte[] startKey, byte[] endKey, int numRegions) throws IOException {
        HTableDescriptor.isLegalTableName(desc.getName());
        if (numRegions < 3) {
            throw new IllegalArgumentException("Must create at least three regions");
        }
        if (Bytes.compareTo((byte[])startKey, (byte[])endKey) >= 0) {
            throw new IllegalArgumentException("Start key must be smaller than end key");
        }
        if (numRegions == 3) {
            this.createTable(desc, new byte[][]{startKey, endKey});
            return;
        }
        byte[][] splitKeys = Bytes.split((byte[])startKey, (byte[])endKey, (int)(numRegions - 3));
        if (splitKeys == null || splitKeys.length != numRegions - 1) {
            throw new IllegalArgumentException("Unable to split key range into enough regions");
        }
        this.createTable(desc, splitKeys);
    }

    public void createTable(final HTableDescriptor desc, byte[][] splitKeys) throws IOException {
        HTableDescriptor.isLegalTableName(desc.getName());
        try {
            this.createTableAsync(desc, splitKeys);
        }
        catch (SocketTimeoutException ste) {
            LOG.warn((Object)("Creating " + desc.getNameAsString() + " took too long"), (Throwable)ste);
        }
        int numRegs = splitKeys == null ? 1 : splitKeys.length + 1;
        int prevRegCount = 0;
        boolean doneWithMetaScan = false;
        for (int tries = 0; tries < this.numRetries * this.retryLongerMultiplier; ++tries) {
            if (!doneWithMetaScan) {
                final AtomicInteger actualRegCount = new AtomicInteger(0);
                MetaScanner.MetaScannerVisitorBase visitor = new MetaScanner.MetaScannerVisitorBase(){

                    @Override
                    public boolean processRow(Result rowResult) throws IOException {
                        HRegionInfo info = HRegionInfo.getHRegionInfo(rowResult);
                        if (info == null) {
                            LOG.warn((Object)("No serialized HRegionInfo in " + rowResult));
                            return true;
                        }
                        if (!Bytes.equals((byte[])info.getTableName(), (byte[])desc.getName())) {
                            return false;
                        }
                        ServerName serverName = HRegionInfo.getServerName(rowResult);
                        if (!info.isOffline() && !info.isSplit() && serverName != null && serverName.getHostAndPort() != null) {
                            actualRegCount.incrementAndGet();
                        }
                        return true;
                    }
                };
                MetaScanner.metaScan(this.conf, visitor, desc.getName());
                if (actualRegCount.get() != numRegs) {
                    if (tries == this.numRetries * this.retryLongerMultiplier - 1) {
                        throw new RegionOfflineException("Only " + actualRegCount.get() + " of " + numRegs + " regions are online; retries exhausted.");
                    }
                    try {
                        Thread.sleep(this.getPauseTime(tries));
                    }
                    catch (InterruptedException e) {
                        throw new InterruptedIOException("Interrupted when opening regions; " + actualRegCount.get() + " of " + numRegs + " regions processed so far");
                    }
                    if (actualRegCount.get() <= prevRegCount) continue;
                    prevRegCount = actualRegCount.get();
                    tries = -1;
                    continue;
                }
                doneWithMetaScan = true;
                tries = -1;
                continue;
            }
            if (this.isTableEnabled(desc.getName())) {
                return;
            }
            try {
                Thread.sleep(this.getPauseTime(tries));
                continue;
            }
            catch (InterruptedException e) {
                throw new InterruptedIOException("Interrupted when waiting for table to be enabled; meta scan was done");
            }
        }
        throw new TableNotEnabledException("Retries exhausted while still waiting for table: " + desc.getNameAsString() + " to be enabled");
    }

    public void createTableAsync(final HTableDescriptor desc, final byte[][] splitKeys) throws IOException {
        HTableDescriptor.isLegalTableName(desc.getName());
        if (splitKeys != null && splitKeys.length > 0) {
            Arrays.sort(splitKeys, Bytes.BYTES_COMPARATOR);
            byte[] lastKey = null;
            for (byte[] splitKey : splitKeys) {
                if (Bytes.compareTo((byte[])splitKey, (byte[])HConstants.EMPTY_BYTE_ARRAY) == 0) {
                    throw new IllegalArgumentException("Empty split key must not be passed in the split keys.");
                }
                if (lastKey != null && Bytes.equals((byte[])splitKey, (byte[])lastKey)) {
                    throw new IllegalArgumentException("All split keys must be unique, found duplicate: " + Bytes.toStringBinary((byte[])splitKey) + ", " + Bytes.toStringBinary((byte[])lastKey));
                }
                lastKey = splitKey;
            }
        }
        this.execute(new MasterAdminCallable<Void>(){

            @Override
            public Void call() throws ServiceException {
                MasterAdminProtos.CreateTableRequest request = RequestConverter.buildCreateTableRequest(desc, splitKeys);
                this.masterAdmin.createTable(null, request);
                return null;
            }
        });
    }

    public void deleteTable(String tableName) throws IOException {
        this.deleteTable(Bytes.toBytes((String)tableName));
    }

    public void deleteTable(final byte[] tableName) throws IOException {
        HTableDescriptor.isLegalTableName(tableName);
        HRegionLocation firstMetaServer = this.getFirstMetaServerForTable(tableName);
        boolean tableExists = true;
        this.execute(new MasterAdminCallable<Void>(){

            @Override
            public Void call() throws ServiceException {
                MasterAdminProtos.DeleteTableRequest req = RequestConverter.buildDeleteTableRequest(tableName);
                this.masterAdmin.deleteTable(null, req);
                return null;
            }
        });
        for (int tries = 0; tries < this.numRetries * this.retryLongerMultiplier; ++tries) {
            block16: {
                try {
                    MasterMonitorProtos.GetTableDescriptorsResponse htds;
                    Scan scan = MetaReader.getScanForTableName(tableName);
                    scan.addColumn(HConstants.CATALOG_FAMILY, HConstants.REGIONINFO_QUALIFIER);
                    ClientProtos.ScanRequest request = RequestConverter.buildScanRequest(firstMetaServer.getRegionInfo().getRegionName(), scan, 1, true);
                    Result[] values = null;
                    ClientProtos.ClientService.BlockingInterface server = this.connection.getClient(firstMetaServer.getServerName());
                    PayloadCarryingRpcController controller = new PayloadCarryingRpcController();
                    try {
                        ClientProtos.ScanResponse response = server.scan((RpcController)controller, request);
                        values = ResponseConverter.getResults(controller.cellScanner(), response);
                    }
                    catch (ServiceException se) {
                        throw ProtobufUtil.getRemoteException(se);
                    }
                    if (values != null && values.length != 0) break block16;
                    tableExists = false;
                    MasterMonitorKeepAliveConnection master = this.connection.getKeepAliveMasterMonitorService();
                    try {
                        MasterMonitorProtos.GetTableDescriptorsRequest req = RequestConverter.buildGetTableDescriptorsRequest(null);
                        htds = master.getTableDescriptors(null, req);
                    }
                    catch (ServiceException se) {
                        throw ProtobufUtil.getRemoteException(se);
                    }
                    finally {
                        master.close();
                    }
                    for (HBaseProtos.TableSchema ts : htds.getTableSchemaList()) {
                        if (!Bytes.equals((byte[])tableName, (byte[])ts.getName().toByteArray())) continue;
                        tableExists = true;
                        break;
                    }
                    if (!tableExists) {
                        break;
                    }
                }
                catch (IOException ex) {
                    if (tries != this.numRetries - 1) break block16;
                    if (ex instanceof RemoteException) {
                        throw ((RemoteException)((Object)ex)).unwrapRemoteException();
                    }
                    throw ex;
                }
            }
            try {
                Thread.sleep(this.getPauseTime(tries));
                continue;
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        if (tableExists) {
            throw new IOException("Retries exhausted, it took too long to wait for the table " + Bytes.toString((byte[])tableName) + " to be deleted.");
        }
        this.connection.clearRegionCache(tableName);
        LOG.info((Object)("Deleted " + Bytes.toString((byte[])tableName)));
    }

    public HTableDescriptor[] deleteTables(String regex) throws IOException {
        return this.deleteTables(Pattern.compile(regex));
    }

    public HTableDescriptor[] deleteTables(Pattern pattern) throws IOException {
        LinkedList<HTableDescriptor> failed = new LinkedList<HTableDescriptor>();
        for (HTableDescriptor table : this.listTables(pattern)) {
            try {
                this.deleteTable(table.getName());
            }
            catch (IOException ex) {
                LOG.info((Object)("Failed to delete table " + table.getNameAsString()), (Throwable)ex);
                failed.add(table);
            }
        }
        return failed.toArray(new HTableDescriptor[failed.size()]);
    }

    public void enableTable(String tableName) throws IOException {
        this.enableTable(Bytes.toBytes((String)tableName));
    }

    public void enableTable(byte[] tableName) throws IOException {
        this.enableTableAsync(tableName);
        this.waitUntilTableIsEnabled(tableName);
        LOG.info((Object)("Enabled table " + Bytes.toString((byte[])tableName)));
    }

    private void waitUntilTableIsEnabled(byte[] tableName) throws IOException {
        boolean enabled = false;
        long start = EnvironmentEdgeManager.currentTimeMillis();
        for (int tries = 0; tries < this.numRetries * this.retryLongerMultiplier; ++tries) {
            boolean bl = enabled = this.isTableEnabled(tableName) && this.isTableAvailable(tableName);
            if (enabled) break;
            long sleep = this.getPauseTime(tries);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Sleeping= " + sleep + "ms, waiting for all regions to be " + "enabled in " + Bytes.toString((byte[])tableName)));
            }
            try {
                Thread.sleep(sleep);
                continue;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new IOException("Interrupted", e);
            }
        }
        if (!enabled) {
            long msec = EnvironmentEdgeManager.currentTimeMillis() - start;
            throw new IOException("Table '" + Bytes.toString((byte[])tableName) + "' not yet enabled, after " + msec + "ms.");
        }
    }

    public void enableTableAsync(String tableName) throws IOException {
        this.enableTableAsync(Bytes.toBytes((String)tableName));
    }

    public void enableTableAsync(final byte[] tableName) throws IOException {
        HTableDescriptor.isLegalTableName(tableName);
        this.execute(new MasterAdminCallable<Void>(){

            @Override
            public Void call() throws ServiceException {
                LOG.info((Object)("Started enable of " + Bytes.toString((byte[])tableName)));
                MasterAdminProtos.EnableTableRequest req = RequestConverter.buildEnableTableRequest(tableName);
                this.masterAdmin.enableTable(null, req);
                return null;
            }
        });
    }

    public HTableDescriptor[] enableTables(String regex) throws IOException {
        return this.enableTables(Pattern.compile(regex));
    }

    public HTableDescriptor[] enableTables(Pattern pattern) throws IOException {
        LinkedList<HTableDescriptor> failed = new LinkedList<HTableDescriptor>();
        for (HTableDescriptor table : this.listTables(pattern)) {
            if (!this.isTableDisabled(table.getName())) continue;
            try {
                this.enableTable(table.getName());
            }
            catch (IOException ex) {
                LOG.info((Object)("Failed to enable table " + table.getNameAsString()), (Throwable)ex);
                failed.add(table);
            }
        }
        return failed.toArray(new HTableDescriptor[failed.size()]);
    }

    public void disableTableAsync(String tableName) throws IOException {
        this.disableTableAsync(Bytes.toBytes((String)tableName));
    }

    public void disableTableAsync(final byte[] tableName) throws IOException {
        HTableDescriptor.isLegalTableName(tableName);
        this.execute(new MasterAdminCallable<Void>(){

            @Override
            public Void call() throws ServiceException {
                LOG.info((Object)("Started disable of " + Bytes.toString((byte[])tableName)));
                MasterAdminProtos.DisableTableRequest req = RequestConverter.buildDisableTableRequest(tableName);
                this.masterAdmin.disableTable(null, req);
                return null;
            }
        });
    }

    public void disableTable(String tableName) throws IOException {
        this.disableTable(Bytes.toBytes((String)tableName));
    }

    public void disableTable(byte[] tableName) throws IOException {
        this.disableTableAsync(tableName);
        boolean disabled = false;
        for (int tries = 0; tries < this.numRetries * this.retryLongerMultiplier && !(disabled = this.isTableDisabled(tableName)); ++tries) {
            long sleep = this.getPauseTime(tries);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Sleeping= " + sleep + "ms, waiting for all regions to be " + "disabled in " + Bytes.toString((byte[])tableName)));
            }
            try {
                Thread.sleep(sleep);
                continue;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new IOException("Interrupted", e);
            }
        }
        if (!disabled) {
            throw new RegionException("Retries exhausted, it took too long to wait for the table " + Bytes.toString((byte[])tableName) + " to be disabled.");
        }
        LOG.info((Object)("Disabled " + Bytes.toString((byte[])tableName)));
    }

    public HTableDescriptor[] disableTables(String regex) throws IOException {
        return this.disableTables(Pattern.compile(regex));
    }

    public HTableDescriptor[] disableTables(Pattern pattern) throws IOException {
        LinkedList<HTableDescriptor> failed = new LinkedList<HTableDescriptor>();
        for (HTableDescriptor table : this.listTables(pattern)) {
            if (!this.isTableEnabled(table.getName())) continue;
            try {
                this.disableTable(table.getName());
            }
            catch (IOException ex) {
                LOG.info((Object)("Failed to disable table " + table.getNameAsString()), (Throwable)ex);
                failed.add(table);
            }
        }
        return failed.toArray(new HTableDescriptor[failed.size()]);
    }

    public boolean isTableEnabled(String tableName) throws IOException {
        return this.isTableEnabled(Bytes.toBytes((String)tableName));
    }

    public boolean isTableEnabled(byte[] tableName) throws IOException {
        if (!HTableDescriptor.isMetaTable(tableName)) {
            HTableDescriptor.isLegalTableName(tableName);
        }
        return this.connection.isTableEnabled(tableName);
    }

    public boolean isTableDisabled(String tableName) throws IOException {
        return this.isTableDisabled(Bytes.toBytes((String)tableName));
    }

    public boolean isTableDisabled(byte[] tableName) throws IOException {
        if (!HTableDescriptor.isMetaTable(tableName)) {
            HTableDescriptor.isLegalTableName(tableName);
        }
        return this.connection.isTableDisabled(tableName);
    }

    public boolean isTableAvailable(byte[] tableName) throws IOException {
        return this.connection.isTableAvailable(tableName);
    }

    public boolean isTableAvailable(String tableName) throws IOException {
        return this.connection.isTableAvailable(Bytes.toBytes((String)tableName));
    }

    public boolean isTableAvailable(String tableName, byte[][] splitKeys) throws IOException {
        return this.connection.isTableAvailable(Bytes.toBytes((String)tableName), splitKeys);
    }

    public boolean isTableAvailable(byte[] tableName, byte[][] splitKeys) throws IOException {
        return this.connection.isTableAvailable(tableName, splitKeys);
    }

    public Pair<Integer, Integer> getAlterStatus(final byte[] tableName) throws IOException {
        HTableDescriptor.isLegalTableName(tableName);
        return this.execute(new MasterMonitorCallable<Pair<Integer, Integer>>(){

            @Override
            public Pair<Integer, Integer> call() throws ServiceException {
                MasterMonitorProtos.GetSchemaAlterStatusRequest req = RequestConverter.buildGetSchemaAlterStatusRequest(tableName);
                MasterMonitorProtos.GetSchemaAlterStatusResponse ret = this.masterMonitor.getSchemaAlterStatus(null, req);
                Pair pair = new Pair((Object)ret.getYetToUpdateRegions(), (Object)ret.getTotalRegions());
                return pair;
            }
        });
    }

    public void addColumn(String tableName, HColumnDescriptor column) throws IOException {
        this.addColumn(Bytes.toBytes((String)tableName), column);
    }

    public void addColumn(final byte[] tableName, final HColumnDescriptor column) throws IOException {
        this.execute(new MasterAdminCallable<Void>(){

            @Override
            public Void call() throws ServiceException {
                MasterAdminProtos.AddColumnRequest req = RequestConverter.buildAddColumnRequest(tableName, column);
                this.masterAdmin.addColumn(null, req);
                return null;
            }
        });
    }

    public void deleteColumn(String tableName, String columnName) throws IOException {
        this.deleteColumn(Bytes.toBytes((String)tableName), Bytes.toBytes((String)columnName));
    }

    public void deleteColumn(final byte[] tableName, final byte[] columnName) throws IOException {
        this.execute(new MasterAdminCallable<Void>(){

            @Override
            public Void call() throws ServiceException {
                MasterAdminProtos.DeleteColumnRequest req = RequestConverter.buildDeleteColumnRequest(tableName, columnName);
                this.masterAdmin.deleteColumn(null, req);
                return null;
            }
        });
    }

    public void modifyColumn(String tableName, HColumnDescriptor descriptor) throws IOException {
        this.modifyColumn(Bytes.toBytes((String)tableName), descriptor);
    }

    public void modifyColumn(final byte[] tableName, final HColumnDescriptor descriptor) throws IOException {
        this.execute(new MasterAdminCallable<Void>(){

            @Override
            public Void call() throws ServiceException {
                MasterAdminProtos.ModifyColumnRequest req = RequestConverter.buildModifyColumnRequest(tableName, descriptor);
                this.masterAdmin.modifyColumn(null, req);
                return null;
            }
        });
    }

    public void closeRegion(String regionname, String serverName) throws IOException {
        this.closeRegion(Bytes.toBytes((String)regionname), serverName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeRegion(byte[] regionname, String serverName) throws IOException {
        CatalogTracker ct = this.getCatalogTracker();
        try {
            if (serverName != null) {
                Pair<HRegionInfo, ServerName> pair = MetaReader.getRegion(ct, regionname);
                if (pair == null || pair.getFirst() == null) {
                    throw new UnknownRegionException(Bytes.toStringBinary((byte[])regionname));
                }
                this.closeRegion(new ServerName(serverName), (HRegionInfo)pair.getFirst());
            } else {
                Pair<HRegionInfo, ServerName> pair = MetaReader.getRegion(ct, regionname);
                if (pair == null) {
                    throw new UnknownRegionException(Bytes.toStringBinary((byte[])regionname));
                }
                if (pair.getSecond() == null) {
                    throw new NoServerForRegionException(Bytes.toStringBinary((byte[])regionname));
                }
                this.closeRegion((ServerName)pair.getSecond(), (HRegionInfo)pair.getFirst());
            }
        }
        finally {
            this.cleanupCatalogTracker(ct);
        }
    }

    public boolean closeRegionWithEncodedRegionName(String encodedRegionName, String serverName) throws IOException {
        if (null == serverName || "".equals(serverName.trim())) {
            throw new IllegalArgumentException("The servername cannot be null or empty.");
        }
        ServerName sn = new ServerName(serverName);
        AdminProtos.AdminService.BlockingInterface admin = this.connection.getAdmin(sn);
        AdminProtos.CloseRegionRequest request = RequestConverter.buildCloseRegionRequest(encodedRegionName, false);
        try {
            AdminProtos.CloseRegionResponse response = admin.closeRegion(null, request);
            boolean isRegionClosed = response.getClosed();
            if (!isRegionClosed) {
                LOG.error((Object)("Not able to close the region " + encodedRegionName + "."));
            }
            return isRegionClosed;
        }
        catch (ServiceException se) {
            throw ProtobufUtil.getRemoteException(se);
        }
    }

    public void closeRegion(ServerName sn, HRegionInfo hri) throws IOException {
        AdminProtos.AdminService.BlockingInterface admin = this.connection.getAdmin(sn);
        ProtobufUtil.closeRegion(admin, hri.getRegionName(), false);
    }

    public List<HRegionInfo> getOnlineRegions(ServerName sn) throws IOException {
        AdminProtos.AdminService.BlockingInterface admin = this.connection.getAdmin(sn);
        return ProtobufUtil.getOnlineRegions(admin);
    }

    public void flush(String tableNameOrRegionName) throws IOException, InterruptedException {
        this.flush(Bytes.toBytes((String)tableNameOrRegionName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush(byte[] tableNameOrRegionName) throws IOException, InterruptedException {
        CatalogTracker ct = this.getCatalogTracker();
        try {
            Pair<HRegionInfo, ServerName> regionServerPair = this.getRegion(tableNameOrRegionName, ct);
            if (regionServerPair != null) {
                if (regionServerPair.getSecond() == null) {
                    throw new NoServerForRegionException(Bytes.toStringBinary((byte[])tableNameOrRegionName));
                }
                this.flush((ServerName)regionServerPair.getSecond(), (HRegionInfo)regionServerPair.getFirst());
            } else {
                String tableName = this.tableNameString(tableNameOrRegionName, ct);
                List<Pair<HRegionInfo, ServerName>> pairs = MetaReader.getTableRegionsAndLocations(ct, tableName);
                for (Pair<HRegionInfo, ServerName> pair : pairs) {
                    if (((HRegionInfo)pair.getFirst()).isOffline() || pair.getSecond() == null) continue;
                    try {
                        this.flush((ServerName)pair.getSecond(), (HRegionInfo)pair.getFirst());
                    }
                    catch (NotServingRegionException e) {
                        if (!LOG.isDebugEnabled()) continue;
                        LOG.debug((Object)("Trying to flush " + pair.getFirst() + ": " + StringUtils.stringifyException((Throwable)e)));
                    }
                }
            }
        }
        finally {
            this.cleanupCatalogTracker(ct);
        }
    }

    private void flush(ServerName sn, HRegionInfo hri) throws IOException {
        AdminProtos.AdminService.BlockingInterface admin = this.connection.getAdmin(sn);
        AdminProtos.FlushRegionRequest request = RequestConverter.buildFlushRegionRequest(hri.getRegionName());
        try {
            admin.flushRegion(null, request);
        }
        catch (ServiceException se) {
            throw ProtobufUtil.getRemoteException(se);
        }
    }

    public void compact(String tableNameOrRegionName) throws IOException, InterruptedException {
        this.compact(Bytes.toBytes((String)tableNameOrRegionName));
    }

    public void compact(byte[] tableNameOrRegionName) throws IOException, InterruptedException {
        this.compact(tableNameOrRegionName, null, false);
    }

    public void compact(String tableOrRegionName, String columnFamily) throws IOException, InterruptedException {
        this.compact(Bytes.toBytes((String)tableOrRegionName), Bytes.toBytes((String)columnFamily));
    }

    public void compact(byte[] tableNameOrRegionName, byte[] columnFamily) throws IOException, InterruptedException {
        this.compact(tableNameOrRegionName, columnFamily, false);
    }

    public void majorCompact(String tableNameOrRegionName) throws IOException, InterruptedException {
        this.majorCompact(Bytes.toBytes((String)tableNameOrRegionName));
    }

    public void majorCompact(byte[] tableNameOrRegionName) throws IOException, InterruptedException {
        this.compact(tableNameOrRegionName, null, true);
    }

    public void majorCompact(String tableNameOrRegionName, String columnFamily) throws IOException, InterruptedException {
        this.majorCompact(Bytes.toBytes((String)tableNameOrRegionName), Bytes.toBytes((String)columnFamily));
    }

    public void majorCompact(byte[] tableNameOrRegionName, byte[] columnFamily) throws IOException, InterruptedException {
        this.compact(tableNameOrRegionName, columnFamily, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void compact(byte[] tableNameOrRegionName, byte[] columnFamily, boolean major) throws IOException, InterruptedException {
        CatalogTracker ct = this.getCatalogTracker();
        try {
            Pair<HRegionInfo, ServerName> regionServerPair = this.getRegion(tableNameOrRegionName, ct);
            if (regionServerPair != null) {
                if (regionServerPair.getSecond() == null) {
                    throw new NoServerForRegionException(Bytes.toStringBinary((byte[])tableNameOrRegionName));
                }
                this.compact((ServerName)regionServerPair.getSecond(), (HRegionInfo)regionServerPair.getFirst(), major, columnFamily);
            } else {
                String tableName = this.tableNameString(tableNameOrRegionName, ct);
                List<Pair<HRegionInfo, ServerName>> pairs = MetaReader.getTableRegionsAndLocations(ct, tableName);
                for (Pair<HRegionInfo, ServerName> pair : pairs) {
                    if (((HRegionInfo)pair.getFirst()).isOffline() || pair.getSecond() == null) continue;
                    try {
                        this.compact((ServerName)pair.getSecond(), (HRegionInfo)pair.getFirst(), major, columnFamily);
                    }
                    catch (NotServingRegionException e) {
                        if (!LOG.isDebugEnabled()) continue;
                        LOG.debug((Object)("Trying to" + (major ? " major" : "") + " compact " + pair.getFirst() + ": " + StringUtils.stringifyException((Throwable)e)));
                    }
                }
            }
        }
        finally {
            this.cleanupCatalogTracker(ct);
        }
    }

    private void compact(ServerName sn, HRegionInfo hri, boolean major, byte[] family) throws IOException {
        AdminProtos.AdminService.BlockingInterface admin = this.connection.getAdmin(sn);
        AdminProtos.CompactRegionRequest request = RequestConverter.buildCompactRegionRequest(hri.getRegionName(), major, family);
        try {
            admin.compactRegion(null, request);
        }
        catch (ServiceException se) {
            throw ProtobufUtil.getRemoteException(se);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void move(byte[] encodedRegionName, byte[] destServerName) throws HBaseIOException, MasterNotRunningException, ZooKeeperConnectionException {
        MasterAdminKeepAliveConnection stub = this.connection.getKeepAliveMasterAdminService();
        try {
            MasterAdminProtos.MoveRegionRequest request = RequestConverter.buildMoveRegionRequest(encodedRegionName, destServerName);
            stub.moveRegion(null, request);
        }
        catch (ServiceException se) {
            IOException ioe = ProtobufUtil.getRemoteException(se);
            if (ioe instanceof HBaseIOException) {
                throw (HBaseIOException)ioe;
            }
            LOG.error((Object)("Unexpected exception: " + (Object)((Object)se) + " from calling HMaster.moveRegion"));
        }
        catch (DeserializationException de) {
            LOG.error((Object)("Could not parse destination server name: " + de));
        }
        finally {
            stub.close();
        }
    }

    public void assign(final byte[] regionName) throws MasterNotRunningException, ZooKeeperConnectionException, IOException {
        this.execute(new MasterAdminCallable<Void>(){

            @Override
            public Void call() throws ServiceException {
                MasterAdminProtos.AssignRegionRequest request = RequestConverter.buildAssignRegionRequest(regionName);
                this.masterAdmin.assignRegion(null, request);
                return null;
            }
        });
    }

    public void unassign(final byte[] regionName, final boolean force) throws MasterNotRunningException, ZooKeeperConnectionException, IOException {
        this.execute(new MasterAdminCallable<Void>(){

            @Override
            public Void call() throws ServiceException {
                MasterAdminProtos.UnassignRegionRequest request = RequestConverter.buildUnassignRegionRequest(regionName, force);
                this.masterAdmin.unassignRegion(null, request);
                return null;
            }
        });
    }

    public void offline(byte[] regionName) throws IOException {
        MasterAdminKeepAliveConnection master = this.connection.getKeepAliveMasterAdminService();
        try {
            master.offlineRegion(null, RequestConverter.buildOfflineRegionRequest(regionName));
        }
        catch (ServiceException se) {
            throw ProtobufUtil.getRemoteException(se);
        }
        finally {
            master.close();
        }
    }

    public boolean setBalancerRunning(boolean on, boolean synchronous) throws MasterNotRunningException, ZooKeeperConnectionException {
        MasterAdminKeepAliveConnection stub = this.connection.getKeepAliveMasterAdminService();
        try {
            MasterAdminProtos.SetBalancerRunningRequest req = RequestConverter.buildSetBalancerRunningRequest(on, synchronous);
            boolean bl = stub.setBalancerRunning(null, req).getPrevBalanceValue();
            return bl;
        }
        catch (ServiceException se) {
            IOException ioe = ProtobufUtil.getRemoteException(se);
            if (ioe instanceof MasterNotRunningException) {
                throw (MasterNotRunningException)ioe;
            }
            if (ioe instanceof ZooKeeperConnectionException) {
                throw (ZooKeeperConnectionException)ioe;
            }
            throw new MasterNotRunningException("Unexpected exception when calling balanceSwitch", (Exception)((Object)se));
        }
        finally {
            stub.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean balancer() throws MasterNotRunningException, ZooKeeperConnectionException, ServiceException {
        MasterAdminKeepAliveConnection stub = this.connection.getKeepAliveMasterAdminService();
        try {
            boolean bl = stub.balance(null, RequestConverter.buildBalanceRequest()).getBalancerRan();
            return bl;
        }
        finally {
            stub.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean enableCatalogJanitor(boolean enable) throws ServiceException, MasterNotRunningException {
        MasterAdminKeepAliveConnection stub = this.connection.getKeepAliveMasterAdminService();
        try {
            boolean bl = stub.enableCatalogJanitor(null, RequestConverter.buildEnableCatalogJanitorRequest(enable)).getPrevValue();
            return bl;
        }
        finally {
            stub.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int runCatalogScan() throws ServiceException, MasterNotRunningException {
        MasterAdminKeepAliveConnection stub = this.connection.getKeepAliveMasterAdminService();
        try {
            int n = stub.runCatalogScan(null, RequestConverter.buildCatalogScanRequest()).getScanResult();
            return n;
        }
        finally {
            stub.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isCatalogJanitorEnabled() throws ServiceException, MasterNotRunningException {
        MasterAdminKeepAliveConnection stub = this.connection.getKeepAliveMasterAdminService();
        try {
            boolean bl = stub.isCatalogJanitorEnabled(null, RequestConverter.buildIsCatalogJanitorEnabledRequest()).getValue();
            return bl;
        }
        finally {
            stub.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mergeRegions(byte[] encodedNameOfRegionA, byte[] encodedNameOfRegionB, boolean forcible) throws IOException {
        MasterAdminKeepAliveConnection master = this.connection.getKeepAliveMasterAdminService();
        try {
            MasterAdminProtos.DispatchMergingRegionsRequest request = RequestConverter.buildDispatchMergingRegionsRequest(encodedNameOfRegionA, encodedNameOfRegionB, forcible);
            master.dispatchMergingRegions(null, request);
        }
        catch (ServiceException se) {
            IOException ioe = ProtobufUtil.getRemoteException(se);
            if (ioe instanceof UnknownRegionException) {
                throw (UnknownRegionException)((Object)ioe);
            }
            LOG.error((Object)("Unexpected exception: " + (Object)((Object)se) + " from calling HMaster.dispatchMergingRegions"));
        }
        catch (DeserializationException de) {
            LOG.error((Object)("Could not parse destination server name: " + de));
        }
        finally {
            master.close();
        }
    }

    public void split(String tableNameOrRegionName) throws IOException, InterruptedException {
        this.split(Bytes.toBytes((String)tableNameOrRegionName));
    }

    public void split(byte[] tableNameOrRegionName) throws IOException, InterruptedException {
        this.split(tableNameOrRegionName, null);
    }

    public void split(String tableNameOrRegionName, String splitPoint) throws IOException, InterruptedException {
        this.split(Bytes.toBytes((String)tableNameOrRegionName), Bytes.toBytes((String)splitPoint));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void split(byte[] tableNameOrRegionName, byte[] splitPoint) throws IOException, InterruptedException {
        CatalogTracker ct = this.getCatalogTracker();
        try {
            Pair<HRegionInfo, ServerName> regionServerPair = this.getRegion(tableNameOrRegionName, ct);
            if (regionServerPair != null) {
                if (regionServerPair.getSecond() == null) {
                    throw new NoServerForRegionException(Bytes.toStringBinary((byte[])tableNameOrRegionName));
                }
                this.split((ServerName)regionServerPair.getSecond(), (HRegionInfo)regionServerPair.getFirst(), splitPoint);
            } else {
                String tableName = this.tableNameString(tableNameOrRegionName, ct);
                List<Pair<HRegionInfo, ServerName>> pairs = MetaReader.getTableRegionsAndLocations(ct, tableName);
                for (Pair<HRegionInfo, ServerName> pair : pairs) {
                    HRegionInfo r;
                    if (pair.getSecond() == null || (r = (HRegionInfo)pair.getFirst()).isSplitParent() || splitPoint != null && !r.containsRow(splitPoint)) continue;
                    this.split((ServerName)pair.getSecond(), (HRegionInfo)pair.getFirst(), splitPoint);
                }
            }
        }
        finally {
            this.cleanupCatalogTracker(ct);
        }
    }

    private void split(ServerName sn, HRegionInfo hri, byte[] splitPoint) throws IOException {
        AdminProtos.AdminService.BlockingInterface admin = this.connection.getAdmin(sn);
        ProtobufUtil.split(admin, hri, splitPoint);
    }

    public void modifyTable(final byte[] tableName, final HTableDescriptor htd) throws IOException {
        if (!Bytes.equals((byte[])tableName, (byte[])htd.getName())) {
            throw new IllegalArgumentException("the specified table name '" + Bytes.toString((byte[])tableName) + "' doesn't match with the HTD one: " + htd.getNameAsString());
        }
        this.execute(new MasterAdminCallable<Void>(){

            @Override
            public Void call() throws ServiceException {
                MasterAdminProtos.ModifyTableRequest request = RequestConverter.buildModifyTableRequest(tableName, htd);
                this.masterAdmin.modifyTable(null, request);
                return null;
            }
        });
    }

    Pair<HRegionInfo, ServerName> getRegion(byte[] tableNameOrRegionName, CatalogTracker ct) throws IOException {
        if (tableNameOrRegionName == null) {
            throw new IllegalArgumentException("Pass a table name or region name");
        }
        Pair pair = MetaReader.getRegion(ct, tableNameOrRegionName);
        if (pair == null) {
            final AtomicReference<Object> result = new AtomicReference<Object>(null);
            final String encodedName = Bytes.toString((byte[])tableNameOrRegionName);
            MetaScanner.MetaScannerVisitorBase visitor = new MetaScanner.MetaScannerVisitorBase(){

                @Override
                public boolean processRow(Result data) throws IOException {
                    HRegionInfo info = HRegionInfo.getHRegionInfo(data);
                    if (info == null) {
                        LOG.warn((Object)("No serialized HRegionInfo in " + data));
                        return true;
                    }
                    if (!encodedName.equals(info.getEncodedName())) {
                        return true;
                    }
                    ServerName sn = HRegionInfo.getServerName(data);
                    result.set(new Pair((Object)info, (Object)sn));
                    return false;
                }
            };
            MetaScanner.metaScan(this.conf, visitor);
            pair = result.get();
        }
        return pair;
    }

    private String tableNameString(byte[] tableNameBytes, CatalogTracker ct) throws IOException {
        String tableNameString = Bytes.toString((byte[])tableNameBytes);
        if (!MetaReader.tableExists(ct, tableNameString)) {
            throw new TableNotFoundException(tableNameString);
        }
        return tableNameString;
    }

    public synchronized void shutdown() throws IOException {
        this.execute(new MasterAdminCallable<Void>(){

            @Override
            public Void call() throws ServiceException {
                this.masterAdmin.shutdown(null, MasterAdminProtos.ShutdownRequest.newBuilder().build());
                return null;
            }
        });
    }

    public synchronized void stopMaster() throws IOException {
        this.execute(new MasterAdminCallable<Void>(){

            @Override
            public Void call() throws ServiceException {
                this.masterAdmin.stopMaster(null, MasterAdminProtos.StopMasterRequest.newBuilder().build());
                return null;
            }
        });
    }

    public synchronized void stopRegionServer(String hostnamePort) throws IOException {
        String hostname = Addressing.parseHostname((String)hostnamePort);
        int port = Addressing.parsePort((String)hostnamePort);
        AdminProtos.AdminService.BlockingInterface admin = this.connection.getAdmin(new ServerName(hostname, port, 0L));
        AdminProtos.StopServerRequest request = RequestConverter.buildStopServerRequest("Called by admin client " + this.connection.toString());
        try {
            admin.stopServer(null, request);
        }
        catch (ServiceException se) {
            throw ProtobufUtil.getRemoteException(se);
        }
    }

    public ClusterStatus getClusterStatus() throws IOException {
        return this.execute(new MasterMonitorCallable<ClusterStatus>(){

            @Override
            public ClusterStatus call() throws ServiceException {
                MasterMonitorProtos.GetClusterStatusRequest req = RequestConverter.buildGetClusterStatusRequest();
                return ClusterStatus.convert(this.masterMonitor.getClusterStatus(null, req).getClusterStatus());
            }
        });
    }

    private HRegionLocation getFirstMetaServerForTable(byte[] tableName) throws IOException {
        return this.connection.locateRegion(HConstants.META_TABLE_NAME, HRegionInfo.createRegionName(tableName, null, "99999999999999", false));
    }

    public Configuration getConfiguration() {
        return this.conf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void checkHBaseAvailable(Configuration conf) throws MasterNotRunningException, ZooKeeperConnectionException, ServiceException, IOException {
        Configuration copyOfConf = HBaseConfiguration.create((Configuration)conf);
        copyOfConf.setInt("hbase.client.retries.number", 1);
        copyOfConf.setInt("zookeeper.recovery.retry", 0);
        HConnectionManager.HConnectionImplementation connection = (HConnectionManager.HConnectionImplementation)HConnectionManager.getConnection(copyOfConf);
        try {
            ZooKeeperKeepAliveConnection zkw = null;
            try {
                zkw = connection.getKeepAliveZooKeeperWatcher();
                zkw.getRecoverableZooKeeper().getZooKeeper().exists(zkw.baseZNode, false);
            }
            catch (IOException e) {
                throw new ZooKeeperConnectionException("Can't connect to ZooKeeper", e);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new ZooKeeperConnectionException("Can't connect to ZooKeeper", e);
            }
            catch (KeeperException e) {
                throw new ZooKeeperConnectionException("Can't connect to ZooKeeper", (Exception)((Object)e));
            }
            finally {
                if (zkw != null) {
                    zkw.close();
                }
            }
            connection.isMasterRunning();
        }
        finally {
            connection.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<HRegionInfo> getTableRegions(byte[] tableName) throws IOException {
        CatalogTracker ct = this.getCatalogTracker();
        List<HRegionInfo> Regions = null;
        try {
            Regions = MetaReader.getTableRegions(ct, tableName, true);
        }
        finally {
            this.cleanupCatalogTracker(ct);
        }
        return Regions;
    }

    @Override
    public void close() throws IOException {
        if (this.connection != null) {
            this.connection.close();
        }
    }

    public HTableDescriptor[] getTableDescriptors(List<String> tableNames) throws IOException {
        return this.connection.getHTableDescriptors(tableNames);
    }

    public synchronized byte[][] rollHLogWriter(String serverName) throws IOException, FailedLogCloseException {
        ServerName sn = new ServerName(serverName);
        AdminProtos.AdminService.BlockingInterface admin = this.connection.getAdmin(sn);
        AdminProtos.RollWALWriterRequest request = RequestConverter.buildRollWALWriterRequest();
        try {
            AdminProtos.RollWALWriterResponse response = admin.rollWALWriter(null, request);
            int regionCount = response.getRegionToFlushCount();
            byte[][] regionsToFlush = new byte[regionCount][];
            for (int i = 0; i < regionCount; ++i) {
                ByteString region = response.getRegionToFlush(i);
                regionsToFlush[i] = region.toByteArray();
            }
            return regionsToFlush;
        }
        catch (ServiceException se) {
            throw ProtobufUtil.getRemoteException(se);
        }
    }

    public String[] getMasterCoprocessors() {
        try {
            return this.getClusterStatus().getMasterCoprocessors();
        }
        catch (IOException e) {
            LOG.error((Object)"Could not getClusterStatus()", (Throwable)e);
            return null;
        }
    }

    public AdminProtos.GetRegionInfoResponse.CompactionState getCompactionState(String tableNameOrRegionName) throws IOException, InterruptedException {
        return this.getCompactionState(Bytes.toBytes((String)tableNameOrRegionName));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public AdminProtos.GetRegionInfoResponse.CompactionState getCompactionState(byte[] tableNameOrRegionName) throws IOException, InterruptedException {
        AdminProtos.GetRegionInfoResponse.CompactionState state = AdminProtos.GetRegionInfoResponse.CompactionState.NONE;
        CatalogTracker ct = this.getCatalogTracker();
        try {
            Pair<HRegionInfo, ServerName> regionServerPair = this.getRegion(tableNameOrRegionName, ct);
            if (regionServerPair != null) {
                if (regionServerPair.getSecond() == null) {
                    throw new NoServerForRegionException(Bytes.toStringBinary((byte[])tableNameOrRegionName));
                }
                ServerName sn = (ServerName)regionServerPair.getSecond();
                AdminProtos.AdminService.BlockingInterface admin = this.connection.getAdmin(sn);
                AdminProtos.GetRegionInfoRequest request = RequestConverter.buildGetRegionInfoRequest(((HRegionInfo)regionServerPair.getFirst()).getRegionName(), true);
                AdminProtos.GetRegionInfoResponse response = admin.getRegionInfo(null, request);
                AdminProtos.GetRegionInfoResponse.CompactionState compactionState = response.getCompactionState();
                return compactionState;
            }
            String tableName = this.tableNameString(tableNameOrRegionName, ct);
            List<Pair<HRegionInfo, ServerName>> pairs = MetaReader.getTableRegionsAndLocations(ct, tableName);
            Iterator<Pair<HRegionInfo, ServerName>> i$ = pairs.iterator();
            while (i$.hasNext()) {
                Pair<HRegionInfo, ServerName> pair = i$.next();
                if (((HRegionInfo)pair.getFirst()).isOffline() || pair.getSecond() == null) continue;
                try {
                    ServerName sn = (ServerName)pair.getSecond();
                    AdminProtos.AdminService.BlockingInterface admin = this.connection.getAdmin(sn);
                    AdminProtos.GetRegionInfoRequest request = RequestConverter.buildGetRegionInfoRequest(((HRegionInfo)pair.getFirst()).getRegionName(), true);
                    AdminProtos.GetRegionInfoResponse response = admin.getRegionInfo(null, request);
                    switch (response.getCompactionState()) {
                        case MAJOR_AND_MINOR: {
                            AdminProtos.GetRegionInfoResponse.CompactionState compactionState = AdminProtos.GetRegionInfoResponse.CompactionState.MAJOR_AND_MINOR;
                            return compactionState;
                        }
                        case MAJOR: {
                            if (state == AdminProtos.GetRegionInfoResponse.CompactionState.MINOR) {
                                AdminProtos.GetRegionInfoResponse.CompactionState compactionState = AdminProtos.GetRegionInfoResponse.CompactionState.MAJOR_AND_MINOR;
                                return compactionState;
                            }
                            state = AdminProtos.GetRegionInfoResponse.CompactionState.MAJOR;
                            break;
                        }
                        case MINOR: {
                            if (state == AdminProtos.GetRegionInfoResponse.CompactionState.MAJOR) {
                                AdminProtos.GetRegionInfoResponse.CompactionState compactionState = AdminProtos.GetRegionInfoResponse.CompactionState.MAJOR_AND_MINOR;
                                return compactionState;
                            }
                            state = AdminProtos.GetRegionInfoResponse.CompactionState.MINOR;
                            break;
                        }
                    }
                }
                catch (NotServingRegionException e) {
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug((Object)("Trying to get compaction state of " + pair.getFirst() + ": " + StringUtils.stringifyException((Throwable)e)));
                }
            }
            return state;
        }
        catch (ServiceException se) {
            throw ProtobufUtil.getRemoteException(se);
        }
        finally {
            this.cleanupCatalogTracker(ct);
        }
    }

    public void snapshot(String snapshotName, String tableName) throws IOException, SnapshotCreationException, IllegalArgumentException {
        this.snapshot(snapshotName, tableName, HBaseProtos.SnapshotDescription.Type.FLUSH);
    }

    public void snapshot(byte[] snapshotName, byte[] tableName) throws IOException, SnapshotCreationException, IllegalArgumentException {
        this.snapshot(Bytes.toString((byte[])snapshotName), Bytes.toString((byte[])tableName));
    }

    public void snapshot(String snapshotName, String tableName, HBaseProtos.SnapshotDescription.Type type) throws IOException, SnapshotCreationException, IllegalArgumentException {
        HBaseProtos.SnapshotDescription.Builder builder = HBaseProtos.SnapshotDescription.newBuilder();
        builder.setTable(tableName);
        builder.setName(snapshotName);
        builder.setType(type);
        this.snapshot(builder.build());
    }

    public void snapshot(HBaseProtos.SnapshotDescription snapshot) throws IOException, SnapshotCreationException, IllegalArgumentException {
        MasterAdminProtos.TakeSnapshotResponse response = this.takeSnapshotAsync(snapshot);
        final MasterAdminProtos.IsSnapshotDoneRequest request = MasterAdminProtos.IsSnapshotDoneRequest.newBuilder().setSnapshot(snapshot).build();
        MasterAdminProtos.IsSnapshotDoneResponse done = null;
        long start = EnvironmentEdgeManager.currentTimeMillis();
        long max = response.getExpectedTimeout();
        long maxPauseTime = max / (long)this.numRetries;
        int tries = 0;
        LOG.debug((Object)("Waiting a max of " + max + " ms for snapshot '" + ClientSnapshotDescriptionUtils.toString(snapshot) + "'' to complete. (max " + maxPauseTime + " ms per retry)"));
        while (tries == 0 || EnvironmentEdgeManager.currentTimeMillis() - start < max && !done.getDone()) {
            try {
                long sleep = this.getPauseTime(tries++);
                sleep = sleep > maxPauseTime ? maxPauseTime : sleep;
                LOG.debug((Object)("(#" + tries + ") Sleeping: " + sleep + "ms while waiting for snapshot completion."));
                Thread.sleep(sleep);
            }
            catch (InterruptedException e) {
                LOG.debug((Object)("Interrupted while waiting for snapshot " + snapshot + " to complete"));
                Thread.currentThread().interrupt();
            }
            LOG.debug((Object)"Getting current status of snapshot from master...");
            done = this.execute(new MasterAdminCallable<MasterAdminProtos.IsSnapshotDoneResponse>(){

                @Override
                public MasterAdminProtos.IsSnapshotDoneResponse call() throws ServiceException {
                    return this.masterAdmin.isSnapshotDone(null, request);
                }
            });
        }
        if (!done.getDone()) {
            throw new SnapshotCreationException("Snapshot '" + snapshot.getName() + "' wasn't completed in expectedTime:" + max + " ms", snapshot);
        }
    }

    public MasterAdminProtos.TakeSnapshotResponse takeSnapshotAsync(HBaseProtos.SnapshotDescription snapshot) throws IOException, SnapshotCreationException {
        ClientSnapshotDescriptionUtils.assertSnapshotRequestIsValid(snapshot);
        final MasterAdminProtos.TakeSnapshotRequest request = MasterAdminProtos.TakeSnapshotRequest.newBuilder().setSnapshot(snapshot).build();
        return this.execute(new MasterAdminCallable<MasterAdminProtos.TakeSnapshotResponse>(){

            @Override
            public MasterAdminProtos.TakeSnapshotResponse call() throws ServiceException {
                return this.masterAdmin.snapshot(null, request);
            }
        });
    }

    public boolean isSnapshotFinished(final HBaseProtos.SnapshotDescription snapshot) throws IOException, HBaseSnapshotException, UnknownSnapshotException {
        return this.execute(new MasterAdminCallable<MasterAdminProtos.IsSnapshotDoneResponse>(){

            @Override
            public MasterAdminProtos.IsSnapshotDoneResponse call() throws ServiceException {
                return this.masterAdmin.isSnapshotDone(null, MasterAdminProtos.IsSnapshotDoneRequest.newBuilder().setSnapshot(snapshot).build());
            }
        }).getDone();
    }

    public void restoreSnapshot(byte[] snapshotName) throws IOException, RestoreSnapshotException {
        this.restoreSnapshot(Bytes.toString((byte[])snapshotName));
    }

    public void restoreSnapshot(String snapshotName) throws IOException, RestoreSnapshotException {
        String rollbackSnapshot = snapshotName + "-" + EnvironmentEdgeManager.currentTimeMillis();
        String tableName = null;
        for (HBaseProtos.SnapshotDescription snapshotInfo : this.listSnapshots()) {
            if (!snapshotInfo.getName().equals(snapshotName)) continue;
            tableName = snapshotInfo.getTable();
            break;
        }
        if (tableName == null) {
            throw new RestoreSnapshotException("Unable to find the table name for snapshot=" + snapshotName);
        }
        this.snapshot(rollbackSnapshot, tableName);
        try {
            this.internalRestoreSnapshot(snapshotName, tableName);
        }
        catch (IOException e) {
            try {
                String msg = "Restore snapshot=" + snapshotName + " failed. Rollback to snapshot=" + rollbackSnapshot + " succeeded.";
                LOG.error((Object)msg, (Throwable)e);
                this.internalRestoreSnapshot(rollbackSnapshot, tableName);
                throw new RestoreSnapshotException(msg, e);
            }
            catch (IOException ex) {
                String msg = "Failed to restore and rollback to snapshot=" + rollbackSnapshot;
                LOG.error((Object)msg, (Throwable)ex);
                throw new RestoreSnapshotException(msg, ex);
            }
        }
    }

    public void cloneSnapshot(byte[] snapshotName, byte[] tableName) throws IOException, TableExistsException, RestoreSnapshotException, InterruptedException {
        this.cloneSnapshot(Bytes.toString((byte[])snapshotName), Bytes.toString((byte[])tableName));
    }

    public void cloneSnapshot(String snapshotName, String tableName) throws IOException, TableExistsException, RestoreSnapshotException, InterruptedException {
        if (this.tableExists(tableName)) {
            throw new TableExistsException("Table '" + tableName + " already exists");
        }
        this.internalRestoreSnapshot(snapshotName, tableName);
        this.waitUntilTableIsEnabled(Bytes.toBytes((String)tableName));
    }

    private void internalRestoreSnapshot(String snapshotName, String tableName) throws IOException, RestoreSnapshotException {
        HBaseProtos.SnapshotDescription snapshot = HBaseProtos.SnapshotDescription.newBuilder().setName(snapshotName).setTable(tableName).build();
        this.internalRestoreSnapshotAsync(snapshot);
        final MasterAdminProtos.IsRestoreSnapshotDoneRequest request = MasterAdminProtos.IsRestoreSnapshotDoneRequest.newBuilder().setSnapshot(snapshot).build();
        MasterAdminProtos.IsRestoreSnapshotDoneResponse done = MasterAdminProtos.IsRestoreSnapshotDoneResponse.newBuilder().buildPartial();
        long maxPauseTime = 5000L;
        int tries = 0;
        while (!done.getDone()) {
            try {
                long sleep = this.getPauseTime(tries++);
                sleep = sleep > 5000L ? 5000L : sleep;
                LOG.debug((Object)(tries + ") Sleeping: " + sleep + " ms while we wait for snapshot restore to complete."));
                Thread.sleep(sleep);
            }
            catch (InterruptedException e) {
                LOG.debug((Object)("Interrupted while waiting for snapshot " + snapshot + " restore to complete"));
                Thread.currentThread().interrupt();
            }
            LOG.debug((Object)"Getting current status of snapshot restore from master...");
            done = this.execute(new MasterAdminCallable<MasterAdminProtos.IsRestoreSnapshotDoneResponse>(){

                @Override
                public MasterAdminProtos.IsRestoreSnapshotDoneResponse call() throws ServiceException {
                    return this.masterAdmin.isRestoreSnapshotDone(null, request);
                }
            });
        }
        if (!done.getDone()) {
            throw new RestoreSnapshotException("Snapshot '" + snapshot.getName() + "' wasn't restored.");
        }
    }

    private MasterAdminProtos.RestoreSnapshotResponse internalRestoreSnapshotAsync(HBaseProtos.SnapshotDescription snapshot) throws IOException, RestoreSnapshotException {
        ClientSnapshotDescriptionUtils.assertSnapshotRequestIsValid(snapshot);
        final MasterAdminProtos.RestoreSnapshotRequest request = MasterAdminProtos.RestoreSnapshotRequest.newBuilder().setSnapshot(snapshot).build();
        return this.execute(new MasterAdminCallable<MasterAdminProtos.RestoreSnapshotResponse>(){

            @Override
            public MasterAdminProtos.RestoreSnapshotResponse call() throws ServiceException {
                return this.masterAdmin.restoreSnapshot(null, request);
            }
        });
    }

    public List<HBaseProtos.SnapshotDescription> listSnapshots() throws IOException {
        return this.execute(new MasterAdminCallable<List<HBaseProtos.SnapshotDescription>>(){

            @Override
            public List<HBaseProtos.SnapshotDescription> call() throws ServiceException {
                return this.masterAdmin.getCompletedSnapshots(null, MasterAdminProtos.ListSnapshotRequest.newBuilder().build()).getSnapshotsList();
            }
        });
    }

    public List<HBaseProtos.SnapshotDescription> listSnapshots(String regex) throws IOException {
        return this.listSnapshots(Pattern.compile(regex));
    }

    public List<HBaseProtos.SnapshotDescription> listSnapshots(Pattern pattern) throws IOException {
        LinkedList<HBaseProtos.SnapshotDescription> matched = new LinkedList<HBaseProtos.SnapshotDescription>();
        List<HBaseProtos.SnapshotDescription> snapshots = this.listSnapshots();
        for (HBaseProtos.SnapshotDescription snapshot : snapshots) {
            if (!pattern.matcher(snapshot.getName()).matches()) continue;
            matched.add(snapshot);
        }
        return matched;
    }

    public void deleteSnapshot(byte[] snapshotName) throws IOException {
        this.deleteSnapshot(Bytes.toString((byte[])snapshotName));
    }

    public void deleteSnapshot(final String snapshotName) throws IOException {
        HTableDescriptor.isLegalTableName(Bytes.toBytes((String)snapshotName));
        this.execute(new MasterAdminCallable<Void>(){

            @Override
            public Void call() throws ServiceException {
                this.masterAdmin.deleteSnapshot(null, MasterAdminProtos.DeleteSnapshotRequest.newBuilder().setSnapshot(HBaseProtos.SnapshotDescription.newBuilder().setName(snapshotName).build()).build());
                return null;
            }
        });
    }

    public void deleteSnapshots(String regex) throws IOException {
        this.deleteSnapshots(Pattern.compile(regex));
    }

    public void deleteSnapshots(Pattern pattern) throws IOException {
        List<HBaseProtos.SnapshotDescription> snapshots = this.listSnapshots(pattern);
        for (final HBaseProtos.SnapshotDescription snapshot : snapshots) {
            this.execute(new MasterAdminCallable<Void>(){

                @Override
                public Void call() throws ServiceException {
                    this.masterAdmin.deleteSnapshot(null, MasterAdminProtos.DeleteSnapshotRequest.newBuilder().setSnapshot(snapshot).build());
                    return null;
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <V> V execute(MasterAdminCallable<V> function) throws IOException {
        function.masterAdmin = this.connection.getKeepAliveMasterAdminService();
        try {
            V v = this.executeCallable(function);
            return v;
        }
        finally {
            function.masterAdmin.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <V> V execute(MasterMonitorCallable<V> function) throws IOException {
        function.masterMonitor = this.connection.getKeepAliveMasterMonitorService();
        try {
            V v = this.executeCallable(function);
            return v;
        }
        finally {
            function.masterMonitor.close();
        }
    }

    private <V> V executeCallable(Callable<V> function) throws IOException {
        try {
            return function.call();
        }
        catch (RemoteException re) {
            throw re.unwrapRemoteException();
        }
        catch (IOException e) {
            throw e;
        }
        catch (ServiceException se) {
            throw ProtobufUtil.getRemoteException(se);
        }
        catch (Exception e) {
            throw new IOException("Unexpected exception when calling master", e);
        }
    }

    public CoprocessorRpcChannel coprocessorService() {
        return new MasterCoprocessorRpcChannel(this.connection);
    }

    private static abstract class MasterMonitorCallable<V>
    implements Callable<V> {
        protected MasterMonitorKeepAliveConnection masterMonitor;

        private MasterMonitorCallable() {
        }
    }

    private static abstract class MasterAdminCallable<V>
    implements Callable<V> {
        protected MasterAdminKeepAliveConnection masterAdmin;

        private MasterAdminCallable() {
        }
    }
}

