/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.ExecutorService;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.client.MasterAdminKeepAliveConnection;
import org.apache.hadoop.hbase.client.MasterMonitorKeepAliveConnection;
import org.apache.hadoop.hbase.client.Row;
import org.apache.hadoop.hbase.client.ServerCallable;
import org.apache.hadoop.hbase.client.coprocessor.Batch;
import org.apache.hadoop.hbase.exceptions.MasterNotRunningException;
import org.apache.hadoop.hbase.exceptions.ZooKeeperConnectionException;
import org.apache.hadoop.hbase.protobuf.generated.AdminProtos;
import org.apache.hadoop.hbase.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.protobuf.generated.MasterAdminProtos;
import org.apache.hadoop.hbase.protobuf.generated.MasterMonitorProtos;

@InterfaceAudience.Public
@InterfaceStability.Stable
public interface HConnection
extends Abortable,
Closeable {
    public Configuration getConfiguration();

    public boolean isMasterRunning() throws MasterNotRunningException, ZooKeeperConnectionException;

    public boolean isTableEnabled(byte[] var1) throws IOException;

    public boolean isTableDisabled(byte[] var1) throws IOException;

    public boolean isTableAvailable(byte[] var1) throws IOException;

    public boolean isTableAvailable(byte[] var1, byte[][] var2) throws IOException;

    public HTableDescriptor[] listTables() throws IOException;

    public HTableDescriptor getHTableDescriptor(byte[] var1) throws IOException;

    public HRegionLocation locateRegion(byte[] var1, byte[] var2) throws IOException;

    public void clearRegionCache();

    public void clearRegionCache(byte[] var1);

    public void deleteCachedRegionLocation(HRegionLocation var1);

    public HRegionLocation relocateRegion(byte[] var1, byte[] var2) throws IOException;

    public HRegionLocation locateRegion(byte[] var1) throws IOException;

    public List<HRegionLocation> locateRegions(byte[] var1) throws IOException;

    public List<HRegionLocation> locateRegions(byte[] var1, boolean var2, boolean var3) throws IOException;

    public MasterAdminProtos.MasterAdminService.BlockingInterface getMasterAdmin() throws IOException;

    public MasterMonitorProtos.MasterMonitorService.BlockingInterface getMasterMonitor() throws IOException;

    public AdminProtos.AdminService.BlockingInterface getAdmin(ServerName var1) throws IOException;

    public ClientProtos.ClientService.BlockingInterface getClient(ServerName var1) throws IOException;

    public AdminProtos.AdminService.BlockingInterface getAdmin(ServerName var1, boolean var2) throws IOException;

    public HRegionLocation getRegionLocation(byte[] var1, byte[] var2, boolean var3) throws IOException;

    @Deprecated
    public <T> T getRegionServerWithRetries(ServerCallable<T> var1) throws IOException, RuntimeException;

    @Deprecated
    public <T> T getRegionServerWithoutRetries(ServerCallable<T> var1) throws IOException, RuntimeException;

    @Deprecated
    public void processBatch(List<? extends Row> var1, byte[] var2, ExecutorService var3, Object[] var4) throws IOException, InterruptedException;

    @Deprecated
    public <R> void processBatchCallback(List<? extends Row> var1, byte[] var2, ExecutorService var3, Object[] var4, Batch.Callback<R> var5) throws IOException, InterruptedException;

    public void setRegionCachePrefetch(byte[] var1, boolean var2);

    public boolean getRegionCachePrefetch(byte[] var1);

    public int getCurrentNrHRS() throws IOException;

    public HTableDescriptor[] getHTableDescriptors(List<String> var1) throws IOException;

    public boolean isClosed();

    public void clearCaches(ServerName var1);

    public MasterMonitorKeepAliveConnection getKeepAliveMasterMonitorService() throws MasterNotRunningException;

    public MasterAdminKeepAliveConnection getKeepAliveMasterAdminService() throws MasterNotRunningException;

    public boolean isDeadServer(ServerName var1);
}

