/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import com.google.common.annotations.VisibleForTesting;
import com.google.protobuf.BlockingRpcChannel;
import com.google.protobuf.RpcController;
import com.google.protobuf.ServiceException;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Chore;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.Stoppable;
import org.apache.hadoop.hbase.client.Action;
import org.apache.hadoop.hbase.client.ClusterStatusListener;
import org.apache.hadoop.hbase.client.ConnectionUtils;
import org.apache.hadoop.hbase.client.HConnectable;
import org.apache.hadoop.hbase.client.HConnection;
import org.apache.hadoop.hbase.client.HConnectionKey;
import org.apache.hadoop.hbase.client.MasterAdminKeepAliveConnection;
import org.apache.hadoop.hbase.client.MasterMonitorKeepAliveConnection;
import org.apache.hadoop.hbase.client.MetaScanner;
import org.apache.hadoop.hbase.client.MultiAction;
import org.apache.hadoop.hbase.client.MultiResponse;
import org.apache.hadoop.hbase.client.MultiServerCallable;
import org.apache.hadoop.hbase.client.NoServerForRegionException;
import org.apache.hadoop.hbase.client.RegionOfflineException;
import org.apache.hadoop.hbase.client.Registry;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.RetriesExhaustedWithDetailsException;
import org.apache.hadoop.hbase.client.Row;
import org.apache.hadoop.hbase.client.ServerCallable;
import org.apache.hadoop.hbase.client.ZooKeeperKeepAliveConnection;
import org.apache.hadoop.hbase.client.ZooKeeperRegistry;
import org.apache.hadoop.hbase.client.coprocessor.Batch;
import org.apache.hadoop.hbase.exceptions.DoNotRetryIOException;
import org.apache.hadoop.hbase.exceptions.MasterNotRunningException;
import org.apache.hadoop.hbase.exceptions.RegionMovedException;
import org.apache.hadoop.hbase.exceptions.RegionOpeningException;
import org.apache.hadoop.hbase.exceptions.RegionServerStoppedException;
import org.apache.hadoop.hbase.exceptions.TableNotFoundException;
import org.apache.hadoop.hbase.exceptions.ZooKeeperConnectionException;
import org.apache.hadoop.hbase.ipc.RpcClient;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.RequestConverter;
import org.apache.hadoop.hbase.protobuf.generated.AdminProtos;
import org.apache.hadoop.hbase.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.protobuf.generated.MasterAdminProtos;
import org.apache.hadoop.hbase.protobuf.generated.MasterMonitorProtos;
import org.apache.hadoop.hbase.protobuf.generated.MasterProtos;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.util.SoftValueSortedMap;
import org.apache.hadoop.hbase.util.Triple;
import org.apache.hadoop.hbase.zookeeper.MasterAddressTracker;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.zookeeper.KeeperException;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class HConnectionManager {
    static final Log LOG = LogFactory.getLog(HConnectionManager.class);
    public static final String RETRIES_BY_SERVER_KEY = "hbase.client.retries.by.server";
    static final Map<HConnectionKey, HConnectionImplementation> CONNECTION_INSTANCES;
    public static final int MAX_CACHED_CONNECTION_INSTANCES;

    private HConnectionManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HConnection getConnection(Configuration conf) throws IOException {
        HConnectionKey connectionKey = new HConnectionKey(conf);
        Map<HConnectionKey, HConnectionImplementation> map = CONNECTION_INSTANCES;
        synchronized (map) {
            HConnectionImplementation connection = CONNECTION_INSTANCES.get(connectionKey);
            if (connection == null) {
                connection = (HConnectionImplementation)HConnectionManager.createConnection(conf, true);
                CONNECTION_INSTANCES.put(connectionKey, connection);
            } else if (connection.isClosed()) {
                HConnectionManager.deleteConnection(connectionKey, true);
                connection = (HConnectionImplementation)HConnectionManager.createConnection(conf, true);
                CONNECTION_INSTANCES.put(connectionKey, connection);
            }
            connection.incCount();
            return connection;
        }
    }

    public static HConnection createConnection(Configuration conf) throws IOException {
        return HConnectionManager.createConnection(conf, false);
    }

    static HConnection createConnection(Configuration conf, boolean managed) throws IOException {
        String className = conf.get("hbase.client.connection.impl", HConnectionImplementation.class.getName());
        Class<?> clazz = null;
        try {
            clazz = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new IOException(e);
        }
        try {
            Constructor<?> constructor = clazz.getDeclaredConstructor(Configuration.class, Boolean.TYPE);
            constructor.setAccessible(true);
            return (HConnection)constructor.newInstance(conf, managed);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public static void deleteConnection(Configuration conf) {
        HConnectionManager.deleteConnection(new HConnectionKey(conf), false);
    }

    public static void deleteStaleConnection(HConnection connection) {
        HConnectionManager.deleteConnection(connection, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteAllConnections() {
        Map<HConnectionKey, HConnectionImplementation> map = CONNECTION_INSTANCES;
        synchronized (map) {
            HashSet<HConnectionKey> connectionKeys = new HashSet<HConnectionKey>();
            connectionKeys.addAll(CONNECTION_INSTANCES.keySet());
            for (HConnectionKey connectionKey : connectionKeys) {
                HConnectionManager.deleteConnection(connectionKey, false);
            }
            CONNECTION_INSTANCES.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void deleteConnection(HConnection connection, boolean staleConnection) {
        Map<HConnectionKey, HConnectionImplementation> map = CONNECTION_INSTANCES;
        synchronized (map) {
            for (Map.Entry<HConnectionKey, HConnectionImplementation> e : CONNECTION_INSTANCES.entrySet()) {
                if (e.getValue() != connection) continue;
                HConnectionManager.deleteConnection(e.getKey(), staleConnection);
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void deleteConnection(HConnectionKey connectionKey, boolean staleConnection) {
        Map<HConnectionKey, HConnectionImplementation> map = CONNECTION_INSTANCES;
        synchronized (map) {
            HConnectionImplementation connection = CONNECTION_INSTANCES.get(connectionKey);
            if (connection != null) {
                connection.decCount();
                if (connection.isZeroReference() || staleConnection) {
                    CONNECTION_INSTANCES.remove(connectionKey);
                    connection.internalClose();
                }
            } else {
                LOG.error((Object)("Connection not found in the list, can't delete it (connection key=" + connectionKey + "). May be the key was modified?"));
            }
        }
    }

    static int getCachedRegionCount(Configuration conf, final byte[] tableName) throws IOException {
        return HConnectionManager.execute(new HConnectable<Integer>(conf){

            @Override
            public Integer connect(HConnection connection) {
                return ((HConnectionImplementation)connection).getNumberOfCachedRegionLocations(tableName);
            }
        });
    }

    static boolean isRegionCached(Configuration conf, final byte[] tableName, final byte[] row) throws IOException {
        return HConnectionManager.execute(new HConnectable<Boolean>(conf){

            @Override
            public Boolean connect(HConnection connection) {
                return ((HConnectionImplementation)connection).isRegionCached(tableName, row);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T execute(HConnectable<T> connectable) throws IOException {
        if (connectable == null || connectable.conf == null) {
            return null;
        }
        Configuration conf = connectable.conf;
        HConnection connection = HConnectionManager.getConnection(conf);
        boolean connectSucceeded = false;
        try {
            T returnValue = connectable.connect(connection);
            connectSucceeded = true;
            T t = returnValue;
            return t;
        }
        finally {
            block8: {
                try {
                    connection.close();
                }
                catch (Exception e) {
                    if (!connectSucceeded) break block8;
                    throw new IOException("The connection to " + connection + " could not be deleted.", e);
                }
            }
        }
    }

    public static void setServerSideHConnectionRetries(Configuration c, String sn, Log log) {
        int hcRetries = c.getInt(HConstants.HBASE_CLIENT_RETRIES_NUMBER, HConstants.DEFAULT_HBASE_CLIENT_RETRIES_NUMBER);
        int serversideMultiplier = c.getInt("hbase.client.serverside.retries.multiplier", 10);
        int retries = hcRetries * serversideMultiplier;
        c.setInt(HConstants.HBASE_CLIENT_RETRIES_NUMBER, retries);
        log.debug((Object)(sn + " HConnection server-to-server retries=" + retries));
    }

    static {
        MAX_CACHED_CONNECTION_INSTANCES = HBaseConfiguration.create().getInt("hbase.zookeeper.property.maxClientCnxns", 300) + 1;
        CONNECTION_INSTANCES = new LinkedHashMap<HConnectionKey, HConnectionImplementation>((int)((float)MAX_CACHED_CONNECTION_INSTANCES / 0.75f) + 1, 0.75f, true){

            @Override
            protected boolean removeEldestEntry(Map.Entry<HConnectionKey, HConnectionImplementation> eldest) {
                return this.size() > MAX_CACHED_CONNECTION_INSTANCES;
            }
        };
    }

    @SuppressWarnings(value={"AT_OPERATION_SEQUENCE_ON_CONCURRENT_ABSTRACTION"}, justification="Access to the conncurrent hash map is under a lock so should be fine.")
    static class HConnectionImplementation
    implements HConnection,
    Closeable {
        static final Log LOG = LogFactory.getLog(HConnectionImplementation.class);
        private final long pause;
        private final int numTries;
        final int rpcTimeout;
        private final int prefetchRegionLimit;
        private final boolean useServerTrackerForRetries;
        private final long serverTrackerTimeout;
        private volatile boolean closed;
        private volatile boolean aborted;
        ClusterStatusListener clusterStatusListener;
        private final Object userRegionLock = new Object();
        private final Object masterAndZKLock = new Object();
        private long keepZooKeeperWatcherAliveUntil = Long.MAX_VALUE;
        private final DelayedClosing delayedClosing = DelayedClosing.createAndStart(this);
        private final Configuration conf;
        private RpcClient rpcClient;
        private final Map<Integer, SoftValueSortedMap<byte[], HRegionLocation>> cachedRegionLocations = new HashMap<Integer, SoftValueSortedMap<byte[], HRegionLocation>>();
        private final Set<ServerName> cachedServers = new HashSet<ServerName>();
        private final Set<Integer> regionCachePrefetchDisabledTables = new CopyOnWriteArraySet<Integer>();
        private int refCount;
        private final boolean managed;
        final Registry registry;
        protected String clusterId = null;
        private final ConcurrentHashMap<String, Object> stubs = new ConcurrentHashMap();
        private final ConcurrentHashMap<String, String> connectionLock = new ConcurrentHashMap();
        private ZooKeeperKeepAliveConnection keepAliveZookeeper;
        private int keepAliveZookeeperUserCount;
        private boolean canCloseZKW = true;
        private static final long keepAlive = 300000L;
        final MasterAdminServiceState adminMasterServiceState = new MasterAdminServiceState(this);
        final MasterMonitorServiceState monitorMasterServiceState = new MasterMonitorServiceState(this);

        HConnectionImplementation(Configuration conf, boolean managed) throws IOException {
            this.conf = conf;
            this.managed = managed;
            this.closed = false;
            this.pause = conf.getLong(HConstants.HBASE_CLIENT_PAUSE, HConstants.DEFAULT_HBASE_CLIENT_PAUSE);
            this.numTries = conf.getInt(HConstants.HBASE_CLIENT_RETRIES_NUMBER, HConstants.DEFAULT_HBASE_CLIENT_RETRIES_NUMBER);
            this.rpcTimeout = conf.getInt(HConstants.HBASE_RPC_TIMEOUT_KEY, HConstants.DEFAULT_HBASE_RPC_TIMEOUT);
            this.prefetchRegionLimit = conf.getInt(HConstants.HBASE_CLIENT_PREFETCH_LIMIT, HConstants.DEFAULT_HBASE_CLIENT_PREFETCH_LIMIT);
            this.useServerTrackerForRetries = conf.getBoolean(HConnectionManager.RETRIES_BY_SERVER_KEY, true);
            long serverTrackerTimeout = 0L;
            if (this.useServerTrackerForRetries) {
                for (int i = 0; i < this.numTries; ++i) {
                    serverTrackerTimeout += ConnectionUtils.getPauseTime(this.pause, i);
                }
            }
            this.serverTrackerTimeout = serverTrackerTimeout;
            this.registry = this.setupRegistry();
            this.retrieveClusterId();
            this.rpcClient = new RpcClient(this.conf, this.clusterId);
            Class listenerClass = conf.getClass("hbase.status.listener.class", ClusterStatusListener.DEFAULT_STATUS_LISTENER_CLASS, ClusterStatusListener.Listener.class);
            if (listenerClass != null) {
                this.clusterStatusListener = new ClusterStatusListener(new ClusterStatusListener.DeadServerHandler(){

                    @Override
                    public void newDead(ServerName sn) {
                        HConnectionImplementation.this.clearCaches(sn);
                        HConnectionImplementation.this.rpcClient.cancelConnections(sn.getHostname(), sn.getPort(), new SocketException(sn.getServerName() + " is dead: closing its connection."));
                    }
                }, conf, listenerClass);
            }
        }

        private Registry setupRegistry() throws IOException {
            String registryClass = this.conf.get("hbase.client.registry.impl", ZooKeeperRegistry.class.getName());
            Registry registry = null;
            try {
                registry = (Registry)Class.forName(registryClass).newInstance();
            }
            catch (Throwable t) {
                throw new IOException(t);
            }
            registry.init(this);
            return registry;
        }

        RpcClient setRpcClient(RpcClient rpcClient) {
            RpcClient oldRpcClient = this.rpcClient;
            this.rpcClient = rpcClient;
            return oldRpcClient;
        }

        public String toString() {
            return "hconnection-0x" + Integer.toHexString(this.hashCode());
        }

        void retrieveClusterId() {
            if (this.clusterId != null) {
                return;
            }
            this.clusterId = this.registry.getClusterId();
            if (this.clusterId == null) {
                this.clusterId = "default-cluster";
                LOG.debug((Object)("clusterid came back null, using default " + this.clusterId));
            }
        }

        @Override
        public Configuration getConfiguration() {
            return this.conf;
        }

        private void checkIfBaseNodeAvailable(ZooKeeperWatcher zkw) throws MasterNotRunningException {
            try {
                if (ZKUtil.checkExists(zkw, zkw.baseZNode) == -1) {
                    String errorMsg = "The node " + zkw.baseZNode + " is not in ZooKeeper. " + "It should have been written by the master. " + "Check the value configured in 'zookeeper.znode.parent'. " + "There could be a mismatch with the one configured in the master.";
                    LOG.error((Object)errorMsg);
                    throw new MasterNotRunningException(errorMsg);
                }
            }
            catch (KeeperException e) {
                String errorMsg = "Can't get connection to ZooKeeper: " + e.getMessage();
                LOG.error((Object)errorMsg);
                throw new MasterNotRunningException(errorMsg, (Exception)((Object)e));
            }
        }

        @Override
        public boolean isMasterRunning() throws MasterNotRunningException, ZooKeeperConnectionException {
            MasterMonitorKeepAliveConnection m = this.getKeepAliveMasterMonitorService();
            try {
                m.close();
            }
            catch (IOException e) {
                throw new MasterNotRunningException("Failed close", e);
            }
            return true;
        }

        @Override
        public HRegionLocation getRegionLocation(byte[] name, byte[] row, boolean reload) throws IOException {
            return reload ? this.relocateRegion(name, row) : this.locateRegion(name, row);
        }

        @Override
        public boolean isTableEnabled(byte[] tableName) throws IOException {
            return this.registry.isTableOnlineState(tableName, true);
        }

        @Override
        public boolean isTableDisabled(byte[] tableName) throws IOException {
            return this.registry.isTableOnlineState(tableName, false);
        }

        @Override
        public boolean isTableAvailable(final byte[] tableName) throws IOException {
            final AtomicBoolean available = new AtomicBoolean(true);
            final AtomicInteger regionCount = new AtomicInteger(0);
            MetaScanner.MetaScannerVisitorBase visitor = new MetaScanner.MetaScannerVisitorBase(){

                @Override
                public boolean processRow(Result row) throws IOException {
                    HRegionInfo info = MetaScanner.getHRegionInfo(row);
                    if (info != null) {
                        if (Bytes.compareTo((byte[])tableName, (byte[])info.getTableName()) == 0) {
                            ServerName server = HRegionInfo.getServerName(row);
                            if (server == null) {
                                available.set(false);
                                return false;
                            }
                            regionCount.incrementAndGet();
                        } else if (Bytes.compareTo((byte[])tableName, (byte[])info.getTableName()) < 0) {
                            return false;
                        }
                    }
                    return true;
                }
            };
            MetaScanner.metaScan(this.conf, visitor, tableName);
            return available.get() && regionCount.get() > 0;
        }

        @Override
        public boolean isTableAvailable(final byte[] tableName, final byte[][] splitKeys) throws IOException {
            final AtomicBoolean available = new AtomicBoolean(true);
            final AtomicInteger regionCount = new AtomicInteger(0);
            MetaScanner.MetaScannerVisitorBase visitor = new MetaScanner.MetaScannerVisitorBase(){

                @Override
                public boolean processRow(Result row) throws IOException {
                    HRegionInfo info = MetaScanner.getHRegionInfo(row);
                    if (info != null) {
                        if (Bytes.compareTo((byte[])tableName, (byte[])info.getTableName()) == 0) {
                            ServerName server = HRegionInfo.getServerName(row);
                            if (server == null) {
                                available.set(false);
                                return false;
                            }
                            if (!Bytes.equals((byte[])info.getStartKey(), (byte[])HConstants.EMPTY_BYTE_ARRAY)) {
                                for (byte[] splitKey : splitKeys) {
                                    if (!Bytes.equals((byte[])info.getStartKey(), (byte[])splitKey)) continue;
                                    regionCount.incrementAndGet();
                                    break;
                                }
                            } else {
                                regionCount.incrementAndGet();
                            }
                        } else if (Bytes.compareTo((byte[])tableName, (byte[])info.getTableName()) < 0) {
                            return false;
                        }
                    }
                    return true;
                }
            };
            MetaScanner.metaScan(this.conf, visitor, tableName);
            return available.get() && regionCount.get() == splitKeys.length + 1;
        }

        @Override
        public HRegionLocation locateRegion(byte[] regionName) throws IOException {
            return this.locateRegion(HRegionInfo.getTableName(regionName), HRegionInfo.getStartKey(regionName), false, true);
        }

        @Override
        public boolean isDeadServer(ServerName sn) {
            if (this.clusterStatusListener == null) {
                return false;
            }
            return this.clusterStatusListener.isDeadServer(sn);
        }

        @Override
        public List<HRegionLocation> locateRegions(byte[] tableName) throws IOException {
            return this.locateRegions(tableName, false, true);
        }

        @Override
        public List<HRegionLocation> locateRegions(byte[] tableName, boolean useCache, boolean offlined) throws IOException {
            NavigableMap<HRegionInfo, ServerName> regions = MetaScanner.allTableRegions(this.conf, tableName, offlined);
            ArrayList<HRegionLocation> locations = new ArrayList<HRegionLocation>();
            for (HRegionInfo regionInfo : regions.keySet()) {
                locations.add(this.locateRegion(tableName, regionInfo.getStartKey(), useCache, true));
            }
            return locations;
        }

        @Override
        public HRegionLocation locateRegion(byte[] tableName, byte[] row) throws IOException {
            return this.locateRegion(tableName, row, true, true);
        }

        @Override
        public HRegionLocation relocateRegion(byte[] tableName, byte[] row) throws IOException {
            if (this.isTableDisabled(tableName)) {
                throw new DoNotRetryIOException(Bytes.toString((byte[])tableName) + " is disabled.");
            }
            return this.locateRegion(tableName, row, false, true);
        }

        private HRegionLocation locateRegion(byte[] tableName, byte[] row, boolean useCache, boolean retry) throws IOException {
            if (this.closed) {
                throw new IOException(this.toString() + " closed");
            }
            if (tableName == null || tableName.length == 0) {
                throw new IllegalArgumentException("table name cannot be null or zero length");
            }
            if (Bytes.equals((byte[])tableName, (byte[])HConstants.META_TABLE_NAME)) {
                return this.registry.getMetaRegionLocation();
            }
            return this.locateRegionInMeta(HConstants.META_TABLE_NAME, tableName, row, useCache, this.userRegionLock, retry);
        }

        private void prefetchRegionCache(final byte[] tableName, byte[] row) {
            MetaScanner.MetaScannerVisitorBase visitor = new MetaScanner.MetaScannerVisitorBase(){

                @Override
                public boolean processRow(Result result) throws IOException {
                    try {
                        HRegionInfo regionInfo = MetaScanner.getHRegionInfo(result);
                        if (regionInfo == null) {
                            return true;
                        }
                        if (!Bytes.equals((byte[])regionInfo.getTableName(), (byte[])tableName)) {
                            return false;
                        }
                        if (regionInfo.isOffline()) {
                            return true;
                        }
                        ServerName serverName = HRegionInfo.getServerName(result);
                        if (serverName == null) {
                            return true;
                        }
                        long seqNum = HRegionInfo.getSeqNumDuringOpen(result);
                        HRegionLocation loc = new HRegionLocation(regionInfo, serverName, seqNum);
                        HConnectionImplementation.this.cacheLocation(tableName, null, loc);
                        return true;
                    }
                    catch (RuntimeException e) {
                        throw new IOException(e);
                    }
                }
            };
            try {
                MetaScanner.metaScan(this.conf, visitor, tableName, row, this.prefetchRegionLimit);
            }
            catch (IOException e) {
                LOG.warn((Object)"Encountered problems when prefetch META table: ", (Throwable)e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private HRegionLocation locateRegionInMeta(byte[] parentTable, byte[] tableName, byte[] row, boolean useCache, Object regionLockObject, boolean retry) throws IOException {
            HRegionLocation location;
            if (useCache && (location = this.getCachedLocation(tableName, row)) != null) {
                return location;
            }
            int localNumRetries = retry ? this.numTries : 1;
            byte[] metaKey = HRegionInfo.createRegionName(tableName, row, "99999999999999", false);
            int tries = 0;
            while (true) {
                block28: {
                    if (tries >= localNumRetries) {
                        throw new NoServerForRegionException("Unable to find region for " + Bytes.toStringBinary((byte[])row) + " after " + this.numTries + " tries.");
                    }
                    HRegionLocation metaLocation = null;
                    try {
                        Result regionInfoRow;
                        metaLocation = this.locateRegion(parentTable, metaKey, true, false);
                        if (metaLocation == null) break block28;
                        ClientProtos.ClientService.BlockingInterface service = this.getClient(metaLocation.getServerName());
                        Object object = regionLockObject;
                        synchronized (object) {
                            if (useCache) {
                                location = this.getCachedLocation(tableName, row);
                                if (location != null) {
                                    return location;
                                }
                                if (Bytes.equals((byte[])parentTable, (byte[])HConstants.META_TABLE_NAME) && this.getRegionCachePrefetch(tableName)) {
                                    this.prefetchRegionCache(tableName, row);
                                }
                                if ((location = this.getCachedLocation(tableName, row)) != null) {
                                    return location;
                                }
                            } else {
                                this.forceDeleteCachedLocation(tableName, row);
                            }
                            regionInfoRow = ProtobufUtil.getRowOrBefore(service, metaLocation.getRegionInfo().getRegionName(), metaKey, HConstants.CATALOG_FAMILY);
                        }
                        if (regionInfoRow == null) {
                            throw new TableNotFoundException(Bytes.toString((byte[])tableName));
                        }
                        HRegionInfo regionInfo = MetaScanner.getHRegionInfo(regionInfoRow);
                        if (regionInfo == null) {
                            throw new IOException("HRegionInfo was null or empty in " + Bytes.toString((byte[])parentTable) + ", row=" + regionInfoRow);
                        }
                        if (!Bytes.equals((byte[])regionInfo.getTableName(), (byte[])tableName)) {
                            throw new TableNotFoundException("Table '" + Bytes.toString((byte[])tableName) + "' was not found, got: " + Bytes.toString((byte[])regionInfo.getTableName()) + ".");
                        }
                        if (regionInfo.isSplit()) {
                            throw new RegionOfflineException("the only available region for the required row is a split parent, the daughters should be online soon: " + regionInfo.getRegionNameAsString());
                        }
                        if (regionInfo.isOffline()) {
                            throw new RegionOfflineException("the region is offline, could be caused by a disable table call: " + regionInfo.getRegionNameAsString());
                        }
                        ServerName serverName = HRegionInfo.getServerName(regionInfoRow);
                        if (serverName == null) {
                            throw new NoServerForRegionException("No server address listed in " + Bytes.toString((byte[])parentTable) + " for region " + regionInfo.getRegionNameAsString() + " containing row " + Bytes.toStringBinary((byte[])row));
                        }
                        if (this.isDeadServer(serverName)) {
                            throw new RegionServerStoppedException(".META. says the region " + regionInfo.getRegionNameAsString() + " is managed by the server " + serverName + ", but it is dead.");
                        }
                        location = new HRegionLocation(regionInfo, serverName, HRegionInfo.getSeqNumDuringOpen(regionInfoRow));
                        this.cacheLocation(tableName, null, location);
                        return location;
                    }
                    catch (TableNotFoundException e) {
                        throw e;
                    }
                    catch (IOException e) {
                        if (e instanceof RemoteException) {
                            e = ((RemoteException)((Object)e)).unwrapRemoteException();
                        }
                        if (tries < this.numTries - 1) {
                            if (LOG.isDebugEnabled()) {
                                LOG.debug((Object)("locateRegionInMeta parentTable=" + Bytes.toString((byte[])parentTable) + ", metaLocation=" + (metaLocation == null ? "null" : "{" + metaLocation + "}") + ", attempt=" + tries + " of " + this.numTries + " failed; retrying after sleep of " + ConnectionUtils.getPauseTime(this.pause, tries) + " because: " + e.getMessage()));
                            }
                        } else {
                            throw e;
                        }
                        if (!(e instanceof RegionOfflineException) && !(e instanceof NoServerForRegionException)) {
                            this.relocateRegion(parentTable, metaKey);
                        }
                        try {
                            Thread.sleep(ConnectionUtils.getPauseTime(this.pause, tries));
                        }
                        catch (InterruptedException e2) {
                            Thread.currentThread().interrupt();
                            throw new IOException("Giving up trying to location region in meta: thread is interrupted.");
                        }
                    }
                }
                ++tries;
            }
        }

        HRegionLocation getCachedLocation(byte[] tableName, byte[] row) {
            SoftValueSortedMap<byte[], HRegionLocation> tableLocations = this.getTableLocations(tableName);
            if (tableLocations.isEmpty()) {
                return null;
            }
            HRegionLocation possibleRegion = (HRegionLocation)tableLocations.get((Object)row);
            if (possibleRegion != null) {
                return possibleRegion;
            }
            possibleRegion = (HRegionLocation)tableLocations.lowerValueByKey((Object)row);
            if (possibleRegion == null) {
                return null;
            }
            byte[] endKey = possibleRegion.getRegionInfo().getEndKey();
            if (Bytes.equals((byte[])endKey, (byte[])HConstants.EMPTY_END_ROW) || KeyValue.getRowComparator((byte[])tableName).compareRows(endKey, 0, endKey.length, row, 0, row.length) > 0) {
                return possibleRegion;
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void forceDeleteCachedLocation(byte[] tableName, byte[] row) {
            HRegionLocation rl = null;
            Map<Integer, SoftValueSortedMap<byte[], HRegionLocation>> map = this.cachedRegionLocations;
            synchronized (map) {
                SoftValueSortedMap<byte[], HRegionLocation> tableLocations = this.getTableLocations(tableName);
                if (!tableLocations.isEmpty() && (rl = this.getCachedLocation(tableName, row)) != null) {
                    tableLocations.remove(rl.getRegionInfo().getStartKey());
                }
            }
            if (rl != null && LOG.isDebugEnabled()) {
                LOG.debug((Object)("Removed " + rl.getHostname() + ":" + rl.getPort() + " as a location of " + rl.getRegionInfo().getRegionNameAsString() + " for tableName=" + Bytes.toString((byte[])tableName) + " from cache"));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clearCaches(ServerName serverName) {
            boolean deletedSomething = false;
            Map<Integer, SoftValueSortedMap<byte[], HRegionLocation>> map = this.cachedRegionLocations;
            synchronized (map) {
                if (!this.cachedServers.contains(serverName)) {
                    return;
                }
                for (SoftValueSortedMap<byte[], HRegionLocation> tableLocations : this.cachedRegionLocations.values()) {
                    for (Map.Entry e : tableLocations.entrySet()) {
                        if (!serverName.equals(((HRegionLocation)e.getValue()).getServerName())) continue;
                        tableLocations.remove(e.getKey());
                        deletedSomething = true;
                    }
                }
                this.cachedServers.remove(serverName);
            }
            if (deletedSomething && LOG.isDebugEnabled()) {
                LOG.debug((Object)("Removed all cached region locations that map to " + serverName));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private SoftValueSortedMap<byte[], HRegionLocation> getTableLocations(byte[] tableName) {
            SoftValueSortedMap result;
            Integer key = Bytes.mapKey((byte[])tableName);
            Map<Integer, SoftValueSortedMap<byte[], HRegionLocation>> map = this.cachedRegionLocations;
            synchronized (map) {
                result = this.cachedRegionLocations.get(key);
                if (result == null) {
                    result = new SoftValueSortedMap(Bytes.BYTES_COMPARATOR);
                    this.cachedRegionLocations.put(key, (SoftValueSortedMap<byte[], HRegionLocation>)result);
                }
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clearRegionCache() {
            Map<Integer, SoftValueSortedMap<byte[], HRegionLocation>> map = this.cachedRegionLocations;
            synchronized (map) {
                this.cachedRegionLocations.clear();
                this.cachedServers.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clearRegionCache(byte[] tableName) {
            Map<Integer, SoftValueSortedMap<byte[], HRegionLocation>> map = this.cachedRegionLocations;
            synchronized (map) {
                this.cachedRegionLocations.remove(Bytes.mapKey((byte[])tableName));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void cacheLocation(byte[] tableName, HRegionLocation source, HRegionLocation location) {
            boolean isFromMeta = source == null;
            byte[] startKey = location.getRegionInfo().getStartKey();
            SoftValueSortedMap<byte[], HRegionLocation> tableLocations = this.getTableLocations(tableName);
            boolean isNewCacheEntry = false;
            boolean isStaleUpdate = false;
            HRegionLocation oldLocation = null;
            Map<Integer, SoftValueSortedMap<byte[], HRegionLocation>> map = this.cachedRegionLocations;
            synchronized (map) {
                this.cachedServers.add(location.getServerName());
                oldLocation = (HRegionLocation)tableLocations.get(startKey);
                boolean bl = isNewCacheEntry = oldLocation == null;
                if (!isNewCacheEntry && !oldLocation.equals(source)) {
                    long newLocationSeqNum = location.getSeqNum();
                    boolean isStaleMetaRecord = isFromMeta && oldLocation.getSeqNum() > newLocationSeqNum;
                    boolean isStaleRedirect = !isFromMeta && oldLocation.getSeqNum() >= newLocationSeqNum;
                    boolean bl2 = isStaleUpdate = isStaleMetaRecord || isStaleRedirect;
                }
                if (!isStaleUpdate) {
                    tableLocations.put(startKey, location);
                }
            }
            if (isNewCacheEntry) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)("Cached location for " + location.getRegionInfo().getRegionNameAsString() + " is " + location.getHostnamePort()));
                }
            } else if (isStaleUpdate && !location.equals(oldLocation) && LOG.isTraceEnabled()) {
                LOG.trace((Object)("Ignoring stale location update for " + location.getRegionInfo().getRegionNameAsString() + ": " + location.getHostnamePort() + " at " + location.getSeqNum() + "; local " + oldLocation.getHostnamePort() + " at " + oldLocation.getSeqNum()));
            }
        }

        @Override
        public AdminProtos.AdminService.BlockingInterface getAdmin(ServerName serverName) throws IOException {
            return this.getAdmin(serverName, false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public AdminProtos.AdminService.BlockingInterface getAdmin(ServerName serverName, boolean master) throws IOException {
            if (this.isDeadServer(serverName)) {
                throw new RegionServerStoppedException(serverName + " is dead.");
            }
            String key = HConnectionImplementation.getStubKey(AdminProtos.AdminService.BlockingInterface.class.getName(), serverName.getHostAndPort());
            this.connectionLock.putIfAbsent(key, key);
            AdminProtos.AdminService.BlockingInterface stub = null;
            String string = this.connectionLock.get(key);
            synchronized (string) {
                stub = (AdminProtos.AdminService.BlockingInterface)this.stubs.get(key);
                if (stub == null) {
                    BlockingRpcChannel channel = this.rpcClient.createBlockingRpcChannel(serverName, User.getCurrent(), this.rpcTimeout);
                    stub = AdminProtos.AdminService.newBlockingStub((BlockingRpcChannel)channel);
                    this.stubs.put(key, stub);
                }
            }
            return stub;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ClientProtos.ClientService.BlockingInterface getClient(ServerName sn) throws IOException {
            if (this.isDeadServer(sn)) {
                throw new RegionServerStoppedException(sn + " is dead.");
            }
            String key = HConnectionImplementation.getStubKey(ClientProtos.ClientService.BlockingInterface.class.getName(), sn.getHostAndPort());
            this.connectionLock.putIfAbsent(key, key);
            ClientProtos.ClientService.BlockingInterface stub = null;
            String string = this.connectionLock.get(key);
            synchronized (string) {
                stub = (ClientProtos.ClientService.BlockingInterface)this.stubs.get(key);
                if (stub == null) {
                    BlockingRpcChannel channel = this.rpcClient.createBlockingRpcChannel(sn, User.getCurrent(), this.rpcTimeout);
                    stub = ClientProtos.ClientService.newBlockingStub((BlockingRpcChannel)channel);
                    this.stubs.put(key, stub);
                }
            }
            return stub;
        }

        static String getStubKey(String serviceName, String rsHostnamePort) {
            return serviceName + "@" + rsHostnamePort;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        ZooKeeperKeepAliveConnection getKeepAliveZooKeeperWatcher() throws IOException {
            Object object = this.masterAndZKLock;
            synchronized (object) {
                if (this.keepAliveZookeeper == null) {
                    if (this.closed) {
                        throw new IOException(this.toString() + " closed");
                    }
                    this.keepAliveZookeeper = new ZooKeeperKeepAliveConnection(this.conf, this.toString(), this);
                }
                ++this.keepAliveZookeeperUserCount;
                this.keepZooKeeperWatcherAliveUntil = Long.MAX_VALUE;
                return this.keepAliveZookeeper;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void releaseZooKeeperWatcher(ZooKeeperWatcher zkw) {
            if (zkw == null) {
                return;
            }
            Object object = this.masterAndZKLock;
            synchronized (object) {
                --this.keepAliveZookeeperUserCount;
                if (this.keepAliveZookeeperUserCount <= 0) {
                    this.keepZooKeeperWatcherAliveUntil = System.currentTimeMillis() + 300000L;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void closeZooKeeperWatcher() {
            Object object = this.masterAndZKLock;
            synchronized (object) {
                if (this.keepAliveZookeeper != null) {
                    LOG.info((Object)("Closing zookeeper sessionid=0x" + Long.toHexString(this.keepAliveZookeeper.getRecoverableZooKeeper().getSessionId())));
                    this.keepAliveZookeeper.internalClose();
                    this.keepAliveZookeeper = null;
                }
                this.keepAliveZookeeperUserCount = 0;
            }
        }

        @Override
        public MasterAdminProtos.MasterAdminService.BlockingInterface getMasterAdmin() throws MasterNotRunningException {
            return this.getKeepAliveMasterAdminService();
        }

        @Override
        public MasterMonitorProtos.MasterMonitorService.BlockingInterface getMasterMonitor() throws MasterNotRunningException {
            return this.getKeepAliveMasterMonitorService();
        }

        private void resetMasterServiceState(MasterServiceState mss) {
            ++mss.userCount;
            mss.keepAliveUntil = Long.MAX_VALUE;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public MasterAdminKeepAliveConnection getKeepAliveMasterAdminService() throws MasterNotRunningException {
            Object object = this.masterAndZKLock;
            synchronized (object) {
                if (!this.isKeepAliveMasterConnectedAndRunning(this.adminMasterServiceState)) {
                    MasterAdminServiceStubMaker stubMaker = new MasterAdminServiceStubMaker();
                    this.adminMasterServiceState.stub = stubMaker.makeStub();
                }
                this.resetMasterServiceState(this.adminMasterServiceState);
            }
            final MasterAdminProtos.MasterAdminService.BlockingInterface stub = this.adminMasterServiceState.stub;
            return new MasterAdminKeepAliveConnection(){
                MasterAdminServiceState mss;
                {
                    this.mss = HConnectionImplementation.this.adminMasterServiceState;
                }

                public MasterAdminProtos.AddColumnResponse addColumn(RpcController controller, MasterAdminProtos.AddColumnRequest request) throws ServiceException {
                    return stub.addColumn(controller, request);
                }

                public MasterAdminProtos.DeleteColumnResponse deleteColumn(RpcController controller, MasterAdminProtos.DeleteColumnRequest request) throws ServiceException {
                    return stub.deleteColumn(controller, request);
                }

                public MasterAdminProtos.ModifyColumnResponse modifyColumn(RpcController controller, MasterAdminProtos.ModifyColumnRequest request) throws ServiceException {
                    return stub.modifyColumn(controller, request);
                }

                public MasterAdminProtos.MoveRegionResponse moveRegion(RpcController controller, MasterAdminProtos.MoveRegionRequest request) throws ServiceException {
                    return stub.moveRegion(controller, request);
                }

                public MasterAdminProtos.DispatchMergingRegionsResponse dispatchMergingRegions(RpcController controller, MasterAdminProtos.DispatchMergingRegionsRequest request) throws ServiceException {
                    return stub.dispatchMergingRegions(controller, request);
                }

                public MasterAdminProtos.AssignRegionResponse assignRegion(RpcController controller, MasterAdminProtos.AssignRegionRequest request) throws ServiceException {
                    return stub.assignRegion(controller, request);
                }

                public MasterAdminProtos.UnassignRegionResponse unassignRegion(RpcController controller, MasterAdminProtos.UnassignRegionRequest request) throws ServiceException {
                    return stub.unassignRegion(controller, request);
                }

                public MasterAdminProtos.OfflineRegionResponse offlineRegion(RpcController controller, MasterAdminProtos.OfflineRegionRequest request) throws ServiceException {
                    return stub.offlineRegion(controller, request);
                }

                public MasterAdminProtos.DeleteTableResponse deleteTable(RpcController controller, MasterAdminProtos.DeleteTableRequest request) throws ServiceException {
                    return stub.deleteTable(controller, request);
                }

                public MasterAdminProtos.EnableTableResponse enableTable(RpcController controller, MasterAdminProtos.EnableTableRequest request) throws ServiceException {
                    return stub.enableTable(controller, request);
                }

                public MasterAdminProtos.DisableTableResponse disableTable(RpcController controller, MasterAdminProtos.DisableTableRequest request) throws ServiceException {
                    return stub.disableTable(controller, request);
                }

                public MasterAdminProtos.ModifyTableResponse modifyTable(RpcController controller, MasterAdminProtos.ModifyTableRequest request) throws ServiceException {
                    return stub.modifyTable(controller, request);
                }

                public MasterAdminProtos.CreateTableResponse createTable(RpcController controller, MasterAdminProtos.CreateTableRequest request) throws ServiceException {
                    return stub.createTable(controller, request);
                }

                public MasterAdminProtos.ShutdownResponse shutdown(RpcController controller, MasterAdminProtos.ShutdownRequest request) throws ServiceException {
                    return stub.shutdown(controller, request);
                }

                public MasterAdminProtos.StopMasterResponse stopMaster(RpcController controller, MasterAdminProtos.StopMasterRequest request) throws ServiceException {
                    return stub.stopMaster(controller, request);
                }

                public MasterAdminProtos.BalanceResponse balance(RpcController controller, MasterAdminProtos.BalanceRequest request) throws ServiceException {
                    return stub.balance(controller, request);
                }

                public MasterAdminProtos.SetBalancerRunningResponse setBalancerRunning(RpcController controller, MasterAdminProtos.SetBalancerRunningRequest request) throws ServiceException {
                    return stub.setBalancerRunning(controller, request);
                }

                public MasterAdminProtos.CatalogScanResponse runCatalogScan(RpcController controller, MasterAdminProtos.CatalogScanRequest request) throws ServiceException {
                    return stub.runCatalogScan(controller, request);
                }

                public MasterAdminProtos.EnableCatalogJanitorResponse enableCatalogJanitor(RpcController controller, MasterAdminProtos.EnableCatalogJanitorRequest request) throws ServiceException {
                    return stub.enableCatalogJanitor(controller, request);
                }

                public MasterAdminProtos.IsCatalogJanitorEnabledResponse isCatalogJanitorEnabled(RpcController controller, MasterAdminProtos.IsCatalogJanitorEnabledRequest request) throws ServiceException {
                    return stub.isCatalogJanitorEnabled(controller, request);
                }

                public ClientProtos.CoprocessorServiceResponse execMasterService(RpcController controller, ClientProtos.CoprocessorServiceRequest request) throws ServiceException {
                    return stub.execMasterService(controller, request);
                }

                public MasterAdminProtos.TakeSnapshotResponse snapshot(RpcController controller, MasterAdminProtos.TakeSnapshotRequest request) throws ServiceException {
                    return stub.snapshot(controller, request);
                }

                public MasterAdminProtos.ListSnapshotResponse getCompletedSnapshots(RpcController controller, MasterAdminProtos.ListSnapshotRequest request) throws ServiceException {
                    return stub.getCompletedSnapshots(controller, request);
                }

                public MasterAdminProtos.DeleteSnapshotResponse deleteSnapshot(RpcController controller, MasterAdminProtos.DeleteSnapshotRequest request) throws ServiceException {
                    return stub.deleteSnapshot(controller, request);
                }

                public MasterAdminProtos.IsSnapshotDoneResponse isSnapshotDone(RpcController controller, MasterAdminProtos.IsSnapshotDoneRequest request) throws ServiceException {
                    return stub.isSnapshotDone(controller, request);
                }

                public MasterAdminProtos.RestoreSnapshotResponse restoreSnapshot(RpcController controller, MasterAdminProtos.RestoreSnapshotRequest request) throws ServiceException {
                    return stub.restoreSnapshot(controller, request);
                }

                public MasterAdminProtos.IsRestoreSnapshotDoneResponse isRestoreSnapshotDone(RpcController controller, MasterAdminProtos.IsRestoreSnapshotDoneRequest request) throws ServiceException {
                    return stub.isRestoreSnapshotDone(controller, request);
                }

                public MasterProtos.IsMasterRunningResponse isMasterRunning(RpcController controller, MasterProtos.IsMasterRunningRequest request) throws ServiceException {
                    return stub.isMasterRunning(controller, request);
                }

                @Override
                public void close() {
                    HConnectionImplementation.release(this.mss);
                }
            };
        }

        private static void release(MasterServiceState mss) {
            if (mss != null && mss.connection != null) {
                ((HConnectionImplementation)mss.connection).releaseMaster(mss);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public MasterMonitorKeepAliveConnection getKeepAliveMasterMonitorService() throws MasterNotRunningException {
            Object object = this.masterAndZKLock;
            synchronized (object) {
                if (!this.isKeepAliveMasterConnectedAndRunning(this.monitorMasterServiceState)) {
                    MasterMonitorServiceStubMaker stubMaker = new MasterMonitorServiceStubMaker();
                    this.monitorMasterServiceState.stub = stubMaker.makeStub();
                }
                this.resetMasterServiceState(this.monitorMasterServiceState);
            }
            final MasterMonitorProtos.MasterMonitorService.BlockingInterface stub = this.monitorMasterServiceState.stub;
            return new MasterMonitorKeepAliveConnection(){
                final MasterMonitorServiceState mss;
                {
                    this.mss = HConnectionImplementation.this.monitorMasterServiceState;
                }

                public MasterMonitorProtos.GetSchemaAlterStatusResponse getSchemaAlterStatus(RpcController controller, MasterMonitorProtos.GetSchemaAlterStatusRequest request) throws ServiceException {
                    return stub.getSchemaAlterStatus(controller, request);
                }

                public MasterMonitorProtos.GetTableDescriptorsResponse getTableDescriptors(RpcController controller, MasterMonitorProtos.GetTableDescriptorsRequest request) throws ServiceException {
                    return stub.getTableDescriptors(controller, request);
                }

                public MasterMonitorProtos.GetClusterStatusResponse getClusterStatus(RpcController controller, MasterMonitorProtos.GetClusterStatusRequest request) throws ServiceException {
                    return stub.getClusterStatus(controller, request);
                }

                public MasterProtos.IsMasterRunningResponse isMasterRunning(RpcController controller, MasterProtos.IsMasterRunningRequest request) throws ServiceException {
                    return stub.isMasterRunning(controller, request);
                }

                @Override
                public void close() throws IOException {
                    HConnectionImplementation.release(this.mss);
                }
            };
        }

        private boolean isKeepAliveMasterConnectedAndRunning(MasterServiceState mss) {
            if (mss.getStub() == null) {
                return false;
            }
            try {
                return mss.isMasterRunning();
            }
            catch (UndeclaredThrowableException e) {
                LOG.info((Object)"Master connection is not running anymore", e.getUndeclaredThrowable());
                return false;
            }
            catch (ServiceException se) {
                LOG.warn((Object)"Checking master connection", (Throwable)se);
                return false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void releaseMaster(MasterServiceState mss) {
            if (mss.getStub() == null) {
                return;
            }
            Object object = this.masterAndZKLock;
            synchronized (object) {
                --mss.userCount;
                if (mss.userCount <= 0) {
                    mss.keepAliveUntil = System.currentTimeMillis() + 300000L;
                }
            }
        }

        private void closeMasterService(MasterServiceState mss) {
            if (mss.getStub() != null) {
                LOG.info((Object)("Closing master protocol: " + mss));
                mss.clearStub();
            }
            mss.userCount = 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void closeMaster() {
            Object object = this.masterAndZKLock;
            synchronized (object) {
                this.closeMasterService(this.adminMasterServiceState);
                this.closeMasterService(this.monitorMasterServiceState);
            }
        }

        @Override
        public <T> T getRegionServerWithRetries(ServerCallable<T> callable) throws IOException, RuntimeException {
            return callable.withRetries();
        }

        @Override
        public <T> T getRegionServerWithoutRetries(ServerCallable<T> callable) throws IOException, RuntimeException {
            return callable.withoutRetries();
        }

        @Deprecated
        private <R> Callable<MultiResponse> createCallable(final HRegionLocation loc, final MultiAction<R> multi, final byte[] tableName) {
            final HConnectionImplementation connection = this;
            return new Callable<MultiResponse>(){

                @Override
                public MultiResponse call() throws Exception {
                    MultiServerCallable callable = new MultiServerCallable(connection, tableName, loc, multi);
                    return (MultiResponse)callable.withoutRetries();
                }
            };
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void updateCachedLocation(HRegionInfo hri, HRegionLocation source, ServerName serverName, long seqNum) {
            HRegionLocation newHrl = new HRegionLocation(hri, serverName, seqNum);
            Map<Integer, SoftValueSortedMap<byte[], HRegionLocation>> map = this.cachedRegionLocations;
            synchronized (map) {
                this.cacheLocation(hri.getTableName(), source, newHrl);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void deleteCachedLocation(HRegionInfo hri, HRegionLocation source) {
            boolean isStaleDelete = false;
            Map<Integer, SoftValueSortedMap<byte[], HRegionLocation>> map = this.cachedRegionLocations;
            synchronized (map) {
                SoftValueSortedMap<byte[], HRegionLocation> tableLocations = this.getTableLocations(hri.getTableName());
                HRegionLocation oldLocation = (HRegionLocation)tableLocations.get(hri.getStartKey());
                if (oldLocation != null) {
                    boolean bl = isStaleDelete = source != null && !oldLocation.equals(source);
                    if (!isStaleDelete) {
                        tableLocations.remove(hri.getStartKey());
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void deleteCachedRegionLocation(HRegionLocation location) {
            if (location == null) {
                return;
            }
            Map<Integer, SoftValueSortedMap<byte[], HRegionLocation>> map = this.cachedRegionLocations;
            synchronized (map) {
                byte[] tableName = location.getRegionInfo().getTableName();
                SoftValueSortedMap<byte[], HRegionLocation> tableLocations = this.getTableLocations(tableName);
                if (!tableLocations.isEmpty()) {
                    HRegionLocation removedLocation = (HRegionLocation)tableLocations.remove(location.getRegionInfo().getStartKey());
                    if (LOG.isDebugEnabled() && removedLocation != null) {
                        LOG.debug((Object)("Removed " + location.getRegionInfo().getRegionNameAsString() + " for tableName=" + Bytes.toString((byte[])tableName) + " from cache"));
                    }
                }
            }
        }

        private void updateCachedLocations(byte[] tableName, Row row, Object exception, HRegionLocation source) {
            if (row == null || tableName == null) {
                LOG.warn((Object)("Coding error, see method javadoc. row=" + (row == null ? "null" : row) + ", tableName=" + (tableName == null ? "null" : Bytes.toString((byte[])tableName))));
                return;
            }
            HRegionLocation oldLocation = this.getCachedLocation(tableName, row.getRow());
            if (oldLocation == null) {
                return;
            }
            HRegionInfo regionInfo = oldLocation.getRegionInfo();
            RegionMovedException rme = RegionMovedException.find(exception);
            if (rme != null) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)("Region " + regionInfo.getRegionNameAsString() + " moved to " + rme.getHostname() + ":" + rme.getPort() + " according to " + source.getHostnamePort()));
                }
                this.updateCachedLocation(regionInfo, source, rme.getServerName(), rme.getLocationSeqNum());
            } else if (RegionOpeningException.find(exception) != null) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)("Region " + regionInfo.getRegionNameAsString() + " is being opened on " + source.getHostnamePort() + "; not deleting the cache entry"));
                }
            } else {
                this.deleteCachedLocation(regionInfo, source);
            }
        }

        @Override
        @Deprecated
        public void processBatch(List<? extends Row> list, byte[] tableName, ExecutorService pool, Object[] results) throws IOException, InterruptedException {
            if (results.length != list.size()) {
                throw new IllegalArgumentException("argument results must be the same size as argument list");
            }
            this.processBatchCallback(list, tableName, pool, results, null);
        }

        @Override
        @Deprecated
        public <R> void processBatchCallback(List<? extends Row> list, byte[] tableName, ExecutorService pool, Object[] results, Batch.Callback<R> callback) throws IOException, InterruptedException {
            Process p = new Process(this, list, tableName, pool, results, callback);
            p.processBatchCallback();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        int getNumberOfCachedRegionLocations(byte[] tableName) {
            Integer key = Bytes.mapKey((byte[])tableName);
            Map<Integer, SoftValueSortedMap<byte[], HRegionLocation>> map = this.cachedRegionLocations;
            synchronized (map) {
                Map tableLocs = (Map)this.cachedRegionLocations.get(key);
                if (tableLocs == null) {
                    return 0;
                }
                return tableLocs.values().size();
            }
        }

        boolean isRegionCached(byte[] tableName, byte[] row) {
            HRegionLocation location = this.getCachedLocation(tableName, row);
            return location != null;
        }

        @Override
        public void setRegionCachePrefetch(byte[] tableName, boolean enable) {
            if (!enable) {
                this.regionCachePrefetchDisabledTables.add(Bytes.mapKey((byte[])tableName));
            } else {
                this.regionCachePrefetchDisabledTables.remove(Bytes.mapKey((byte[])tableName));
            }
        }

        @Override
        public boolean getRegionCachePrefetch(byte[] tableName) {
            return !this.regionCachePrefetchDisabledTables.contains(Bytes.mapKey((byte[])tableName));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void abort(String msg, Throwable t) {
            if (t instanceof KeeperException.SessionExpiredException && this.keepAliveZookeeper != null) {
                Object object = this.masterAndZKLock;
                synchronized (object) {
                    if (this.keepAliveZookeeper != null) {
                        LOG.warn((Object)"This client just lost it's session with ZooKeeper, closing it. It will be recreated next time someone needs it", t);
                        this.closeZooKeeperWatcher();
                    }
                }
            } else {
                if (t != null) {
                    LOG.fatal((Object)msg, t);
                } else {
                    LOG.fatal((Object)msg);
                }
                this.aborted = true;
                this.close();
                this.closed = true;
            }
        }

        @Override
        public boolean isClosed() {
            return this.closed;
        }

        @Override
        public boolean isAborted() {
            return this.aborted;
        }

        @Override
        public int getCurrentNrHRS() throws IOException {
            return this.registry.getCurrentNrHRS();
        }

        void incCount() {
            ++this.refCount;
        }

        void decCount() {
            if (this.refCount > 0) {
                --this.refCount;
            }
        }

        boolean isZeroReference() {
            return this.refCount == 0;
        }

        void internalClose() {
            if (this.closed) {
                return;
            }
            this.delayedClosing.stop("Closing connection");
            this.closeMaster();
            this.closed = true;
            this.closeZooKeeperWatcher();
            this.stubs.clear();
            if (this.clusterStatusListener != null) {
                this.clusterStatusListener.close();
            }
        }

        @Override
        public void close() {
            if (this.managed) {
                if (this.aborted) {
                    HConnectionManager.deleteStaleConnection(this);
                } else {
                    HConnectionManager.deleteConnection(this, false);
                }
            } else {
                this.internalClose();
            }
        }

        protected void finalize() throws Throwable {
            super.finalize();
            this.refCount = 1;
            this.close();
        }

        @Override
        public HTableDescriptor[] listTables() throws IOException {
            MasterMonitorKeepAliveConnection master = this.getKeepAliveMasterMonitorService();
            try {
                MasterMonitorProtos.GetTableDescriptorsRequest req = RequestConverter.buildGetTableDescriptorsRequest(null);
                HTableDescriptor[] hTableDescriptorArray = ProtobufUtil.getHTableDescriptorArray(master.getTableDescriptors(null, req));
                return hTableDescriptorArray;
            }
            catch (ServiceException se) {
                throw ProtobufUtil.getRemoteException(se);
            }
            finally {
                master.close();
            }
        }

        @Override
        public HTableDescriptor[] getHTableDescriptors(List<String> tableNames) throws IOException {
            if (tableNames == null || tableNames.isEmpty()) {
                return new HTableDescriptor[0];
            }
            MasterMonitorKeepAliveConnection master = this.getKeepAliveMasterMonitorService();
            try {
                MasterMonitorProtos.GetTableDescriptorsRequest req = RequestConverter.buildGetTableDescriptorsRequest(tableNames);
                HTableDescriptor[] hTableDescriptorArray = ProtobufUtil.getHTableDescriptorArray(master.getTableDescriptors(null, req));
                return hTableDescriptorArray;
            }
            catch (ServiceException se) {
                throw ProtobufUtil.getRemoteException(se);
            }
            finally {
                master.close();
            }
        }

        @Override
        public HTableDescriptor getHTableDescriptor(byte[] tableName) throws IOException {
            MasterMonitorProtos.GetTableDescriptorsResponse htds;
            if (tableName == null || tableName.length == 0) {
                return null;
            }
            if (Bytes.equals((byte[])tableName, (byte[])HConstants.META_TABLE_NAME)) {
                return HTableDescriptor.META_TABLEDESC;
            }
            MasterMonitorKeepAliveConnection master = this.getKeepAliveMasterMonitorService();
            try {
                MasterMonitorProtos.GetTableDescriptorsRequest req = RequestConverter.buildGetTableDescriptorsRequest(null);
                htds = master.getTableDescriptors(null, req);
            }
            catch (ServiceException se) {
                throw ProtobufUtil.getRemoteException(se);
            }
            finally {
                master.close();
            }
            for (HBaseProtos.TableSchema ts : htds.getTableSchemaList()) {
                if (!Bytes.equals((byte[])tableName, (byte[])ts.getName().toByteArray())) continue;
                return HTableDescriptor.convert(ts);
            }
            throw new TableNotFoundException(Bytes.toString((byte[])tableName));
        }

        public boolean isUsingServerTrackerForRetries() {
            return this.useServerTrackerForRetries;
        }

        ServerErrorTracker createServerErrorTracker() {
            return new ServerErrorTracker(this.serverTrackerTimeout);
        }

        @VisibleForTesting
        static class ServerErrorTracker {
            private final Map<HRegionLocation, ServerErrors> errorsByServer = new HashMap<HRegionLocation, ServerErrors>();
            private long canRetryUntil = 0L;

            public ServerErrorTracker(long timeout) {
                LOG.trace((Object)("Server tracker timeout is " + timeout + "ms"));
                this.canRetryUntil = EnvironmentEdgeManager.currentTimeMillis() + timeout;
            }

            boolean canRetryMore() {
                return EnvironmentEdgeManager.currentTimeMillis() < this.canRetryUntil;
            }

            long calculateBackoffTime(HRegionLocation server, long basePause) {
                long result = 0L;
                ServerErrors errorStats = this.errorsByServer.get(server);
                if (errorStats != null) {
                    result = ConnectionUtils.getPauseTime(basePause, errorStats.retries);
                    long now = EnvironmentEdgeManager.currentTimeMillis();
                    long timeSinceLastError = now - errorStats.getLastErrorTime();
                    if (timeSinceLastError > 0L) {
                        result = Math.max(0L, result - timeSinceLastError);
                    }
                    if (result > 0L && now + result > this.canRetryUntil) {
                        result = Math.max(0L, this.canRetryUntil - now);
                    }
                }
                return result;
            }

            void reportServerError(HRegionLocation server) {
                ServerErrors errors = this.errorsByServer.get(server);
                if (errors != null) {
                    errors.addError();
                } else {
                    this.errorsByServer.put(server, new ServerErrors());
                }
            }

            private static class ServerErrors {
                public long lastErrorTime = EnvironmentEdgeManager.currentTimeMillis();
                public int retries = 0;

                public void addError() {
                    this.lastErrorTime = EnvironmentEdgeManager.currentTimeMillis();
                    ++this.retries;
                }

                public long getLastErrorTime() {
                    return this.lastErrorTime;
                }
            }
        }

        private static class Process<R> {
            private final HConnectionImplementation hci;
            private final List<? extends Row> rows;
            private final byte[] tableName;
            private final ExecutorService pool;
            private final Object[] results;
            private final Batch.Callback<R> callback;
            private final List<Action<R>> toReplay;
            private final LinkedList<Triple<MultiAction<R>, HRegionLocation, Future<MultiResponse>>> inProgress;
            private ServerErrorTracker errorsByServer = null;
            private int curNumRetries;
            private final List<MultiAction<R>> finishedTasks = new ArrayList<MultiAction<R>>();

            private Process(HConnectionImplementation hci, List<? extends Row> list, byte[] tableName, ExecutorService pool, Object[] results, Batch.Callback<R> callback) {
                this.hci = hci;
                this.rows = list;
                this.tableName = tableName;
                this.pool = pool;
                this.results = results;
                this.callback = callback;
                this.toReplay = new ArrayList<Action<R>>();
                this.inProgress = new LinkedList();
                this.curNumRetries = 0;
            }

            private void submit(List<Action<R>> actionsList, boolean isRetry) throws IOException {
                HashMap<HRegionLocation, MultiAction<R>> actionsByServer = new HashMap<HRegionLocation, MultiAction<R>>();
                for (Action<R> action : actionsList) {
                    Row row = action.getAction();
                    if (row == null) continue;
                    HRegionLocation loc = this.hci.locateRegion(this.tableName, row.getRow());
                    if (loc == null) {
                        throw new IOException("No location found, aborting submit.");
                    }
                    byte[] regionName = loc.getRegionInfo().getRegionName();
                    MultiAction<R> actions = (MultiAction<R>)actionsByServer.get(loc);
                    if (actions == null) {
                        actions = new MultiAction<R>();
                        actionsByServer.put(loc, actions);
                    }
                    actions.add(regionName, action);
                }
                for (Map.Entry entry : actionsByServer.entrySet()) {
                    long backoffTime = 0L;
                    if (isRetry) {
                        if (this.hci.isUsingServerTrackerForRetries()) {
                            assert (this.errorsByServer != null);
                            backoffTime = this.errorsByServer.calculateBackoffTime((HRegionLocation)entry.getKey(), this.hci.pause);
                        } else {
                            backoffTime = ConnectionUtils.getPauseTime(this.hci.pause, this.curNumRetries - 1);
                        }
                    }
                    Callable<MultiResponse> callable = this.createDelayedCallable(backoffTime, (HRegionLocation)entry.getKey(), (MultiAction)entry.getValue());
                    if (LOG.isTraceEnabled() && isRetry) {
                        StringBuilder sb = new StringBuilder();
                        for (Action action : ((MultiAction)entry.getValue()).allActions()) {
                            if (sb.length() > 0) {
                                sb.append(' ');
                            }
                            sb.append(Bytes.toStringBinary((byte[])action.getAction().getRow()));
                        }
                        LOG.trace((Object)("Attempt #" + this.curNumRetries + " against " + ((HRegionLocation)entry.getKey()).getHostnamePort() + " after=" + backoffTime + "ms, row(s)=" + sb.toString()));
                    }
                    Triple p = new Triple(entry.getValue(), entry.getKey(), this.pool.submit(callable));
                    this.inProgress.addLast(p);
                }
            }

            private void doRetry() throws IOException {
                this.submit(this.toReplay, true);
                this.toReplay.clear();
            }

            private void processBatchCallback() throws IOException, InterruptedException {
                boolean noRetry;
                if (this.results.length != this.rows.size()) {
                    throw new IllegalArgumentException("argument results (size=" + this.results.length + ") must be the same size as " + "argument list (size=" + this.rows.size() + ")");
                }
                if (this.rows.isEmpty()) {
                    return;
                }
                boolean isTraceEnabled = LOG.isTraceEnabled();
                BatchErrors errors = new BatchErrors();
                BatchErrors retriedErrors = null;
                if (isTraceEnabled) {
                    retriedErrors = new BatchErrors();
                }
                int[] nbRetries = new int[this.results.length];
                ArrayList<Action<R>> listActions = new ArrayList<Action<R>>(this.rows.size());
                for (int i = 0; i < this.rows.size(); ++i) {
                    Action action = new Action(this.rows.get(i), i);
                    listActions.add(action);
                }
                this.submit(listActions, false);
                boolean lastRetry = false;
                boolean bl = noRetry = this.hci.numTries < 2;
                while (!this.inProgress.isEmpty()) {
                    Triple<MultiAction<R>, HRegionLocation, Future<MultiResponse>> currentTask = this.removeFirstDone();
                    MultiResponse responses = null;
                    ExecutionException exception = null;
                    try {
                        responses = (MultiResponse)((Future)currentTask.getThird()).get();
                    }
                    catch (ExecutionException e) {
                        exception = e;
                    }
                    HRegionLocation location = (HRegionLocation)currentTask.getSecond();
                    if (responses == null) {
                        for (List list : ((MultiAction)currentTask.getFirst()).actions.values()) {
                            for (Action action : list) {
                                Row row = action.getAction();
                                this.hci.updateCachedLocations(this.tableName, row, null, location);
                                if (noRetry) {
                                    errors.add(exception, row, location);
                                    continue;
                                }
                                if (isTraceEnabled) {
                                    retriedErrors.add(exception, row, location);
                                }
                                lastRetry = this.addToReplay(nbRetries, action, location);
                            }
                        }
                    } else {
                        for (Map.Entry entry : responses.getResults().entrySet()) {
                            for (Pair regionResult : (List)entry.getValue()) {
                                Object result;
                                Action correspondingAction = (Action)listActions.get((Integer)regionResult.getFirst());
                                this.results[correspondingAction.getOriginalIndex()] = result = regionResult.getSecond();
                                if (result == null || result instanceof Throwable) {
                                    Row row = correspondingAction.getAction();
                                    this.hci.updateCachedLocations(this.tableName, row, result, location);
                                    if (result instanceof DoNotRetryIOException || noRetry) {
                                        errors.add((Exception)result, row, location);
                                        continue;
                                    }
                                    if (isTraceEnabled) {
                                        retriedErrors.add((Exception)result, row, location);
                                    }
                                    lastRetry = this.addToReplay(nbRetries, correspondingAction, location);
                                    continue;
                                }
                                if (this.callback == null) continue;
                                this.callback.update((byte[])entry.getKey(), this.rows.get((Integer)regionResult.getFirst()).getRow(), result);
                            }
                        }
                    }
                    if (noRetry || this.toReplay.isEmpty()) continue;
                    if (isTraceEnabled) {
                        LOG.trace((Object)("Retrying #" + this.curNumRetries + (lastRetry ? " (one last time)" : "") + " because " + retriedErrors.getDescriptionAndClear()));
                    }
                    this.doRetry();
                    if (!lastRetry) continue;
                    noRetry = true;
                }
                errors.rethrowIfAny();
            }

            private boolean addToReplay(int[] nbRetries, Action<R> action, HRegionLocation source) {
                this.toReplay.add(action);
                int n = action.getOriginalIndex();
                nbRetries[n] = nbRetries[n] + 1;
                if (nbRetries[action.getOriginalIndex()] > this.curNumRetries) {
                    this.curNumRetries = nbRetries[action.getOriginalIndex()];
                }
                if (this.hci.isUsingServerTrackerForRetries()) {
                    if (this.errorsByServer == null) {
                        this.errorsByServer = this.hci.createServerErrorTracker();
                    }
                    this.errorsByServer.reportServerError(source);
                    return !this.errorsByServer.canRetryMore();
                }
                return this.curNumRetries + 1 >= this.hci.numTries;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private Triple<MultiAction<R>, HRegionLocation, Future<MultiResponse>> removeFirstDone() throws InterruptedException {
                while (true) {
                    List<MultiAction<R>> list = this.finishedTasks;
                    synchronized (list) {
                        if (!this.finishedTasks.isEmpty()) {
                            MultiAction<R> done = this.finishedTasks.remove(this.finishedTasks.size() - 1);
                            Iterator it = this.inProgress.iterator();
                            while (it.hasNext()) {
                                Triple task = (Triple)it.next();
                                if (task.getFirst() != done) continue;
                                it.remove();
                                return task;
                            }
                            LOG.error((Object)("Development error: We didn't see a task in the list. " + done.getRegions()));
                        }
                        this.finishedTasks.wait(10L);
                    }
                }
            }

            private Callable<MultiResponse> createDelayedCallable(final long delay, HRegionLocation loc, final MultiAction<R> multi) {
                final Callable delegate = this.hci.createCallable(loc, multi, this.tableName);
                return new Callable<MultiResponse>(){
                    private final long creationTime = System.currentTimeMillis();

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public MultiResponse call() throws Exception {
                        try {
                            long waitingTime = delay + this.creationTime - System.currentTimeMillis();
                            if (waitingTime > 0L) {
                                Thread.sleep(waitingTime);
                            }
                            MultiResponse multiResponse = (MultiResponse)delegate.call();
                            return multiResponse;
                        }
                        finally {
                            List list = Process.this.finishedTasks;
                            synchronized (list) {
                                Process.this.finishedTasks.add(multi);
                                Process.this.finishedTasks.notifyAll();
                            }
                        }
                    }
                };
            }

            private class BatchErrors {
                private List<Throwable> exceptions = new ArrayList<Throwable>();
                private List<Row> actions = new ArrayList<Row>();
                private List<String> addresses = new ArrayList<String>();

                private BatchErrors() {
                }

                public void add(Exception ex, Row row, HRegionLocation location) {
                    this.exceptions.add(ex);
                    this.actions.add(row);
                    this.addresses.add(location.getHostnamePort());
                }

                public void rethrowIfAny() throws RetriesExhaustedWithDetailsException {
                    if (!this.exceptions.isEmpty()) {
                        throw this.makeException();
                    }
                }

                public String getDescriptionAndClear() {
                    if (this.exceptions.isEmpty()) {
                        return "";
                    }
                    String result = this.makeException().getExhaustiveDescription();
                    this.exceptions.clear();
                    this.actions.clear();
                    this.addresses.clear();
                    return result;
                }

                private RetriesExhaustedWithDetailsException makeException() {
                    return new RetriesExhaustedWithDetailsException(this.exceptions, this.actions, this.addresses);
                }
            }
        }

        private static class DelayedClosing
        extends Chore
        implements Stoppable {
            private HConnectionImplementation hci;
            Stoppable stoppable;

            private DelayedClosing(HConnectionImplementation hci, Stoppable stoppable) {
                super("ZooKeeperWatcher and Master delayed closing for connection " + hci, 60000, stoppable);
                this.hci = hci;
                this.stoppable = stoppable;
            }

            static DelayedClosing createAndStart(HConnectionImplementation hci) {
                Stoppable stoppable = new Stoppable(){
                    private volatile boolean isStopped = false;

                    @Override
                    public void stop(String why) {
                        this.isStopped = true;
                    }

                    @Override
                    public boolean isStopped() {
                        return this.isStopped;
                    }
                };
                return new DelayedClosing(hci, stoppable);
            }

            protected void closeMasterProtocol(MasterServiceState protocolState) {
                if (System.currentTimeMillis() > protocolState.keepAliveUntil) {
                    this.hci.closeMasterService(protocolState);
                    protocolState.keepAliveUntil = Long.MAX_VALUE;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void chore() {
                Object object = this.hci.masterAndZKLock;
                synchronized (object) {
                    if (this.hci.canCloseZKW && System.currentTimeMillis() > this.hci.keepZooKeeperWatcherAliveUntil) {
                        this.hci.closeZooKeeperWatcher();
                        this.hci.keepZooKeeperWatcherAliveUntil = Long.MAX_VALUE;
                    }
                    this.closeMasterProtocol(this.hci.adminMasterServiceState);
                    this.closeMasterProtocol(this.hci.monitorMasterServiceState);
                }
            }

            @Override
            public void stop(String why) {
                this.stoppable.stop(why);
            }

            @Override
            public boolean isStopped() {
                return this.stoppable.isStopped();
            }
        }

        class MasterAdminServiceStubMaker
        extends StubMaker {
            private MasterAdminProtos.MasterAdminService.BlockingInterface stub;

            MasterAdminServiceStubMaker() {
            }

            @Override
            protected String getServiceName() {
                return MasterAdminProtos.MasterAdminService.getDescriptor().getName();
            }

            @SuppressWarnings(value={"SWL_SLEEP_WITH_LOCK_HELD"})
            MasterAdminProtos.MasterAdminService.BlockingInterface makeStub() throws MasterNotRunningException {
                return (MasterAdminProtos.MasterAdminService.BlockingInterface)super.makeStub();
            }

            @Override
            protected Object makeStub(BlockingRpcChannel channel) {
                this.stub = MasterAdminProtos.MasterAdminService.newBlockingStub((BlockingRpcChannel)channel);
                return this.stub;
            }

            @Override
            protected void isMasterRunning() throws ServiceException {
                this.stub.isMasterRunning(null, RequestConverter.buildIsMasterRunningRequest());
            }
        }

        class MasterMonitorServiceStubMaker
        extends StubMaker {
            private MasterMonitorProtos.MasterMonitorService.BlockingInterface stub;

            MasterMonitorServiceStubMaker() {
            }

            @Override
            protected String getServiceName() {
                return MasterMonitorProtos.MasterMonitorService.getDescriptor().getName();
            }

            @SuppressWarnings(value={"SWL_SLEEP_WITH_LOCK_HELD"})
            MasterMonitorProtos.MasterMonitorService.BlockingInterface makeStub() throws MasterNotRunningException {
                return (MasterMonitorProtos.MasterMonitorService.BlockingInterface)super.makeStub();
            }

            @Override
            protected Object makeStub(BlockingRpcChannel channel) {
                this.stub = MasterMonitorProtos.MasterMonitorService.newBlockingStub((BlockingRpcChannel)channel);
                return this.stub;
            }

            @Override
            protected void isMasterRunning() throws ServiceException {
                this.stub.isMasterRunning(null, RequestConverter.buildIsMasterRunningRequest());
            }
        }

        abstract class StubMaker {
            StubMaker() {
            }

            protected abstract String getServiceName();

            protected abstract Object makeStub(BlockingRpcChannel var1);

            protected abstract void isMasterRunning() throws ServiceException;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private Object makeStubNoRetries() throws IOException, KeeperException, ServiceException {
                ZooKeeperKeepAliveConnection zkw;
                try {
                    zkw = HConnectionImplementation.this.getKeepAliveZooKeeperWatcher();
                }
                catch (IOException e) {
                    throw new ZooKeeperConnectionException("Can't connect to ZooKeeper", e);
                }
                try {
                    HConnectionImplementation.this.checkIfBaseNodeAvailable(zkw);
                    ServerName sn = MasterAddressTracker.getMasterAddress(zkw);
                    if (sn == null) {
                        String msg = "ZooKeeper available but no active master location found";
                        LOG.info((Object)msg);
                        throw new MasterNotRunningException(msg);
                    }
                    if (HConnectionImplementation.this.isDeadServer(sn)) {
                        throw new MasterNotRunningException(sn + " is dead.");
                    }
                    String key = HConnectionImplementation.getStubKey(this.getServiceName(), sn.getHostAndPort());
                    HConnectionImplementation.this.connectionLock.putIfAbsent(key, key);
                    Object stub = null;
                    String string = (String)HConnectionImplementation.this.connectionLock.get(key);
                    synchronized (string) {
                        stub = HConnectionImplementation.this.stubs.get(key);
                        if (stub == null) {
                            BlockingRpcChannel channel = HConnectionImplementation.this.rpcClient.createBlockingRpcChannel(sn, User.getCurrent(), HConnectionImplementation.this.rpcTimeout);
                            stub = this.makeStub(channel);
                            this.isMasterRunning();
                            HConnectionImplementation.this.stubs.put(key, stub);
                        }
                    }
                    string = stub;
                    return string;
                }
                finally {
                    zkw.close();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @SuppressWarnings(value={"SWL_SLEEP_WITH_LOCK_HELD"})
            Object makeStub() throws MasterNotRunningException {
                Object object = HConnectionImplementation.this.masterAndZKLock;
                synchronized (object) {
                    Throwable exceptionCaught = null;
                    Object stub = null;
                    int tries = 0;
                    while (!HConnectionImplementation.this.closed && stub == null) {
                        ++tries;
                        try {
                            stub = this.makeStubNoRetries();
                        }
                        catch (IOException e) {
                            exceptionCaught = e;
                        }
                        catch (KeeperException e) {
                            exceptionCaught = e;
                        }
                        catch (ServiceException e) {
                            exceptionCaught = e;
                        }
                        if (exceptionCaught == null) continue;
                        if (tries < HConnectionImplementation.this.numTries) {
                            long pauseTime = ConnectionUtils.getPauseTime(HConnectionImplementation.this.pause, tries - 1);
                            LOG.info((Object)("getMaster attempt " + tries + " of " + HConnectionImplementation.this.numTries + " failed; retrying after sleep of " + pauseTime + ", exception=" + exceptionCaught));
                            try {
                                Thread.sleep(pauseTime);
                                continue;
                            }
                            catch (InterruptedException e) {
                                Thread.currentThread().interrupt();
                                throw new RuntimeException("Thread was interrupted while trying to connect to master.", e);
                            }
                        }
                        LOG.info((Object)("getMaster attempt " + tries + " of " + HConnectionImplementation.this.numTries + " failed; no more retrying."), exceptionCaught);
                        throw new MasterNotRunningException((Exception)exceptionCaught);
                    }
                    if (stub == null) {
                        throw new MasterNotRunningException("Connection was closed while trying to get master");
                    }
                    return stub;
                }
            }
        }

        static class MasterMonitorServiceState
        extends MasterServiceState {
            MasterMonitorProtos.MasterMonitorService.BlockingInterface stub;

            MasterMonitorServiceState(HConnection connection) {
                super(connection);
            }

            public String toString() {
                return "MasterMonitorService";
            }

            @Override
            Object getStub() {
                return this.stub;
            }

            @Override
            void clearStub() {
                this.stub = null;
            }

            @Override
            boolean isMasterRunning() throws ServiceException {
                MasterProtos.IsMasterRunningResponse response = this.stub.isMasterRunning(null, RequestConverter.buildIsMasterRunningRequest());
                return response != null ? response.getIsMasterRunning() : false;
            }
        }

        static class MasterAdminServiceState
        extends MasterServiceState {
            MasterAdminProtos.MasterAdminService.BlockingInterface stub;

            MasterAdminServiceState(HConnection connection) {
                super(connection);
            }

            public String toString() {
                return "MasterAdminService";
            }

            @Override
            Object getStub() {
                return this.stub;
            }

            @Override
            void clearStub() {
                this.stub = null;
            }

            @Override
            boolean isMasterRunning() throws ServiceException {
                MasterProtos.IsMasterRunningResponse response = this.stub.isMasterRunning(null, RequestConverter.buildIsMasterRunningRequest());
                return response != null ? response.getIsMasterRunning() : false;
            }
        }

        static abstract class MasterServiceState {
            HConnection connection;
            int userCount;
            long keepAliveUntil = Long.MAX_VALUE;

            MasterServiceState(HConnection connection) {
                this.connection = connection;
            }

            abstract Object getStub();

            abstract void clearStub();

            abstract boolean isMasterRunning() throws ServiceException;
        }
    }
}

