/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.NavigableMap;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.UnmodifyableHRegionInfo;
import org.apache.hadoop.hbase.exceptions.TableNotFoundException;
import org.apache.hadoop.hbase.util.Bytes;

@InterfaceAudience.Private
public class MetaScanner {
    private static final Log LOG = LogFactory.getLog(MetaScanner.class);

    public static void metaScan(Configuration configuration, MetaScannerVisitor visitor) throws IOException {
        MetaScanner.metaScan(configuration, visitor, null);
    }

    public static void metaScan(Configuration configuration, MetaScannerVisitor visitor, byte[] userTableName) throws IOException {
        MetaScanner.metaScan(configuration, visitor, userTableName, null, Integer.MAX_VALUE);
    }

    public static void metaScan(Configuration configuration, MetaScannerVisitor visitor, byte[] userTableName, byte[] row, int rowLimit) throws IOException {
        MetaScanner.metaScan(configuration, visitor, userTableName, row, rowLimit, HConstants.META_TABLE_NAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void metaScan(Configuration configuration, MetaScannerVisitor visitor, byte[] tableName, byte[] row, int rowLimit, byte[] metaTableName) throws IOException {
        int rowUpperLimit = rowLimit > 0 ? rowLimit : Integer.MAX_VALUE;
        HTable metaTable = new HTable(configuration, HConstants.META_TABLE_NAME);
        ResultScanner scanner = null;
        try {
            byte[] startRow;
            if (row != null) {
                byte[] searchRow = HRegionInfo.createRegionName(tableName, row, "99999999999999", false);
                Result startRowResult = metaTable.getRowOrBefore(searchRow, HConstants.CATALOG_FAMILY);
                if (startRowResult == null) {
                    throw new TableNotFoundException("Cannot find row in .META. for table: " + Bytes.toString((byte[])tableName) + ", row=" + Bytes.toStringBinary((byte[])searchRow));
                }
                HRegionInfo regionInfo = MetaScanner.getHRegionInfo(startRowResult);
                if (regionInfo == null) {
                    throw new IOException("HRegionInfo was null or empty in Meta for " + Bytes.toString((byte[])tableName) + ", row=" + Bytes.toStringBinary((byte[])searchRow));
                }
                byte[] rowBefore = regionInfo.getStartKey();
                startRow = HRegionInfo.createRegionName(tableName, rowBefore, "00000000000000", false);
            } else {
                startRow = tableName == null || tableName.length == 0 ? HConstants.EMPTY_START_ROW : HRegionInfo.createRegionName(tableName, HConstants.EMPTY_START_ROW, "00000000000000", false);
            }
            Scan scan = new Scan(startRow).addFamily(HConstants.CATALOG_FAMILY);
            int rows = Math.min(rowLimit, configuration.getInt(HConstants.HBASE_META_SCANNER_CACHING, HConstants.DEFAULT_HBASE_META_SCANNER_CACHING));
            scan.setCaching(rows);
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Scanning " + Bytes.toString((byte[])metaTableName) + " starting at row=" + Bytes.toStringBinary((byte[])startRow) + " for max=" + rowUpperLimit + " with caching=" + rows));
            }
            scanner = metaTable.getScanner(scan);
            Result result = null;
            int processedRows = 0;
            while ((result = scanner.next()) != null) {
                if (visitor != null && !visitor.processRow(result)) {
                } else if (++processedRows < rowUpperLimit) continue;
                break;
            }
        }
        finally {
            if (scanner != null) {
                try {
                    scanner.close();
                }
                catch (Throwable t) {
                    LOG.debug((Object)"Got exception in closing the result scanner", t);
                }
            }
            if (visitor != null) {
                try {
                    visitor.close();
                }
                catch (Throwable t) {
                    LOG.debug((Object)"Got exception in closing the meta scanner visitor", t);
                }
            }
            if (metaTable != null) {
                try {
                    metaTable.close();
                }
                catch (Throwable t) {
                    LOG.debug((Object)"Got exception in closing the meta table", t);
                }
            }
        }
    }

    public static HRegionInfo getHRegionInfo(Result data) {
        byte[] bytes = data.getValue(HConstants.CATALOG_FAMILY, HConstants.REGIONINFO_QUALIFIER);
        if (bytes == null) {
            return null;
        }
        HRegionInfo info = HRegionInfo.parseFromOrNull(bytes);
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Current INFO from scan results = " + info));
        }
        return info;
    }

    public static List<HRegionInfo> listAllRegions(Configuration conf) throws IOException {
        return MetaScanner.listAllRegions(conf, true);
    }

    public static List<HRegionInfo> listAllRegions(Configuration conf, final boolean offlined) throws IOException {
        final ArrayList<HRegionInfo> regions = new ArrayList<HRegionInfo>();
        DefaultMetaScannerVisitor visitor = new DefaultMetaScannerVisitor(){

            @Override
            public boolean processRowInternal(Result result) throws IOException {
                if (result == null || result.isEmpty()) {
                    return true;
                }
                HRegionInfo regionInfo = MetaScanner.getHRegionInfo(result);
                if (regionInfo == null) {
                    LOG.warn((Object)("Null REGIONINFO_QUALIFIER: " + result));
                    return true;
                }
                if (regionInfo.isOffline() && !offlined) {
                    return true;
                }
                regions.add(regionInfo);
                return true;
            }
        };
        MetaScanner.metaScan(conf, visitor);
        return regions;
    }

    public static NavigableMap<HRegionInfo, ServerName> allTableRegions(Configuration conf, byte[] tablename, boolean offlined) throws IOException {
        final TreeMap<HRegionInfo, ServerName> regions = new TreeMap<HRegionInfo, ServerName>();
        TableMetaScannerVisitor visitor = new TableMetaScannerVisitor(tablename){

            @Override
            public boolean processRowInternal(Result rowResult) throws IOException {
                HRegionInfo info = MetaScanner.getHRegionInfo(rowResult);
                ServerName serverName = HRegionInfo.getServerName(rowResult);
                regions.put(new UnmodifyableHRegionInfo(info), serverName);
                return true;
            }
        };
        MetaScanner.metaScan(conf, visitor, tablename);
        return regions;
    }

    public static abstract class TableMetaScannerVisitor
    extends DefaultMetaScannerVisitor {
        private byte[] tableName;

        public TableMetaScannerVisitor(byte[] tableName) {
            this.tableName = tableName;
        }

        @Override
        public final boolean processRow(Result rowResult) throws IOException {
            HRegionInfo info = MetaScanner.getHRegionInfo(rowResult);
            if (info == null) {
                return true;
            }
            if (!Bytes.equals((byte[])info.getTableName(), (byte[])this.tableName)) {
                return false;
            }
            return super.processRow(rowResult);
        }
    }

    public static abstract class DefaultMetaScannerVisitor
    extends MetaScannerVisitorBase {
        public abstract boolean processRowInternal(Result var1) throws IOException;

        @Override
        public boolean processRow(Result rowResult) throws IOException {
            HRegionInfo info = MetaScanner.getHRegionInfo(rowResult);
            if (info == null) {
                return true;
            }
            if (!info.isOffline() && !info.isSplit()) {
                return this.processRowInternal(rowResult);
            }
            return true;
        }
    }

    public static abstract class MetaScannerVisitorBase
    implements MetaScannerVisitor {
        @Override
        public void close() throws IOException {
        }
    }

    public static interface MetaScannerVisitor
    extends Closeable {
        public boolean processRow(Result var1) throws IOException;
    }
}

