/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import com.google.protobuf.RpcController;
import com.google.protobuf.ServiceException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hbase.CellScannable;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.client.Action;
import org.apache.hadoop.hbase.client.HConnection;
import org.apache.hadoop.hbase.client.MultiAction;
import org.apache.hadoop.hbase.client.MultiResponse;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Row;
import org.apache.hadoop.hbase.client.RowMutations;
import org.apache.hadoop.hbase.client.ServerCallable;
import org.apache.hadoop.hbase.ipc.PayloadCarryingRpcController;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.RequestConverter;
import org.apache.hadoop.hbase.protobuf.ResponseConverter;
import org.apache.hadoop.hbase.protobuf.generated.ClientProtos;

class MultiServerCallable<R>
extends ServerCallable<MultiResponse> {
    private final MultiAction<R> multi;
    private final HRegionLocation loc;

    MultiServerCallable(HConnection connection, byte[] tableName, HRegionLocation loc, MultiAction<R> multi) {
        super(connection, tableName, null);
        this.multi = multi;
        this.loc = loc;
    }

    @Override
    public MultiResponse call() throws IOException {
        MultiResponse response = new MultiResponse();
        for (Map.Entry e : this.multi.actions.entrySet()) {
            byte[] regionName = e.getKey();
            int rowMutations = 0;
            List actions = e.getValue();
            for (Action action : actions) {
                Row row = action.getAction();
                if (!(row instanceof RowMutations)) continue;
                try {
                    RowMutations rms = (RowMutations)row;
                    ArrayList<CellScannable> cells = new ArrayList<CellScannable>(rms.getMutations().size());
                    ClientProtos.MultiRequest multiRequest = RequestConverter.buildNoDataMultiRequest(regionName, rms, cells);
                    this.stub.multi((RpcController)new PayloadCarryingRpcController(cells), multiRequest);
                    response.add(regionName, action.getOriginalIndex(), Result.EMPTY_RESULT);
                }
                catch (ServiceException se) {
                    response.add(regionName, action.getOriginalIndex(), ProtobufUtil.getRemoteException(se));
                }
                ++rowMutations;
            }
            if (actions.size() <= rowMutations) continue;
            IOException ex = null;
            List<Object> results = null;
            ArrayList<CellScannable> cells = new ArrayList<CellScannable>(actions.size() - rowMutations);
            try {
                ClientProtos.MultiRequest multiRequest = RequestConverter.buildNoDataMultiRequest(regionName, actions, cells);
                PayloadCarryingRpcController controller = new PayloadCarryingRpcController(cells);
                ClientProtos.MultiResponse responseProto = this.stub.multi((RpcController)controller, multiRequest);
                results = ResponseConverter.getResults(responseProto, controller.cellScanner());
            }
            catch (ServiceException se) {
                ex = ProtobufUtil.getRemoteException(se);
            }
            int n = actions.size();
            for (int i = 0; i < n; ++i) {
                int originalIndex = actions.get(i).getOriginalIndex();
                response.add(regionName, originalIndex, results == null ? ex : results.get(i));
            }
        }
        return response;
    }

    @Override
    public void prepare(boolean reload) throws IOException {
        this.stub = this.connection.getClient(this.loc.getServerName());
    }
}

