/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import java.util.UUID;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellScannable;
import org.apache.hadoop.hbase.CellScanner;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.KeyValueUtil;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.OperationWithAttributes;
import org.apache.hadoop.hbase.client.Row;
import org.apache.hadoop.hbase.io.HeapSize;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.ClassSize;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public abstract class Mutation
extends OperationWithAttributes
implements Row,
CellScannable,
HeapSize {
    public static final long MUTATION_OVERHEAD = ClassSize.align((int)(ClassSize.OBJECT + 2 * ClassSize.REFERENCE + 8 + ClassSize.REFERENCE + ClassSize.REFERENCE + ClassSize.TREEMAP));
    private static final String CLUSTER_ID_ATTR = "_c.id_";
    protected byte[] row = null;
    protected long ts = Long.MAX_VALUE;
    protected Durability durability = Durability.USE_DEFAULT;
    protected NavigableMap<byte[], List<? extends Cell>> familyMap = new TreeMap<byte[], List<? extends Cell>>(Bytes.BYTES_COMPARATOR);

    public CellScanner cellScanner() {
        return CellUtil.createCellScanner(this.getFamilyMap());
    }

    List<? extends Cell> getCellList(byte[] family) {
        ArrayList list = (ArrayList)this.familyMap.get(family);
        if (list == null) {
            list = new ArrayList();
        }
        return list;
    }

    KeyValue createPutKeyValue(byte[] family, byte[] qualifier, long ts, byte[] value) {
        return new KeyValue(this.row, family, qualifier, ts, KeyValue.Type.Put, value);
    }

    @Override
    public Map<String, Object> getFingerprint() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        ArrayList<String> families = new ArrayList<String>();
        map.put("families", families);
        for (Map.Entry entry : this.familyMap.entrySet()) {
            families.add(Bytes.toStringBinary((byte[])((byte[])entry.getKey())));
        }
        return map;
    }

    @Override
    public Map<String, Object> toMap(int maxCols) {
        Map<String, Object> map = this.getFingerprint();
        HashMap columns = new HashMap();
        map.put("families", columns);
        map.put("row", Bytes.toStringBinary((byte[])this.row));
        int colCount = 0;
        for (Map.Entry entry : this.familyMap.entrySet()) {
            ArrayList<Map> qualifierDetails = new ArrayList<Map>();
            columns.put(Bytes.toStringBinary((byte[])((byte[])entry.getKey())), qualifierDetails);
            colCount += ((List)entry.getValue()).size();
            if (maxCols <= 0) continue;
            for (Cell cell : (List)entry.getValue()) {
                if (--maxCols <= 0) continue;
                KeyValue kv = KeyValueUtil.ensureKeyValue((Cell)cell);
                Map kvMap = kv.toStringMap();
                kvMap.remove("row");
                kvMap.remove("family");
                qualifierDetails.add(kvMap);
            }
        }
        map.put("totalColumns", colCount);
        if (this.getId() != null) {
            map.put("id", this.getId());
        }
        return map;
    }

    public void setDurability(Durability d) {
        this.durability = d;
    }

    public Durability getDurability() {
        return this.durability;
    }

    public NavigableMap<byte[], List<? extends Cell>> getFamilyMap() {
        return this.familyMap;
    }

    public void setFamilyMap(NavigableMap<byte[], List<? extends Cell>> map) {
        this.familyMap = map;
    }

    public boolean isEmpty() {
        return this.familyMap.isEmpty();
    }

    @Override
    public byte[] getRow() {
        return this.row;
    }

    @Override
    public int compareTo(Row d) {
        return Bytes.compareTo((byte[])this.getRow(), (byte[])d.getRow());
    }

    public long getTimeStamp() {
        return this.ts;
    }

    public void setClusterId(UUID clusterId) {
        if (clusterId == null) {
            return;
        }
        byte[] val = new byte[16];
        Bytes.putLong((byte[])val, (int)0, (long)clusterId.getMostSignificantBits());
        Bytes.putLong((byte[])val, (int)8, (long)clusterId.getLeastSignificantBits());
        this.setAttribute(CLUSTER_ID_ATTR, val);
    }

    public UUID getClusterId() {
        byte[] attr = this.getAttribute(CLUSTER_ID_ATTR);
        if (attr == null) {
            return HConstants.DEFAULT_CLUSTER_ID;
        }
        return new UUID(Bytes.toLong((byte[])attr, (int)0), Bytes.toLong((byte[])attr, (int)8));
    }

    public int size() {
        int size = 0;
        for (List cells : this.familyMap.values()) {
            size += cells.size();
        }
        return size;
    }

    public int numFamilies() {
        return this.familyMap.size();
    }

    public long heapSize() {
        long heapsize = MUTATION_OVERHEAD;
        heapsize += (long)ClassSize.align((int)(ClassSize.ARRAY + this.row.length));
        heapsize += (long)ClassSize.align((int)(this.familyMap.size() * ClassSize.MAP_ENTRY));
        for (Map.Entry entry : this.familyMap.entrySet()) {
            heapsize += (long)ClassSize.align((int)(ClassSize.ARRAY + ((byte[])entry.getKey()).length));
            heapsize += (long)ClassSize.align((int)ClassSize.ARRAYLIST);
            int size = ((List)entry.getValue()).size();
            heapsize += (long)ClassSize.align((int)(ClassSize.ARRAY + size * ClassSize.REFERENCE));
            for (Cell cell : (List)entry.getValue()) {
                KeyValue kv = KeyValueUtil.ensureKeyValue((Cell)cell);
                heapsize += kv.heapSize();
            }
        }
        heapsize += this.getAttributeSize();
        return ClassSize.align((long)(heapsize += this.extraHeapSize()));
    }

    protected long extraHeapSize() {
        return 0L;
    }

    static byte[] checkRow(byte[] row) {
        return Mutation.checkRow(row, 0, row == null ? 0 : row.length);
    }

    static byte[] checkRow(byte[] row, int offset, int length) {
        if (row == null) {
            throw new IllegalArgumentException("Row buffer is null");
        }
        if (length == 0) {
            throw new IllegalArgumentException("Row length is 0");
        }
        if (length > Short.MAX_VALUE) {
            throw new IllegalArgumentException("Row length " + length + " is > " + Short.MAX_VALUE);
        }
        return row;
    }
}

