/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellScannable;
import org.apache.hadoop.hbase.CellScanner;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.util.Bytes;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class Result
implements CellScannable {
    private KeyValue[] kvs;
    private transient byte[] row = null;
    private transient NavigableMap<byte[], NavigableMap<byte[], NavigableMap<Long, byte[]>>> familyMap = null;
    private static byte[] buffer = null;
    private static final int PAD_WIDTH = 128;
    public static final Result EMPTY_RESULT = new Result();

    public Result() {
    }

    public Result(KeyValue[] kvs) {
        this.kvs = kvs;
    }

    public Result(List<? extends Cell> kvs) {
        this(kvs.toArray(new KeyValue[kvs.size()]));
    }

    public byte[] getRow() {
        if (this.row == null) {
            this.row = this.kvs == null || this.kvs.length == 0 ? null : this.kvs[0].getRow();
        }
        return this.row;
    }

    public KeyValue[] raw() {
        return this.kvs;
    }

    public List<KeyValue> list() {
        return this.isEmpty() ? null : Arrays.asList(this.raw());
    }

    public List<KeyValue> getColumn(byte[] family, byte[] qualifier) {
        KeyValue kv;
        ArrayList<KeyValue> result = new ArrayList<KeyValue>();
        KeyValue[] kvs = this.raw();
        if (kvs == null || kvs.length == 0) {
            return result;
        }
        int pos = this.binarySearch(kvs, family, qualifier);
        if (pos == -1) {
            return result;
        }
        for (int i = pos; i < kvs.length && (kv = kvs[i]).matchingColumn(family, qualifier); ++i) {
            result.add(kv);
        }
        return result;
    }

    protected int binarySearch(KeyValue[] kvs, byte[] family, byte[] qualifier) {
        KeyValue searchTerm = KeyValue.createFirstOnRow((byte[])kvs[0].getRow(), (byte[])family, (byte[])qualifier);
        int pos = Arrays.binarySearch(kvs, searchTerm, KeyValue.COMPARATOR);
        if (pos < 0) {
            pos = (pos + 1) * -1;
        }
        if (pos == kvs.length) {
            return -1;
        }
        return pos;
    }

    protected int binarySearch(KeyValue[] kvs, byte[] family, int foffset, int flength, byte[] qualifier, int qoffset, int qlength) {
        KeyValue searchTerm;
        int pos;
        double keyValueSize = KeyValue.getKeyValueDataStructureSize((int)kvs[0].getRowLength(), (int)flength, (int)qlength, (int)0);
        if (buffer == null || keyValueSize > (double)buffer.length) {
            buffer = new byte[(int)Math.ceil(keyValueSize / 128.0) * 128];
        }
        if ((pos = Arrays.binarySearch(kvs, searchTerm = KeyValue.createFirstOnRow((byte[])buffer, (int)0, (byte[])kvs[0].getBuffer(), (int)kvs[0].getRowOffset(), (int)kvs[0].getRowLength(), (byte[])family, (int)foffset, (int)flength, (byte[])qualifier, (int)qoffset, (int)qlength), KeyValue.COMPARATOR)) < 0) {
            pos = (pos + 1) * -1;
        }
        if (pos == kvs.length) {
            return -1;
        }
        return pos;
    }

    public KeyValue getColumnLatest(byte[] family, byte[] qualifier) {
        KeyValue[] kvs = this.raw();
        if (kvs == null || kvs.length == 0) {
            return null;
        }
        int pos = this.binarySearch(kvs, family, qualifier);
        if (pos == -1) {
            return null;
        }
        KeyValue kv = kvs[pos];
        if (kv.matchingColumn(family, qualifier)) {
            return kv;
        }
        return null;
    }

    public KeyValue getColumnLatest(byte[] family, int foffset, int flength, byte[] qualifier, int qoffset, int qlength) {
        KeyValue[] kvs = this.raw();
        if (kvs == null || kvs.length == 0) {
            return null;
        }
        int pos = this.binarySearch(kvs, family, foffset, flength, qualifier, qoffset, qlength);
        if (pos == -1) {
            return null;
        }
        KeyValue kv = kvs[pos];
        if (kv.matchingColumn(family, foffset, flength, qualifier, qoffset, qlength)) {
            return kv;
        }
        return null;
    }

    public byte[] getValue(byte[] family, byte[] qualifier) {
        KeyValue kv = this.getColumnLatest(family, qualifier);
        if (kv == null) {
            return null;
        }
        return kv.getValue();
    }

    public ByteBuffer getValueAsByteBuffer(byte[] family, byte[] qualifier) {
        KeyValue kv = this.getColumnLatest(family, 0, family.length, qualifier, 0, qualifier.length);
        if (kv == null) {
            return null;
        }
        return kv.getValueAsByteBuffer();
    }

    public ByteBuffer getValueAsByteBuffer(byte[] family, int foffset, int flength, byte[] qualifier, int qoffset, int qlength) {
        KeyValue kv = this.getColumnLatest(family, foffset, flength, qualifier, qoffset, qlength);
        if (kv == null) {
            return null;
        }
        return kv.getValueAsByteBuffer();
    }

    public boolean loadValue(byte[] family, byte[] qualifier, ByteBuffer dst) throws BufferOverflowException {
        return this.loadValue(family, 0, family.length, qualifier, 0, qualifier.length, dst);
    }

    public boolean loadValue(byte[] family, int foffset, int flength, byte[] qualifier, int qoffset, int qlength, ByteBuffer dst) throws BufferOverflowException {
        KeyValue kv = this.getColumnLatest(family, foffset, flength, qualifier, qoffset, qlength);
        if (kv == null) {
            return false;
        }
        kv.loadValue(dst);
        return true;
    }

    public boolean containsNonEmptyColumn(byte[] family, byte[] qualifier) {
        return this.containsNonEmptyColumn(family, 0, family.length, qualifier, 0, qualifier.length);
    }

    public boolean containsNonEmptyColumn(byte[] family, int foffset, int flength, byte[] qualifier, int qoffset, int qlength) {
        KeyValue kv = this.getColumnLatest(family, foffset, flength, qualifier, qoffset, qlength);
        return kv != null && kv.getValueLength() > 0;
    }

    public boolean containsEmptyColumn(byte[] family, byte[] qualifier) {
        return this.containsEmptyColumn(family, 0, family.length, qualifier, 0, qualifier.length);
    }

    public boolean containsEmptyColumn(byte[] family, int foffset, int flength, byte[] qualifier, int qoffset, int qlength) {
        KeyValue kv = this.getColumnLatest(family, foffset, flength, qualifier, qoffset, qlength);
        return kv != null && kv.getValueLength() == 0;
    }

    public boolean containsColumn(byte[] family, byte[] qualifier) {
        KeyValue kv = this.getColumnLatest(family, qualifier);
        return kv != null;
    }

    public boolean containsColumn(byte[] family, int foffset, int flength, byte[] qualifier, int qoffset, int qlength) {
        return this.getColumnLatest(family, foffset, flength, qualifier, qoffset, qlength) != null;
    }

    public NavigableMap<byte[], NavigableMap<byte[], NavigableMap<Long, byte[]>>> getMap() {
        if (this.familyMap != null) {
            return this.familyMap;
        }
        if (this.isEmpty()) {
            return null;
        }
        this.familyMap = new TreeMap<byte[], NavigableMap<byte[], NavigableMap<Long, byte[]>>>(Bytes.BYTES_COMPARATOR);
        for (KeyValue kv : this.kvs) {
            byte[] qualifier;
            TreeMap<Long, byte[]> versionMap;
            KeyValue.SplitKeyValue splitKV = kv.split();
            byte[] family = splitKV.getFamily();
            TreeMap columnMap = (TreeMap)this.familyMap.get(family);
            if (columnMap == null) {
                columnMap = new TreeMap(Bytes.BYTES_COMPARATOR);
                this.familyMap.put(family, columnMap);
            }
            if ((versionMap = (TreeMap<Long, byte[]>)columnMap.get(qualifier = splitKV.getQualifier())) == null) {
                versionMap = new TreeMap<Long, byte[]>(new Comparator<Long>(){

                    @Override
                    public int compare(Long l1, Long l2) {
                        return l2.compareTo(l1);
                    }
                });
                columnMap.put(qualifier, versionMap);
            }
            Long timestamp = Bytes.toLong((byte[])splitKV.getTimestamp());
            byte[] value = splitKV.getValue();
            versionMap.put(timestamp, value);
        }
        return this.familyMap;
    }

    public NavigableMap<byte[], NavigableMap<byte[], byte[]>> getNoVersionMap() {
        if (this.familyMap == null) {
            this.getMap();
        }
        if (this.isEmpty()) {
            return null;
        }
        TreeMap<byte[], NavigableMap<byte[], byte[]>> returnMap = new TreeMap<byte[], NavigableMap<byte[], byte[]>>(Bytes.BYTES_COMPARATOR);
        for (Map.Entry familyEntry : this.familyMap.entrySet()) {
            TreeMap qualifierMap = new TreeMap(Bytes.BYTES_COMPARATOR);
            for (Map.Entry qualifierEntry : ((NavigableMap)familyEntry.getValue()).entrySet()) {
                byte[] value = (byte[])((NavigableMap)qualifierEntry.getValue()).get(((NavigableMap)qualifierEntry.getValue()).firstKey());
                qualifierMap.put(qualifierEntry.getKey(), value);
            }
            returnMap.put((byte[])familyEntry.getKey(), qualifierMap);
        }
        return returnMap;
    }

    public NavigableMap<byte[], byte[]> getFamilyMap(byte[] family) {
        if (this.familyMap == null) {
            this.getMap();
        }
        if (this.isEmpty()) {
            return null;
        }
        TreeMap<byte[], byte[]> returnMap = new TreeMap<byte[], byte[]>(Bytes.BYTES_COMPARATOR);
        NavigableMap qualifierMap = (NavigableMap)this.familyMap.get(family);
        if (qualifierMap == null) {
            return returnMap;
        }
        for (Map.Entry entry : qualifierMap.entrySet()) {
            byte[] value = (byte[])((NavigableMap)entry.getValue()).get(((NavigableMap)entry.getValue()).firstKey());
            returnMap.put((byte[])entry.getKey(), value);
        }
        return returnMap;
    }

    public byte[] value() {
        if (this.isEmpty()) {
            return null;
        }
        return this.kvs[0].getValue();
    }

    public boolean isEmpty() {
        return this.kvs == null || this.kvs.length == 0;
    }

    public int size() {
        return this.kvs == null ? 0 : this.kvs.length;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("keyvalues=");
        if (this.isEmpty()) {
            sb.append("NONE");
            return sb.toString();
        }
        sb.append("{");
        boolean moreThanOne = false;
        for (KeyValue kv : this.kvs) {
            if (moreThanOne) {
                sb.append(", ");
            } else {
                moreThanOne = true;
            }
            sb.append(kv.toString());
        }
        sb.append("}");
        return sb.toString();
    }

    public static void compareResults(Result res1, Result res2) throws Exception {
        if (res2 == null) {
            throw new Exception("There wasn't enough rows, we stopped at " + Bytes.toStringBinary((byte[])res1.getRow()));
        }
        if (res1.size() != res2.size()) {
            throw new Exception("This row doesn't have the same number of KVs: " + res1.toString() + " compared to " + res2.toString());
        }
        KeyValue[] ourKVs = res1.raw();
        KeyValue[] replicatedKVs = res2.raw();
        for (int i = 0; i < res1.size(); ++i) {
            if (ourKVs[i].equals((Object)replicatedKVs[i]) && Bytes.equals((byte[])ourKVs[i].getValue(), (byte[])replicatedKVs[i].getValue())) continue;
            throw new Exception("This result was different: " + res1.toString() + " compared to " + res2.toString());
        }
    }

    public void copyFrom(Result other) {
        this.row = null;
        this.familyMap = null;
        this.kvs = other.kvs;
    }

    public CellScanner cellScanner() {
        return CellUtil.createCellScanner((Cell[])this.kvs);
    }
}

