/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import com.google.protobuf.ServiceException;
import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.ConnectException;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.client.ConnectionUtils;
import org.apache.hadoop.hbase.client.HConnection;
import org.apache.hadoop.hbase.client.RetriesExhaustedException;
import org.apache.hadoop.hbase.exceptions.DoNotRetryIOException;
import org.apache.hadoop.hbase.exceptions.NotServingRegionException;
import org.apache.hadoop.hbase.ipc.RpcClient;
import org.apache.hadoop.hbase.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.ipc.RemoteException;

@InterfaceAudience.Public
@InterfaceStability.Stable
public abstract class ServerCallable<T>
implements Callable<T> {
    static final Log LOG = LogFactory.getLog(ServerCallable.class);
    protected final HConnection connection;
    protected final byte[] tableName;
    protected final byte[] row;
    protected HRegionLocation location;
    protected ClientProtos.ClientService.BlockingInterface stub;
    protected int callTimeout;
    protected long globalStartTime;
    protected long startTime;
    protected long endTime;
    protected static final int MIN_RPC_TIMEOUT = 2000;
    protected static final int MIN_WAIT_DEAD_SERVER = 10000;

    public ServerCallable(HConnection connection, byte[] tableName, byte[] row) {
        this(connection, tableName, row, Integer.MAX_VALUE);
    }

    public ServerCallable(HConnection connection, byte[] tableName, byte[] row, int callTimeout) {
        this.connection = connection;
        this.tableName = tableName;
        this.row = row;
        this.callTimeout = callTimeout;
    }

    public void prepare(boolean reload) throws IOException {
        this.location = this.connection.getRegionLocation(this.tableName, this.row, reload);
        if (this.location == null) {
            throw new IOException("Failed to find location, tableName=" + this.tableName + ", row=" + Bytes.toString((byte[])this.row) + ", reload=" + reload);
        }
        this.stub = this.connection.getClient(this.location.getServerName());
    }

    public String getServerName() {
        if (this.location == null) {
            return null;
        }
        return this.location.getHostnamePort();
    }

    public byte[] getRegionName() {
        if (this.location == null) {
            return null;
        }
        return this.location.getRegionInfo().getRegionName();
    }

    public byte[] getRow() {
        return this.row;
    }

    public void beforeCall() {
        this.startTime = EnvironmentEdgeManager.currentTimeMillis();
        int remaining = (int)((long)this.callTimeout - (this.startTime - this.globalStartTime));
        if (remaining < 2000) {
            remaining = 2000;
        }
        RpcClient.setRpcTimeout(remaining);
    }

    public void afterCall() {
        RpcClient.resetRpcTimeout();
        this.endTime = EnvironmentEdgeManager.currentTimeMillis();
    }

    HConnection getConnection() {
        return this.connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T withRetries() throws IOException, RuntimeException {
        Configuration c = this.getConnection().getConfiguration();
        long pause = c.getLong(HConstants.HBASE_CLIENT_PAUSE, HConstants.DEFAULT_HBASE_CLIENT_PAUSE);
        int numRetries = c.getInt(HConstants.HBASE_CLIENT_RETRIES_NUMBER, HConstants.DEFAULT_HBASE_CLIENT_RETRIES_NUMBER);
        ArrayList<RetriesExhaustedException.ThrowableWithExtraContext> exceptions = new ArrayList<RetriesExhaustedException.ThrowableWithExtraContext>();
        this.globalStartTime = EnvironmentEdgeManager.currentTimeMillis();
        int tries = 0;
        while (true) {
            long expectedSleep = 0L;
            try {
                this.beforeCall();
                this.prepare(tries != 0);
                Object v = this.call();
                return (T)v;
            }
            catch (Throwable t) {
                long duration;
                LOG.warn((Object)("Call exception, tries=" + tries + ", numRetries=" + numRetries), t);
                t = ServerCallable.translateException(t);
                if (t instanceof SocketTimeoutException || t instanceof ConnectException || t instanceof RetriesExhaustedException || this.location != null && this.getConnection().isDeadServer(this.location.getServerName())) {
                    this.getConnection().clearCaches(this.location.getServerName());
                } else if (t instanceof NotServingRegionException && numRetries == 1) {
                    this.getConnection().deleteCachedRegionLocation(this.location);
                }
                RetriesExhaustedException.ThrowableWithExtraContext qt = new RetriesExhaustedException.ThrowableWithExtraContext(t, EnvironmentEdgeManager.currentTimeMillis(), this.toString());
                exceptions.add(qt);
                if (tries >= numRetries - 1) {
                    throw new RetriesExhaustedException(tries, exceptions);
                }
                expectedSleep = ConnectionUtils.getPauseTime(pause, tries + 1);
                if (expectedSleep < 10000L && (this.location == null || this.getConnection().isDeadServer(this.location.getServerName()))) {
                    expectedSleep = ConnectionUtils.addJitter(10000L, 0.1f);
                }
                if ((duration = this.singleCallDuration(expectedSleep)) > (long)this.callTimeout) {
                    throw (SocketTimeoutException)new SocketTimeoutException("Call to access row '" + Bytes.toString((byte[])this.row) + "' on table '" + Bytes.toString((byte[])this.tableName) + "' failed on timeout. " + " callTimeout=" + this.callTimeout + ", callDuration=" + duration).initCause(t);
                }
            }
            finally {
                this.afterCall();
            }
            try {
                Thread.sleep(expectedSleep);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new IOException("Interrupted after " + tries + " tries  on " + numRetries, e);
            }
            ++tries;
        }
    }

    private long singleCallDuration(long expectedSleep) {
        return this.endTime - this.globalStartTime + 2000L + expectedSleep;
    }

    public T withoutRetries() throws IOException, RuntimeException {
        this.globalStartTime = EnvironmentEdgeManager.currentTimeMillis();
        try {
            this.beforeCall();
            this.prepare(false);
            Object v = this.call();
            return (T)v;
        }
        catch (Throwable t) {
            Throwable t2 = ServerCallable.translateException(t);
            if (t2 instanceof IOException) {
                throw (IOException)t2;
            }
            throw new RuntimeException(t2);
        }
        finally {
            this.afterCall();
        }
    }

    protected static Throwable translateException(Throwable t) throws DoNotRetryIOException {
        if (t instanceof UndeclaredThrowableException && t.getCause() != null) {
            t = t.getCause();
        }
        if (t instanceof RemoteException) {
            t = ((RemoteException)t).unwrapRemoteException();
        }
        if (t instanceof ServiceException) {
            ServiceException se = (ServiceException)t;
            Throwable cause = se.getCause();
            if (cause != null && cause instanceof DoNotRetryIOException) {
                throw (DoNotRetryIOException)((Object)cause);
            }
        } else if (t instanceof DoNotRetryIOException) {
            throw (DoNotRetryIOException)((Object)t);
        }
        return t;
    }
}

