/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.client.HConnection;
import org.apache.hadoop.hbase.client.HConnectionManager;
import org.apache.hadoop.hbase.client.Registry;
import org.apache.hadoop.hbase.client.ZooKeeperKeepAliveConnection;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.zookeeper.MetaRegionTracker;
import org.apache.hadoop.hbase.zookeeper.ZKClusterId;
import org.apache.hadoop.hbase.zookeeper.ZKTableReadOnly;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.zookeeper.KeeperException;

class ZooKeeperRegistry
implements Registry {
    static final Log LOG = LogFactory.getLog(ZooKeeperRegistry.class);
    HConnectionManager.HConnectionImplementation hci;
    private String clusterId = null;

    ZooKeeperRegistry() {
    }

    @Override
    public void init(HConnection connection) {
        if (!(connection instanceof HConnectionManager.HConnectionImplementation)) {
            throw new RuntimeException("This registry depends on HConnectionImplementation");
        }
        this.hci = (HConnectionManager.HConnectionImplementation)connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HRegionLocation getMetaRegionLocation() throws IOException {
        ZooKeeperKeepAliveConnection zkw = this.hci.getKeepAliveZooKeeperWatcher();
        try {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Looking up meta region location in ZK, connection=" + this));
            }
            ServerName servername = MetaRegionTracker.blockUntilAvailable(zkw, this.hci.rpcTimeout);
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Looked up meta region location, connection=" + this + "; serverName=" + (servername == null ? "null" : servername)));
            }
            if (servername == null) {
                HRegionLocation hRegionLocation = null;
                return hRegionLocation;
            }
            HRegionLocation hRegionLocation = new HRegionLocation(HRegionInfo.FIRST_META_REGIONINFO, servername, 0L);
            return hRegionLocation;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            HRegionLocation hRegionLocation = null;
            return hRegionLocation;
        }
        finally {
            zkw.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getClusterId() {
        if (this.clusterId != null) {
            return this.clusterId;
        }
        ZooKeeperKeepAliveConnection zkw = null;
        try {
            zkw = this.hci.getKeepAliveZooKeeperWatcher();
            this.clusterId = ZKClusterId.readClusterIdZNode(zkw);
            if (this.clusterId == null) {
                LOG.info((Object)"ClusterId read in ZooKeeper is null");
            }
        }
        catch (KeeperException e) {
            LOG.warn((Object)"Can't retrieve clusterId from Zookeeper", (Throwable)e);
        }
        catch (IOException e) {
            LOG.warn((Object)"Can't retrieve clusterId from Zookeeper", (Throwable)e);
        }
        finally {
            if (zkw != null) {
                zkw.close();
            }
        }
        return this.clusterId;
    }

    @Override
    public boolean isTableOnlineState(byte[] tableName, boolean enabled) throws IOException {
        String tableNameStr = Bytes.toString((byte[])tableName);
        ZooKeeperKeepAliveConnection zkw = this.hci.getKeepAliveZooKeeperWatcher();
        try {
            if (enabled) {
                boolean bl = ZKTableReadOnly.isEnabledTable(zkw, tableNameStr);
                return bl;
            }
            boolean bl = ZKTableReadOnly.isDisabledTable(zkw, tableNameStr);
            return bl;
        }
        catch (KeeperException e) {
            throw new IOException("Enable/Disable failed", e);
        }
        finally {
            zkw.close();
        }
    }

    @Override
    public int getCurrentNrHRS() throws IOException {
        ZooKeeperKeepAliveConnection zkw = this.hci.getKeepAliveZooKeeperWatcher();
        try {
            int n = ZKUtil.getNumberOfChildren(zkw, zkw.rsZNode);
            return n;
        }
        catch (KeeperException ke) {
            throw new IOException("Unexpected ZooKeeper exception", ke);
        }
        finally {
            zkw.close();
        }
    }
}

