/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.filter;

import java.io.IOException;
import java.util.List;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.exceptions.DeserializationException;

@InterfaceAudience.Public
@InterfaceStability.Stable
public abstract class Filter {
    public abstract void reset() throws IOException;

    public abstract boolean filterRowKey(byte[] var1, int var2, int var3) throws IOException;

    public abstract boolean filterAllRemaining() throws IOException;

    public abstract ReturnCode filterKeyValue(KeyValue var1) throws IOException;

    public abstract KeyValue transform(KeyValue var1) throws IOException;

    public abstract void filterRow(List<KeyValue> var1) throws IOException;

    public abstract boolean hasFilterRow();

    public abstract boolean filterRow() throws IOException;

    public abstract KeyValue getNextKeyHint(KeyValue var1) throws IOException;

    public abstract boolean isFamilyEssential(byte[] var1) throws IOException;

    public abstract byte[] toByteArray() throws IOException;

    public static Filter parseFrom(byte[] pbBytes) throws DeserializationException {
        throw new DeserializationException("parseFrom called on base Filter, but should be called on derived type");
    }

    abstract boolean areSerializedFieldsEqual(Filter var1);

    public static enum ReturnCode {
        INCLUDE,
        INCLUDE_AND_NEXT_COL,
        SKIP,
        NEXT_COL,
        NEXT_ROW,
        SEEK_NEXT_USING_HINT;

    }
}

