/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.filter;

import com.google.protobuf.InvalidProtocolBufferException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.generated.FilterProtos;
import org.apache.hadoop.hbase.protobuf.generated.HBaseProtos;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class FilterList
extends Filter {
    private static final Configuration conf = HBaseConfiguration.create();
    private static final int MAX_LOG_FILTERS = 5;
    private Operator operator = Operator.MUST_PASS_ALL;
    private List<Filter> filters = new ArrayList<Filter>();

    public FilterList(List<Filter> rowFilters) {
        this.filters = rowFilters instanceof ArrayList ? rowFilters : new ArrayList<Filter>(rowFilters);
    }

    public FilterList(Filter ... rowFilters) {
        this.filters = new ArrayList<Filter>(Arrays.asList(rowFilters));
    }

    public FilterList(Operator operator) {
        this.operator = operator;
    }

    public FilterList(Operator operator, List<Filter> rowFilters) {
        this.filters = new ArrayList<Filter>(rowFilters);
        this.operator = operator;
    }

    public FilterList(Operator operator, Filter ... rowFilters) {
        this.filters = new ArrayList<Filter>(Arrays.asList(rowFilters));
        this.operator = operator;
    }

    public Operator getOperator() {
        return this.operator;
    }

    public List<Filter> getFilters() {
        return this.filters;
    }

    public void addFilter(Filter filter) {
        this.filters.add(filter);
    }

    @Override
    public void reset() throws IOException {
        for (Filter filter : this.filters) {
            filter.reset();
        }
    }

    @Override
    public boolean filterRowKey(byte[] rowKey, int offset, int length) throws IOException {
        boolean flag = this.operator == Operator.MUST_PASS_ONE;
        for (Filter filter : this.filters) {
            if (this.operator == Operator.MUST_PASS_ALL) {
                if (!filter.filterAllRemaining() && !filter.filterRowKey(rowKey, offset, length)) continue;
                flag = true;
                continue;
            }
            if (this.operator != Operator.MUST_PASS_ONE || filter.filterAllRemaining() || filter.filterRowKey(rowKey, offset, length)) continue;
            flag = false;
        }
        return flag;
    }

    @Override
    public boolean filterAllRemaining() throws IOException {
        for (Filter filter : this.filters) {
            if (filter.filterAllRemaining()) {
                if (this.operator != Operator.MUST_PASS_ALL) continue;
                return true;
            }
            if (this.operator != Operator.MUST_PASS_ONE) continue;
            return false;
        }
        return this.operator == Operator.MUST_PASS_ONE;
    }

    @Override
    public KeyValue transform(KeyValue v) throws IOException {
        KeyValue current = v;
        for (Filter filter : this.filters) {
            current = filter.transform(current);
        }
        return current;
    }

    @Override
    public Filter.ReturnCode filterKeyValue(KeyValue v) throws IOException {
        Filter.ReturnCode rc = this.operator == Operator.MUST_PASS_ONE ? Filter.ReturnCode.SKIP : Filter.ReturnCode.INCLUDE;
        block12: for (Filter filter : this.filters) {
            if (this.operator == Operator.MUST_PASS_ALL) {
                if (filter.filterAllRemaining()) {
                    return Filter.ReturnCode.NEXT_ROW;
                }
                Filter.ReturnCode code = filter.filterKeyValue(v);
                switch (code) {
                    case INCLUDE_AND_NEXT_COL: {
                        rc = Filter.ReturnCode.INCLUDE_AND_NEXT_COL;
                    }
                    case INCLUDE: {
                        continue block12;
                    }
                }
                return code;
            }
            if (this.operator != Operator.MUST_PASS_ONE || filter.filterAllRemaining()) continue;
            switch (filter.filterKeyValue(v)) {
                case INCLUDE: {
                    if (rc == Filter.ReturnCode.INCLUDE_AND_NEXT_COL) continue block12;
                    rc = Filter.ReturnCode.INCLUDE;
                    continue block12;
                }
                case INCLUDE_AND_NEXT_COL: {
                    rc = Filter.ReturnCode.INCLUDE_AND_NEXT_COL;
                    continue block12;
                }
                case NEXT_ROW: {
                    continue block12;
                }
                case SKIP: {
                    continue block12;
                }
                case NEXT_COL: {
                    continue block12;
                }
                case SEEK_NEXT_USING_HINT: {
                    continue block12;
                }
            }
            throw new IllegalStateException("Received code is not valid.");
        }
        return rc;
    }

    @Override
    public void filterRow(List<KeyValue> kvs) throws IOException {
        for (Filter filter : this.filters) {
            filter.filterRow(kvs);
        }
    }

    @Override
    public boolean hasFilterRow() {
        for (Filter filter : this.filters) {
            if (!filter.hasFilterRow()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean filterRow() throws IOException {
        for (Filter filter : this.filters) {
            if (this.operator == Operator.MUST_PASS_ALL) {
                if (!filter.filterRow()) continue;
                return true;
            }
            if (this.operator != Operator.MUST_PASS_ONE || filter.filterRow()) continue;
            return false;
        }
        return this.operator == Operator.MUST_PASS_ONE;
    }

    @Override
    public byte[] toByteArray() throws IOException {
        FilterProtos.FilterList.Builder builder = FilterProtos.FilterList.newBuilder();
        builder.setOperator(FilterProtos.FilterList.Operator.valueOf((String)this.operator.name()));
        for (Filter filter : this.filters) {
            builder.addFilters(ProtobufUtil.toFilter(filter));
        }
        return builder.build().toByteArray();
    }

    public static FilterList parseFrom(byte[] pbBytes) throws DeserializationException {
        FilterProtos.FilterList proto;
        try {
            proto = FilterProtos.FilterList.parseFrom((byte[])pbBytes);
        }
        catch (InvalidProtocolBufferException e) {
            throw new DeserializationException(e);
        }
        ArrayList<Filter> rowFilters = new ArrayList<Filter>(proto.getFiltersCount());
        try {
            for (HBaseProtos.Filter filter : proto.getFiltersList()) {
                rowFilters.add(ProtobufUtil.toFilter(filter));
            }
        }
        catch (IOException ioe) {
            throw new DeserializationException(ioe);
        }
        return new FilterList(Operator.valueOf(proto.getOperator().name()), rowFilters);
    }

    @Override
    boolean areSerializedFieldsEqual(Filter o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FilterList)) {
            return false;
        }
        FilterList other = (FilterList)o;
        return this.getOperator().equals((Object)other.getOperator()) && (this.getFilters() == other.getFilters() || ((Object)this.getFilters()).equals(other.getFilters()));
    }

    @Override
    public KeyValue getNextKeyHint(KeyValue currentKV) throws IOException {
        KeyValue keyHint = null;
        for (Filter filter : this.filters) {
            KeyValue curKeyHint = filter.getNextKeyHint(currentKV);
            if (curKeyHint == null && this.operator == Operator.MUST_PASS_ONE) {
                return null;
            }
            if (curKeyHint == null) continue;
            if (keyHint == null) {
                keyHint = curKeyHint;
                continue;
            }
            if (this.operator == Operator.MUST_PASS_ALL && KeyValue.COMPARATOR.compare(keyHint, curKeyHint) < 0) {
                keyHint = curKeyHint;
                continue;
            }
            if (this.operator != Operator.MUST_PASS_ONE || KeyValue.COMPARATOR.compare(keyHint, curKeyHint) <= 0) continue;
            keyHint = curKeyHint;
        }
        return keyHint;
    }

    @Override
    public boolean isFamilyEssential(byte[] name) throws IOException {
        for (Filter filter : this.filters) {
            if (!filter.isFamilyEssential(name)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return this.toString(5);
    }

    protected String toString(int maxFilters) {
        int endIndex = this.filters.size() < maxFilters ? this.filters.size() : maxFilters;
        return String.format("%s %s (%d/%d): %s", this.getClass().getSimpleName(), this.operator == Operator.MUST_PASS_ALL ? "AND" : "OR", endIndex, this.filters.size(), this.filters.subList(0, endIndex).toString());
    }

    public static enum Operator {
        MUST_PASS_ALL,
        MUST_PASS_ONE;

    }
}

