/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.filter;

import com.google.protobuf.InvalidProtocolBufferException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.filter.ByteArrayComparable;
import org.apache.hadoop.hbase.filter.CompareFilter;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.SingleColumnValueFilter;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.generated.FilterProtos;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class SingleColumnValueExcludeFilter
extends SingleColumnValueFilter {
    public SingleColumnValueExcludeFilter(byte[] family, byte[] qualifier, CompareFilter.CompareOp compareOp, byte[] value) {
        super(family, qualifier, compareOp, value);
    }

    public SingleColumnValueExcludeFilter(byte[] family, byte[] qualifier, CompareFilter.CompareOp compareOp, ByteArrayComparable comparator) {
        super(family, qualifier, compareOp, comparator);
    }

    protected SingleColumnValueExcludeFilter(byte[] family, byte[] qualifier, CompareFilter.CompareOp compareOp, ByteArrayComparable comparator, boolean filterIfMissing, boolean latestVersionOnly) {
        super(family, qualifier, compareOp, comparator, filterIfMissing, latestVersionOnly);
    }

    @Override
    public boolean hasFilterRow() {
        return true;
    }

    @Override
    public void filterRow(List<KeyValue> kvs) {
        Iterator<KeyValue> it = kvs.iterator();
        while (it.hasNext()) {
            KeyValue kv = it.next();
            if (!kv.matchingColumn(this.columnFamily, this.columnQualifier)) continue;
            it.remove();
        }
    }

    public static Filter createFilterFromArguments(ArrayList<byte[]> filterArguments) {
        SingleColumnValueFilter tempFilter = (SingleColumnValueFilter)SingleColumnValueFilter.createFilterFromArguments(filterArguments);
        SingleColumnValueExcludeFilter filter = new SingleColumnValueExcludeFilter(tempFilter.getFamily(), tempFilter.getQualifier(), tempFilter.getOperator(), tempFilter.getComparator());
        if (filterArguments.size() == 6) {
            filter.setFilterIfMissing(tempFilter.getFilterIfMissing());
            filter.setLatestVersionOnly(tempFilter.getLatestVersionOnly());
        }
        return filter;
    }

    @Override
    public byte[] toByteArray() {
        FilterProtos.SingleColumnValueExcludeFilter.Builder builder = FilterProtos.SingleColumnValueExcludeFilter.newBuilder();
        builder.setSingleColumnValueFilter(super.convert());
        return builder.build().toByteArray();
    }

    public static SingleColumnValueExcludeFilter parseFrom(byte[] pbBytes) throws DeserializationException {
        ByteArrayComparable comparator;
        FilterProtos.SingleColumnValueExcludeFilter proto;
        try {
            proto = FilterProtos.SingleColumnValueExcludeFilter.parseFrom((byte[])pbBytes);
        }
        catch (InvalidProtocolBufferException e) {
            throw new DeserializationException(e);
        }
        FilterProtos.SingleColumnValueFilter parentProto = proto.getSingleColumnValueFilter();
        CompareFilter.CompareOp compareOp = CompareFilter.CompareOp.valueOf(parentProto.getCompareOp().name());
        try {
            comparator = ProtobufUtil.toComparator(parentProto.getComparator());
        }
        catch (IOException ioe) {
            throw new DeserializationException(ioe);
        }
        return new SingleColumnValueExcludeFilter(parentProto.hasColumnFamily() ? parentProto.getColumnFamily().toByteArray() : null, parentProto.hasColumnQualifier() ? parentProto.getColumnQualifier().toByteArray() : null, compareOp, comparator, parentProto.getFilterIfMissing(), parentProto.getLatestVersionOnly());
    }

    @Override
    boolean areSerializedFieldsEqual(Filter o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SingleColumnValueExcludeFilter)) {
            return false;
        }
        return super.areSerializedFieldsEqual(o);
    }
}

