/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.ipc;

import com.google.common.base.Preconditions;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.Message;
import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.CellScanner;
import org.apache.hadoop.hbase.codec.Codec;
import org.apache.hadoop.hbase.io.ByteBufferOutputStream;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.compress.CodecPool;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.CompressionInputStream;
import org.apache.hadoop.io.compress.Compressor;
import org.apache.hadoop.io.compress.Decompressor;

class IPCUtil {
    public static final Log LOG = LogFactory.getLog(IPCUtil.class);
    private final int cellBlockBuildingInitialBufferSize;
    private final int cellBlockDecompressionMultiplier;
    private final Configuration conf;

    IPCUtil(Configuration conf) {
        this.conf = conf;
        this.cellBlockBuildingInitialBufferSize = conf.getInt("hbase.ipc.cellblock.building.initial.buffersize", 16384);
        this.cellBlockDecompressionMultiplier = conf.getInt("hbase.ipc.cellblock.decompression.buffersize.multiplier", 3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ByteBuffer buildCellBlock(Codec codec, CompressionCodec compressor, CellScanner cells) throws IOException {
        ByteBufferOutputStream baos;
        if (cells == null) {
            return null;
        }
        ByteBufferOutputStream os = baos = new ByteBufferOutputStream(this.cellBlockBuildingInitialBufferSize);
        Compressor poolCompressor = null;
        try {
            if (compressor != null) {
                if (compressor instanceof Configurable) {
                    ((Configurable)compressor).setConf(this.conf);
                }
                poolCompressor = CodecPool.getCompressor((CompressionCodec)compressor);
                os = compressor.createOutputStream((OutputStream)os, poolCompressor);
            }
            Codec.Encoder encoder = codec.getEncoder((OutputStream)os);
            while (cells.advance()) {
                encoder.write(cells.current());
            }
            encoder.flush();
        }
        finally {
            os.close();
            if (poolCompressor != null) {
                CodecPool.returnCompressor((Compressor)poolCompressor);
            }
        }
        if (LOG.isTraceEnabled() && this.cellBlockBuildingInitialBufferSize < baos.size()) {
            LOG.trace((Object)("Buffer grew from " + this.cellBlockBuildingInitialBufferSize + " to " + baos.size()));
        }
        return baos.getByteBuffer();
    }

    CellScanner createCellScanner(Codec codec, CompressionCodec compressor, byte[] cellBlock) throws IOException {
        return this.createCellScanner(codec, compressor, cellBlock, 0, cellBlock.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CellScanner createCellScanner(Codec codec, CompressionCodec compressor, byte[] cellBlock, int offset, int length) throws IOException {
        ByteArrayInputStream is = null;
        if (compressor != null) {
            if (compressor instanceof Configurable) {
                ((Configurable)compressor).setConf(this.conf);
            }
            Decompressor poolDecompressor = CodecPool.getDecompressor((CompressionCodec)compressor);
            CompressionInputStream cis = compressor.createInputStream((InputStream)new ByteArrayInputStream(cellBlock, offset, length), poolDecompressor);
            try {
                ByteBufferOutputStream bbos = new ByteBufferOutputStream((length - offset) * this.cellBlockDecompressionMultiplier);
                IOUtils.copy((InputStream)cis, (OutputStream)bbos);
                bbos.close();
                ByteBuffer bb = bbos.getByteBuffer();
                is = new ByteArrayInputStream(bb.array(), 0, bb.limit());
            }
            finally {
                if (is != null) {
                    ((InputStream)is).close();
                }
                CodecPool.returnDecompressor((Decompressor)poolDecompressor);
            }
        } else {
            is = new ByteArrayInputStream(cellBlock, offset, length);
        }
        return codec.getDecoder((InputStream)is);
    }

    static ByteBufferOutputStream write(Message header, Message param, ByteBuffer cellBlock) throws IOException {
        int totalSize = IPCUtil.getTotalSizeWhenWrittenDelimited(header, param);
        if (cellBlock != null) {
            totalSize += cellBlock.limit();
        }
        ByteBufferOutputStream bbos = new ByteBufferOutputStream(totalSize);
        IPCUtil.write((OutputStream)bbos, header, param, cellBlock, totalSize);
        bbos.close();
        return bbos;
    }

    static int write(OutputStream dos, Message header, Message param, ByteBuffer cellBlock) throws IOException {
        int totalSize = IPCUtil.getTotalSizeWhenWrittenDelimited(header, param);
        if (cellBlock != null) {
            totalSize += cellBlock.remaining();
        }
        return IPCUtil.write(dos, header, param, cellBlock, totalSize);
    }

    private static int write(OutputStream dos, Message header, Message param, ByteBuffer cellBlock, int totalSize) throws IOException {
        dos.write(Bytes.toBytes((int)totalSize));
        header.writeDelimitedTo(dos);
        if (param != null) {
            param.writeDelimitedTo(dos);
        }
        if (cellBlock != null) {
            dos.write(cellBlock.array(), 0, cellBlock.remaining());
        }
        dos.flush();
        return totalSize;
    }

    static byte[] getDelimitedMessageBytes(DataInputStream in) throws IOException {
        byte b = in.readByte();
        int size = CodedInputStream.readRawVarint32((int)b, (InputStream)in);
        byte[] bytes = new byte[size];
        IOUtils.readFully((InputStream)in, (byte[])bytes);
        return bytes;
    }

    static void readChunked(DataInput in, byte[] dest, int offset, int len) throws IOException {
        int maxRead = 8192;
        while (offset < len) {
            in.readFully(dest, offset, Math.min(len - offset, maxRead));
            offset += maxRead;
        }
    }

    static int getTotalSizeWhenWrittenDelimited(Message ... messages) {
        int totalSize = 0;
        for (Message m : messages) {
            if (m == null) continue;
            totalSize += m.getSerializedSize();
            totalSize += CodedOutputStream.computeRawVarint32Size((int)m.getSerializedSize());
        }
        Preconditions.checkArgument((totalSize < Integer.MAX_VALUE ? 1 : 0) != 0);
        return totalSize;
    }
}

