/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.ipc;

import com.google.protobuf.ByteString;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.client.HConnection;
import org.apache.hadoop.hbase.ipc.CoprocessorRpcChannel;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.generated.ClientProtos;

@InterfaceAudience.Private
public class MasterCoprocessorRpcChannel
extends CoprocessorRpcChannel {
    private static Log LOG = LogFactory.getLog(MasterCoprocessorRpcChannel.class);
    private final HConnection connection;

    public MasterCoprocessorRpcChannel(HConnection conn) {
        this.connection = conn;
    }

    @Override
    protected Message callExecService(Descriptors.MethodDescriptor method, Message request, Message responsePrototype) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Call: " + method.getName() + ", " + request.toString()));
        }
        ClientProtos.CoprocessorServiceCall call = ClientProtos.CoprocessorServiceCall.newBuilder().setRow(ByteString.copyFrom((byte[])HConstants.EMPTY_BYTE_ARRAY)).setServiceName(method.getService().getFullName()).setMethodName(method.getName()).setRequest(request.toByteString()).build();
        ClientProtos.CoprocessorServiceResponse result = ProtobufUtil.execService(this.connection.getMasterAdmin(), call);
        Message response = null;
        response = result.getValue().hasValue() ? responsePrototype.newBuilderForType().mergeFrom(result.getValue().getValue()).build() : responsePrototype.getDefaultInstanceForType();
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Master Result is value=" + response));
        }
        return response;
    }
}

