/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.protobuf;

import com.google.protobuf.ByteString;
import java.io.IOException;
import java.util.List;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.hbase.CellScannable;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.client.Action;
import org.apache.hadoop.hbase.client.Append;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Row;
import org.apache.hadoop.hbase.client.RowMutations;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.exceptions.DoNotRetryIOException;
import org.apache.hadoop.hbase.filter.ByteArrayComparable;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.generated.AccessControlProtos;
import org.apache.hadoop.hbase.protobuf.generated.AdminProtos;
import org.apache.hadoop.hbase.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.protobuf.generated.MasterAdminProtos;
import org.apache.hadoop.hbase.protobuf.generated.MasterMonitorProtos;
import org.apache.hadoop.hbase.protobuf.generated.MasterProtos;
import org.apache.hadoop.hbase.protobuf.generated.RegionServerStatusProtos;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.util.Triple;

@InterfaceAudience.Private
public final class RequestConverter {
    private RequestConverter() {
    }

    public static ClientProtos.GetRequest buildGetRowOrBeforeRequest(byte[] regionName, byte[] row, byte[] family) {
        ClientProtos.GetRequest.Builder builder = ClientProtos.GetRequest.newBuilder();
        HBaseProtos.RegionSpecifier region = RequestConverter.buildRegionSpecifier(HBaseProtos.RegionSpecifier.RegionSpecifierType.REGION_NAME, regionName);
        builder.setClosestRowBefore(true);
        builder.setRegion(region);
        ClientProtos.Column.Builder columnBuilder = ClientProtos.Column.newBuilder();
        columnBuilder.setFamily(ByteString.copyFrom((byte[])family));
        ClientProtos.Get.Builder getBuilder = ClientProtos.Get.newBuilder();
        getBuilder.setRow(ByteString.copyFrom((byte[])row));
        getBuilder.addColumn(columnBuilder.build());
        builder.setGet(getBuilder.build());
        return builder.build();
    }

    public static ClientProtos.GetRequest buildGetRequest(byte[] regionName, Get get) throws IOException {
        return RequestConverter.buildGetRequest(regionName, get, false);
    }

    public static ClientProtos.GetRequest buildGetRequest(byte[] regionName, Get get, boolean existenceOnly) throws IOException {
        ClientProtos.GetRequest.Builder builder = ClientProtos.GetRequest.newBuilder();
        HBaseProtos.RegionSpecifier region = RequestConverter.buildRegionSpecifier(HBaseProtos.RegionSpecifier.RegionSpecifierType.REGION_NAME, regionName);
        builder.setExistenceOnly(existenceOnly);
        builder.setRegion(region);
        builder.setGet(ProtobufUtil.toGet(get));
        return builder.build();
    }

    public static ClientProtos.MultiGetRequest buildMultiGetRequest(byte[] regionName, List<Get> gets, boolean existenceOnly, boolean closestRowBefore) throws IOException {
        ClientProtos.MultiGetRequest.Builder builder = ClientProtos.MultiGetRequest.newBuilder();
        HBaseProtos.RegionSpecifier region = RequestConverter.buildRegionSpecifier(HBaseProtos.RegionSpecifier.RegionSpecifierType.REGION_NAME, regionName);
        builder.setExistenceOnly(existenceOnly);
        builder.setClosestRowBefore(closestRowBefore);
        builder.setRegion(region);
        for (Get get : gets) {
            builder.addGet(ProtobufUtil.toGet(get));
        }
        return builder.build();
    }

    public static ClientProtos.MutateRequest buildMutateRequest(byte[] regionName, byte[] row, byte[] family, byte[] qualifier, long amount, Durability durability) {
        ClientProtos.MutateRequest.Builder builder = ClientProtos.MutateRequest.newBuilder();
        HBaseProtos.RegionSpecifier region = RequestConverter.buildRegionSpecifier(HBaseProtos.RegionSpecifier.RegionSpecifierType.REGION_NAME, regionName);
        builder.setRegion(region);
        ClientProtos.MutationProto.Builder mutateBuilder = ClientProtos.MutationProto.newBuilder();
        mutateBuilder.setRow(ByteString.copyFrom((byte[])row));
        mutateBuilder.setMutateType(ClientProtos.MutationProto.MutationType.INCREMENT);
        mutateBuilder.setDurability(ProtobufUtil.toDurability(durability));
        ClientProtos.MutationProto.ColumnValue.Builder columnBuilder = ClientProtos.MutationProto.ColumnValue.newBuilder();
        columnBuilder.setFamily(ByteString.copyFrom((byte[])family));
        ClientProtos.MutationProto.ColumnValue.QualifierValue.Builder valueBuilder = ClientProtos.MutationProto.ColumnValue.QualifierValue.newBuilder();
        valueBuilder.setValue(ByteString.copyFrom((byte[])Bytes.toBytes((long)amount)));
        valueBuilder.setQualifier(ByteString.copyFrom((byte[])qualifier));
        columnBuilder.addQualifierValue(valueBuilder.build());
        mutateBuilder.addColumnValue(columnBuilder.build());
        builder.setMutation(mutateBuilder.build());
        return builder.build();
    }

    public static ClientProtos.MutateRequest buildMutateRequest(byte[] regionName, byte[] row, byte[] family, byte[] qualifier, ByteArrayComparable comparator, HBaseProtos.CompareType compareType, Put put) throws IOException {
        ClientProtos.MutateRequest.Builder builder = ClientProtos.MutateRequest.newBuilder();
        HBaseProtos.RegionSpecifier region = RequestConverter.buildRegionSpecifier(HBaseProtos.RegionSpecifier.RegionSpecifierType.REGION_NAME, regionName);
        builder.setRegion(region);
        ClientProtos.Condition condition = RequestConverter.buildCondition(row, family, qualifier, comparator, compareType);
        builder.setMutation(ProtobufUtil.toMutation(ClientProtos.MutationProto.MutationType.PUT, put));
        builder.setCondition(condition);
        return builder.build();
    }

    public static ClientProtos.MutateRequest buildMutateRequest(byte[] regionName, byte[] row, byte[] family, byte[] qualifier, ByteArrayComparable comparator, HBaseProtos.CompareType compareType, Delete delete) throws IOException {
        ClientProtos.MutateRequest.Builder builder = ClientProtos.MutateRequest.newBuilder();
        HBaseProtos.RegionSpecifier region = RequestConverter.buildRegionSpecifier(HBaseProtos.RegionSpecifier.RegionSpecifierType.REGION_NAME, regionName);
        builder.setRegion(region);
        ClientProtos.Condition condition = RequestConverter.buildCondition(row, family, qualifier, comparator, compareType);
        builder.setMutation(ProtobufUtil.toMutation(ClientProtos.MutationProto.MutationType.DELETE, delete));
        builder.setCondition(condition);
        return builder.build();
    }

    public static ClientProtos.MutateRequest buildMutateRequest(byte[] regionName, Put put) throws IOException {
        ClientProtos.MutateRequest.Builder builder = ClientProtos.MutateRequest.newBuilder();
        HBaseProtos.RegionSpecifier region = RequestConverter.buildRegionSpecifier(HBaseProtos.RegionSpecifier.RegionSpecifierType.REGION_NAME, regionName);
        builder.setRegion(region);
        builder.setMutation(ProtobufUtil.toMutation(ClientProtos.MutationProto.MutationType.PUT, put));
        return builder.build();
    }

    public static ClientProtos.MutateRequest buildMutateRequest(byte[] regionName, Append append) throws IOException {
        ClientProtos.MutateRequest.Builder builder = ClientProtos.MutateRequest.newBuilder();
        HBaseProtos.RegionSpecifier region = RequestConverter.buildRegionSpecifier(HBaseProtos.RegionSpecifier.RegionSpecifierType.REGION_NAME, regionName);
        builder.setRegion(region);
        builder.setMutation(ProtobufUtil.toMutation(ClientProtos.MutationProto.MutationType.APPEND, append));
        return builder.build();
    }

    public static ClientProtos.MutateRequest buildMutateRequest(byte[] regionName, Increment increment) {
        ClientProtos.MutateRequest.Builder builder = ClientProtos.MutateRequest.newBuilder();
        HBaseProtos.RegionSpecifier region = RequestConverter.buildRegionSpecifier(HBaseProtos.RegionSpecifier.RegionSpecifierType.REGION_NAME, regionName);
        builder.setRegion(region);
        builder.setMutation(ProtobufUtil.toMutation(increment));
        return builder.build();
    }

    public static ClientProtos.MutateRequest buildMutateRequest(byte[] regionName, Delete delete) throws IOException {
        ClientProtos.MutateRequest.Builder builder = ClientProtos.MutateRequest.newBuilder();
        HBaseProtos.RegionSpecifier region = RequestConverter.buildRegionSpecifier(HBaseProtos.RegionSpecifier.RegionSpecifierType.REGION_NAME, regionName);
        builder.setRegion(region);
        builder.setMutation(ProtobufUtil.toMutation(ClientProtos.MutationProto.MutationType.DELETE, delete));
        return builder.build();
    }

    public static ClientProtos.MultiRequest buildMultiRequest(byte[] regionName, RowMutations rowMutations) throws IOException {
        ClientProtos.MultiRequest.Builder builder = RequestConverter.getMultiRequestBuilderWithRegionAndAtomicSet(regionName, true);
        for (Mutation mutation : rowMutations.getMutations()) {
            ClientProtos.MutationProto.MutationType mutateType = null;
            if (mutation instanceof Put) {
                mutateType = ClientProtos.MutationProto.MutationType.PUT;
            } else if (mutation instanceof Delete) {
                mutateType = ClientProtos.MutationProto.MutationType.DELETE;
            } else {
                throw new DoNotRetryIOException("RowMutations supports only put and delete, not " + mutation.getClass().getName());
            }
            ClientProtos.MutationProto mp = ProtobufUtil.toMutation(mutateType, mutation);
            builder.addAction(ClientProtos.MultiAction.newBuilder().setMutation(mp).build());
        }
        return builder.build();
    }

    public static ClientProtos.MultiRequest buildNoDataMultiRequest(byte[] regionName, RowMutations rowMutations, List<CellScannable> cells) throws IOException {
        ClientProtos.MultiRequest.Builder builder = RequestConverter.getMultiRequestBuilderWithRegionAndAtomicSet(regionName, true);
        for (Mutation mutation : rowMutations.getMutations()) {
            ClientProtos.MutationProto.MutationType type = null;
            if (mutation instanceof Put) {
                type = ClientProtos.MutationProto.MutationType.PUT;
            } else if (mutation instanceof Delete) {
                type = ClientProtos.MutationProto.MutationType.DELETE;
            } else {
                throw new DoNotRetryIOException("RowMutations supports only put and delete, not " + mutation.getClass().getName());
            }
            ClientProtos.MutationProto mp = ProtobufUtil.toMutationNoData(type, mutation);
            cells.add(mutation);
            builder.addAction(ClientProtos.MultiAction.newBuilder().setMutation(mp).build());
        }
        return builder.build();
    }

    private static ClientProtos.MultiRequest.Builder getMultiRequestBuilderWithRegionAndAtomicSet(byte[] regionName, boolean atomic) {
        ClientProtos.MultiRequest.Builder builder = ClientProtos.MultiRequest.newBuilder();
        HBaseProtos.RegionSpecifier region = RequestConverter.buildRegionSpecifier(HBaseProtos.RegionSpecifier.RegionSpecifierType.REGION_NAME, regionName);
        builder.setRegion(region);
        return builder.setAtomic(atomic);
    }

    public static ClientProtos.ScanRequest buildScanRequest(byte[] regionName, Scan scan, int numberOfRows, boolean closeScanner) throws IOException {
        ClientProtos.ScanRequest.Builder builder = ClientProtos.ScanRequest.newBuilder();
        HBaseProtos.RegionSpecifier region = RequestConverter.buildRegionSpecifier(HBaseProtos.RegionSpecifier.RegionSpecifierType.REGION_NAME, regionName);
        builder.setNumberOfRows(numberOfRows);
        builder.setCloseScanner(closeScanner);
        builder.setRegion(region);
        builder.setScan(ProtobufUtil.toScan(scan));
        return builder.build();
    }

    public static ClientProtos.ScanRequest buildScanRequest(long scannerId, int numberOfRows, boolean closeScanner) {
        ClientProtos.ScanRequest.Builder builder = ClientProtos.ScanRequest.newBuilder();
        builder.setNumberOfRows(numberOfRows);
        builder.setCloseScanner(closeScanner);
        builder.setScannerId(scannerId);
        return builder.build();
    }

    public static ClientProtos.ScanRequest buildScanRequest(long scannerId, int numberOfRows, boolean closeScanner, long nextCallSeq) {
        ClientProtos.ScanRequest.Builder builder = ClientProtos.ScanRequest.newBuilder();
        builder.setNumberOfRows(numberOfRows);
        builder.setCloseScanner(closeScanner);
        builder.setScannerId(scannerId);
        builder.setNextCallSeq(nextCallSeq);
        return builder.build();
    }

    public static ClientProtos.BulkLoadHFileRequest buildBulkLoadHFileRequest(List<Pair<byte[], String>> familyPaths, byte[] regionName, boolean assignSeqNum) {
        ClientProtos.BulkLoadHFileRequest.Builder builder = ClientProtos.BulkLoadHFileRequest.newBuilder();
        HBaseProtos.RegionSpecifier region = RequestConverter.buildRegionSpecifier(HBaseProtos.RegionSpecifier.RegionSpecifierType.REGION_NAME, regionName);
        builder.setRegion(region);
        ClientProtos.BulkLoadHFileRequest.FamilyPath.Builder familyPathBuilder = ClientProtos.BulkLoadHFileRequest.FamilyPath.newBuilder();
        for (Pair<byte[], String> familyPath : familyPaths) {
            familyPathBuilder.setFamily(ByteString.copyFrom((byte[])((byte[])familyPath.getFirst())));
            familyPathBuilder.setPath((String)familyPath.getSecond());
            builder.addFamilyPath(familyPathBuilder.build());
        }
        builder.setAssignSeqNum(assignSeqNum);
        return builder.build();
    }

    public static <R> ClientProtos.MultiRequest buildMultiRequest(byte[] regionName, List<Action<R>> actions) throws IOException {
        ClientProtos.MultiRequest.Builder builder = RequestConverter.getMultiRequestBuilderWithRegionAndAtomicSet(regionName, false);
        for (Action<R> action : actions) {
            ClientProtos.MultiAction.Builder protoAction = ClientProtos.MultiAction.newBuilder();
            Row row = action.getAction();
            if (row instanceof Get) {
                protoAction.setGet(ProtobufUtil.toGet((Get)row));
            } else if (row instanceof Put) {
                protoAction.setMutation(ProtobufUtil.toMutation(ClientProtos.MutationProto.MutationType.PUT, (Put)row));
            } else if (row instanceof Delete) {
                protoAction.setMutation(ProtobufUtil.toMutation(ClientProtos.MutationProto.MutationType.DELETE, (Delete)row));
            } else if (row instanceof Append) {
                protoAction.setMutation(ProtobufUtil.toMutation(ClientProtos.MutationProto.MutationType.APPEND, (Append)row));
            } else if (row instanceof Increment) {
                protoAction.setMutation(ProtobufUtil.toMutation((Increment)row));
            } else {
                if (row instanceof RowMutations) continue;
                throw new DoNotRetryIOException("multi doesn't support " + row.getClass().getName());
            }
            builder.addAction(protoAction.build());
        }
        return builder.build();
    }

    public static <R> ClientProtos.MultiRequest buildNoDataMultiRequest(byte[] regionName, List<Action<R>> actions, List<CellScannable> cells) throws IOException {
        ClientProtos.MultiRequest.Builder builder = RequestConverter.getMultiRequestBuilderWithRegionAndAtomicSet(regionName, false);
        for (Action<R> action : actions) {
            ClientProtos.MultiAction.Builder protoAction = ClientProtos.MultiAction.newBuilder();
            Row row = action.getAction();
            if (row instanceof Get) {
                protoAction.setGet(ProtobufUtil.toGet((Get)row));
            } else if (row instanceof Put) {
                Put p = (Put)row;
                cells.add(p);
                protoAction.setMutation(ProtobufUtil.toMutationNoData(ClientProtos.MutationProto.MutationType.PUT, p));
            } else if (row instanceof Delete) {
                Delete d = (Delete)row;
                int size = d.size();
                if (size > 0) {
                    cells.add(d);
                    protoAction.setMutation(ProtobufUtil.toMutationNoData(ClientProtos.MutationProto.MutationType.DELETE, d));
                } else {
                    protoAction.setMutation(ProtobufUtil.toMutation(ClientProtos.MutationProto.MutationType.DELETE, d));
                }
            } else if (row instanceof Append) {
                Append a = (Append)row;
                cells.add(a);
                protoAction.setMutation(ProtobufUtil.toMutationNoData(ClientProtos.MutationProto.MutationType.APPEND, a));
            } else if (row instanceof Increment) {
                Increment i = (Increment)row;
                cells.add(i);
                protoAction.setMutation(ProtobufUtil.toMutationNoData(ClientProtos.MutationProto.MutationType.INCREMENT, i));
            } else {
                if (row instanceof RowMutations) continue;
                throw new DoNotRetryIOException("Multi doesn't support " + row.getClass().getName());
            }
            builder.addAction(protoAction.build());
        }
        return builder.build();
    }

    public static AdminProtos.GetRegionInfoRequest buildGetRegionInfoRequest(byte[] regionName) {
        return RequestConverter.buildGetRegionInfoRequest(regionName, false);
    }

    public static AdminProtos.GetRegionInfoRequest buildGetRegionInfoRequest(byte[] regionName, boolean includeCompactionState) {
        AdminProtos.GetRegionInfoRequest.Builder builder = AdminProtos.GetRegionInfoRequest.newBuilder();
        HBaseProtos.RegionSpecifier region = RequestConverter.buildRegionSpecifier(HBaseProtos.RegionSpecifier.RegionSpecifierType.REGION_NAME, regionName);
        builder.setRegion(region);
        if (includeCompactionState) {
            builder.setCompactionState(includeCompactionState);
        }
        return builder.build();
    }

    public static AdminProtos.GetStoreFileRequest buildGetStoreFileRequest(byte[] regionName, byte[] family) {
        AdminProtos.GetStoreFileRequest.Builder builder = AdminProtos.GetStoreFileRequest.newBuilder();
        HBaseProtos.RegionSpecifier region = RequestConverter.buildRegionSpecifier(HBaseProtos.RegionSpecifier.RegionSpecifierType.REGION_NAME, regionName);
        builder.setRegion(region);
        builder.addFamily(ByteString.copyFrom((byte[])family));
        return builder.build();
    }

    public static AdminProtos.GetOnlineRegionRequest buildGetOnlineRegionRequest() {
        return AdminProtos.GetOnlineRegionRequest.newBuilder().build();
    }

    public static AdminProtos.FlushRegionRequest buildFlushRegionRequest(byte[] regionName) {
        AdminProtos.FlushRegionRequest.Builder builder = AdminProtos.FlushRegionRequest.newBuilder();
        HBaseProtos.RegionSpecifier region = RequestConverter.buildRegionSpecifier(HBaseProtos.RegionSpecifier.RegionSpecifierType.REGION_NAME, regionName);
        builder.setRegion(region);
        return builder.build();
    }

    public static AdminProtos.OpenRegionRequest buildOpenRegionRequest(List<Triple<HRegionInfo, Integer, List<ServerName>>> regionOpenInfos) {
        AdminProtos.OpenRegionRequest.Builder builder = AdminProtos.OpenRegionRequest.newBuilder();
        for (Triple<HRegionInfo, Integer, List<ServerName>> regionOpenInfo : regionOpenInfos) {
            Integer second = (Integer)regionOpenInfo.getSecond();
            int versionOfOfflineNode = second == null ? -1 : second;
            builder.addOpenInfo(RequestConverter.buildRegionOpenInfo((HRegionInfo)regionOpenInfo.getFirst(), versionOfOfflineNode, (List)regionOpenInfo.getThird()));
        }
        return builder.build();
    }

    public static AdminProtos.OpenRegionRequest buildOpenRegionRequest(HRegionInfo region, int versionOfOfflineNode, List<ServerName> favoredNodes) {
        AdminProtos.OpenRegionRequest.Builder builder = AdminProtos.OpenRegionRequest.newBuilder();
        builder.addOpenInfo(RequestConverter.buildRegionOpenInfo(region, versionOfOfflineNode, favoredNodes));
        return builder.build();
    }

    public static AdminProtos.CloseRegionRequest buildCloseRegionRequest(byte[] regionName, boolean transitionInZK) {
        AdminProtos.CloseRegionRequest.Builder builder = AdminProtos.CloseRegionRequest.newBuilder();
        HBaseProtos.RegionSpecifier region = RequestConverter.buildRegionSpecifier(HBaseProtos.RegionSpecifier.RegionSpecifierType.REGION_NAME, regionName);
        builder.setRegion(region);
        builder.setTransitionInZK(transitionInZK);
        return builder.build();
    }

    public static AdminProtos.CloseRegionRequest buildCloseRegionRequest(byte[] regionName, int versionOfClosingNode, ServerName destinationServer, boolean transitionInZK) {
        AdminProtos.CloseRegionRequest.Builder builder = AdminProtos.CloseRegionRequest.newBuilder();
        HBaseProtos.RegionSpecifier region = RequestConverter.buildRegionSpecifier(HBaseProtos.RegionSpecifier.RegionSpecifierType.REGION_NAME, regionName);
        builder.setRegion(region);
        builder.setVersionOfClosingNode(versionOfClosingNode);
        builder.setTransitionInZK(transitionInZK);
        if (destinationServer != null) {
            builder.setDestinationServer(ProtobufUtil.toServerName(destinationServer));
        }
        return builder.build();
    }

    public static AdminProtos.CloseRegionRequest buildCloseRegionRequest(String encodedRegionName, boolean transitionInZK) {
        AdminProtos.CloseRegionRequest.Builder builder = AdminProtos.CloseRegionRequest.newBuilder();
        HBaseProtos.RegionSpecifier region = RequestConverter.buildRegionSpecifier(HBaseProtos.RegionSpecifier.RegionSpecifierType.ENCODED_REGION_NAME, Bytes.toBytes((String)encodedRegionName));
        builder.setRegion(region);
        builder.setTransitionInZK(transitionInZK);
        return builder.build();
    }

    public static AdminProtos.SplitRegionRequest buildSplitRegionRequest(byte[] regionName, byte[] splitPoint) {
        AdminProtos.SplitRegionRequest.Builder builder = AdminProtos.SplitRegionRequest.newBuilder();
        HBaseProtos.RegionSpecifier region = RequestConverter.buildRegionSpecifier(HBaseProtos.RegionSpecifier.RegionSpecifierType.REGION_NAME, regionName);
        builder.setRegion(region);
        if (splitPoint != null) {
            builder.setSplitPoint(ByteString.copyFrom((byte[])splitPoint));
        }
        return builder.build();
    }

    public static AdminProtos.MergeRegionsRequest buildMergeRegionsRequest(byte[] regionA, byte[] regionB, boolean forcible) {
        AdminProtos.MergeRegionsRequest.Builder builder = AdminProtos.MergeRegionsRequest.newBuilder();
        HBaseProtos.RegionSpecifier regionASpecifier = RequestConverter.buildRegionSpecifier(HBaseProtos.RegionSpecifier.RegionSpecifierType.REGION_NAME, regionA);
        HBaseProtos.RegionSpecifier regionBSpecifier = RequestConverter.buildRegionSpecifier(HBaseProtos.RegionSpecifier.RegionSpecifierType.REGION_NAME, regionB);
        builder.setRegionA(regionASpecifier);
        builder.setRegionB(regionBSpecifier);
        builder.setForcible(forcible);
        return builder.build();
    }

    public static AdminProtos.CompactRegionRequest buildCompactRegionRequest(byte[] regionName, boolean major, byte[] family) {
        AdminProtos.CompactRegionRequest.Builder builder = AdminProtos.CompactRegionRequest.newBuilder();
        HBaseProtos.RegionSpecifier region = RequestConverter.buildRegionSpecifier(HBaseProtos.RegionSpecifier.RegionSpecifierType.REGION_NAME, regionName);
        builder.setRegion(region);
        builder.setMajor(major);
        if (family != null) {
            builder.setFamily(ByteString.copyFrom((byte[])family));
        }
        return builder.build();
    }

    public static AdminProtos.RollWALWriterRequest buildRollWALWriterRequest() {
        AdminProtos.RollWALWriterRequest.Builder builder = AdminProtos.RollWALWriterRequest.newBuilder();
        return builder.build();
    }

    public static AdminProtos.GetServerInfoRequest buildGetServerInfoRequest() {
        AdminProtos.GetServerInfoRequest.Builder builder = AdminProtos.GetServerInfoRequest.newBuilder();
        return builder.build();
    }

    public static AdminProtos.StopServerRequest buildStopServerRequest(String reason) {
        AdminProtos.StopServerRequest.Builder builder = AdminProtos.StopServerRequest.newBuilder();
        builder.setReason(reason);
        return builder.build();
    }

    public static HBaseProtos.RegionSpecifier buildRegionSpecifier(HBaseProtos.RegionSpecifier.RegionSpecifierType type, byte[] value) {
        HBaseProtos.RegionSpecifier.Builder regionBuilder = HBaseProtos.RegionSpecifier.newBuilder();
        regionBuilder.setValue(ByteString.copyFrom((byte[])value));
        regionBuilder.setType(type);
        return regionBuilder.build();
    }

    private static ClientProtos.Condition buildCondition(byte[] row, byte[] family, byte[] qualifier, ByteArrayComparable comparator, HBaseProtos.CompareType compareType) throws IOException {
        ClientProtos.Condition.Builder builder = ClientProtos.Condition.newBuilder();
        builder.setRow(ByteString.copyFrom((byte[])row));
        builder.setFamily(ByteString.copyFrom((byte[])family));
        builder.setQualifier(ByteString.copyFrom((byte[])qualifier));
        builder.setComparator(ProtobufUtil.toComparator(comparator));
        builder.setCompareType(compareType);
        return builder.build();
    }

    public static MasterAdminProtos.AddColumnRequest buildAddColumnRequest(byte[] tableName, HColumnDescriptor column) {
        MasterAdminProtos.AddColumnRequest.Builder builder = MasterAdminProtos.AddColumnRequest.newBuilder();
        builder.setTableName(ByteString.copyFrom((byte[])tableName));
        builder.setColumnFamilies(column.convert());
        return builder.build();
    }

    public static MasterAdminProtos.DeleteColumnRequest buildDeleteColumnRequest(byte[] tableName, byte[] columnName) {
        MasterAdminProtos.DeleteColumnRequest.Builder builder = MasterAdminProtos.DeleteColumnRequest.newBuilder();
        builder.setTableName(ByteString.copyFrom((byte[])tableName));
        builder.setColumnName(ByteString.copyFrom((byte[])columnName));
        return builder.build();
    }

    public static MasterAdminProtos.ModifyColumnRequest buildModifyColumnRequest(byte[] tableName, HColumnDescriptor column) {
        MasterAdminProtos.ModifyColumnRequest.Builder builder = MasterAdminProtos.ModifyColumnRequest.newBuilder();
        builder.setTableName(ByteString.copyFrom((byte[])tableName));
        builder.setColumnFamilies(column.convert());
        return builder.build();
    }

    public static MasterAdminProtos.MoveRegionRequest buildMoveRegionRequest(byte[] encodedRegionName, byte[] destServerName) throws DeserializationException {
        MasterAdminProtos.MoveRegionRequest.Builder builder = MasterAdminProtos.MoveRegionRequest.newBuilder();
        builder.setRegion(RequestConverter.buildRegionSpecifier(HBaseProtos.RegionSpecifier.RegionSpecifierType.ENCODED_REGION_NAME, encodedRegionName));
        if (destServerName != null) {
            builder.setDestServerName(ProtobufUtil.toServerName(new ServerName(Bytes.toString((byte[])destServerName))));
        }
        return builder.build();
    }

    public static MasterAdminProtos.DispatchMergingRegionsRequest buildDispatchMergingRegionsRequest(byte[] encodedNameOfRegionA, byte[] encodedNameOfRegionB, boolean forcible) throws DeserializationException {
        MasterAdminProtos.DispatchMergingRegionsRequest.Builder builder = MasterAdminProtos.DispatchMergingRegionsRequest.newBuilder();
        builder.setRegionA(RequestConverter.buildRegionSpecifier(HBaseProtos.RegionSpecifier.RegionSpecifierType.ENCODED_REGION_NAME, encodedNameOfRegionA));
        builder.setRegionB(RequestConverter.buildRegionSpecifier(HBaseProtos.RegionSpecifier.RegionSpecifierType.ENCODED_REGION_NAME, encodedNameOfRegionB));
        builder.setForcible(forcible);
        return builder.build();
    }

    public static MasterAdminProtos.AssignRegionRequest buildAssignRegionRequest(byte[] regionName) {
        MasterAdminProtos.AssignRegionRequest.Builder builder = MasterAdminProtos.AssignRegionRequest.newBuilder();
        builder.setRegion(RequestConverter.buildRegionSpecifier(HBaseProtos.RegionSpecifier.RegionSpecifierType.REGION_NAME, regionName));
        return builder.build();
    }

    public static MasterAdminProtos.UnassignRegionRequest buildUnassignRegionRequest(byte[] regionName, boolean force) {
        MasterAdminProtos.UnassignRegionRequest.Builder builder = MasterAdminProtos.UnassignRegionRequest.newBuilder();
        builder.setRegion(RequestConverter.buildRegionSpecifier(HBaseProtos.RegionSpecifier.RegionSpecifierType.REGION_NAME, regionName));
        builder.setForce(force);
        return builder.build();
    }

    public static MasterAdminProtos.OfflineRegionRequest buildOfflineRegionRequest(byte[] regionName) {
        MasterAdminProtos.OfflineRegionRequest.Builder builder = MasterAdminProtos.OfflineRegionRequest.newBuilder();
        builder.setRegion(RequestConverter.buildRegionSpecifier(HBaseProtos.RegionSpecifier.RegionSpecifierType.REGION_NAME, regionName));
        return builder.build();
    }

    public static MasterAdminProtos.DeleteTableRequest buildDeleteTableRequest(byte[] tableName) {
        MasterAdminProtos.DeleteTableRequest.Builder builder = MasterAdminProtos.DeleteTableRequest.newBuilder();
        builder.setTableName(ByteString.copyFrom((byte[])tableName));
        return builder.build();
    }

    public static MasterAdminProtos.EnableTableRequest buildEnableTableRequest(byte[] tableName) {
        MasterAdminProtos.EnableTableRequest.Builder builder = MasterAdminProtos.EnableTableRequest.newBuilder();
        builder.setTableName(ByteString.copyFrom((byte[])tableName));
        return builder.build();
    }

    public static MasterAdminProtos.DisableTableRequest buildDisableTableRequest(byte[] tableName) {
        MasterAdminProtos.DisableTableRequest.Builder builder = MasterAdminProtos.DisableTableRequest.newBuilder();
        builder.setTableName(ByteString.copyFrom((byte[])tableName));
        return builder.build();
    }

    public static MasterAdminProtos.CreateTableRequest buildCreateTableRequest(HTableDescriptor hTableDesc, byte[][] splitKeys) {
        MasterAdminProtos.CreateTableRequest.Builder builder = MasterAdminProtos.CreateTableRequest.newBuilder();
        builder.setTableSchema(hTableDesc.convert());
        if (splitKeys != null) {
            for (byte[] splitKey : splitKeys) {
                builder.addSplitKeys(ByteString.copyFrom((byte[])splitKey));
            }
        }
        return builder.build();
    }

    public static MasterAdminProtos.ModifyTableRequest buildModifyTableRequest(byte[] table, HTableDescriptor hTableDesc) {
        MasterAdminProtos.ModifyTableRequest.Builder builder = MasterAdminProtos.ModifyTableRequest.newBuilder();
        builder.setTableName(ByteString.copyFrom((byte[])table));
        builder.setTableSchema(hTableDesc.convert());
        return builder.build();
    }

    public static MasterMonitorProtos.GetSchemaAlterStatusRequest buildGetSchemaAlterStatusRequest(byte[] tableName) {
        MasterMonitorProtos.GetSchemaAlterStatusRequest.Builder builder = MasterMonitorProtos.GetSchemaAlterStatusRequest.newBuilder();
        builder.setTableName(ByteString.copyFrom((byte[])tableName));
        return builder.build();
    }

    public static MasterMonitorProtos.GetTableDescriptorsRequest buildGetTableDescriptorsRequest(List<String> tableNames) {
        MasterMonitorProtos.GetTableDescriptorsRequest.Builder builder = MasterMonitorProtos.GetTableDescriptorsRequest.newBuilder();
        if (tableNames != null) {
            for (String str : tableNames) {
                builder.addTableNames(str);
            }
        }
        return builder.build();
    }

    public static MasterProtos.IsMasterRunningRequest buildIsMasterRunningRequest() {
        return MasterProtos.IsMasterRunningRequest.newBuilder().build();
    }

    public static MasterAdminProtos.BalanceRequest buildBalanceRequest() {
        return MasterAdminProtos.BalanceRequest.newBuilder().build();
    }

    public static MasterAdminProtos.SetBalancerRunningRequest buildSetBalancerRunningRequest(boolean on, boolean synchronous) {
        return MasterAdminProtos.SetBalancerRunningRequest.newBuilder().setOn(on).setSynchronous(synchronous).build();
    }

    public static MasterMonitorProtos.GetClusterStatusRequest buildGetClusterStatusRequest() {
        return MasterMonitorProtos.GetClusterStatusRequest.newBuilder().build();
    }

    public static MasterAdminProtos.CatalogScanRequest buildCatalogScanRequest() {
        return MasterAdminProtos.CatalogScanRequest.newBuilder().build();
    }

    public static MasterAdminProtos.EnableCatalogJanitorRequest buildEnableCatalogJanitorRequest(boolean enable) {
        return MasterAdminProtos.EnableCatalogJanitorRequest.newBuilder().setEnable(enable).build();
    }

    public static MasterAdminProtos.IsCatalogJanitorEnabledRequest buildIsCatalogJanitorEnabledRequest() {
        return MasterAdminProtos.IsCatalogJanitorEnabledRequest.newBuilder().build();
    }

    public static RegionServerStatusProtos.GetLastFlushedSequenceIdRequest buildGetLastFlushedSequenceIdRequest(byte[] regionName) {
        return RegionServerStatusProtos.GetLastFlushedSequenceIdRequest.newBuilder().setRegionName(ByteString.copyFrom((byte[])regionName)).build();
    }

    public static AccessControlProtos.GrantRequest buildGrantRequest(String username, byte[] table, byte[] family, byte[] qualifier, AccessControlProtos.Permission.Action ... actions) {
        AccessControlProtos.Permission.Builder permissionBuilder = AccessControlProtos.Permission.newBuilder();
        for (AccessControlProtos.Permission.Action a : actions) {
            permissionBuilder.addAction(a);
        }
        if (table != null) {
            permissionBuilder.setTable(ByteString.copyFrom((byte[])table));
        }
        if (family != null) {
            permissionBuilder.setFamily(ByteString.copyFrom((byte[])family));
        }
        if (qualifier != null) {
            permissionBuilder.setQualifier(ByteString.copyFrom((byte[])qualifier));
        }
        return AccessControlProtos.GrantRequest.newBuilder().setPermission(AccessControlProtos.UserPermission.newBuilder().setUser(ByteString.copyFromUtf8((String)username)).setPermission(permissionBuilder.build())).build();
    }

    public static AccessControlProtos.RevokeRequest buildRevokeRequest(String username, byte[] table, byte[] family, byte[] qualifier, AccessControlProtos.Permission.Action ... actions) {
        AccessControlProtos.Permission.Builder permissionBuilder = AccessControlProtos.Permission.newBuilder();
        for (AccessControlProtos.Permission.Action a : actions) {
            permissionBuilder.addAction(a);
        }
        if (table != null) {
            permissionBuilder.setTable(ByteString.copyFrom((byte[])table));
        }
        if (family != null) {
            permissionBuilder.setFamily(ByteString.copyFrom((byte[])family));
        }
        if (qualifier != null) {
            permissionBuilder.setQualifier(ByteString.copyFrom((byte[])qualifier));
        }
        return AccessControlProtos.RevokeRequest.newBuilder().setPermission(AccessControlProtos.UserPermission.newBuilder().setUser(ByteString.copyFromUtf8((String)username)).setPermission(permissionBuilder.build())).build();
    }

    private static AdminProtos.OpenRegionRequest.RegionOpenInfo buildRegionOpenInfo(HRegionInfo region, int versionOfOfflineNode, List<ServerName> favoredNodes) {
        AdminProtos.OpenRegionRequest.RegionOpenInfo.Builder builder = AdminProtos.OpenRegionRequest.RegionOpenInfo.newBuilder();
        builder.setRegion(HRegionInfo.convert(region));
        if (versionOfOfflineNode >= 0) {
            builder.setVersionOfOfflineNode(versionOfOfflineNode);
        }
        if (favoredNodes != null) {
            for (ServerName server : favoredNodes) {
                builder.addFavoredNodes(ProtobufUtil.toServerName(server));
            }
        }
        return builder.build();
    }
}

