/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.protobuf;

import com.google.protobuf.ByteString;
import com.google.protobuf.RpcController;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellScanner;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.exceptions.DoNotRetryIOException;
import org.apache.hadoop.hbase.ipc.ServerRpcController;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.generated.AccessControlProtos;
import org.apache.hadoop.hbase.protobuf.generated.AdminProtos;
import org.apache.hadoop.hbase.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.protobuf.generated.MasterAdminProtos;
import org.apache.hadoop.hbase.protobuf.generated.RegionServerStatusProtos;
import org.apache.hadoop.hbase.regionserver.RegionOpeningState;
import org.apache.hadoop.hbase.security.access.UserPermission;
import org.apache.hadoop.util.StringUtils;

@InterfaceAudience.Private
public final class ResponseConverter {
    public static final Log LOG = LogFactory.getLog(ResponseConverter.class);

    private ResponseConverter() {
    }

    public static List<Object> getResults(ClientProtos.MultiResponse proto, CellScanner cells) throws IOException {
        ArrayList<Object> results = new ArrayList<Object>();
        List resultList = proto.getResultList();
        int n = resultList.size();
        for (int i = 0; i < n; ++i) {
            ClientProtos.ActionResult result = (ClientProtos.ActionResult)resultList.get(i);
            if (result.hasException()) {
                results.add(ProtobufUtil.toException(result.getException()));
                continue;
            }
            if (result.hasValue()) {
                ClientProtos.Result value = result.getValue();
                results.add(ProtobufUtil.toResult(value, cells));
                continue;
            }
            results.add(new Result());
        }
        return results;
    }

    public static ClientProtos.ActionResult buildActionResult(Throwable t) {
        ClientProtos.ActionResult.Builder builder = ClientProtos.ActionResult.newBuilder();
        HBaseProtos.NameBytesPair.Builder parameterBuilder = HBaseProtos.NameBytesPair.newBuilder();
        parameterBuilder.setName(t.getClass().getName());
        parameterBuilder.setValue(ByteString.copyFromUtf8((String)StringUtils.stringifyException((Throwable)t)));
        builder.setException(parameterBuilder.build());
        return builder.build();
    }

    public static AccessControlProtos.UserPermissionsResponse buildUserPermissionsResponse(List<UserPermission> permissions) {
        AccessControlProtos.UserPermissionsResponse.Builder builder = AccessControlProtos.UserPermissionsResponse.newBuilder();
        for (UserPermission perm : permissions) {
            builder.addPermission(ProtobufUtil.toUserPermission(perm));
        }
        return builder.build();
    }

    public static byte[][] getRegions(AdminProtos.RollWALWriterResponse proto) {
        if (proto == null || proto.getRegionToFlushCount() == 0) {
            return null;
        }
        ArrayList<byte[]> regions = new ArrayList<byte[]>();
        for (ByteString region : proto.getRegionToFlushList()) {
            regions.add(region.toByteArray());
        }
        return (byte[][])regions.toArray();
    }

    public static List<HRegionInfo> getRegionInfos(AdminProtos.GetOnlineRegionResponse proto) {
        if (proto == null || proto.getRegionInfoCount() == 0) {
            return null;
        }
        return ProtobufUtil.getRegionInfos(proto);
    }

    public static RegionOpeningState getRegionOpeningState(AdminProtos.OpenRegionResponse proto) {
        if (proto == null || proto.getOpeningStateCount() != 1) {
            return null;
        }
        return RegionOpeningState.valueOf(proto.getOpeningState(0).name());
    }

    public static List<RegionOpeningState> getRegionOpeningStateList(AdminProtos.OpenRegionResponse proto) {
        if (proto == null) {
            return null;
        }
        ArrayList<RegionOpeningState> regionOpeningStates = new ArrayList<RegionOpeningState>();
        for (int i = 0; i < proto.getOpeningStateCount(); ++i) {
            regionOpeningStates.add(RegionOpeningState.valueOf(proto.getOpeningState(i).name()));
        }
        return regionOpeningStates;
    }

    public static boolean isClosed(AdminProtos.CloseRegionResponse proto) {
        if (proto == null || !proto.hasClosed()) {
            return false;
        }
        return proto.getClosed();
    }

    public static AdminProtos.GetServerInfoResponse buildGetServerInfoResponse(ServerName serverName, int webuiPort) {
        AdminProtos.GetServerInfoResponse.Builder builder = AdminProtos.GetServerInfoResponse.newBuilder();
        AdminProtos.ServerInfo.Builder serverInfoBuilder = AdminProtos.ServerInfo.newBuilder();
        serverInfoBuilder.setServerName(ProtobufUtil.toServerName(serverName));
        if (webuiPort >= 0) {
            serverInfoBuilder.setWebuiPort(webuiPort);
        }
        builder.setServerInfo(serverInfoBuilder.build());
        return builder.build();
    }

    public static AdminProtos.GetOnlineRegionResponse buildGetOnlineRegionResponse(List<HRegionInfo> regions) {
        AdminProtos.GetOnlineRegionResponse.Builder builder = AdminProtos.GetOnlineRegionResponse.newBuilder();
        for (HRegionInfo region : regions) {
            builder.addRegionInfo(HRegionInfo.convert(region));
        }
        return builder.build();
    }

    public static MasterAdminProtos.CatalogScanResponse buildCatalogScanResponse(int numCleaned) {
        return MasterAdminProtos.CatalogScanResponse.newBuilder().setScanResult(numCleaned).build();
    }

    public static MasterAdminProtos.EnableCatalogJanitorResponse buildEnableCatalogJanitorResponse(boolean prevValue) {
        return MasterAdminProtos.EnableCatalogJanitorResponse.newBuilder().setPrevValue(prevValue).build();
    }

    public static RegionServerStatusProtos.GetLastFlushedSequenceIdResponse buildGetLastFlushedSequenceIdResponse(long seqId) {
        return RegionServerStatusProtos.GetLastFlushedSequenceIdResponse.newBuilder().setLastFlushedSequenceId(seqId).build();
    }

    public static void setControllerException(RpcController controller, IOException ioe) {
        if (controller != null) {
            if (controller instanceof ServerRpcController) {
                ((ServerRpcController)controller).setFailedOn(ioe);
            } else {
                controller.setFailed(StringUtils.stringifyException((Throwable)ioe));
            }
        }
    }

    public static Result[] getResults(CellScanner cellScanner, ClientProtos.ScanResponse response) throws IOException {
        if (response == null || cellScanner == null) {
            return null;
        }
        ClientProtos.ResultCellMeta resultCellMeta = response.getResultCellMeta();
        if (resultCellMeta == null) {
            return null;
        }
        int noOfResults = resultCellMeta.getCellsLengthCount();
        Result[] results = new Result[noOfResults];
        for (int i = 0; i < noOfResults; ++i) {
            int noOfCells = resultCellMeta.getCellsLength(i);
            ArrayList<Cell> cells = new ArrayList<Cell>(noOfCells);
            for (int j = 0; j < noOfCells; ++j) {
                try {
                    if (!cellScanner.advance()) {
                        String msg = "Results sent from server=" + noOfResults + ". But only got " + i + " results completely at client. Resetting the scanner to scan again.";
                        LOG.error((Object)msg);
                        throw new DoNotRetryIOException(msg);
                    }
                }
                catch (IOException ioe) {
                    LOG.error((Object)"Exception while reading cells from result.Resetting the scanner to scan again.", (Throwable)ioe);
                    throw new DoNotRetryIOException("Resetting the scanner.", ioe);
                }
                cells.add(cellScanner.current());
            }
            results[i] = new Result(cells);
        }
        return results;
    }
}

