/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication;

import java.util.ArrayList;
import java.util.List;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.generated.ZooKeeperProtos;
import org.apache.hadoop.hbase.replication.ReplicationQueueInfo;
import org.apache.hadoop.hbase.replication.ReplicationQueues;
import org.apache.hadoop.hbase.replication.ReplicationStateZKBase;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.zookeeper.KeeperException;

public class ReplicationQueuesZKImpl
extends ReplicationStateZKBase
implements ReplicationQueues {
    private String myQueuesZnode;
    private static final String RS_LOCK_ZNODE = "lock";
    private static final Log LOG = LogFactory.getLog(ReplicationQueuesZKImpl.class);

    public ReplicationQueuesZKImpl(ZooKeeperWatcher zk, Configuration conf, Abortable abortable) {
        super(zk, conf, abortable);
    }

    @Override
    public void init(String serverName) throws KeeperException {
        this.myQueuesZnode = ZKUtil.joinZNode(this.queuesZNode, serverName);
        ZKUtil.createWithParents(this.zookeeper, this.myQueuesZnode);
    }

    @Override
    public void removeQueue(String queueId) {
        try {
            ZKUtil.deleteNodeRecursively(this.zookeeper, ZKUtil.joinZNode(this.myQueuesZnode, queueId));
        }
        catch (KeeperException e) {
            this.abortable.abort("Failed to delete queue (queueId=" + queueId + ")", e);
        }
    }

    @Override
    public void addLog(String queueId, String filename) throws KeeperException {
        String znode = ZKUtil.joinZNode(this.myQueuesZnode, queueId);
        znode = ZKUtil.joinZNode(znode, filename);
        ZKUtil.createWithParents(this.zookeeper, znode);
    }

    @Override
    public void removeLog(String queueId, String filename) {
        try {
            String znode = ZKUtil.joinZNode(this.myQueuesZnode, queueId);
            znode = ZKUtil.joinZNode(znode, filename);
            ZKUtil.deleteNode(this.zookeeper, znode);
        }
        catch (KeeperException e) {
            this.abortable.abort("Failed to remove hlog from queue (queueId=" + queueId + ", filename=" + filename + ")", e);
        }
    }

    @Override
    public void setLogPosition(String queueId, String filename, long position) {
        try {
            String znode = ZKUtil.joinZNode(this.myQueuesZnode, queueId);
            znode = ZKUtil.joinZNode(znode, filename);
            ZKUtil.setData(this.zookeeper, znode, ZKUtil.positionToByteArray(position));
        }
        catch (KeeperException e) {
            this.abortable.abort("Failed to write replication hlog position (filename=" + filename + ", position=" + position + ")", e);
        }
    }

    @Override
    public long getLogPosition(String queueId, String filename) throws KeeperException {
        String clusterZnode = ZKUtil.joinZNode(this.myQueuesZnode, queueId);
        String znode = ZKUtil.joinZNode(clusterZnode, filename);
        byte[] bytes = ZKUtil.getData(this.zookeeper, znode);
        try {
            return ZKUtil.parseHLogPositionFrom(bytes);
        }
        catch (DeserializationException de) {
            LOG.warn((Object)("Failed to parse HLogPosition for queueId=" + queueId + " and hlog=" + filename + "znode content, continuing."));
            return 0L;
        }
    }

    @Override
    public SortedMap<String, SortedSet<String>> claimQueues(String regionserverZnode) {
        SortedMap<String, SortedSet<String>> newQueues = new TreeMap<String, SortedSet<String>>();
        if (ZKUtil.joinZNode(this.queuesZNode, regionserverZnode).equals(this.myQueuesZnode)) {
            LOG.warn((Object)("An attempt was made to claim our own queues on region server " + regionserverZnode));
            return newQueues;
        }
        if (this.conf.getBoolean("hbase.zookeeper.useMulti", true)) {
            LOG.info((Object)("Atomically moving " + regionserverZnode + "'s hlogs to my queue"));
            newQueues = this.copyQueuesFromRSUsingMulti(regionserverZnode);
        } else {
            LOG.info((Object)("Moving " + regionserverZnode + "'s hlogs to my queue"));
            if (!this.lockOtherRS(regionserverZnode)) {
                return newQueues;
            }
            newQueues = this.copyQueuesFromRS(regionserverZnode);
            this.deleteAnotherRSQueues(regionserverZnode);
        }
        return newQueues;
    }

    @Override
    public void removeAllQueues() {
        try {
            ZKUtil.deleteNodeRecursively(this.zookeeper, this.myQueuesZnode);
        }
        catch (KeeperException e) {
            if (e instanceof KeeperException.SessionExpiredException) {
                return;
            }
            this.abortable.abort("Failed to delete replication queues for region server: " + this.myQueuesZnode, e);
        }
    }

    @Override
    public List<String> getLogsInQueue(String queueId) {
        String znode = ZKUtil.joinZNode(this.myQueuesZnode, queueId);
        List<String> result = null;
        try {
            result = ZKUtil.listChildrenNoWatch(this.zookeeper, znode);
        }
        catch (KeeperException e) {
            this.abortable.abort("Failed to get list of hlogs for queueId=" + queueId, e);
        }
        return result;
    }

    @Override
    public List<String> getAllQueues() {
        List<String> listOfQueues = null;
        try {
            listOfQueues = ZKUtil.listChildrenNoWatch(this.zookeeper, this.myQueuesZnode);
        }
        catch (KeeperException e) {
            this.abortable.abort("Failed to get a list of queues for region server: " + this.myQueuesZnode, e);
        }
        return listOfQueues;
    }

    private boolean lockOtherRS(String znode) {
        try {
            String parent = ZKUtil.joinZNode(this.queuesZNode, znode);
            if (parent.equals(this.myQueuesZnode)) {
                LOG.warn((Object)"Won't lock because this is us, we're dead!");
                return false;
            }
            String p = ZKUtil.joinZNode(parent, RS_LOCK_ZNODE);
            ZKUtil.createAndWatch(this.zookeeper, p, ReplicationQueuesZKImpl.lockToByteArray(this.myQueuesZnode));
        }
        catch (KeeperException e) {
            if (e instanceof KeeperException.NoNodeException || e instanceof KeeperException.NodeExistsException) {
                LOG.info((Object)("Won't transfer the queue, another RS took care of it because of: " + e.getMessage()));
            } else {
                LOG.info((Object)"Failed lock other rs", (Throwable)e);
            }
            return false;
        }
        return true;
    }

    private void deleteAnotherRSQueues(String regionserverZnode) {
        String fullpath = ZKUtil.joinZNode(this.queuesZNode, regionserverZnode);
        try {
            List<String> clusters = ZKUtil.listChildrenNoWatch(this.zookeeper, fullpath);
            for (String cluster : clusters) {
                if (cluster.equals(RS_LOCK_ZNODE)) continue;
                String fullClusterPath = ZKUtil.joinZNode(fullpath, cluster);
                ZKUtil.deleteNodeRecursively(this.zookeeper, fullClusterPath);
            }
            ZKUtil.deleteNodeRecursively(this.zookeeper, fullpath);
        }
        catch (KeeperException e) {
            if ((e instanceof KeeperException.NoNodeException || e instanceof KeeperException.NotEmptyException) && e.getPath().equals(fullpath)) {
                return;
            }
            this.abortable.abort("Failed to delete replication queues for region server: " + regionserverZnode, e);
        }
    }

    private SortedMap<String, SortedSet<String>> copyQueuesFromRSUsingMulti(String znode) {
        TreeMap<String, SortedSet<String>> queues = new TreeMap<String, SortedSet<String>>();
        String deadRSZnodePath = ZKUtil.joinZNode(this.queuesZNode, znode);
        List<String> peerIdsToProcess = null;
        ArrayList<ZKUtil.ZKUtilOp> listOfOps = new ArrayList<ZKUtil.ZKUtilOp>();
        try {
            peerIdsToProcess = ZKUtil.listChildrenNoWatch(this.zookeeper, deadRSZnodePath);
            if (peerIdsToProcess == null) {
                return queues;
            }
            for (String peerId : peerIdsToProcess) {
                ReplicationQueueInfo replicationQueueInfo = new ReplicationQueueInfo(peerId);
                if (!this.peerExists(replicationQueueInfo.getPeerId())) {
                    LOG.warn((Object)("Peer " + peerId + " didn't exist, skipping the replay"));
                    continue;
                }
                String newPeerId = peerId + "-" + znode;
                String newPeerZnode = ZKUtil.joinZNode(this.myQueuesZnode, newPeerId);
                String oldClusterZnode = ZKUtil.joinZNode(deadRSZnodePath, peerId);
                List<String> hlogs = ZKUtil.listChildrenNoWatch(this.zookeeper, oldClusterZnode);
                if (hlogs == null || hlogs.size() == 0) {
                    listOfOps.add(ZKUtil.ZKUtilOp.deleteNodeFailSilent(oldClusterZnode));
                    continue;
                }
                TreeSet<String> logQueue = new TreeSet<String>();
                queues.put(newPeerId, logQueue);
                ZKUtil.ZKUtilOp op = ZKUtil.ZKUtilOp.createAndFailSilent(newPeerZnode, HConstants.EMPTY_BYTE_ARRAY);
                listOfOps.add(op);
                for (String hlog : hlogs) {
                    String oldHlogZnode = ZKUtil.joinZNode(oldClusterZnode, hlog);
                    byte[] logOffset = ZKUtil.getData(this.zookeeper, oldHlogZnode);
                    LOG.debug((Object)("Creating " + hlog + " with data " + Bytes.toString((byte[])logOffset)));
                    String newLogZnode = ZKUtil.joinZNode(newPeerZnode, hlog);
                    listOfOps.add(ZKUtil.ZKUtilOp.createAndFailSilent(newLogZnode, logOffset));
                    listOfOps.add(ZKUtil.ZKUtilOp.deleteNodeFailSilent(oldHlogZnode));
                    logQueue.add(hlog);
                }
                listOfOps.add(ZKUtil.ZKUtilOp.deleteNodeFailSilent(oldClusterZnode));
            }
            listOfOps.add(ZKUtil.ZKUtilOp.deleteNodeFailSilent(deadRSZnodePath));
            LOG.debug((Object)(" The multi list size is: " + listOfOps.size()));
            ZKUtil.multiOrSequential(this.zookeeper, listOfOps, false);
            LOG.info((Object)"Atomically moved the dead regionserver logs. ");
        }
        catch (KeeperException e) {
            LOG.warn((Object)"Got exception in copyQueuesFromRSUsingMulti: ", (Throwable)e);
            queues.clear();
        }
        return queues;
    }

    private SortedMap<String, SortedSet<String>> copyQueuesFromRS(String znode) {
        TreeMap<String, SortedSet<String>> queues = new TreeMap<String, SortedSet<String>>();
        try {
            String nodePath = ZKUtil.joinZNode(this.queuesZNode, znode);
            List<String> clusters = ZKUtil.listChildrenNoWatch(this.zookeeper, nodePath);
            if (clusters == null || clusters.size() <= 1) {
                return queues;
            }
            clusters.remove(RS_LOCK_ZNODE);
            for (String cluster : clusters) {
                ReplicationQueueInfo replicationQueueInfo = new ReplicationQueueInfo(cluster);
                if (!this.peerExists(replicationQueueInfo.getPeerId())) {
                    LOG.warn((Object)("Peer " + cluster + " didn't exist, skipping the replay"));
                    continue;
                }
                String newCluster = cluster + "-" + znode;
                String newClusterZnode = ZKUtil.joinZNode(this.myQueuesZnode, newCluster);
                String clusterPath = ZKUtil.joinZNode(nodePath, cluster);
                List<String> hlogs = ZKUtil.listChildrenNoWatch(this.zookeeper, clusterPath);
                if (hlogs == null || hlogs.size() == 0) continue;
                ZKUtil.createNodeIfNotExistsAndWatch(this.zookeeper, newClusterZnode, HConstants.EMPTY_BYTE_ARRAY);
                TreeSet<String> logQueue = new TreeSet<String>();
                queues.put(newCluster, logQueue);
                for (String hlog : hlogs) {
                    String z = ZKUtil.joinZNode(clusterPath, hlog);
                    byte[] positionBytes = ZKUtil.getData(this.zookeeper, z);
                    long position = 0L;
                    try {
                        position = ZKUtil.parseHLogPositionFrom(positionBytes);
                    }
                    catch (DeserializationException e) {
                        LOG.warn((Object)("Failed parse of hlog position from the following znode: " + z + ", Exception: " + e));
                    }
                    LOG.debug((Object)("Creating " + hlog + " with data " + position));
                    String child = ZKUtil.joinZNode(newClusterZnode, hlog);
                    ZKUtil.createAndWatch(this.zookeeper, child, positionBytes);
                    logQueue.add(hlog);
                }
            }
        }
        catch (KeeperException e) {
            this.abortable.abort("Copy queues from rs", e);
        }
        return queues;
    }

    static byte[] lockToByteArray(String lockOwner) {
        byte[] bytes = ZooKeeperProtos.ReplicationLock.newBuilder().setLockOwner(lockOwner).build().toByteArray();
        return ProtobufUtil.prependPBMagic(bytes);
    }
}

