/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication;

import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.Server;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.replication.ReplicationPeers;
import org.apache.hadoop.hbase.replication.ReplicationPeersZKImpl;
import org.apache.hadoop.hbase.replication.ReplicationQueues;
import org.apache.hadoop.hbase.replication.ReplicationQueuesZKImpl;
import org.apache.hadoop.hbase.replication.ReplicationStateImpl;
import org.apache.hadoop.hbase.replication.ReplicationStateInterface;
import org.apache.hadoop.hbase.replication.ReplicationStateZKBase;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperListener;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.zookeeper.KeeperException;

@InterfaceAudience.Private
public class ReplicationZookeeper
extends ReplicationStateZKBase
implements Closeable {
    private static final Log LOG = LogFactory.getLog(ReplicationZookeeper.class);
    private final ZooKeeperWatcher zookeeper;
    private String peersZNode;
    private final Configuration conf;
    private Abortable abortable;
    private final ReplicationStateInterface replicationState;
    private final ReplicationPeers replicationPeers;
    private final ReplicationQueues replicationQueues;

    public ReplicationZookeeper(Abortable abortable, Configuration conf, ZooKeeperWatcher zk) throws KeeperException, IOException {
        super(zk, conf, abortable);
        this.conf = conf;
        this.zookeeper = zk;
        this.setZNodes(abortable);
        this.replicationState = new ReplicationStateImpl(this.zookeeper, conf, abortable);
        this.replicationState.init();
        this.replicationQueues = null;
        this.replicationPeers = new ReplicationPeersZKImpl(this.zookeeper, this.conf, abortable);
        this.replicationPeers.init();
    }

    public ReplicationZookeeper(Server server, AtomicBoolean replicating) throws IOException, KeeperException {
        super(server.getZooKeeper(), server.getConfiguration(), server);
        this.abortable = server;
        this.zookeeper = server.getZooKeeper();
        this.conf = server.getConfiguration();
        this.setZNodes(server);
        this.replicationState = new ReplicationStateImpl(this.zookeeper, this.conf, server, replicating);
        this.replicationState.init();
        this.replicationQueues = new ReplicationQueuesZKImpl(this.zookeeper, this.conf, server);
        this.replicationQueues.init(server.getServerName().toString());
        this.replicationPeers = new ReplicationPeersZKImpl(this.zookeeper, this.conf, server);
        this.replicationPeers.init();
    }

    private void setZNodes(Abortable abortable) throws KeeperException {
        String replicationZNodeName = this.conf.get("zookeeper.znode.replication", "replication");
        String peersZNodeName = this.conf.get("zookeeper.znode.replication.peers", "peers");
        String replicationZNode = ZKUtil.joinZNode(this.zookeeper.baseZNode, replicationZNodeName);
        this.peersZNode = ZKUtil.joinZNode(replicationZNode, peersZNodeName);
    }

    public List<String> listPeersIdsAndWatch() {
        return this.replicationPeers.getAllPeerIds();
    }

    public Map<String, String> listPeers() {
        return this.replicationPeers.getAllPeerClusterKeys();
    }

    public List<ServerName> getSlavesAddresses(String peerClusterId) {
        return this.replicationPeers.getRegionServersOfConnectedPeer(peerClusterId);
    }

    public boolean connectToPeer(String peerId) throws IOException, KeeperException {
        return this.replicationPeers.connectToPeer(peerId);
    }

    public void removePeer(String id) throws IOException {
        this.replicationPeers.removePeer(id);
    }

    public void addPeer(String id, String clusterKey) throws IOException {
        this.replicationPeers.addPeer(id, clusterKey);
    }

    public void enablePeer(String id) throws IOException {
        this.replicationPeers.enablePeer(id);
    }

    public void disablePeer(String id) throws IOException {
        this.replicationPeers.disablePeer(id);
    }

    public boolean getPeerEnabled(String id) {
        return this.replicationPeers.getStatusOfConnectedPeer(id);
    }

    public boolean getReplication() throws KeeperException {
        return this.replicationState.getState();
    }

    public void setReplication(boolean newState) throws KeeperException {
        this.replicationState.setState(newState);
    }

    public void addLogToList(String filename, String peerId) throws KeeperException {
        this.replicationQueues.addLog(peerId, filename);
    }

    public void removeLogFromList(String filename, String clusterId) {
        this.replicationQueues.removeLog(clusterId, filename);
    }

    public void writeReplicationStatus(String filename, String clusterId, long position) {
        this.replicationQueues.setLogPosition(clusterId, filename, position);
    }

    public List<String> getRegisteredRegionServers() {
        List<String> result = null;
        try {
            result = ZKUtil.listChildrenAndWatchThem(this.zookeeper, this.zookeeper.rsZNode);
        }
        catch (KeeperException e) {
            this.abortable.abort("Get list of registered region servers", e);
        }
        return result;
    }

    public SortedMap<String, SortedSet<String>> claimQueues(String regionserver) {
        return this.replicationQueues.claimQueues(regionserver);
    }

    public void deleteSource(String peerZnode, boolean closeConnection) {
        this.replicationQueues.removeQueue(peerZnode);
        if (closeConnection) {
            this.replicationPeers.disconnectFromPeer(peerZnode);
        }
    }

    public void deleteOwnRSZNode() {
        this.replicationQueues.removeAllQueues();
    }

    public long getHLogRepPosition(String peerId, String hlog) throws KeeperException {
        return this.replicationQueues.getLogPosition(peerId, hlog);
    }

    public UUID getPeerUUID(String peerId) {
        return this.replicationPeers.getPeerUUID(peerId);
    }

    public void registerRegionServerListener(ZooKeeperListener listener) {
        this.zookeeper.registerListener(listener);
    }

    public Set<String> getPeerClusters() {
        return this.replicationPeers.getConnectedPeers();
    }

    public boolean isPeerPath(String path) {
        return path.split("/").length == this.peersZNode.split("/").length + 1;
    }

    public static String getZNodeName(String fullPath) {
        String[] parts = fullPath.split("/");
        return parts.length > 0 ? parts[parts.length - 1] : "";
    }

    public ZooKeeperWatcher getZookeeperWatcher() {
        return this.zookeeper;
    }

    public String getPeersZNode() {
        return this.peersZNode;
    }

    @Override
    public void close() throws IOException {
        if (this.replicationState != null) {
            this.replicationState.close();
        }
    }
}

