/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security.access;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.security.access.Permission;
import org.apache.hadoop.hbase.util.Bytes;

public class TablePermission
extends Permission {
    private static Log LOG = LogFactory.getLog(TablePermission.class);
    private byte[] table;
    private byte[] family;
    private byte[] qualifier;

    public TablePermission() {
    }

    public TablePermission(byte[] table, byte[] family, Permission.Action ... assigned) {
        this(table, family, (byte[])null, assigned);
    }

    public TablePermission(byte[] table, byte[] family, byte[] qualifier, Permission.Action ... assigned) {
        super(assigned);
        this.table = table;
        this.family = family;
        this.qualifier = qualifier;
    }

    public TablePermission(byte[] table, byte[] family, byte[] qualifier, byte[] actionCodes) {
        super(actionCodes);
        this.table = table;
        this.family = family;
        this.qualifier = qualifier;
    }

    public boolean hasTable() {
        return this.table != null;
    }

    public byte[] getTable() {
        return this.table;
    }

    public boolean hasFamily() {
        return this.family != null;
    }

    public byte[] getFamily() {
        return this.family;
    }

    public boolean hasQualifier() {
        return this.qualifier != null;
    }

    public byte[] getQualifier() {
        return this.qualifier;
    }

    public boolean implies(byte[] table, byte[] family, byte[] qualifier, Permission.Action action) {
        if (!Bytes.equals((byte[])this.table, (byte[])table)) {
            return false;
        }
        if (!(this.family == null || family != null && Bytes.equals((byte[])this.family, (byte[])family))) {
            return false;
        }
        if (!(this.qualifier == null || qualifier != null && Bytes.equals((byte[])this.qualifier, (byte[])qualifier))) {
            return false;
        }
        return super.implies(action);
    }

    public boolean implies(byte[] table, KeyValue kv, Permission.Action action) {
        if (!Bytes.equals((byte[])this.table, (byte[])table)) {
            return false;
        }
        if (this.family != null && Bytes.compareTo((byte[])this.family, (int)0, (int)this.family.length, (byte[])kv.getBuffer(), (int)kv.getFamilyOffset(), (int)kv.getFamilyLength()) != 0) {
            return false;
        }
        if (this.qualifier != null && Bytes.compareTo((byte[])this.qualifier, (int)0, (int)this.qualifier.length, (byte[])kv.getBuffer(), (int)kv.getQualifierOffset(), (int)kv.getQualifierLength()) != 0) {
            return false;
        }
        return super.implies(action);
    }

    public boolean matchesFamily(byte[] table, byte[] family, Permission.Action action) {
        if (!Bytes.equals((byte[])this.table, (byte[])table)) {
            return false;
        }
        if (!(this.family == null || family != null && Bytes.equals((byte[])this.family, (byte[])family))) {
            return false;
        }
        return super.implies(action);
    }

    public boolean matchesFamilyQualifier(byte[] table, byte[] family, byte[] qualifier, Permission.Action action) {
        if (!this.matchesFamily(table, family, action)) {
            return false;
        }
        if (!(this.qualifier == null || qualifier != null && Bytes.equals((byte[])this.qualifier, (byte[])qualifier))) {
            return false;
        }
        return super.implies(action);
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof TablePermission)) {
            return false;
        }
        TablePermission other = (TablePermission)((Object)obj);
        if (!(Bytes.equals((byte[])this.table, (byte[])other.getTable()) && (this.family == null && other.getFamily() == null || Bytes.equals((byte[])this.family, (byte[])other.getFamily())) && (this.qualifier == null && other.getQualifier() == null || Bytes.equals((byte[])this.qualifier, (byte[])other.getQualifier())))) {
            return false;
        }
        return super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int prime = 37;
        int result = super.hashCode();
        if (this.table != null) {
            result = 37 * result + Bytes.hashCode((byte[])this.table);
        }
        if (this.family != null) {
            result = 37 * result + Bytes.hashCode((byte[])this.family);
        }
        if (this.qualifier != null) {
            result = 37 * result + Bytes.hashCode((byte[])this.qualifier);
        }
        return result;
    }

    @Override
    public String toString() {
        StringBuilder str = new StringBuilder("[TablePermission: ").append("table=").append(Bytes.toString((byte[])this.table)).append(", family=").append(Bytes.toString((byte[])this.family)).append(", qualifier=").append(Bytes.toString((byte[])this.qualifier)).append(", actions=");
        if (this.actions != null) {
            for (int i = 0; i < this.actions.length; ++i) {
                if (i > 0) {
                    str.append(",");
                }
                if (this.actions[i] != null) {
                    str.append(this.actions[i].toString());
                    continue;
                }
                str.append("NULL");
            }
        }
        str.append("]");
        return str.toString();
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        super.readFields(in);
        this.table = Bytes.readByteArray((DataInput)in);
        if (in.readBoolean()) {
            this.family = Bytes.readByteArray((DataInput)in);
        }
        if (in.readBoolean()) {
            this.qualifier = Bytes.readByteArray((DataInput)in);
        }
    }

    @Override
    public void write(DataOutput out) throws IOException {
        super.write(out);
        Bytes.writeByteArray((DataOutput)out, (byte[])this.table);
        out.writeBoolean(this.family != null);
        if (this.family != null) {
            Bytes.writeByteArray((DataOutput)out, (byte[])this.family);
        }
        out.writeBoolean(this.qualifier != null);
        if (this.qualifier != null) {
            Bytes.writeByteArray((DataOutput)out, (byte[])this.qualifier);
        }
    }
}

