/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security.access;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.security.access.Permission;
import org.apache.hadoop.hbase.security.access.TablePermission;
import org.apache.hadoop.hbase.util.Bytes;

public class UserPermission
extends TablePermission {
    private static Log LOG = LogFactory.getLog(UserPermission.class);
    private byte[] user;

    public UserPermission() {
    }

    public UserPermission(byte[] user, Permission.Action ... assigned) {
        super((byte[])null, (byte[])null, (byte[])null, assigned);
        this.user = user;
    }

    public UserPermission(byte[] user, byte[] actionCodes) {
        super(null, null, null, actionCodes);
        this.user = user;
    }

    public UserPermission(byte[] user, byte[] table, byte[] family, Permission.Action ... assigned) {
        super(table, family, assigned);
        this.user = user;
    }

    public UserPermission(byte[] user, byte[] table, byte[] family, byte[] qualifier, Permission.Action ... assigned) {
        super(table, family, qualifier, assigned);
        this.user = user;
    }

    public UserPermission(byte[] user, byte[] table, byte[] family, byte[] qualifier, byte[] actionCodes) {
        super(table, family, qualifier, actionCodes);
        this.user = user;
    }

    public byte[] getUser() {
        return this.user;
    }

    public boolean isGlobal() {
        byte[] tableName = this.getTable();
        return tableName == null || tableName.length == 0;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof UserPermission)) {
            return false;
        }
        UserPermission other = (UserPermission)((Object)obj);
        return Bytes.equals((byte[])this.user, (byte[])other.getUser()) && super.equals(obj);
    }

    @Override
    public int hashCode() {
        int prime = 37;
        int result = super.hashCode();
        if (this.user != null) {
            result = 37 * result + Bytes.hashCode((byte[])this.user);
        }
        return result;
    }

    @Override
    public String toString() {
        StringBuilder str = new StringBuilder("UserPermission: ").append("user=").append(Bytes.toString((byte[])this.user)).append(", ").append(super.toString());
        return str.toString();
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        super.readFields(in);
        this.user = Bytes.readByteArray((DataInput)in);
    }

    @Override
    public void write(DataOutput out) throws IOException {
        super.write(out);
        Bytes.writeByteArray((DataOutput)out, (byte[])this.user);
    }
}

