/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.zookeeper;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.exceptions.ZooKeeperConnectionException;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.hadoop.hbase.zookeeper.RecoverableZooKeeper;
import org.apache.hadoop.hbase.zookeeper.ZKConfig;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperListener;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.data.ACL;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class ZooKeeperWatcher
implements Watcher,
Abortable,
Closeable {
    private static final Log LOG = LogFactory.getLog(ZooKeeperWatcher.class);
    private String identifier;
    private String quorum;
    private RecoverableZooKeeper recoverableZooKeeper;
    protected Abortable abortable;
    private boolean aborted = false;
    private final List<ZooKeeperListener> listeners = new CopyOnWriteArrayList<ZooKeeperListener>();
    public CountDownLatch saslLatch = new CountDownLatch(1);
    public String baseZNode;
    public String metaServerZNode;
    public String rsZNode;
    public String drainingZNode;
    private String masterAddressZNode;
    public String backupMasterAddressesZNode;
    public String clusterStateZNode;
    public String assignmentZNode;
    public String tableZNode;
    public String clusterIdZNode;
    public String splitLogZNode;
    public String balancerZNode;
    public String tableLockZNode;
    public String recoveringRegionsZNode;
    public static final ArrayList<ACL> CREATOR_ALL_AND_WORLD_READABLE = new ArrayList<ACL>(){
        {
            this.add(new ACL(1, ZooDefs.Ids.ANYONE_ID_UNSAFE));
            this.add(new ACL(31, ZooDefs.Ids.AUTH_IDS));
        }
    };
    private final Configuration conf;
    private final Exception constructorCaller;

    public ZooKeeperWatcher(Configuration conf, String identifier, Abortable abortable) throws ZooKeeperConnectionException, IOException {
        this(conf, identifier, abortable, false);
    }

    public ZooKeeperWatcher(Configuration conf, String identifier, Abortable abortable, boolean canCreateBaseZNode) throws IOException, ZooKeeperConnectionException {
        this.conf = conf;
        try {
            throw new Exception("ZKW CONSTRUCTOR STACK TRACE FOR DEBUGGING");
        }
        catch (Exception e) {
            this.constructorCaller = e;
            this.quorum = ZKConfig.getZKQuorumServersString(conf);
            this.identifier = identifier;
            this.abortable = abortable;
            this.setNodeNames(conf);
            this.recoverableZooKeeper = ZKUtil.connect(conf, this.quorum, this, identifier);
            if (canCreateBaseZNode) {
                this.createBaseZNodes();
            }
            return;
        }
    }

    private void createBaseZNodes() throws ZooKeeperConnectionException {
        try {
            ZKUtil.createWithParents(this, this.baseZNode);
            ZKUtil.createAndFailSilent(this, this.assignmentZNode);
            ZKUtil.createAndFailSilent(this, this.rsZNode);
            ZKUtil.createAndFailSilent(this, this.drainingZNode);
            ZKUtil.createAndFailSilent(this, this.tableZNode);
            ZKUtil.createAndFailSilent(this, this.splitLogZNode);
            ZKUtil.createAndFailSilent(this, this.backupMasterAddressesZNode);
            ZKUtil.createAndFailSilent(this, this.tableLockZNode);
            ZKUtil.createAndFailSilent(this, this.recoveringRegionsZNode);
        }
        catch (KeeperException e) {
            throw new ZooKeeperConnectionException(this.prefix("Unexpected KeeperException creating base node"), (Exception)((Object)e));
        }
    }

    public String toString() {
        return this.identifier;
    }

    public String prefix(String str) {
        return this.toString() + " " + str;
    }

    private void setNodeNames(Configuration conf) {
        this.baseZNode = conf.get("zookeeper.znode.parent", "/hbase");
        this.metaServerZNode = ZKUtil.joinZNode(this.baseZNode, conf.get("zookeeper.znode.metaserver", "meta-region-server"));
        this.rsZNode = ZKUtil.joinZNode(this.baseZNode, conf.get("zookeeper.znode.rs", "rs"));
        this.drainingZNode = ZKUtil.joinZNode(this.baseZNode, conf.get("zookeeper.znode.draining.rs", "draining"));
        this.masterAddressZNode = ZKUtil.joinZNode(this.baseZNode, conf.get("zookeeper.znode.master", "master"));
        this.backupMasterAddressesZNode = ZKUtil.joinZNode(this.baseZNode, conf.get("zookeeper.znode.backup.masters", "backup-masters"));
        this.clusterStateZNode = ZKUtil.joinZNode(this.baseZNode, conf.get("zookeeper.znode.state", "running"));
        this.assignmentZNode = ZKUtil.joinZNode(this.baseZNode, conf.get("zookeeper.znode.unassigned", "region-in-transition"));
        this.tableZNode = ZKUtil.joinZNode(this.baseZNode, conf.get("zookeeper.znode.tableEnableDisable", "table"));
        this.clusterIdZNode = ZKUtil.joinZNode(this.baseZNode, conf.get("zookeeper.znode.clusterId", "hbaseid"));
        this.splitLogZNode = ZKUtil.joinZNode(this.baseZNode, conf.get("zookeeper.znode.splitlog", "splitlog"));
        this.balancerZNode = ZKUtil.joinZNode(this.baseZNode, conf.get("zookeeper.znode.balancer", "balancer"));
        this.tableLockZNode = ZKUtil.joinZNode(this.baseZNode, conf.get("zookeeper.znode.tableLock", "table-lock"));
        this.recoveringRegionsZNode = ZKUtil.joinZNode(this.baseZNode, conf.get("zookeeper.znode.recovering.regions", "recovering-regions"));
    }

    public void registerListener(ZooKeeperListener listener) {
        this.listeners.add(listener);
    }

    public void registerListenerFirst(ZooKeeperListener listener) {
        this.listeners.add(0, listener);
    }

    public void unregisterListener(ZooKeeperListener listener) {
        this.listeners.remove(listener);
    }

    public void unregisterAllListeners() {
        this.listeners.clear();
    }

    public List<ZooKeeperListener> getListeners() {
        return new ArrayList<ZooKeeperListener>(this.listeners);
    }

    public int getNumberOfListeners() {
        return this.listeners.size();
    }

    public RecoverableZooKeeper getRecoverableZooKeeper() {
        return this.recoverableZooKeeper;
    }

    public void reconnectAfterExpiration() throws IOException, InterruptedException {
        this.recoverableZooKeeper.reconnectAfterExpiration();
    }

    public String getQuorum() {
        return this.quorum;
    }

    public void process(WatchedEvent event) {
        LOG.debug((Object)this.prefix("Received ZooKeeper Event, type=" + event.getType() + ", " + "state=" + event.getState() + ", " + "path=" + event.getPath()));
        switch (event.getType()) {
            case None: {
                this.connectionEvent(event);
                break;
            }
            case NodeCreated: {
                for (ZooKeeperListener listener : this.listeners) {
                    listener.nodeCreated(event.getPath());
                }
                break;
            }
            case NodeDeleted: {
                for (ZooKeeperListener listener : this.listeners) {
                    listener.nodeDeleted(event.getPath());
                }
                break;
            }
            case NodeDataChanged: {
                for (ZooKeeperListener listener : this.listeners) {
                    listener.nodeDataChanged(event.getPath());
                }
                break;
            }
            case NodeChildrenChanged: {
                for (ZooKeeperListener listener : this.listeners) {
                    listener.nodeChildrenChanged(event.getPath());
                }
                break;
            }
        }
    }

    private void connectionEvent(WatchedEvent event) {
        switch (event.getState()) {
            case SyncConnected: {
                long finished = System.currentTimeMillis() + this.conf.getLong("hbase.zookeeper.watcher.sync.connected.wait", 2000L);
                while (System.currentTimeMillis() < finished) {
                    Threads.sleep((long)1L);
                    if (this.recoverableZooKeeper == null) continue;
                }
                if (this.recoverableZooKeeper == null) {
                    LOG.error((Object)"ZK is null on connection event -- see stack trace for the stack trace when constructor was called on this zkw", (Throwable)this.constructorCaller);
                    throw new NullPointerException("ZK is null");
                }
                this.identifier = this.identifier + "-0x" + Long.toHexString(this.recoverableZooKeeper.getSessionId());
                LOG.debug((Object)(this.identifier + " connected"));
                break;
            }
            case Disconnected: {
                LOG.debug((Object)this.prefix("Received Disconnected from ZooKeeper, ignoring"));
                break;
            }
            case Expired: {
                String msg = this.prefix(this.identifier + " received expired from " + "ZooKeeper, aborting");
                if (this.abortable == null) break;
                this.abortable.abort(msg, (Throwable)new KeeperException.SessionExpiredException());
                break;
            }
            case ConnectedReadOnly: {
                break;
            }
            default: {
                throw new IllegalStateException("Received event is not valid.");
            }
        }
    }

    public void sync(String path) {
        this.recoverableZooKeeper.sync(path, null, null);
    }

    public void keeperException(KeeperException ke) throws KeeperException {
        LOG.error((Object)this.prefix("Received unexpected KeeperException, re-throwing exception"), (Throwable)ke);
        throw ke;
    }

    public void interruptedException(InterruptedException ie) {
        LOG.debug((Object)this.prefix("Received InterruptedException, doing nothing here"), (Throwable)ie);
        Thread.currentThread().interrupt();
    }

    @Override
    public void close() {
        try {
            if (this.recoverableZooKeeper != null) {
                this.recoverableZooKeeper.close();
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public Configuration getConfiguration() {
        return this.conf;
    }

    @Override
    public void abort(String why, Throwable e) {
        if (this.abortable != null) {
            this.abortable.abort(why, e);
        } else {
            this.aborted = true;
        }
    }

    @Override
    public boolean isAborted() {
        return this.abortable == null ? this.aborted : this.abortable.isAborted();
    }

    public String getMasterAddressZNode() {
        return this.masterAddressZNode;
    }
}

