/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.net.ConnectException;
import java.net.SocketTimeoutException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.NotServingRegionException;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.ConnectionUtils;
import org.apache.hadoop.hbase.client.HConnection;
import org.apache.hadoop.hbase.client.RetriesExhaustedException;
import org.apache.hadoop.hbase.client.RetryingCallable;
import org.apache.hadoop.hbase.exceptions.RegionMovedException;
import org.apache.hadoop.hbase.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.util.Bytes;

@InterfaceAudience.Private
public abstract class RegionServerCallable<T>
implements RetryingCallable<T> {
    static final Log LOG = LogFactory.getLog(RegionServerCallable.class);
    private final HConnection connection;
    private final TableName tableName;
    private final byte[] row;
    private HRegionLocation location;
    private ClientProtos.ClientService.BlockingInterface stub;
    protected static final int MIN_WAIT_DEAD_SERVER = 10000;

    public RegionServerCallable(HConnection connection, TableName tableName, byte[] row) {
        this.connection = connection;
        this.tableName = tableName;
        this.row = row;
    }

    @Override
    public void prepare(boolean reload) throws IOException {
        this.location = this.connection.getRegionLocation(this.tableName, this.row, reload);
        if (this.location == null) {
            throw new IOException("Failed to find location, tableName=" + this.tableName + ", row=" + Bytes.toString((byte[])this.row) + ", reload=" + reload);
        }
        this.setStub(this.getConnection().getClient(this.getLocation().getServerName()));
    }

    HConnection getConnection() {
        return this.connection;
    }

    protected ClientProtos.ClientService.BlockingInterface getStub() {
        return this.stub;
    }

    void setStub(ClientProtos.ClientService.BlockingInterface stub) {
        this.stub = stub;
    }

    protected HRegionLocation getLocation() {
        return this.location;
    }

    protected void setLocation(HRegionLocation location) {
        this.location = location;
    }

    public TableName getTableName() {
        return this.tableName;
    }

    public byte[] getRow() {
        return this.row;
    }

    @Override
    public void throwable(Throwable t, boolean retrying) {
        if (t instanceof SocketTimeoutException || t instanceof ConnectException || t instanceof RetriesExhaustedException || this.location != null && this.getConnection().isDeadServer(this.location.getServerName())) {
            if (this.location != null) {
                this.getConnection().clearCaches(this.location.getServerName());
            }
        } else if (t instanceof RegionMovedException) {
            this.getConnection().updateCachedLocations(this.tableName, this.row, (Object)t, this.location);
        } else if (t instanceof NotServingRegionException && !retrying) {
            this.getConnection().deleteCachedRegionLocation(this.location);
        }
    }

    @Override
    public String getExceptionMessageAdditionalDetail() {
        return "row '" + Bytes.toString((byte[])this.row) + "' on table '" + this.tableName;
    }

    @Override
    public long sleep(long pause, int tries) {
        long sleep = ConnectionUtils.getPauseTime(pause, tries + 1);
        if (sleep < 10000L && (this.location == null || this.getConnection().isDeadServer(this.location.getServerName()))) {
            sleep = ConnectionUtils.addJitter(10000L, 0.1f);
        }
        return sleep;
    }

    public HRegionInfo getHRegionInfo() {
        if (this.location == null) {
            return null;
        }
        return this.location.getRegionInfo();
    }
}

