/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.ipc;

import com.google.common.annotations.VisibleForTesting;
import com.google.protobuf.BlockingRpcChannel;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.RpcController;
import com.google.protobuf.ServiceException;
import com.google.protobuf.TextFormat;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import javax.net.SocketFactory;
import javax.security.sasl.SaslException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.CellScanner;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.HBaseIOException;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.codec.Codec;
import org.apache.hadoop.hbase.codec.KeyValueCodec;
import org.apache.hadoop.hbase.ipc.FatalConnectionException;
import org.apache.hadoop.hbase.ipc.IPCUtil;
import org.apache.hadoop.hbase.ipc.PayloadCarryingRpcController;
import org.apache.hadoop.hbase.ipc.RemoteWithExtrasException;
import org.apache.hadoop.hbase.ipc.StoppedRpcClientException;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.generated.AuthenticationProtos;
import org.apache.hadoop.hbase.protobuf.generated.RPCProtos;
import org.apache.hadoop.hbase.protobuf.generated.TracingProtos;
import org.apache.hadoop.hbase.security.AuthMethod;
import org.apache.hadoop.hbase.security.HBaseSaslRpcClient;
import org.apache.hadoop.hbase.security.SecurityInfo;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.security.UserProvider;
import org.apache.hadoop.hbase.security.token.AuthenticationTokenSelector;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.util.PoolMap;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.net.SocketInputWrapper;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.security.token.TokenSelector;
import org.cloudera.htrace.Span;
import org.cloudera.htrace.Trace;

@InterfaceAudience.Private
public class RpcClient {
    public static final Log LOG = LogFactory.getLog((String)"org.apache.hadoop.ipc.RpcClient");
    protected final PoolMap<ConnectionId, Connection> connections;
    protected int counter;
    protected final AtomicBoolean running = new AtomicBoolean(true);
    protected final Configuration conf;
    protected final int maxIdleTime;
    protected final int maxRetries;
    protected final long failureSleep;
    protected final boolean tcpNoDelay;
    protected final boolean tcpKeepAlive;
    protected int pingInterval;
    protected FailedServers failedServers;
    private final Codec codec;
    private final CompressionCodec compressor;
    private final IPCUtil ipcUtil;
    protected final SocketFactory socketFactory;
    protected String clusterId;
    protected final SocketAddress localAddr;
    private final boolean fallbackAllowed;
    private UserProvider userProvider;
    private static final String PING_INTERVAL_NAME = "ipc.ping.interval";
    private static final String SOCKET_TIMEOUT = "ipc.socket.timeout";
    static final int DEFAULT_PING_INTERVAL = 60000;
    static final int DEFAULT_SOCKET_TIMEOUT = 20000;
    static final int PING_CALL_ID = -1;
    public static final String FAILED_SERVER_EXPIRY_KEY = "hbase.ipc.client.failed.servers.expiry";
    public static final int FAILED_SERVER_EXPIRY_DEFAULT = 2000;
    public static final String IPC_CLIENT_FALLBACK_TO_SIMPLE_AUTH_ALLOWED_KEY = "hbase.ipc.client.fallback-to-simple-auth-allowed";
    public static final boolean IPC_CLIENT_FALLBACK_TO_SIMPLE_AUTH_ALLOWED_DEFAULT = false;
    private static ThreadLocal<Integer> rpcTimeout = new ThreadLocal<Integer>(){

        @Override
        protected Integer initialValue() {
            return Integer.MAX_VALUE;
        }
    };
    protected static final Map<AuthenticationProtos.TokenIdentifier.Kind, TokenSelector<? extends TokenIdentifier>> tokenHandlers = new HashMap<AuthenticationProtos.TokenIdentifier.Kind, TokenSelector<? extends TokenIdentifier>>();

    public static void setPingInterval(Configuration conf, int pingInterval) {
        conf.setInt(PING_INTERVAL_NAME, pingInterval);
    }

    static int getPingInterval(Configuration conf) {
        return conf.getInt(PING_INTERVAL_NAME, 60000);
    }

    public static void setSocketTimeout(Configuration conf, int socketTimeout) {
        conf.setInt(SOCKET_TIMEOUT, socketTimeout);
    }

    static int getSocketTimeout(Configuration conf) {
        return conf.getInt(SOCKET_TIMEOUT, 20000);
    }

    protected Connection createConnection(ConnectionId remoteId, Codec codec, CompressionCodec compressor) throws IOException {
        return new Connection(remoteId, codec, compressor);
    }

    @SuppressWarnings(value={"IS2_INCONSISTENT_SYNC"}, justification="Presume sync not needed setting socket timeout")
    private static void setSocketTimeout(Socket socket, int rpcTimeout) throws SocketException {
        if (socket == null) {
            return;
        }
        socket.setSoTimeout(rpcTimeout);
    }

    RpcClient(Configuration conf, String clusterId, SocketFactory factory) {
        this(conf, clusterId, factory, null);
    }

    RpcClient(Configuration conf, String clusterId, SocketFactory factory, SocketAddress localAddr) {
        this.maxIdleTime = conf.getInt("hbase.ipc.client.connection.maxidletime", 10000);
        this.maxRetries = conf.getInt("hbase.ipc.client.connect.max.retries", 0);
        this.failureSleep = conf.getLong(HConstants.HBASE_CLIENT_PAUSE, HConstants.DEFAULT_HBASE_CLIENT_PAUSE);
        this.tcpNoDelay = conf.getBoolean("hbase.ipc.client.tcpnodelay", true);
        this.tcpKeepAlive = conf.getBoolean("hbase.ipc.client.tcpkeepalive", true);
        this.pingInterval = RpcClient.getPingInterval(conf);
        this.ipcUtil = new IPCUtil(conf);
        this.conf = conf;
        this.codec = this.getCodec();
        this.compressor = RpcClient.getCompressor(conf);
        this.socketFactory = factory;
        this.clusterId = clusterId != null ? clusterId : "default-cluster";
        this.connections = new PoolMap(RpcClient.getPoolType(conf), RpcClient.getPoolSize(conf));
        this.failedServers = new FailedServers(conf);
        this.fallbackAllowed = conf.getBoolean(IPC_CLIENT_FALLBACK_TO_SIMPLE_AUTH_ALLOWED_KEY, false);
        this.localAddr = localAddr;
        this.userProvider = UserProvider.instantiate((Configuration)conf);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Codec=" + this.codec + ", compressor=" + this.compressor + ", tcpKeepAlive=" + this.tcpKeepAlive + ", tcpNoDelay=" + this.tcpNoDelay + ", maxIdleTime=" + this.maxIdleTime + ", maxRetries=" + this.maxRetries + ", fallbackAllowed=" + this.fallbackAllowed + ", ping interval=" + this.pingInterval + "ms" + ", bind address=" + (this.localAddr != null ? this.localAddr : "null")));
        }
    }

    public RpcClient(Configuration conf, String clusterId) {
        this(conf, clusterId, NetUtils.getDefaultSocketFactory((Configuration)conf), null);
    }

    public RpcClient(Configuration conf, String clusterId, SocketAddress localAddr) {
        this(conf, clusterId, NetUtils.getDefaultSocketFactory((Configuration)conf), localAddr);
    }

    Codec getCodec() {
        String className = this.conf.get("hbase.client.rpc.codec", RpcClient.getDefaultCodec(this.conf));
        if (className == null || className.length() == 0) {
            return null;
        }
        try {
            return (Codec)Class.forName(className).newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed getting codec " + className, e);
        }
    }

    @VisibleForTesting
    public static String getDefaultCodec(Configuration c) {
        return c.get("hbase.client.default.rpc.codec", KeyValueCodec.class.getCanonicalName());
    }

    private static CompressionCodec getCompressor(Configuration conf) {
        String className = conf.get("hbase.client.rpc.compressor", null);
        if (className == null || className.isEmpty()) {
            return null;
        }
        try {
            return (CompressionCodec)Class.forName(className).newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed getting compressor " + className, e);
        }
    }

    protected static PoolMap.PoolType getPoolType(Configuration config) {
        return PoolMap.PoolType.valueOf(config.get("hbase.client.ipc.pool.type"), PoolMap.PoolType.RoundRobin, PoolMap.PoolType.ThreadLocal);
    }

    protected static int getPoolSize(Configuration config) {
        return config.getInt("hbase.client.ipc.pool.size", 1);
    }

    SocketFactory getSocketFactory() {
        return this.socketFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Stopping rpc client");
        }
        if (!this.running.compareAndSet(true, false)) {
            return;
        }
        PoolMap<ConnectionId, Connection> poolMap = this.connections;
        synchronized (poolMap) {
            for (Connection conn : this.connections.values()) {
                conn.interrupt();
            }
        }
        while (!this.connections.isEmpty()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    Pair<Message, CellScanner> call(Descriptors.MethodDescriptor md, Message param, CellScanner cells, Message returnType, User ticket, InetSocketAddress addr, int rpcTimeout) throws InterruptedException, IOException {
        return this.call(md, param, cells, returnType, ticket, addr, rpcTimeout, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Pair<Message, CellScanner> call(Descriptors.MethodDescriptor md, Message param, CellScanner cells, Message returnType, User ticket, InetSocketAddress addr, int rpcTimeout, int priority) throws InterruptedException, IOException {
        Call call = new Call(md, param, cells, returnType);
        Connection connection = this.getConnection(ticket, call, addr, rpcTimeout, this.codec, this.compressor);
        connection.writeRequest(call, priority);
        boolean interrupted = false;
        Call call2 = call;
        synchronized (call2) {
            while (!call.done) {
                if (connection.shouldCloseConnection.get()) {
                    throw new IOException("Unexpected closed connection");
                }
                try {
                    call.wait(1000L);
                }
                catch (InterruptedException ignored) {
                    interrupted = true;
                }
            }
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
            if (call.error != null) {
                if (call.error instanceof RemoteException) {
                    call.error.fillInStackTrace();
                    throw call.error;
                }
                throw this.wrapException(addr, call.error);
            }
            return new Pair((Object)call.response, (Object)call.cells);
        }
    }

    protected IOException wrapException(InetSocketAddress addr, IOException exception) {
        if (exception instanceof ConnectException) {
            return (ConnectException)new ConnectException("Call to " + addr + " failed on connection exception: " + exception).initCause(exception);
        }
        if (exception instanceof SocketTimeoutException) {
            return (SocketTimeoutException)new SocketTimeoutException("Call to " + addr + " failed because " + exception).initCause(exception);
        }
        return (IOException)new IOException("Call to " + addr + " failed on local exception: " + exception).initCause(exception);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelConnections(String hostname, int port, IOException ioe) {
        PoolMap<ConnectionId, Connection> poolMap = this.connections;
        synchronized (poolMap) {
            for (Connection connection : this.connections.values()) {
                if (!connection.isAlive() || connection.getRemoteAddress().getPort() != port || !connection.getRemoteAddress().getHostName().equals(hostname)) continue;
                LOG.info((Object)("The server on " + hostname + ":" + port + " is dead - stopping the connection " + connection.remoteId));
                connection.closeConnection();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Connection getConnection(User ticket, Call call, InetSocketAddress addr, int rpcTimeout, Codec codec, CompressionCodec compressor) throws IOException, InterruptedException {
        Connection connection;
        if (!this.running.get()) {
            throw new StoppedRpcClientException();
        }
        ConnectionId remoteId = new ConnectionId(ticket, call.md.getService().getName(), addr, rpcTimeout);
        PoolMap<ConnectionId, Connection> poolMap = this.connections;
        synchronized (poolMap) {
            connection = this.connections.get(remoteId);
            if (connection == null) {
                connection = this.createConnection(remoteId, this.codec, this.compressor);
                this.connections.put(remoteId, connection);
            }
        }
        connection.addCall(call);
        connection.setupIOstreams();
        return connection;
    }

    public static void setRpcTimeout(int t) {
        rpcTimeout.set(t);
    }

    public static int getRpcTimeout() {
        return rpcTimeout.get();
    }

    public static int getRpcTimeout(int defaultTimeout) {
        return Math.min(defaultTimeout, rpcTimeout.get());
    }

    public static void resetRpcTimeout() {
        rpcTimeout.remove();
    }

    Message callBlockingMethod(Descriptors.MethodDescriptor md, RpcController controller, Message param, Message returnType, User ticket, InetSocketAddress isa, int rpcTimeout) throws ServiceException {
        long startTime = 0L;
        if (LOG.isTraceEnabled()) {
            startTime = System.currentTimeMillis();
        }
        PayloadCarryingRpcController pcrc = (PayloadCarryingRpcController)controller;
        CellScanner cells = null;
        if (pcrc != null) {
            cells = pcrc.cellScanner();
            pcrc.setCellScanner(null);
        }
        Pair<Message, CellScanner> val = null;
        try {
            val = this.call(md, param, cells, returnType, ticket, isa, rpcTimeout, pcrc != null ? pcrc.getPriority() : 0);
            if (pcrc != null) {
                if (val.getSecond() != null) {
                    pcrc.setCellScanner((CellScanner)val.getSecond());
                }
            } else if (val.getSecond() != null) {
                throw new ServiceException("Client dropping data on the floor!");
            }
            if (LOG.isTraceEnabled()) {
                long callTime = System.currentTimeMillis() - startTime;
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)("Call: " + md.getName() + ", callTime: " + callTime + "ms"));
                }
            }
            return (Message)val.getFirst();
        }
        catch (Throwable e) {
            throw new ServiceException(e);
        }
    }

    public BlockingRpcChannel createBlockingRpcChannel(ServerName sn, User ticket, int rpcTimeout) {
        return new BlockingRpcChannelImplementation(this, sn, ticket, rpcTimeout);
    }

    static {
        tokenHandlers.put(AuthenticationProtos.TokenIdentifier.Kind.HBASE_AUTH_TOKEN, new AuthenticationTokenSelector());
    }

    public static class BlockingRpcChannelImplementation
    implements BlockingRpcChannel {
        private final InetSocketAddress isa;
        private volatile RpcClient rpcClient;
        private final int rpcTimeout;
        private final User ticket;

        protected BlockingRpcChannelImplementation(RpcClient rpcClient, ServerName sn, User ticket, int rpcTimeout) {
            this.isa = new InetSocketAddress(sn.getHostname(), sn.getPort());
            this.rpcClient = rpcClient;
            this.rpcTimeout = RpcClient.getRpcTimeout(rpcTimeout);
            this.ticket = ticket;
        }

        public Message callBlockingMethod(Descriptors.MethodDescriptor md, RpcController controller, Message param, Message returnType) throws ServiceException {
            return this.rpcClient.callBlockingMethod(md, controller, param, returnType, this.ticket, this.isa, this.rpcTimeout);
        }
    }

    protected static class ConnectionId {
        final InetSocketAddress address;
        final User ticket;
        final int rpcTimeout;
        private static final int PRIME = 16777619;
        final String serviceName;

        ConnectionId(User ticket, String serviceName, InetSocketAddress address, int rpcTimeout) {
            this.address = address;
            this.ticket = ticket;
            this.rpcTimeout = rpcTimeout;
            this.serviceName = serviceName;
        }

        String getServiceName() {
            return this.serviceName;
        }

        InetSocketAddress getAddress() {
            return this.address;
        }

        User getTicket() {
            return this.ticket;
        }

        public String toString() {
            return this.address.toString() + "/" + this.serviceName + "/" + this.ticket + "/" + this.rpcTimeout;
        }

        public boolean equals(Object obj) {
            if (obj instanceof ConnectionId) {
                ConnectionId id = (ConnectionId)obj;
                return this.address.equals(id.address) && (this.ticket != null && this.ticket.equals((Object)id.ticket) || this.ticket == id.ticket) && this.rpcTimeout == id.rpcTimeout && this.serviceName == id.serviceName;
            }
            return false;
        }

        public int hashCode() {
            int hashcode = this.address.hashCode() + 16777619 * (16777619 * this.serviceName.hashCode() ^ (this.ticket == null ? 0 : this.ticket.hashCode())) ^ this.rpcTimeout;
            return hashcode;
        }
    }

    @InterfaceAudience.Public
    @InterfaceStability.Evolving
    public static class CallTimeoutException
    extends IOException {
        public CallTimeoutException(String msg) {
            super(msg);
        }
    }

    protected class Connection
    extends Thread {
        private RPCProtos.ConnectionHeader header;
        protected ConnectionId remoteId;
        protected Socket socket = null;
        protected DataInputStream in;
        protected DataOutputStream out;
        private InetSocketAddress server;
        private String serverPrincipal;
        private AuthMethod authMethod;
        private boolean useSasl;
        private Token<? extends TokenIdentifier> token;
        private HBaseSaslRpcClient saslRpcClient;
        private int reloginMaxBackoff;
        private final Codec codec;
        private final CompressionCodec compressor;
        protected final ConcurrentSkipListMap<Integer, Call> calls = new ConcurrentSkipListMap();
        protected final AtomicLong lastActivity = new AtomicLong();
        protected final AtomicBoolean shouldCloseConnection = new AtomicBoolean();
        protected IOException closeException;

        Connection(ConnectionId remoteId, Codec codec, CompressionCodec compressor) throws IOException {
            if (remoteId.getAddress().isUnresolved()) {
                throw new UnknownHostException("unknown host: " + remoteId.getAddress().getHostName());
            }
            this.server = remoteId.getAddress();
            this.codec = codec;
            this.compressor = compressor;
            UserGroupInformation ticket = remoteId.getTicket().getUGI();
            SecurityInfo securityInfo = SecurityInfo.getInfo(remoteId.getServiceName());
            this.useSasl = RpcClient.this.userProvider.isHBaseSecurityEnabled();
            if (this.useSasl && securityInfo != null) {
                String serverKey;
                AuthenticationProtos.TokenIdentifier.Kind tokenKind = securityInfo.getTokenKind();
                if (tokenKind != null) {
                    TokenSelector<? extends TokenIdentifier> tokenSelector = tokenHandlers.get(tokenKind);
                    if (tokenSelector != null) {
                        this.token = tokenSelector.selectToken(new Text(RpcClient.this.clusterId), ticket.getTokens());
                    } else if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("No token selector found for type " + tokenKind));
                    }
                }
                if ((serverKey = securityInfo.getServerPrincipal()) == null) {
                    throw new IOException("Can't obtain server Kerberos config key from SecurityInfo");
                }
                this.serverPrincipal = SecurityUtil.getServerPrincipal((String)RpcClient.this.conf.get(serverKey), (String)this.server.getAddress().getCanonicalHostName().toLowerCase());
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("RPC Server Kerberos principal name for service=" + remoteId.getServiceName() + " is " + this.serverPrincipal));
                }
            }
            this.authMethod = !this.useSasl ? AuthMethod.SIMPLE : (this.token != null ? AuthMethod.DIGEST : AuthMethod.KERBEROS);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Use " + (Object)((Object)this.authMethod) + " authentication for service " + remoteId.serviceName + ", sasl=" + this.useSasl));
            }
            this.reloginMaxBackoff = RpcClient.this.conf.getInt("hbase.security.relogin.maxbackoff", 5000);
            this.remoteId = remoteId;
            RPCProtos.ConnectionHeader.Builder builder = RPCProtos.ConnectionHeader.newBuilder();
            builder.setServiceName(remoteId.getServiceName());
            RPCProtos.UserInformation userInfoPB = this.getUserInfo(ticket);
            if (userInfoPB != null) {
                builder.setUserInfo(userInfoPB);
            }
            if (this.codec != null) {
                builder.setCellBlockCodecClass(this.codec.getClass().getCanonicalName());
            }
            if (this.compressor != null) {
                builder.setCellBlockCompressorClass(this.compressor.getClass().getCanonicalName());
            }
            this.header = builder.build();
            this.setName("IPC Client (" + RpcClient.this.socketFactory.hashCode() + ") connection to " + remoteId.getAddress().toString() + (ticket == null ? " from an unknown user" : " from " + ticket.getUserName()));
            this.setDaemon(true);
        }

        private RPCProtos.UserInformation getUserInfo(UserGroupInformation ugi) {
            if (ugi == null || this.authMethod == AuthMethod.DIGEST) {
                return null;
            }
            RPCProtos.UserInformation.Builder userInfoPB = RPCProtos.UserInformation.newBuilder();
            if (this.authMethod == AuthMethod.KERBEROS) {
                userInfoPB.setEffectiveUser(ugi.getUserName());
            } else if (this.authMethod == AuthMethod.SIMPLE) {
                userInfoPB.setEffectiveUser(ugi.getUserName());
                if (ugi.getRealUser() != null) {
                    userInfoPB.setRealUser(ugi.getRealUser().getUserName());
                }
            }
            return userInfoPB.build();
        }

        protected void touch() {
            this.lastActivity.set(System.currentTimeMillis());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @SuppressWarnings(value={"NN_NAKED_NOTIFY"}, justification="Notify because new call available for processing")
        protected synchronized void addCall(Call call) {
            if (this.shouldCloseConnection.get()) {
                if (this.closeException == null) {
                    call.setException(new IOException("Call " + call.id + " not added as the connection " + this.remoteId + " is closing"));
                } else {
                    call.setException(this.closeException);
                }
                Call call2 = call;
                synchronized (call2) {
                    call.notifyAll();
                }
            }
            this.calls.put(call.id, call);
            Call call3 = call;
            synchronized (call3) {
                this.notify();
            }
        }

        protected synchronized void setupConnection() throws IOException {
            int ioFailures = 0;
            int timeoutFailures = 0;
            while (true) {
                try {
                    this.socket = RpcClient.this.socketFactory.createSocket();
                    this.socket.setTcpNoDelay(RpcClient.this.tcpNoDelay);
                    this.socket.setKeepAlive(RpcClient.this.tcpKeepAlive);
                    if (RpcClient.this.localAddr != null) {
                        this.socket.bind(RpcClient.this.localAddr);
                    }
                    NetUtils.connect((Socket)this.socket, (SocketAddress)this.remoteId.getAddress(), (int)RpcClient.getSocketTimeout(RpcClient.this.conf));
                    if (this.remoteId.rpcTimeout > 0) {
                        RpcClient.this.pingInterval = this.remoteId.rpcTimeout;
                    }
                    this.socket.setSoTimeout(RpcClient.this.pingInterval);
                    return;
                }
                catch (SocketTimeoutException toe) {
                    int n = timeoutFailures;
                    timeoutFailures = (short)(timeoutFailures + 1);
                    this.handleConnectionFailure(n, RpcClient.this.maxRetries, toe);
                    continue;
                }
                catch (IOException ie) {
                    int n = ioFailures;
                    ioFailures = (short)(ioFailures + 1);
                    this.handleConnectionFailure(n, RpcClient.this.maxRetries, ie);
                    continue;
                }
                break;
            }
        }

        protected void closeConnection() {
            if (this.socket == null) {
                return;
            }
            try {
                if (this.socket.getOutputStream() != null) {
                    this.socket.getOutputStream().close();
                }
            }
            catch (IOException ignored) {
                // empty catch block
            }
            try {
                if (this.socket.getInputStream() != null) {
                    this.socket.getInputStream().close();
                }
            }
            catch (IOException ignored) {
                // empty catch block
            }
            try {
                if (this.socket.getChannel() != null) {
                    this.socket.getChannel().close();
                }
            }
            catch (IOException ignored) {
                // empty catch block
            }
            try {
                this.socket.close();
            }
            catch (IOException e) {
                LOG.warn((Object)"Not able to close a socket", (Throwable)e);
            }
            this.socket = null;
        }

        private void handleConnectionFailure(int curRetries, int maxRetries, IOException ioe) throws IOException {
            this.closeConnection();
            if (curRetries >= maxRetries) {
                throw ioe;
            }
            try {
                Thread.sleep(RpcClient.this.failureSleep);
            }
            catch (InterruptedException ignored) {
                // empty catch block
            }
            LOG.info((Object)("Retrying connect to server: " + this.remoteId.getAddress() + " after sleeping " + RpcClient.this.failureSleep + "ms. Already tried " + curRetries + " time(s)."));
        }

        protected synchronized boolean waitForWork() {
            long timeout;
            if (this.calls.isEmpty() && !this.shouldCloseConnection.get() && RpcClient.this.running.get() && (timeout = (long)RpcClient.this.maxIdleTime - (System.currentTimeMillis() - this.lastActivity.get())) > 0L) {
                try {
                    this.wait(timeout);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (!this.calls.isEmpty() && !this.shouldCloseConnection.get() && RpcClient.this.running.get()) {
                return true;
            }
            if (this.shouldCloseConnection.get()) {
                return false;
            }
            if (this.calls.isEmpty()) {
                this.markClosed(null);
                return false;
            }
            this.markClosed((IOException)new IOException().initCause(new InterruptedException()));
            return false;
        }

        public InetSocketAddress getRemoteAddress() {
            return this.remoteId.getAddress();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected synchronized void sendPing() throws IOException {
            long curTime = System.currentTimeMillis();
            if (curTime - this.lastActivity.get() >= (long)RpcClient.this.pingInterval) {
                this.lastActivity.set(curTime);
                DataOutputStream dataOutputStream = this.out;
                synchronized (dataOutputStream) {
                    this.out.writeInt(-1);
                    this.out.flush();
                }
            }
        }

        @Override
        public void run() {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(this.getName() + ": starting, connections " + RpcClient.this.connections.size()));
            }
            try {
                while (this.waitForWork()) {
                    this.readResponse();
                }
            }
            catch (Throwable t) {
                LOG.warn((Object)(this.getName() + ": unexpected exception receiving call responses"), t);
                this.markClosed(new IOException("Unexpected exception receiving call responses", t));
            }
            this.close();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(this.getName() + ": stopped, connections " + RpcClient.this.connections.size()));
            }
        }

        private synchronized void disposeSasl() {
            if (this.saslRpcClient != null) {
                try {
                    this.saslRpcClient.dispose();
                    this.saslRpcClient = null;
                }
                catch (IOException ioe) {
                    LOG.error((Object)"Error disposing of SASL client", (Throwable)ioe);
                }
            }
        }

        private synchronized boolean shouldAuthenticateOverKrb() throws IOException {
            UserGroupInformation loginUser = UserGroupInformation.getLoginUser();
            UserGroupInformation currentUser = UserGroupInformation.getCurrentUser();
            UserGroupInformation realUser = currentUser.getRealUser();
            return this.authMethod == AuthMethod.KERBEROS && loginUser != null && loginUser.hasKerberosCredentials() && (loginUser.equals((Object)currentUser) || loginUser.equals((Object)realUser));
        }

        private synchronized boolean setupSaslConnection(InputStream in2, OutputStream out2) throws IOException {
            this.saslRpcClient = new HBaseSaslRpcClient(this.authMethod, this.token, this.serverPrincipal, RpcClient.this.fallbackAllowed);
            return this.saslRpcClient.saslConnect(in2, out2);
        }

        private synchronized void handleSaslConnectionFailure(final int currRetries, final int maxRetries, final Exception ex, final Random rand, UserGroupInformation user) throws IOException, InterruptedException {
            user.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws IOException, InterruptedException {
                    Connection.this.closeConnection();
                    if (Connection.this.shouldAuthenticateOverKrb()) {
                        if (currRetries < maxRetries) {
                            LOG.debug((Object)("Exception encountered while connecting to the server : " + ex));
                            if (UserGroupInformation.isLoginKeytabBased()) {
                                UserGroupInformation.getLoginUser().reloginFromKeytab();
                            } else {
                                UserGroupInformation.getLoginUser().reloginFromTicketCache();
                            }
                            Connection.this.disposeSasl();
                            Thread.sleep(rand.nextInt(Connection.this.reloginMaxBackoff) + 1);
                            return null;
                        }
                        String msg = "Couldn't setup connection for " + UserGroupInformation.getLoginUser().getUserName() + " to " + Connection.this.serverPrincipal;
                        LOG.warn((Object)msg);
                        throw (IOException)new IOException(msg).initCause(ex);
                    }
                    LOG.warn((Object)("Exception encountered while connecting to the server : " + ex));
                    if (ex instanceof RemoteException) {
                        throw (RemoteException)ex;
                    }
                    if (ex instanceof SaslException) {
                        String msg = "SASL authentication failed. The most likely cause is missing or invalid credentials. Consider 'kinit'.";
                        LOG.fatal((Object)msg, (Throwable)ex);
                        throw new RuntimeException(msg, ex);
                    }
                    throw new IOException(ex);
                }
            });
        }

        protected synchronized void setupIOstreams() throws IOException, InterruptedException {
            if (this.socket != null || this.shouldCloseConnection.get()) {
                return;
            }
            if (RpcClient.this.failedServers.isFailedServer(this.remoteId.getAddress())) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Not trying to connect to " + this.server + " this server is in the failed servers list"));
                }
                FailedServerException e = new FailedServerException("This server is in the failed servers list: " + this.server);
                this.markClosed((IOException)((Object)e));
                this.close();
                throw e;
            }
            try {
                OutputStream outStream;
                Object inStream;
                block18: {
                    boolean continueSasl;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Connecting to " + this.server));
                    }
                    int numRetries = 0;
                    int MAX_RETRIES = 5;
                    Random rand = null;
                    while (true) {
                        this.setupConnection();
                        inStream = NetUtils.getInputStream((Socket)this.socket);
                        outStream = NetUtils.getOutputStream((Socket)this.socket, (long)RpcClient.this.pingInterval);
                        this.writeConnectionHeaderPreamble(outStream);
                        if (!this.useSasl) break block18;
                        SocketInputWrapper in2 = inStream;
                        OutputStream out2 = outStream;
                        UserGroupInformation ticket = this.remoteId.getTicket().getUGI();
                        if (this.authMethod == AuthMethod.KERBEROS && ticket != null && ticket.getRealUser() != null) {
                            ticket = ticket.getRealUser();
                        }
                        continueSasl = false;
                        if (ticket == null) {
                            throw new FatalConnectionException("ticket/user is null");
                        }
                        try {
                            continueSasl = (Boolean)ticket.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Boolean>((InputStream)in2, out2){
                                final /* synthetic */ InputStream val$in2;
                                final /* synthetic */ OutputStream val$out2;
                                {
                                    this.val$in2 = inputStream;
                                    this.val$out2 = outputStream;
                                }

                                @Override
                                public Boolean run() throws IOException {
                                    return Connection.this.setupSaslConnection(this.val$in2, this.val$out2);
                                }
                            });
                        }
                        catch (Exception ex) {
                            if (rand == null) {
                                rand = new Random();
                            }
                            int n = numRetries;
                            numRetries = (short)(numRetries + 1);
                            this.handleSaslConnectionFailure(n, 5, ex, rand, ticket);
                            continue;
                        }
                        break;
                    }
                    if (continueSasl) {
                        inStream = this.saslRpcClient.getInputStream((InputStream)inStream);
                        outStream = this.saslRpcClient.getOutputStream(outStream);
                    } else {
                        this.authMethod = AuthMethod.SIMPLE;
                        this.useSasl = false;
                    }
                }
                this.in = new DataInputStream(new BufferedInputStream(new PingInputStream((InputStream)inStream)));
                this.out = new DataOutputStream(new BufferedOutputStream(outStream));
                this.writeConnectionHeader();
                this.touch();
                this.start();
                return;
            }
            catch (Throwable t) {
                RpcClient.this.failedServers.addToFailedServers(this.remoteId.address);
                Object e = null;
                if (t instanceof LinkageError) {
                    e = new DoNotRetryIOException(t);
                    this.markClosed((IOException)e);
                } else if (t instanceof IOException) {
                    e = (IOException)t;
                    this.markClosed((IOException)e);
                } else {
                    e = new IOException("Could not set up IO Streams", t);
                    this.markClosed((IOException)e);
                }
                this.close();
                throw e;
            }
        }

        private void writeConnectionHeaderPreamble(OutputStream outStream) throws IOException {
            int rpcHeaderLen = HConstants.RPC_HEADER.array().length;
            byte[] preamble = new byte[rpcHeaderLen + 2];
            System.arraycopy(HConstants.RPC_HEADER.array(), 0, preamble, 0, rpcHeaderLen);
            preamble[rpcHeaderLen] = 0;
            preamble[rpcHeaderLen + 1] = this.authMethod.code;
            outStream.write(preamble);
            outStream.flush();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void writeConnectionHeader() throws IOException {
            DataOutputStream dataOutputStream = this.out;
            synchronized (dataOutputStream) {
                this.out.writeInt(this.header.getSerializedSize());
                this.header.writeTo((OutputStream)this.out);
                this.out.flush();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected synchronized void close() {
            if (!this.shouldCloseConnection.get()) {
                LOG.error((Object)(this.getName() + ": the connection is not in the closed state"));
                return;
            }
            Object object = RpcClient.this.connections;
            synchronized (object) {
                RpcClient.this.connections.remove(this.remoteId, this);
            }
            if (this.out != null) {
                object = this.out;
                synchronized (object) {
                    IOUtils.closeStream((Closeable)this.out);
                    this.out = null;
                }
            }
            IOUtils.closeStream((Closeable)this.in);
            this.in = null;
            this.disposeSasl();
            if (this.closeException == null) {
                if (!this.calls.isEmpty()) {
                    LOG.warn((Object)(this.getName() + ": connection is closed for no cause and calls are not empty. " + "#Calls: " + this.calls.size()));
                    this.closeException = new IOException("Unexpected closed connection");
                    this.cleanupCalls();
                }
            } else {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)(this.getName() + ": closing ipc connection to " + this.server + ": " + this.closeException.getMessage()), (Throwable)this.closeException);
                }
                this.cleanupCalls();
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(this.getName() + ": closed"));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void writeRequest(Call call, int priority) {
            if (this.shouldCloseConnection.get()) {
                return;
            }
            try {
                RPCProtos.RequestHeader.Builder builder = RPCProtos.RequestHeader.newBuilder();
                builder.setCallId(call.id);
                if (Trace.isTracing()) {
                    Span s = Trace.currentSpan();
                    builder.setTraceInfo(TracingProtos.RPCTInfo.newBuilder().setParentId(s.getSpanId()).setTraceId(s.getTraceId()));
                }
                builder.setMethodName(call.md.getName());
                builder.setRequestParam(call.param != null);
                ByteBuffer cellBlock = RpcClient.this.ipcUtil.buildCellBlock(this.codec, this.compressor, call.cells);
                if (cellBlock != null) {
                    RPCProtos.CellBlockMeta.Builder cellBlockBuilder = RPCProtos.CellBlockMeta.newBuilder();
                    cellBlockBuilder.setLength(cellBlock.limit());
                    builder.setCellBlockMeta(cellBlockBuilder.build());
                }
                if (priority != 0) {
                    builder.setPriority(priority);
                }
                RPCProtos.RequestHeader header = builder.build();
                DataOutputStream dataOutputStream = this.out;
                synchronized (dataOutputStream) {
                    IPCUtil.write(this.out, (Message)header, call.param, cellBlock);
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)(this.getName() + ": wrote request header " + TextFormat.shortDebugString((MessageOrBuilder)header)));
                }
            }
            catch (IOException e) {
                this.markClosed(e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void readResponse() {
            if (this.shouldCloseConnection.get()) {
                return;
            }
            this.touch();
            int totalSize = -1;
            try {
                Call call;
                totalSize = this.in.readInt();
                RPCProtos.ResponseHeader responseHeader = RPCProtos.ResponseHeader.parseDelimitedFrom((InputStream)this.in);
                int id = responseHeader.getCallId();
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)(this.getName() + ": got response header " + TextFormat.shortDebugString((MessageOrBuilder)responseHeader) + ", totalSize: " + totalSize + " bytes"));
                }
                if ((call = this.calls.get(id)) == null) {
                    int readSoFar = IPCUtil.getTotalSizeWhenWrittenDelimited(new Message[]{responseHeader});
                    int whatIsLeftToRead = totalSize - readSoFar;
                    LOG.debug((Object)("Unknown callId: " + id + ", skipping over this response of " + whatIsLeftToRead + " bytes"));
                    IOUtils.skipFully((InputStream)this.in, (long)whatIsLeftToRead);
                }
                if (responseHeader.hasException()) {
                    RPCProtos.ExceptionResponse exceptionResponse = responseHeader.getException();
                    RemoteException re = this.createRemoteException(exceptionResponse);
                    if (this.isFatalConnectionException(exceptionResponse)) {
                        this.markClosed((IOException)re);
                    } else if (call != null) {
                        call.setException((IOException)re);
                    }
                } else {
                    Message value = null;
                    if (call != null && call.responseDefaultType != null) {
                        Message.Builder builder = call.responseDefaultType.newBuilderForType();
                        builder.mergeDelimitedFrom((InputStream)this.in);
                        value = builder.build();
                    }
                    CellScanner cellBlockScanner = null;
                    if (responseHeader.hasCellBlockMeta()) {
                        int size = responseHeader.getCellBlockMeta().getLength();
                        byte[] cellBlock = new byte[size];
                        IOUtils.readFully((InputStream)this.in, (byte[])cellBlock, (int)0, (int)cellBlock.length);
                        cellBlockScanner = RpcClient.this.ipcUtil.createCellScanner(this.codec, this.compressor, cellBlock);
                    }
                    if (call != null) {
                        call.setResponse(value, cellBlockScanner);
                    }
                }
                if (call != null) {
                    this.calls.remove(id);
                }
            }
            catch (IOException e) {
                if (e instanceof SocketTimeoutException && this.remoteId.rpcTimeout > 0) {
                    this.closeException = e;
                } else {
                    this.markClosed(e);
                }
            }
            finally {
                if (this.remoteId.rpcTimeout > 0) {
                    this.cleanupCalls(this.remoteId.rpcTimeout);
                }
            }
        }

        private boolean isFatalConnectionException(RPCProtos.ExceptionResponse e) {
            return e.getExceptionClassName().equals(FatalConnectionException.class.getName());
        }

        private RemoteException createRemoteException(RPCProtos.ExceptionResponse e) {
            String innerExceptionClassName = e.getExceptionClassName();
            boolean doNotRetry = e.getDoNotRetry();
            return e.hasHostname() ? new RemoteWithExtrasException(innerExceptionClassName, e.getStackTrace(), e.getHostname(), e.getPort(), doNotRetry) : new RemoteWithExtrasException(innerExceptionClassName, e.getStackTrace(), doNotRetry);
        }

        protected synchronized void markClosed(IOException e) {
            if (this.shouldCloseConnection.compareAndSet(false, true)) {
                this.closeException = e;
                this.notifyAll();
            }
        }

        protected void cleanupCalls() {
            this.cleanupCalls(0L);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @SuppressWarnings(value={"NN_NAKED_NOTIFY"}, justification="Notify because timedout")
        protected void cleanupCalls(long rpcTimeout) {
            Iterator<Map.Entry<Integer, Call>> itor = this.calls.entrySet().iterator();
            while (itor.hasNext()) {
                Call c = itor.next().getValue();
                long waitTime = System.currentTimeMillis() - c.getStartTime();
                if (waitTime < rpcTimeout) break;
                if (this.closeException == null) {
                    this.closeException = new CallTimeoutException("Call id=" + c.id + ", waitTime=" + waitTime + ", rpcTimetout=" + rpcTimeout);
                }
                c.setException(this.closeException);
                Call call = c;
                synchronized (call) {
                    c.notifyAll();
                }
                itor.remove();
            }
            try {
                if (!this.calls.isEmpty()) {
                    Call firstCall = this.calls.get(this.calls.firstKey());
                    long maxWaitTime = System.currentTimeMillis() - firstCall.getStartTime();
                    if (maxWaitTime < rpcTimeout) {
                        rpcTimeout -= maxWaitTime;
                    }
                }
                if (!this.shouldCloseConnection.get()) {
                    this.closeException = null;
                    RpcClient.setSocketTimeout(this.socket, (int)rpcTimeout);
                }
            }
            catch (SocketException e) {
                LOG.debug((Object)"Couldn't lower timeout, which may result in longer than expected calls");
            }
        }

        protected class PingInputStream
        extends FilterInputStream {
            protected PingInputStream(InputStream in) {
                super(in);
            }

            private void handleTimeout(SocketTimeoutException e) throws IOException {
                if (Connection.this.shouldCloseConnection.get() || !RpcClient.this.running.get() || Connection.this.remoteId.rpcTimeout > 0) {
                    throw e;
                }
                Connection.this.sendPing();
            }

            @Override
            public int read() throws IOException {
                while (true) {
                    try {
                        return super.read();
                    }
                    catch (SocketTimeoutException e) {
                        this.handleTimeout(e);
                        continue;
                    }
                    break;
                }
            }

            @Override
            public int read(byte[] buf, int off, int len) throws IOException {
                while (true) {
                    try {
                        return super.read(buf, off, len);
                    }
                    catch (SocketTimeoutException e) {
                        this.handleTimeout(e);
                        continue;
                    }
                    break;
                }
            }
        }
    }

    protected class Call {
        final int id;
        final Message param;
        CellScanner cells;
        Message response;
        Message responseDefaultType;
        IOException error;
        boolean done;
        long startTime;
        final Descriptors.MethodDescriptor md;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Call(Descriptors.MethodDescriptor md, Message param, CellScanner cells, Message responseDefaultType) {
            this.param = param;
            this.md = md;
            this.cells = cells;
            this.startTime = System.currentTimeMillis();
            this.responseDefaultType = responseDefaultType;
            RpcClient rpcClient2 = RpcClient.this;
            synchronized (rpcClient2) {
                this.id = RpcClient.this.counter++;
            }
        }

        public String toString() {
            return "callId: " + this.id + " methodName: " + this.md.getName() + " param {" + (this.param != null ? ProtobufUtil.getShortTextFormat(this.param) : "") + "}";
        }

        protected synchronized void callComplete() {
            this.done = true;
            this.notify();
        }

        public void setException(IOException error) {
            this.error = error;
            this.callComplete();
        }

        public void setResponse(Message response, CellScanner cells) {
            this.response = response;
            this.cells = cells;
            this.callComplete();
        }

        public long getStartTime() {
            return this.startTime;
        }
    }

    @InterfaceAudience.Public
    @InterfaceStability.Evolving
    public static class FailedServerException
    extends HBaseIOException {
        public FailedServerException(String s) {
            super(s);
        }
    }

    static class FailedServers {
        private final LinkedList<Pair<Long, String>> failedServers = new LinkedList();
        private final int recheckServersTimeout;

        FailedServers(Configuration conf) {
            this.recheckServersTimeout = conf.getInt(RpcClient.FAILED_SERVER_EXPIRY_KEY, 2000);
        }

        public synchronized void addToFailedServers(InetSocketAddress address) {
            long expiry = EnvironmentEdgeManager.currentTimeMillis() + (long)this.recheckServersTimeout;
            this.failedServers.addFirst((Pair<Long, String>)new Pair((Object)expiry, (Object)address.toString()));
        }

        public synchronized boolean isFailedServer(InetSocketAddress address) {
            if (this.failedServers.isEmpty()) {
                return false;
            }
            String lookup = address.toString();
            long now = EnvironmentEdgeManager.currentTimeMillis();
            Iterator it = this.failedServers.iterator();
            while (it.hasNext()) {
                Pair cur = (Pair)it.next();
                if ((Long)cur.getFirst() < now) {
                    it.remove();
                    continue;
                }
                if (!lookup.equals(cur.getSecond())) continue;
                return true;
            }
            return false;
        }
    }
}

