/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.ipc;

import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.client.HConnection;
import org.apache.hadoop.hbase.ipc.CoprocessorRpcChannel;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.util.ByteStringer;

@InterfaceAudience.Private
public class RegionServerCoprocessorRpcChannel
extends CoprocessorRpcChannel {
    private static Log LOG = LogFactory.getLog(RegionServerCoprocessorRpcChannel.class);
    private final HConnection connection;
    private final ServerName serverName;

    public RegionServerCoprocessorRpcChannel(HConnection conn, ServerName serverName) {
        this.connection = conn;
        this.serverName = serverName;
    }

    @Override
    protected Message callExecService(Descriptors.MethodDescriptor method, Message request, Message responsePrototype) throws IOException {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Call: " + method.getName() + ", " + request.toString()));
        }
        ClientProtos.CoprocessorServiceCall call = ClientProtos.CoprocessorServiceCall.newBuilder().setRow(ByteStringer.wrap((byte[])HConstants.EMPTY_BYTE_ARRAY)).setServiceName(method.getService().getFullName()).setMethodName(method.getName()).setRequest(request.toByteString()).build();
        ClientProtos.CoprocessorServiceResponse result = ProtobufUtil.execRegionServerService(this.connection.getClient(this.serverName), call);
        Message response = null;
        if (result.getValue().hasValue()) {
            Message.Builder builder = responsePrototype.newBuilderForType();
            ProtobufUtil.mergeFrom(builder, result.getValue().getValue());
            response = builder.build();
        } else {
            response = responsePrototype.getDefaultInstanceForType();
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Result is value=" + response));
        }
        return response;
    }
}

