/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.filter;

import com.google.protobuf.InvalidProtocolBufferException;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.util.Arrays;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.filter.ByteArrayComparable;
import org.apache.hadoop.hbase.protobuf.generated.ComparatorProtos;
import org.apache.hadoop.hbase.util.Bytes;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class RegexStringComparator
extends ByteArrayComparable {
    private static final Log LOG = LogFactory.getLog(RegexStringComparator.class);
    private Charset charset = HConstants.UTF8_CHARSET;
    private Pattern pattern;

    public RegexStringComparator(String expr) {
        this(expr, 32);
    }

    public RegexStringComparator(String expr, int flags) {
        super(Bytes.toBytes((String)expr));
        this.pattern = Pattern.compile(expr, flags);
    }

    public void setCharset(Charset charset) {
        this.charset = charset;
    }

    @Override
    public int compareTo(byte[] value, int offset, int length) {
        String tmp = length < value.length / 2 ? new String(Arrays.copyOfRange(value, offset, offset + length), this.charset) : new String(value, offset, length, this.charset);
        return this.pattern.matcher(tmp).find() ? 0 : 1;
    }

    @Override
    public byte[] toByteArray() {
        ComparatorProtos.RegexStringComparator.Builder builder = ComparatorProtos.RegexStringComparator.newBuilder();
        builder.setPattern(this.pattern.toString());
        builder.setPatternFlags(this.pattern.flags());
        builder.setCharset(this.charset.name());
        return builder.build().toByteArray();
    }

    public static RegexStringComparator parseFrom(byte[] pbBytes) throws DeserializationException {
        ComparatorProtos.RegexStringComparator proto;
        try {
            proto = ComparatorProtos.RegexStringComparator.parseFrom((byte[])pbBytes);
        }
        catch (InvalidProtocolBufferException e) {
            throw new DeserializationException(e);
        }
        RegexStringComparator comparator = new RegexStringComparator(proto.getPattern(), proto.getPatternFlags());
        String charset = proto.getCharset();
        if (charset.length() > 0) {
            try {
                comparator.setCharset(Charset.forName(charset));
            }
            catch (IllegalCharsetNameException e) {
                LOG.error((Object)"invalid charset", (Throwable)e);
            }
        }
        return comparator;
    }

    @Override
    boolean areSerializedFieldsEqual(ByteArrayComparable other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof RegexStringComparator)) {
            return false;
        }
        RegexStringComparator comparator = (RegexStringComparator)other;
        return super.areSerializedFieldsEqual(comparator) && this.pattern.toString().equals(comparator.pattern.toString()) && this.pattern.flags() == comparator.pattern.flags() && this.charset.equals(comparator.charset);
    }
}

