/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import com.google.protobuf.Message;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Matcher;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.regionserver.BloomType;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.util.ByteStringer;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Writables;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class HTableDescriptor
implements WritableComparable<HTableDescriptor> {
    private static final Log LOG = LogFactory.getLog(HTableDescriptor.class);
    private static final byte TABLE_DESCRIPTOR_VERSION = 7;
    private TableName name = null;
    private final Map<ImmutableBytesWritable, ImmutableBytesWritable> values = new HashMap<ImmutableBytesWritable, ImmutableBytesWritable>();
    private final Map<String, String> configuration = new HashMap<String, String>();
    public static final String SPLIT_POLICY = "SPLIT_POLICY";
    public static final String MAX_FILESIZE = "MAX_FILESIZE";
    private static final ImmutableBytesWritable MAX_FILESIZE_KEY = new ImmutableBytesWritable(Bytes.toBytes((String)"MAX_FILESIZE"));
    public static final String OWNER = "OWNER";
    public static final ImmutableBytesWritable OWNER_KEY = new ImmutableBytesWritable(Bytes.toBytes((String)"OWNER"));
    public static final String READONLY = "READONLY";
    private static final ImmutableBytesWritable READONLY_KEY = new ImmutableBytesWritable(Bytes.toBytes((String)"READONLY"));
    public static final String COMPACTION_ENABLED = "COMPACTION_ENABLED";
    private static final ImmutableBytesWritable COMPACTION_ENABLED_KEY = new ImmutableBytesWritable(Bytes.toBytes((String)"COMPACTION_ENABLED"));
    public static final String MEMSTORE_FLUSHSIZE = "MEMSTORE_FLUSHSIZE";
    private static final ImmutableBytesWritable MEMSTORE_FLUSHSIZE_KEY = new ImmutableBytesWritable(Bytes.toBytes((String)"MEMSTORE_FLUSHSIZE"));
    public static final String IS_ROOT = "IS_ROOT";
    private static final ImmutableBytesWritable IS_ROOT_KEY = new ImmutableBytesWritable(Bytes.toBytes((String)"IS_ROOT"));
    public static final String IS_META = "IS_META";
    private static final ImmutableBytesWritable IS_META_KEY = new ImmutableBytesWritable(Bytes.toBytes((String)"IS_META"));
    @Deprecated
    public static final String DEFERRED_LOG_FLUSH = "DEFERRED_LOG_FLUSH";
    @Deprecated
    private static final ImmutableBytesWritable DEFERRED_LOG_FLUSH_KEY = new ImmutableBytesWritable(Bytes.toBytes((String)"DEFERRED_LOG_FLUSH"));
    public static final String DURABILITY = "DURABILITY";
    private static final ImmutableBytesWritable DURABILITY_KEY = new ImmutableBytesWritable(Bytes.toBytes((String)"DURABILITY"));
    public static final String REGION_REPLICATION = "REGION_REPLICATION";
    private static final ImmutableBytesWritable REGION_REPLICATION_KEY = new ImmutableBytesWritable(Bytes.toBytes((String)"REGION_REPLICATION"));
    private static final Durability DEFAULT_DURABLITY = Durability.USE_DEFAULT;
    private static final ImmutableBytesWritable FALSE = new ImmutableBytesWritable(Bytes.toBytes((String)Boolean.FALSE.toString()));
    private static final ImmutableBytesWritable TRUE = new ImmutableBytesWritable(Bytes.toBytes((String)Boolean.TRUE.toString()));
    private static final boolean DEFAULT_DEFERRED_LOG_FLUSH = false;
    public static final boolean DEFAULT_READONLY = false;
    public static final boolean DEFAULT_COMPACTION_ENABLED = true;
    public static final long DEFAULT_MEMSTORE_FLUSH_SIZE = 0x8000000L;
    public static final int DEFAULT_REGION_REPLICATION = 1;
    private static final Map<String, String> DEFAULT_VALUES = new HashMap<String, String>();
    private static final Set<ImmutableBytesWritable> RESERVED_KEYWORDS = new HashSet<ImmutableBytesWritable>();
    private volatile Boolean meta = null;
    private volatile Boolean root = null;
    private Durability durability = null;
    private final Map<byte[], HColumnDescriptor> families = new TreeMap<byte[], HColumnDescriptor>((Comparator<byte[]>)Bytes.BYTES_RAWCOMPARATOR);
    @Deprecated
    public static final HTableDescriptor META_TABLEDESC;
    public static final String NAMESPACE_FAMILY_INFO = "info";
    public static final byte[] NAMESPACE_FAMILY_INFO_BYTES;
    public static final byte[] NAMESPACE_COL_DESC_BYTES;
    public static final HTableDescriptor NAMESPACE_TABLEDESC;

    @InterfaceAudience.Private
    protected HTableDescriptor(TableName name, HColumnDescriptor[] families) {
        this.setName(name);
        for (HColumnDescriptor descriptor : families) {
            this.families.put(descriptor.getName(), descriptor);
        }
    }

    protected HTableDescriptor(TableName name, HColumnDescriptor[] families, Map<ImmutableBytesWritable, ImmutableBytesWritable> values) {
        this.setName(name);
        for (HColumnDescriptor descriptor : families) {
            this.families.put(descriptor.getName(), descriptor);
        }
        for (Map.Entry<ImmutableBytesWritable, ImmutableBytesWritable> entry : values.entrySet()) {
            this.setValue(entry.getKey(), entry.getValue());
        }
    }

    @Deprecated
    public HTableDescriptor() {
    }

    public HTableDescriptor(TableName name) {
        this.setName(name);
    }

    @Deprecated
    public HTableDescriptor(byte[] name) {
        this(TableName.valueOf((byte[])name));
    }

    @Deprecated
    public HTableDescriptor(String name) {
        this(TableName.valueOf((String)name));
    }

    public HTableDescriptor(HTableDescriptor desc) {
        this.setName(desc.name);
        this.setMetaFlags(this.name);
        for (HColumnDescriptor hColumnDescriptor : desc.families.values()) {
            this.families.put(hColumnDescriptor.getName(), new HColumnDescriptor(hColumnDescriptor));
        }
        for (Map.Entry entry : desc.values.entrySet()) {
            this.setValue((ImmutableBytesWritable)entry.getKey(), (ImmutableBytesWritable)entry.getValue());
        }
        for (Map.Entry entry : desc.configuration.entrySet()) {
            this.configuration.put((String)entry.getKey(), (String)entry.getValue());
        }
    }

    private void setMetaFlags(TableName name) {
        this.setMetaRegion(this.isRootRegion() || name.equals((Object)TableName.META_TABLE_NAME));
    }

    public boolean isRootRegion() {
        if (this.root == null) {
            this.root = this.isSomething(IS_ROOT_KEY, false) ? Boolean.TRUE : Boolean.FALSE;
        }
        return this.root;
    }

    protected void setRootRegion(boolean isRoot) {
        this.setValue(IS_ROOT_KEY, isRoot ? TRUE : FALSE);
    }

    public boolean isMetaRegion() {
        if (this.meta == null) {
            this.meta = this.calculateIsMetaRegion();
        }
        return this.meta;
    }

    private synchronized Boolean calculateIsMetaRegion() {
        byte[] value = this.getValue(IS_META_KEY);
        return value != null ? Boolean.valueOf(Bytes.toString((byte[])value)) : Boolean.FALSE;
    }

    private boolean isSomething(ImmutableBytesWritable key, boolean valueIfNull) {
        byte[] value = this.getValue(key);
        if (value != null) {
            return Boolean.valueOf(Bytes.toString((byte[])value));
        }
        return valueIfNull;
    }

    protected void setMetaRegion(boolean isMeta) {
        this.setValue(IS_META_KEY, isMeta ? TRUE : FALSE);
    }

    public boolean isMetaTable() {
        return this.isMetaRegion() && !this.isRootRegion();
    }

    public byte[] getValue(byte[] key) {
        return this.getValue(new ImmutableBytesWritable(key));
    }

    private byte[] getValue(ImmutableBytesWritable key) {
        ImmutableBytesWritable ibw = this.values.get(key);
        if (ibw == null) {
            return null;
        }
        return ibw.get();
    }

    public String getValue(String key) {
        byte[] value = this.getValue(Bytes.toBytes((String)key));
        if (value == null) {
            return null;
        }
        return Bytes.toString((byte[])value);
    }

    public Map<ImmutableBytesWritable, ImmutableBytesWritable> getValues() {
        return Collections.unmodifiableMap(this.values);
    }

    public HTableDescriptor setValue(byte[] key, byte[] value) {
        this.setValue(new ImmutableBytesWritable(key), new ImmutableBytesWritable(value));
        return this;
    }

    private HTableDescriptor setValue(ImmutableBytesWritable key, String value) {
        this.setValue(key, new ImmutableBytesWritable(Bytes.toBytes((String)value)));
        return this;
    }

    public HTableDescriptor setValue(ImmutableBytesWritable key, ImmutableBytesWritable value) {
        if (key.compareTo(DEFERRED_LOG_FLUSH_KEY) == 0) {
            boolean isDeferredFlush = Boolean.valueOf(Bytes.toString((byte[])value.get()));
            LOG.warn((Object)"HTableDescriptor property:DEFERRED_LOG_FLUSH is deprecated, use DURABILITY instead");
            this.setDurability(isDeferredFlush ? Durability.ASYNC_WAL : DEFAULT_DURABLITY);
            return this;
        }
        Matcher matcher = HConstants.CP_HTD_ATTR_KEY_PATTERN.matcher(Bytes.toString((byte[])key.get()));
        if (matcher.matches()) {
            LOG.warn((Object)"Use addCoprocessor* methods to add a coprocessor instead");
        }
        this.values.put(key, value);
        return this;
    }

    public HTableDescriptor setValue(String key, String value) {
        if (value == null) {
            this.remove(key);
        } else {
            this.setValue(Bytes.toBytes((String)key), Bytes.toBytes((String)value));
        }
        return this;
    }

    public void remove(String key) {
        this.remove(new ImmutableBytesWritable(Bytes.toBytes((String)key)));
    }

    public void remove(ImmutableBytesWritable key) {
        this.values.remove(key);
    }

    public void remove(byte[] key) {
        this.remove(new ImmutableBytesWritable(key));
    }

    public boolean isReadOnly() {
        return this.isSomething(READONLY_KEY, false);
    }

    public HTableDescriptor setReadOnly(boolean readOnly) {
        return this.setValue(READONLY_KEY, readOnly ? TRUE : FALSE);
    }

    public boolean isCompactionEnabled() {
        return this.isSomething(COMPACTION_ENABLED_KEY, true);
    }

    public HTableDescriptor setCompactionEnabled(boolean isEnable) {
        this.setValue(COMPACTION_ENABLED_KEY, isEnable ? TRUE : FALSE);
        return this;
    }

    public HTableDescriptor setDurability(Durability durability) {
        this.durability = durability;
        this.setValue(DURABILITY_KEY, durability.name());
        return this;
    }

    public Durability getDurability() {
        if (this.durability == null) {
            byte[] durabilityValue = this.getValue(DURABILITY_KEY);
            if (durabilityValue == null) {
                this.durability = DEFAULT_DURABLITY;
            } else {
                try {
                    this.durability = Durability.valueOf(Bytes.toString((byte[])durabilityValue));
                }
                catch (IllegalArgumentException ex) {
                    LOG.warn((Object)("Received " + ex + " because Durability value for HTableDescriptor" + " is not known. Durability:" + Bytes.toString((byte[])durabilityValue)));
                    this.durability = DEFAULT_DURABLITY;
                }
            }
        }
        return this.durability;
    }

    public TableName getTableName() {
        return this.name;
    }

    @Deprecated
    public byte[] getName() {
        return this.name.getName();
    }

    public String getNameAsString() {
        return this.name.getNameAsString();
    }

    public HTableDescriptor setRegionSplitPolicyClassName(String clazz) {
        this.setValue(SPLIT_POLICY, clazz);
        return this;
    }

    public String getRegionSplitPolicyClassName() {
        return this.getValue(SPLIT_POLICY);
    }

    @Deprecated
    public HTableDescriptor setName(byte[] name) {
        this.setName(TableName.valueOf((byte[])name));
        return this;
    }

    @Deprecated
    public HTableDescriptor setName(TableName name) {
        this.name = name;
        this.setMetaFlags(this.name);
        return this;
    }

    public long getMaxFileSize() {
        byte[] value = this.getValue(MAX_FILESIZE_KEY);
        if (value != null) {
            return Long.parseLong(Bytes.toString((byte[])value));
        }
        return -1L;
    }

    public HTableDescriptor setMaxFileSize(long maxFileSize) {
        this.setValue(MAX_FILESIZE_KEY, Long.toString(maxFileSize));
        return this;
    }

    public long getMemStoreFlushSize() {
        byte[] value = this.getValue(MEMSTORE_FLUSHSIZE_KEY);
        if (value != null) {
            return Long.parseLong(Bytes.toString((byte[])value));
        }
        return -1L;
    }

    public HTableDescriptor setMemStoreFlushSize(long memstoreFlushSize) {
        this.setValue(MEMSTORE_FLUSHSIZE_KEY, Long.toString(memstoreFlushSize));
        return this;
    }

    public HTableDescriptor addFamily(HColumnDescriptor family) {
        if (family.getName() == null || family.getName().length <= 0) {
            throw new IllegalArgumentException("Family name cannot be null or empty");
        }
        if (this.hasFamily(family.getName())) {
            throw new IllegalArgumentException("Family '" + family.getNameAsString() + "' already exists so cannot be added");
        }
        this.families.put(family.getName(), family);
        return this;
    }

    public HTableDescriptor modifyFamily(HColumnDescriptor family) {
        if (family.getName() == null || family.getName().length <= 0) {
            throw new IllegalArgumentException("Family name cannot be null or empty");
        }
        if (!this.hasFamily(family.getName())) {
            throw new IllegalArgumentException("Column family '" + family.getNameAsString() + "' does not exist");
        }
        this.families.put(family.getName(), family);
        return this;
    }

    public boolean hasFamily(byte[] familyName) {
        return this.families.containsKey(familyName);
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append('\'').append(Bytes.toString((byte[])this.name.getName())).append('\'');
        s.append((CharSequence)this.getValues(true));
        for (HColumnDescriptor f : this.families.values()) {
            s.append(", ").append(f);
        }
        return s.toString();
    }

    public String toStringCustomizedValues() {
        StringBuilder s = new StringBuilder();
        s.append('\'').append(Bytes.toString((byte[])this.name.getName())).append('\'');
        s.append((CharSequence)this.getValues(false));
        for (HColumnDescriptor hcd : this.families.values()) {
            s.append(", ").append(hcd.toStringCustomizedValues());
        }
        return s.toString();
    }

    public String toStringTableAttributes() {
        return this.getValues(true).toString();
    }

    private StringBuilder getValues(boolean printDefaults) {
        boolean hasAttributes;
        StringBuilder s = new StringBuilder();
        TreeSet<ImmutableBytesWritable> reservedKeys = new TreeSet<ImmutableBytesWritable>();
        TreeSet<ImmutableBytesWritable> userKeys = new TreeSet<ImmutableBytesWritable>();
        for (ImmutableBytesWritable k : this.values.keySet()) {
            if (k == null || k.get() == null) continue;
            String key = Bytes.toString((byte[])k.get());
            if (!RESERVED_KEYWORDS.contains(k) && !key.startsWith("coprocessor$")) {
                userKeys.add(k);
                continue;
            }
            String value = Bytes.toString((byte[])this.values.get(k).get());
            if ((key.equalsIgnoreCase(IS_ROOT) || key.equalsIgnoreCase(IS_META)) && !Boolean.valueOf(value).booleanValue() || !printDefaults && DEFAULT_VALUES.containsKey(key) && DEFAULT_VALUES.get(key).equalsIgnoreCase(value)) continue;
            reservedKeys.add(k);
        }
        boolean bl = hasAttributes = !reservedKeys.isEmpty() || !userKeys.isEmpty();
        if (!hasAttributes && this.configuration.isEmpty()) {
            return s;
        }
        s.append(", {");
        if (hasAttributes) {
            s.append("TABLE_ATTRIBUTES => {");
            boolean printCommaForAttr = false;
            for (ImmutableBytesWritable k : reservedKeys) {
                String key = Bytes.toString((byte[])k.get());
                String value = Bytes.toStringBinary((byte[])this.values.get(k).get());
                if (printCommaForAttr) {
                    s.append(", ");
                }
                printCommaForAttr = true;
                s.append(key);
                s.append(" => ");
                s.append('\'').append(value).append('\'');
            }
            if (!userKeys.isEmpty()) {
                if (printCommaForAttr) {
                    s.append(", ");
                }
                printCommaForAttr = true;
                s.append("METADATA").append(" => ");
                s.append("{");
                boolean printCommaForCfg = false;
                for (ImmutableBytesWritable k : userKeys) {
                    String key = Bytes.toString((byte[])k.get());
                    String value = Bytes.toStringBinary((byte[])this.values.get(k).get());
                    if (printCommaForCfg) {
                        s.append(", ");
                    }
                    printCommaForCfg = true;
                    s.append('\'').append(key).append('\'');
                    s.append(" => ");
                    s.append('\'').append(value).append('\'');
                }
                s.append("}");
            }
        }
        if (!this.configuration.isEmpty()) {
            if (hasAttributes) {
                s.append(", ");
            }
            s.append("CONFIGURATION").append(" => ");
            s.append('{');
            boolean printCommaForConfig = false;
            for (Map.Entry<String, String> e : this.configuration.entrySet()) {
                if (printCommaForConfig) {
                    s.append(", ");
                }
                printCommaForConfig = true;
                s.append('\'').append(e.getKey()).append('\'');
                s.append(" => ");
                s.append('\'').append(e.getValue()).append('\'');
            }
            s.append("}");
        }
        s.append("}");
        return s;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HTableDescriptor)) {
            return false;
        }
        return this.compareTo((HTableDescriptor)obj) == 0;
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result ^= Byte.valueOf((byte)7).hashCode();
        if (this.families != null && this.families.size() > 0) {
            for (HColumnDescriptor e : this.families.values()) {
                result ^= e.hashCode();
            }
        }
        result ^= this.values.hashCode();
        return result ^= this.configuration.hashCode();
    }

    @Deprecated
    public void readFields(DataInput in) throws IOException {
        int version = in.readInt();
        if (version < 3) {
            throw new IOException("versions < 3 are not supported (and never existed!?)");
        }
        this.name = TableName.valueOf((byte[])Bytes.readByteArray((DataInput)in));
        this.setRootRegion(in.readBoolean());
        this.setMetaRegion(in.readBoolean());
        this.values.clear();
        this.configuration.clear();
        int numVals = in.readInt();
        for (int i = 0; i < numVals; ++i) {
            ImmutableBytesWritable key = new ImmutableBytesWritable();
            ImmutableBytesWritable value = new ImmutableBytesWritable();
            key.readFields(in);
            value.readFields(in);
            this.setValue(key, value);
        }
        this.families.clear();
        int numFamilies = in.readInt();
        for (int i = 0; i < numFamilies; ++i) {
            HColumnDescriptor c = new HColumnDescriptor();
            c.readFields(in);
            this.families.put(c.getName(), c);
        }
        if (version >= 7) {
            int numConfigs = in.readInt();
            for (int i = 0; i < numConfigs; ++i) {
                ImmutableBytesWritable key = new ImmutableBytesWritable();
                ImmutableBytesWritable value = new ImmutableBytesWritable();
                key.readFields(in);
                value.readFields(in);
                this.configuration.put(Bytes.toString((byte[])key.get(), (int)key.getOffset(), (int)key.getLength()), Bytes.toString((byte[])value.get(), (int)value.getOffset(), (int)value.getLength()));
            }
        }
    }

    @Deprecated
    public void write(DataOutput out) throws IOException {
        out.writeInt(7);
        Bytes.writeByteArray((DataOutput)out, (byte[])this.name.toBytes());
        out.writeBoolean(this.isRootRegion());
        out.writeBoolean(this.isMetaRegion());
        out.writeInt(this.values.size());
        for (Map.Entry<ImmutableBytesWritable, ImmutableBytesWritable> entry : this.values.entrySet()) {
            entry.getKey().write(out);
            entry.getValue().write(out);
        }
        out.writeInt(this.families.size());
        for (HColumnDescriptor hColumnDescriptor : this.families.values()) {
            hColumnDescriptor.write(out);
        }
        out.writeInt(this.configuration.size());
        for (Map.Entry<Object, Object> entry : this.configuration.entrySet()) {
            new ImmutableBytesWritable(Bytes.toBytes((String)((String)entry.getKey()))).write(out);
            new ImmutableBytesWritable(Bytes.toBytes((String)((String)entry.getValue()))).write(out);
        }
    }

    public int compareTo(HTableDescriptor other) {
        int result = this.name.compareTo(other.name);
        if (result == 0) {
            result = this.families.size() - other.families.size();
        }
        if (result == 0 && this.families.size() != other.families.size()) {
            result = Integer.valueOf(this.families.size()).compareTo(other.families.size());
        }
        if (result == 0) {
            Iterator<HColumnDescriptor> it = this.families.values().iterator();
            Iterator<HColumnDescriptor> it2 = other.families.values().iterator();
            while (it.hasNext() && (result = it.next().compareTo(it2.next())) == 0) {
            }
        }
        if (result == 0) {
            result = this.values.hashCode() - other.values.hashCode();
            if (result < 0) {
                result = -1;
            } else if (result > 0) {
                result = 1;
            }
        }
        if (result == 0) {
            result = this.configuration.hashCode() - other.configuration.hashCode();
            if (result < 0) {
                result = -1;
            } else if (result > 0) {
                result = 1;
            }
        }
        return result;
    }

    public Collection<HColumnDescriptor> getFamilies() {
        return Collections.unmodifiableCollection(this.families.values());
    }

    public int getRegionReplication() {
        byte[] val = this.getValue(REGION_REPLICATION_KEY);
        if (val == null || val.length == 0) {
            return 1;
        }
        return Integer.parseInt(Bytes.toString((byte[])val));
    }

    public HTableDescriptor setRegionReplication(int regionReplication) {
        this.setValue(REGION_REPLICATION_KEY, new ImmutableBytesWritable(Bytes.toBytes((String)Integer.toString(regionReplication))));
        return this;
    }

    public Set<byte[]> getFamiliesKeys() {
        return Collections.unmodifiableSet(this.families.keySet());
    }

    public HColumnDescriptor[] getColumnFamilies() {
        Collection<HColumnDescriptor> hColumnDescriptors = this.getFamilies();
        return hColumnDescriptors.toArray(new HColumnDescriptor[hColumnDescriptors.size()]);
    }

    public HColumnDescriptor getFamily(byte[] column) {
        return this.families.get(column);
    }

    public HColumnDescriptor removeFamily(byte[] column) {
        return this.families.remove(column);
    }

    public HTableDescriptor addCoprocessor(String className) throws IOException {
        this.addCoprocessor(className, null, 0x3FFFFFFF, null);
        return this;
    }

    public HTableDescriptor addCoprocessor(String className, Path jarFilePath, int priority, Map<String, String> kvs) throws IOException {
        this.checkHasCoprocessor(className);
        StringBuilder kvString = new StringBuilder();
        if (kvs != null) {
            for (Map.Entry<String, String> e : kvs.entrySet()) {
                if (!e.getKey().matches("[^=,]+")) {
                    throw new IOException("Illegal parameter key = " + e.getKey());
                }
                if (!e.getValue().matches("[^,]+")) {
                    throw new IOException("Illegal parameter (" + e.getKey() + ") value = " + e.getValue());
                }
                if (kvString.length() != 0) {
                    kvString.append(',');
                }
                kvString.append(e.getKey());
                kvString.append('=');
                kvString.append(e.getValue());
            }
        }
        String value = (jarFilePath == null ? "" : jarFilePath.toString()) + "|" + className + "|" + Integer.toString(priority) + "|" + kvString.toString();
        return this.addCoprocessorToMap(value);
    }

    public HTableDescriptor addCoprocessorWithSpec(String specStr) throws IOException {
        String className = HTableDescriptor.getCoprocessorClassNameFromSpecStr(specStr);
        if (className == null) {
            throw new IllegalArgumentException("Format does not match " + HConstants.CP_HTD_ATTR_VALUE_PATTERN + ": " + specStr);
        }
        this.checkHasCoprocessor(className);
        return this.addCoprocessorToMap(specStr);
    }

    private void checkHasCoprocessor(String className) throws IOException {
        if (this.hasCoprocessor(className)) {
            throw new IOException("Coprocessor " + className + " already exists.");
        }
    }

    private HTableDescriptor addCoprocessorToMap(String specStr) {
        if (specStr == null) {
            return this;
        }
        int maxCoprocessorNumber = 0;
        for (Map.Entry<ImmutableBytesWritable, ImmutableBytesWritable> e : this.values.entrySet()) {
            Matcher keyMatcher = HConstants.CP_HTD_ATTR_KEY_PATTERN.matcher(Bytes.toString((byte[])e.getKey().get()));
            if (!keyMatcher.matches()) continue;
            maxCoprocessorNumber = Math.max(Integer.parseInt(keyMatcher.group(1)), maxCoprocessorNumber);
        }
        String key = "coprocessor$" + Integer.toString(++maxCoprocessorNumber);
        this.values.put(new ImmutableBytesWritable(Bytes.toBytes((String)key)), new ImmutableBytesWritable(Bytes.toBytes((String)specStr)));
        return this;
    }

    public boolean hasCoprocessor(String classNameToMatch) {
        for (Map.Entry<ImmutableBytesWritable, ImmutableBytesWritable> e : this.values.entrySet()) {
            String className;
            Matcher keyMatcher = HConstants.CP_HTD_ATTR_KEY_PATTERN.matcher(Bytes.toString((byte[])e.getKey().get()));
            if (!keyMatcher.matches() || (className = HTableDescriptor.getCoprocessorClassNameFromSpecStr(Bytes.toString((byte[])e.getValue().get()))) == null || !className.equals(classNameToMatch.trim())) continue;
            return true;
        }
        return false;
    }

    public List<String> getCoprocessors() {
        ArrayList<String> result = new ArrayList<String>();
        for (Map.Entry<ImmutableBytesWritable, ImmutableBytesWritable> e : this.values.entrySet()) {
            String className;
            Matcher keyMatcher = HConstants.CP_HTD_ATTR_KEY_PATTERN.matcher(Bytes.toString((byte[])e.getKey().get()));
            if (!keyMatcher.matches() || (className = HTableDescriptor.getCoprocessorClassNameFromSpecStr(Bytes.toString((byte[])e.getValue().get()))) == null) continue;
            result.add(className);
        }
        return result;
    }

    private static String getCoprocessorClassNameFromSpecStr(String spec) {
        Matcher matcher = HConstants.CP_HTD_ATTR_VALUE_PATTERN.matcher(spec);
        return matcher != null && matcher.matches() ? matcher.group(2).trim() : null;
    }

    public void removeCoprocessor(String className) {
        ImmutableBytesWritable match = null;
        for (Map.Entry<ImmutableBytesWritable, ImmutableBytesWritable> e : this.values.entrySet()) {
            String clazz;
            Matcher valueMatcher;
            Matcher keyMatcher = HConstants.CP_HTD_ATTR_KEY_PATTERN.matcher(Bytes.toString((byte[])e.getKey().get()));
            if (!keyMatcher.matches() || !(valueMatcher = HConstants.CP_HTD_ATTR_VALUE_PATTERN.matcher(Bytes.toString((byte[])e.getValue().get()))).matches() || !(clazz = valueMatcher.group(2).trim()).equals(className.trim())) continue;
            match = e.getKey();
            break;
        }
        if (match != null) {
            this.remove(match);
        }
    }

    @Deprecated
    public static Path getTableDir(Path rootdir, byte[] tableName) {
        TableName name = TableName.valueOf((byte[])tableName);
        return new Path(rootdir, new Path("data", new Path(name.getNamespaceAsString(), new Path(name.getQualifierAsString()))));
    }

    @Deprecated
    public HTableDescriptor setOwner(User owner) {
        return this.setOwnerString(owner != null ? owner.getShortName() : null);
    }

    @Deprecated
    public HTableDescriptor setOwnerString(String ownerString) {
        if (ownerString != null) {
            this.setValue(OWNER_KEY, ownerString);
        } else {
            this.remove(OWNER_KEY);
        }
        return this;
    }

    @Deprecated
    public String getOwnerString() {
        if (this.getValue(OWNER_KEY) != null) {
            return Bytes.toString((byte[])this.getValue(OWNER_KEY));
        }
        return null;
    }

    public byte[] toByteArray() {
        return ProtobufUtil.prependPBMagic(this.convert().toByteArray());
    }

    public static HTableDescriptor parseFrom(byte[] bytes) throws DeserializationException, IOException {
        HBaseProtos.TableSchema ts;
        if (!ProtobufUtil.isPBMagicPrefix(bytes)) {
            return (HTableDescriptor)Writables.getWritable(bytes, (Writable)new HTableDescriptor());
        }
        int pblen = ProtobufUtil.lengthOfPBMagic();
        HBaseProtos.TableSchema.Builder builder = HBaseProtos.TableSchema.newBuilder();
        try {
            ProtobufUtil.mergeFrom((Message.Builder)builder, bytes, pblen, bytes.length - pblen);
            ts = builder.build();
        }
        catch (IOException e) {
            throw new DeserializationException(e);
        }
        return HTableDescriptor.convert(ts);
    }

    public HBaseProtos.TableSchema convert() {
        HBaseProtos.TableSchema.Builder builder = HBaseProtos.TableSchema.newBuilder();
        builder.setTableName(ProtobufUtil.toProtoTableName(this.getTableName()));
        for (Map.Entry<ImmutableBytesWritable, ImmutableBytesWritable> entry : this.values.entrySet()) {
            HBaseProtos.BytesBytesPair.Builder aBuilder = HBaseProtos.BytesBytesPair.newBuilder();
            aBuilder.setFirst(ByteStringer.wrap((byte[])entry.getKey().get()));
            aBuilder.setSecond(ByteStringer.wrap((byte[])entry.getValue().get()));
            builder.addAttributes(aBuilder.build());
        }
        for (HColumnDescriptor hcd : this.getColumnFamilies()) {
            builder.addColumnFamilies(hcd.convert());
        }
        for (Map.Entry<Object, Object> entry : this.configuration.entrySet()) {
            HBaseProtos.NameStringPair.Builder aBuilder = HBaseProtos.NameStringPair.newBuilder();
            aBuilder.setName((String)entry.getKey());
            aBuilder.setValue((String)entry.getValue());
            builder.addConfiguration(aBuilder.build());
        }
        return builder.build();
    }

    public static HTableDescriptor convert(HBaseProtos.TableSchema ts) {
        List list = ts.getColumnFamiliesList();
        HColumnDescriptor[] hcds = new HColumnDescriptor[list.size()];
        int index = 0;
        for (HBaseProtos.ColumnFamilySchema cfs : list) {
            hcds[index++] = HColumnDescriptor.convert(cfs);
        }
        HTableDescriptor htd = new HTableDescriptor(ProtobufUtil.toTableName(ts.getTableName()), hcds);
        for (HBaseProtos.BytesBytesPair a : ts.getAttributesList()) {
            htd.setValue(a.getFirst().toByteArray(), a.getSecond().toByteArray());
        }
        for (HBaseProtos.BytesBytesPair a : ts.getConfigurationList()) {
            htd.setConfiguration(a.getName(), a.getValue());
        }
        return htd;
    }

    public String getConfigurationValue(String key) {
        return this.configuration.get(key);
    }

    public Map<String, String> getConfiguration() {
        return Collections.unmodifiableMap(this.configuration);
    }

    public HTableDescriptor setConfiguration(String key, String value) {
        if (value == null) {
            this.removeConfiguration(key);
        } else {
            this.configuration.put(key, value);
        }
        return this;
    }

    public void removeConfiguration(String key) {
        this.configuration.remove(key);
    }

    public static HTableDescriptor metaTableDescriptor(Configuration conf) throws IOException {
        HTableDescriptor metaDescriptor = new HTableDescriptor(TableName.META_TABLE_NAME, new HColumnDescriptor[]{new HColumnDescriptor(HConstants.CATALOG_FAMILY).setMaxVersions(conf.getInt(HConstants.HBASE_META_VERSIONS, HConstants.DEFAULT_HBASE_META_VERSIONS)).setInMemory(true).setBlocksize(conf.getInt(HConstants.HBASE_META_BLOCK_SIZE, HConstants.DEFAULT_HBASE_META_BLOCK_SIZE)).setScope(0).setBloomFilterType(BloomType.NONE)});
        metaDescriptor.addCoprocessor("org.apache.hadoop.hbase.coprocessor.MultiRowMutationEndpoint", null, 0x1FFFFFFF, null);
        return metaDescriptor;
    }

    static {
        DEFAULT_VALUES.put(MAX_FILESIZE, String.valueOf(0x280000000L));
        DEFAULT_VALUES.put(READONLY, String.valueOf(false));
        DEFAULT_VALUES.put(MEMSTORE_FLUSHSIZE, String.valueOf(0x8000000L));
        DEFAULT_VALUES.put(DEFERRED_LOG_FLUSH, String.valueOf(false));
        DEFAULT_VALUES.put(DURABILITY, DEFAULT_DURABLITY.name());
        DEFAULT_VALUES.put(REGION_REPLICATION, String.valueOf(1));
        for (String s : DEFAULT_VALUES.keySet()) {
            RESERVED_KEYWORDS.add(new ImmutableBytesWritable(Bytes.toBytes((String)s)));
        }
        RESERVED_KEYWORDS.add(IS_ROOT_KEY);
        RESERVED_KEYWORDS.add(IS_META_KEY);
        META_TABLEDESC = new HTableDescriptor(TableName.META_TABLE_NAME, new HColumnDescriptor[]{new HColumnDescriptor(HConstants.CATALOG_FAMILY).setMaxVersions(HConstants.DEFAULT_HBASE_META_VERSIONS).setInMemory(true).setBlocksize(HConstants.DEFAULT_HBASE_META_BLOCK_SIZE).setScope(0).setBloomFilterType(BloomType.NONE).setCacheDataInL1(true)});
        try {
            META_TABLEDESC.addCoprocessor("org.apache.hadoop.hbase.coprocessor.MultiRowMutationEndpoint", null, 0x1FFFFFFF, null);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        NAMESPACE_FAMILY_INFO_BYTES = Bytes.toBytes((String)NAMESPACE_FAMILY_INFO);
        NAMESPACE_COL_DESC_BYTES = Bytes.toBytes((String)"d");
        NAMESPACE_TABLEDESC = new HTableDescriptor(TableName.NAMESPACE_TABLE_NAME, new HColumnDescriptor[]{new HColumnDescriptor(NAMESPACE_FAMILY_INFO).setMaxVersions(10).setInMemory(true).setBlocksize(8192).setScope(0).setCacheDataInL1(true)});
    }
}

