/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication;

import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.generated.ZooKeeperProtos;
import org.apache.hadoop.hbase.replication.ReplicationException;
import org.apache.hadoop.hbase.replication.ReplicationQueueInfo;
import org.apache.hadoop.hbase.replication.ReplicationQueues;
import org.apache.hadoop.hbase.replication.ReplicationStateZKBase;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.zookeeper.KeeperException;

@InterfaceAudience.Private
public class ReplicationQueuesZKImpl
extends ReplicationStateZKBase
implements ReplicationQueues {
    private String myQueuesZnode;
    public static final String RS_LOCK_ZNODE = "lock";
    private static final Log LOG = LogFactory.getLog(ReplicationQueuesZKImpl.class);

    public ReplicationQueuesZKImpl(ZooKeeperWatcher zk, Configuration conf, Abortable abortable) {
        super(zk, conf, abortable);
    }

    @Override
    public void init(String serverName) throws ReplicationException {
        this.myQueuesZnode = ZKUtil.joinZNode(this.queuesZNode, serverName);
        try {
            if (ZKUtil.checkExists(this.zookeeper, this.myQueuesZnode) < 0) {
                ZKUtil.createWithParents(this.zookeeper, this.myQueuesZnode);
            }
        }
        catch (KeeperException e) {
            throw new ReplicationException("Could not initialize replication queues.", e);
        }
        if (this.conf.getBoolean("hbase.replication.bulkload.enabled", false)) {
            try {
                if (ZKUtil.checkExists(this.zookeeper, this.hfileRefsZNode) < 0) {
                    ZKUtil.createWithParents(this.zookeeper, this.hfileRefsZNode);
                }
            }
            catch (KeeperException e) {
                throw new ReplicationException("Could not initialize hfile references replication queue.", e);
            }
        }
    }

    @Override
    public void removeQueue(String queueId) {
        try {
            ZKUtil.deleteNodeRecursively(this.zookeeper, ZKUtil.joinZNode(this.myQueuesZnode, queueId));
        }
        catch (KeeperException e) {
            this.abortable.abort("Failed to delete queue (queueId=" + queueId + ")", e);
        }
    }

    @Override
    public void addLog(String queueId, String filename) throws ReplicationException {
        String znode = ZKUtil.joinZNode(this.myQueuesZnode, queueId);
        znode = ZKUtil.joinZNode(znode, filename);
        try {
            ZKUtil.createWithParents(this.zookeeper, znode);
        }
        catch (KeeperException e) {
            throw new ReplicationException("Could not add log because znode could not be created. queueId=" + queueId + ", filename=" + filename);
        }
    }

    @Override
    public void removeLog(String queueId, String filename) {
        try {
            String znode = ZKUtil.joinZNode(this.myQueuesZnode, queueId);
            znode = ZKUtil.joinZNode(znode, filename);
            ZKUtil.deleteNode(this.zookeeper, znode);
        }
        catch (KeeperException e) {
            this.abortable.abort("Failed to remove wal from queue (queueId=" + queueId + ", filename=" + filename + ")", e);
        }
    }

    @Override
    public void setLogPosition(String queueId, String filename, long position) {
        try {
            String znode = ZKUtil.joinZNode(this.myQueuesZnode, queueId);
            znode = ZKUtil.joinZNode(znode, filename);
            ZKUtil.setData(this.zookeeper, znode, ZKUtil.positionToByteArray(position));
        }
        catch (KeeperException e) {
            this.abortable.abort("Failed to write replication wal position (filename=" + filename + ", position=" + position + ")", e);
        }
    }

    @Override
    public long getLogPosition(String queueId, String filename) throws ReplicationException {
        String clusterZnode = ZKUtil.joinZNode(this.myQueuesZnode, queueId);
        String znode = ZKUtil.joinZNode(clusterZnode, filename);
        byte[] bytes = null;
        try {
            bytes = ZKUtil.getData(this.zookeeper, znode);
        }
        catch (KeeperException e) {
            throw new ReplicationException("Internal Error: could not get position in log for queueId=" + queueId + ", filename=" + filename, e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return 0L;
        }
        try {
            return ZKUtil.parseWALPositionFrom(bytes);
        }
        catch (DeserializationException de) {
            LOG.warn((Object)("Failed to parse WALPosition for queueId=" + queueId + " and wal=" + filename + " znode content, continuing."));
            return 0L;
        }
    }

    @Override
    public boolean isThisOurZnode(String znode) {
        return ZKUtil.joinZNode(this.queuesZNode, znode).equals(this.myQueuesZnode);
    }

    @Override
    public void removeAllQueues() {
        try {
            ZKUtil.deleteNodeRecursively(this.zookeeper, this.myQueuesZnode);
        }
        catch (KeeperException e) {
            if (e instanceof KeeperException.SessionExpiredException) {
                return;
            }
            this.abortable.abort("Failed to delete replication queues for region server: " + this.myQueuesZnode, e);
        }
    }

    @Override
    public List<String> getLogsInQueue(String queueId) {
        String znode = ZKUtil.joinZNode(this.myQueuesZnode, queueId);
        List<String> result = null;
        try {
            result = ZKUtil.listChildrenNoWatch(this.zookeeper, znode);
        }
        catch (KeeperException e) {
            this.abortable.abort("Failed to get list of wals for queueId=" + queueId, e);
        }
        return result;
    }

    @Override
    public List<String> getAllQueues() {
        List<String> listOfQueues = null;
        try {
            listOfQueues = ZKUtil.listChildrenNoWatch(this.zookeeper, this.myQueuesZnode);
        }
        catch (KeeperException e) {
            this.abortable.abort("Failed to get a list of queues for region server: " + this.myQueuesZnode, e);
        }
        return listOfQueues;
    }

    @Override
    public boolean isThisOurRegionServer(String regionserver) {
        return ZKUtil.joinZNode(this.queuesZNode, regionserver).equals(this.myQueuesZnode);
    }

    @Override
    public List<String> getUnClaimedQueueIds(String regionserver) {
        if (this.isThisOurRegionServer(regionserver)) {
            return null;
        }
        String rsZnodePath = ZKUtil.joinZNode(this.queuesZNode, regionserver);
        List<String> queues = null;
        try {
            queues = ZKUtil.listChildrenNoWatch(this.zookeeper, rsZnodePath);
        }
        catch (KeeperException e) {
            this.abortable.abort("Failed to getUnClaimedQueueIds for " + regionserver, e);
        }
        if (queues != null) {
            queues.remove(RS_LOCK_ZNODE);
        }
        return queues;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Pair<String, SortedSet<String>> claimQueue(String regionserver, String queueId) {
        Pair<String, SortedSet<String>> newQueues;
        if (this.conf.getBoolean("hbase.zookeeper.useMulti", true)) {
            LOG.info((Object)("Atomically moving " + regionserver + "/" + queueId + "'s WALs to my queue"));
            return this.moveQueueUsingMulti(regionserver, queueId);
        }
        LOG.info((Object)("Moving " + regionserver + "/" + queueId + "'s wals to my queue"));
        if (!this.lockOtherRS(regionserver)) {
            LOG.info((Object)"Can not take the lock now");
            return null;
        }
        try {
            newQueues = this.copyQueueFromLockedRS(regionserver, queueId);
            this.removeQueueFromLockedRS(regionserver, queueId);
        }
        finally {
            this.unlockOtherRS(regionserver);
        }
        return newQueues;
    }

    private void removeQueueFromLockedRS(String znode, String peerId) {
        String nodePath = ZKUtil.joinZNode(this.queuesZNode, znode);
        String peerPath = ZKUtil.joinZNode(nodePath, peerId);
        try {
            ZKUtil.deleteNodeRecursively(this.zookeeper, peerPath);
        }
        catch (KeeperException e) {
            LOG.warn((Object)"Remove copied queue failed", (Throwable)e);
        }
    }

    @Override
    public void removeReplicatorIfQueueIsEmpty(String regionserver) {
        String rsPath = ZKUtil.joinZNode(this.queuesZNode, regionserver);
        try {
            List<String> list = ZKUtil.listChildrenNoWatch(this.zookeeper, rsPath);
            if (list != null && list.size() == 0) {
                ZKUtil.deleteNode(this.zookeeper, rsPath);
            }
        }
        catch (KeeperException e) {
            LOG.warn((Object)"Got error while removing replicator", (Throwable)e);
        }
    }

    @VisibleForTesting
    public boolean lockOtherRS(String znode) {
        try {
            String parent = ZKUtil.joinZNode(this.queuesZNode, znode);
            if (parent.equals(this.myQueuesZnode)) {
                LOG.warn((Object)"Won't lock because this is us, we're dead!");
                return false;
            }
            String p = ZKUtil.joinZNode(parent, RS_LOCK_ZNODE);
            ZKUtil.createAndWatch(this.zookeeper, p, ReplicationQueuesZKImpl.lockToByteArray(this.myQueuesZnode));
        }
        catch (KeeperException e) {
            if (e instanceof KeeperException.NoNodeException || e instanceof KeeperException.NodeExistsException) {
                LOG.info((Object)("Won't transfer the queue, another RS took care of it because of: " + e.getMessage()));
            } else {
                LOG.info((Object)"Failed lock other rs", (Throwable)e);
            }
            return false;
        }
        return true;
    }

    public String getLockZNode(String znode) {
        return this.queuesZNode + "/" + znode + "/" + RS_LOCK_ZNODE;
    }

    @VisibleForTesting
    public boolean checkLockExists(String znode) throws KeeperException {
        return ZKUtil.checkExists(this.zookeeper, this.getLockZNode(znode)) >= 0;
    }

    private void unlockOtherRS(String znode) {
        String parent = ZKUtil.joinZNode(this.queuesZNode, znode);
        String p = ZKUtil.joinZNode(parent, RS_LOCK_ZNODE);
        try {
            ZKUtil.deleteNode(this.zookeeper, p);
        }
        catch (KeeperException e) {
            this.abortable.abort("Remove lock failed", e);
        }
    }

    private void deleteAnotherRSQueues(String regionserverZnode) {
        String fullpath = ZKUtil.joinZNode(this.queuesZNode, regionserverZnode);
        try {
            List<String> clusters = ZKUtil.listChildrenNoWatch(this.zookeeper, fullpath);
            for (String cluster : clusters) {
                if (cluster.equals(RS_LOCK_ZNODE)) continue;
                String fullClusterPath = ZKUtil.joinZNode(fullpath, cluster);
                ZKUtil.deleteNodeRecursively(this.zookeeper, fullClusterPath);
            }
            ZKUtil.deleteNodeRecursively(this.zookeeper, fullpath);
        }
        catch (KeeperException e) {
            if ((e instanceof KeeperException.NoNodeException || e instanceof KeeperException.NotEmptyException) && e.getPath().equals(fullpath)) {
                return;
            }
            this.abortable.abort("Failed to delete replication queues for region server: " + regionserverZnode, e);
        }
    }

    private Pair<String, SortedSet<String>> moveQueueUsingMulti(String znode, String peerId) {
        try {
            String deadRSZnodePath = ZKUtil.joinZNode(this.queuesZNode, znode);
            ArrayList<ZKUtil.ZKUtilOp> listOfOps = new ArrayList<ZKUtil.ZKUtilOp>();
            ReplicationQueueInfo replicationQueueInfo = new ReplicationQueueInfo(peerId);
            String newPeerId = peerId + "-" + znode;
            String newPeerZnode = ZKUtil.joinZNode(this.myQueuesZnode, newPeerId);
            String oldClusterZnode = ZKUtil.joinZNode(deadRSZnodePath, peerId);
            List<String> wals = ZKUtil.listChildrenNoWatch(this.zookeeper, oldClusterZnode);
            if (!this.peerExists(replicationQueueInfo.getPeerId())) {
                LOG.warn((Object)("Peer " + replicationQueueInfo.getPeerId() + " didn't exist, will move its queue to avoid the failure of multi op"));
                for (String wal : wals) {
                    String oldWalZnode = ZKUtil.joinZNode(oldClusterZnode, wal);
                    listOfOps.add(ZKUtil.ZKUtilOp.deleteNodeFailSilent(oldWalZnode));
                }
                listOfOps.add(ZKUtil.ZKUtilOp.deleteNodeFailSilent(oldClusterZnode));
                ZKUtil.multiOrSequential(this.zookeeper, listOfOps, false);
                return null;
            }
            TreeSet<String> logQueue = new TreeSet<String>();
            if (wals == null || wals.size() == 0) {
                listOfOps.add(ZKUtil.ZKUtilOp.deleteNodeFailSilent(oldClusterZnode));
            } else {
                ZKUtil.ZKUtilOp op = ZKUtil.ZKUtilOp.createAndFailSilent(newPeerZnode, HConstants.EMPTY_BYTE_ARRAY);
                listOfOps.add(op);
                for (String wal : wals) {
                    String oldWalZnode = ZKUtil.joinZNode(oldClusterZnode, wal);
                    byte[] logOffset = ZKUtil.getData(this.zookeeper, oldWalZnode);
                    LOG.debug((Object)("Creating " + wal + " with data " + Bytes.toString((byte[])logOffset)));
                    String newLogZnode = ZKUtil.joinZNode(newPeerZnode, wal);
                    listOfOps.add(ZKUtil.ZKUtilOp.createAndFailSilent(newLogZnode, logOffset));
                    listOfOps.add(ZKUtil.ZKUtilOp.deleteNodeFailSilent(oldWalZnode));
                    logQueue.add(wal);
                }
                listOfOps.add(ZKUtil.ZKUtilOp.deleteNodeFailSilent(oldClusterZnode));
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)(" The multi list size is: " + listOfOps.size()));
                }
            }
            ZKUtil.multiOrSequential(this.zookeeper, listOfOps, false);
            LOG.info((Object)("Atomically moved " + znode + "/" + peerId + "'s WALs to my queue"));
            return new Pair((Object)newPeerId, logQueue);
        }
        catch (KeeperException e) {
            LOG.warn((Object)"Got exception in copyQueuesFromRSUsingMulti: ", (Throwable)e);
        }
        catch (InterruptedException e) {
            LOG.warn((Object)"Got exception in copyQueuesFromRSUsingMulti: ", (Throwable)e);
            Thread.currentThread().interrupt();
        }
        return null;
    }

    private Pair<String, SortedSet<String>> copyQueueFromLockedRS(String znode, String peerId) {
        try {
            String nodePath = ZKUtil.joinZNode(this.queuesZNode, znode);
            ReplicationQueueInfo replicationQueueInfo = new ReplicationQueueInfo(peerId);
            String clusterPath = ZKUtil.joinZNode(nodePath, peerId);
            if (!this.peerExists(replicationQueueInfo.getPeerId())) {
                LOG.warn((Object)("Peer " + peerId + " didn't exist, skipping the replay"));
                return null;
            }
            String newCluster = peerId + "-" + znode;
            String newClusterZnode = ZKUtil.joinZNode(this.myQueuesZnode, newCluster);
            List<String> wals = ZKUtil.listChildrenNoWatch(this.zookeeper, clusterPath);
            if (wals == null || wals.size() == 0) {
                return null;
            }
            ZKUtil.createNodeIfNotExistsAndWatch(this.zookeeper, newClusterZnode, HConstants.EMPTY_BYTE_ARRAY);
            TreeSet<String> logQueue = new TreeSet<String>();
            for (String wal : wals) {
                String z = ZKUtil.joinZNode(clusterPath, wal);
                byte[] positionBytes = ZKUtil.getData(this.zookeeper, z);
                long position = 0L;
                try {
                    position = ZKUtil.parseWALPositionFrom(positionBytes);
                }
                catch (DeserializationException e) {
                    LOG.warn((Object)("Failed parse of wal position from the following znode: " + z + ", Exception: " + e));
                }
                LOG.debug((Object)("Creating " + wal + " with data " + position));
                String child = ZKUtil.joinZNode(newClusterZnode, wal);
                ZKUtil.createNodeIfNotExistsAndWatch(this.zookeeper, child, positionBytes);
                logQueue.add(wal);
            }
            return new Pair((Object)newCluster, logQueue);
        }
        catch (KeeperException e) {
            LOG.warn((Object)"Got exception in copyQueueFromLockedRS: ", (Throwable)e);
        }
        catch (InterruptedException e) {
            LOG.warn((Object)e);
            Thread.currentThread().interrupt();
        }
        return null;
    }

    static byte[] lockToByteArray(String lockOwner) {
        byte[] bytes = ZooKeeperProtos.ReplicationLock.newBuilder().setLockOwner(lockOwner).build().toByteArray();
        return ProtobufUtil.prependPBMagic(bytes);
    }

    @Override
    public void addHFileRefs(String peerId, List<Pair<Path, Path>> pairs) throws ReplicationException {
        String peerZnode = ZKUtil.joinZNode(this.hfileRefsZNode, peerId);
        boolean debugEnabled = LOG.isDebugEnabled();
        if (debugEnabled) {
            LOG.debug((Object)("Adding hfile references " + pairs + " in queue " + peerZnode));
        }
        ArrayList<ZKUtil.ZKUtilOp> listOfOps = new ArrayList<ZKUtil.ZKUtilOp>();
        int size = pairs.size();
        for (int i = 0; i < size; ++i) {
            listOfOps.add(ZKUtil.ZKUtilOp.createAndFailSilent(ZKUtil.joinZNode(peerZnode, ((Path)pairs.get(i).getSecond()).getName()), HConstants.EMPTY_BYTE_ARRAY));
        }
        if (debugEnabled) {
            LOG.debug((Object)(" The multi list size for adding hfile references in zk for node " + peerZnode + " is " + listOfOps.size()));
        }
        try {
            ZKUtil.multiOrSequential(this.zookeeper, listOfOps, true);
        }
        catch (KeeperException e) {
            throw new ReplicationException("Failed to create hfile reference znode=" + e.getPath(), e);
        }
    }

    @Override
    public void removeHFileRefs(String peerId, List<String> files) {
        String peerZnode = ZKUtil.joinZNode(this.hfileRefsZNode, peerId);
        boolean debugEnabled = LOG.isDebugEnabled();
        if (debugEnabled) {
            LOG.debug((Object)("Removing hfile references " + files + " from queue " + peerZnode));
        }
        ArrayList<ZKUtil.ZKUtilOp> listOfOps = new ArrayList<ZKUtil.ZKUtilOp>();
        int size = files.size();
        for (int i = 0; i < size; ++i) {
            listOfOps.add(ZKUtil.ZKUtilOp.deleteNodeFailSilent(ZKUtil.joinZNode(peerZnode, files.get(i))));
        }
        if (debugEnabled) {
            LOG.debug((Object)(" The multi list size for removing hfile references in zk for node " + peerZnode + " is " + listOfOps.size()));
        }
        try {
            ZKUtil.multiOrSequential(this.zookeeper, listOfOps, true);
        }
        catch (KeeperException e) {
            LOG.error((Object)("Failed to remove hfile reference znode=" + e.getPath()), (Throwable)e);
        }
    }

    @Override
    public void addPeerToHFileRefs(String peerId) throws ReplicationException {
        String peerZnode = ZKUtil.joinZNode(this.hfileRefsZNode, peerId);
        try {
            if (ZKUtil.checkExists(this.zookeeper, peerZnode) == -1) {
                LOG.info((Object)("Adding peer " + peerId + " to hfile reference queue."));
                ZKUtil.createWithParents(this.zookeeper, peerZnode);
            }
        }
        catch (KeeperException e) {
            throw new ReplicationException("Failed to add peer " + peerId + " to hfile reference queue.", e);
        }
    }

    @Override
    public void removePeerFromHFileRefs(String peerId) {
        String peerZnode = ZKUtil.joinZNode(this.hfileRefsZNode, peerId);
        try {
            if (ZKUtil.checkExists(this.zookeeper, peerZnode) == -1) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Peer " + peerZnode + " not found in hfile reference queue."));
                }
                return;
            }
            LOG.info((Object)("Removing peer " + peerZnode + " from hfile reference queue."));
            ZKUtil.deleteNodeRecursively(this.zookeeper, peerZnode);
        }
        catch (KeeperException e) {
            LOG.error((Object)("Ignoring the exception to remove peer " + peerId + " from hfile reference queue."), (Throwable)e);
        }
    }
}

