/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.ipc;

import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.ipc.Call;
import org.apache.hadoop.hbase.ipc.CallEvent;

@InterfaceAudience.Private
class BufferCallBeforeInitHandler
extends ChannelDuplexHandler {
    private static final BufferCallEvent SUCCESS_EVENT = new BufferCallEvent(BufferCallAction.FLUSH, null);
    private final Map<Integer, Call> id2Call = new HashMap<Integer, Call>();

    BufferCallBeforeInitHandler() {
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) {
        if (msg instanceof Call) {
            Call call = (Call)msg;
            this.id2Call.put(call.id, call);
            promise.trySuccess();
        } else {
            ctx.write(msg, promise);
        }
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (evt instanceof BufferCallEvent) {
            BufferCallEvent bcEvt = (BufferCallEvent)evt;
            switch (bcEvt.action) {
                case FLUSH: {
                    for (Call call : this.id2Call.values()) {
                        ctx.write((Object)call);
                    }
                    break;
                }
                case FAIL: {
                    for (Call call : this.id2Call.values()) {
                        call.setException(bcEvt.error);
                    }
                    break;
                }
            }
            ctx.flush();
            ctx.pipeline().remove((ChannelHandler)this);
        } else if (evt instanceof CallEvent) {
            this.id2Call.remove(((CallEvent)evt).call.id);
        } else {
            ctx.fireUserEventTriggered(evt);
        }
    }

    public static final class BufferCallEvent {
        public final BufferCallAction action;
        public final IOException error;

        private BufferCallEvent(BufferCallAction action, IOException error) {
            this.action = action;
            this.error = error;
        }

        public static BufferCallEvent success() {
            return SUCCESS_EVENT;
        }

        public static BufferCallEvent fail(IOException error) {
            return new BufferCallEvent(BufferCallAction.FAIL, error);
        }
    }

    private static enum BufferCallAction {
        FLUSH,
        FAIL;

    }
}

