/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.ipc;

import java.net.InetSocketAddress;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.ipc.FailedServers;
import org.apache.hadoop.hbase.testclassification.ClientTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.log4j.Appender;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.spi.LoggingEvent;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
@Category(value={ClientTests.class, SmallTests.class})
public class TestFailedServersLog {
    static final int TEST_PORT = 9999;
    private InetSocketAddress addr;
    @Mock
    private Appender mockAppender;
    @Captor
    private ArgumentCaptor captorLoggingEvent;

    @Before
    public void setup() {
        LogManager.getRootLogger().addAppender(this.mockAppender);
    }

    @After
    public void teardown() {
        LogManager.getRootLogger().removeAppender(this.mockAppender);
    }

    @Test
    public void testAddToFailedServersLogging() {
        NullPointerException nullException = new NullPointerException();
        FailedServers fs = new FailedServers(new Configuration());
        this.addr = new InetSocketAddress(9999);
        fs.addToFailedServers(this.addr, (Throwable)nullException);
        ((Appender)Mockito.verify((Object)this.mockAppender)).doAppend((LoggingEvent)this.captorLoggingEvent.capture());
        LoggingEvent loggingEvent = (LoggingEvent)this.captorLoggingEvent.getValue();
        Assert.assertThat((Object)loggingEvent.getLevel(), (Matcher)CoreMatchers.is((Object)Level.DEBUG));
        Assert.assertEquals((Object)("Added failed server with address " + this.addr.toString() + " to list caused by " + nullException.toString()), (Object)loggingEvent.getRenderedMessage());
    }
}

