/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.util.Iterator;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellScanner;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.RegionLocations;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.ClientSimpleScanner;
import org.apache.hadoop.hbase.client.ClusterConnection;
import org.apache.hadoop.hbase.client.Consistency;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.RetriesExhaustedException;
import org.apache.hadoop.hbase.client.RetryingCallable;
import org.apache.hadoop.hbase.client.RpcRetryingCaller;
import org.apache.hadoop.hbase.client.RpcRetryingCallerFactory;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.ScannerCallable;
import org.apache.hadoop.hbase.client.ScannerCallableWithReplicas;
import org.apache.hadoop.hbase.ipc.RpcControllerFactory;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.InOrder;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

@Category(value={SmallTests.class})
public class TestClientScanner {
    Scan scan;
    ExecutorService pool;
    Configuration conf;
    ClusterConnection clusterConn;
    RpcRetryingCallerFactory rpcFactory;
    RpcControllerFactory controllerFactory;

    @Before
    public void setup() throws IOException {
        this.clusterConn = (ClusterConnection)Mockito.mock(ClusterConnection.class);
        this.rpcFactory = (RpcRetryingCallerFactory)Mockito.mock(RpcRetryingCallerFactory.class);
        this.controllerFactory = (RpcControllerFactory)Mockito.mock(RpcControllerFactory.class);
        this.pool = Executors.newSingleThreadExecutor();
        this.scan = new Scan();
        this.conf = new Configuration();
        Mockito.when((Object)this.clusterConn.getConfiguration()).thenReturn((Object)this.conf);
    }

    @After
    public void teardown() {
        if (null != this.pool) {
            this.pool.shutdownNow();
        }
    }

    @Test
    public void testNoResultsHint() throws IOException {
        final Result[] results = new Result[1];
        KeyValue kv1 = new KeyValue(Bytes.toBytes((String)"row"), Bytes.toBytes((String)"cf"), Bytes.toBytes((String)"cq"), 1L, KeyValue.Type.Maximum);
        results[0] = Result.create((Cell[])new Cell[]{kv1});
        RpcRetryingCaller caller = (RpcRetryingCaller)Mockito.mock(RpcRetryingCaller.class);
        Mockito.when((Object)this.rpcFactory.newCaller()).thenReturn((Object)caller);
        Mockito.when((Object)caller.callWithoutRetries((RetryingCallable)Mockito.any(RetryingCallable.class), Mockito.anyInt())).thenAnswer((Answer)new Answer<Result[]>(){
            private int count = 0;

            public Result[] answer(InvocationOnMock invocation) throws Throwable {
                ScannerCallableWithReplicas callable = (ScannerCallableWithReplicas)invocation.getArgumentAt(0, ScannerCallableWithReplicas.class);
                switch (this.count) {
                    case 0: {
                        ++this.count;
                        callable.currentScannerCallable.setMoreResultsInRegion(ScannerCallable.MoreResults.UNKNOWN);
                        return results;
                    }
                    case 1: 
                    case 2: {
                        ++this.count;
                        return new Result[0];
                    }
                }
                throw new RuntimeException("Expected only 2 invocations");
            }
        });
        this.scan.setCaching(100);
        this.scan.setMaxResultSize(1000000L);
        try (MockClientScanner scanner = new MockClientScanner(this.conf, this.scan, TableName.valueOf((String)"table"), this.clusterConn, this.rpcFactory, this.controllerFactory, this.pool, Integer.MAX_VALUE);){
            scanner.setRpcFinished(true);
            InOrder inOrder = Mockito.inOrder((Object[])new Object[]{caller});
            scanner.loadCache();
            ((RpcRetryingCaller)inOrder.verify((Object)caller, Mockito.times((int)2))).callWithoutRetries((RetryingCallable)Mockito.any(RetryingCallable.class), Mockito.anyInt());
            Assert.assertEquals((long)1L, (long)scanner.cache.size());
            Result r = (Result)scanner.cache.poll();
            Assert.assertNotNull((Object)r);
            CellScanner cs = r.cellScanner();
            Assert.assertTrue((boolean)cs.advance());
            Assert.assertEquals((Object)kv1, (Object)cs.current());
            Assert.assertFalse((boolean)cs.advance());
        }
    }

    @Test
    public void testSizeLimit() throws IOException {
        final Result[] results = new Result[1];
        KeyValue kv1 = new KeyValue(Bytes.toBytes((String)"row"), Bytes.toBytes((String)"cf"), Bytes.toBytes((String)"cq"), 1L, KeyValue.Type.Maximum);
        results[0] = Result.create((Cell[])new Cell[]{kv1});
        RpcRetryingCaller caller = (RpcRetryingCaller)Mockito.mock(RpcRetryingCaller.class);
        Mockito.when((Object)this.rpcFactory.newCaller()).thenReturn((Object)caller);
        Mockito.when((Object)caller.callWithoutRetries((RetryingCallable)Mockito.any(RetryingCallable.class), Mockito.anyInt())).thenAnswer((Answer)new Answer<Result[]>(){
            private int count = 0;

            public Result[] answer(InvocationOnMock invocation) throws Throwable {
                ScannerCallableWithReplicas callable = (ScannerCallableWithReplicas)invocation.getArgumentAt(0, ScannerCallableWithReplicas.class);
                switch (this.count) {
                    case 0: {
                        ++this.count;
                        callable.currentScannerCallable.setMoreResultsInRegion(ScannerCallable.MoreResults.YES);
                        return results;
                    }
                    case 1: {
                        ++this.count;
                        return null;
                    }
                }
                throw new RuntimeException("Expected only 2 invocations");
            }
        });
        Mockito.when((Object)this.rpcFactory.newCaller()).thenReturn((Object)caller);
        this.scan.setCaching(100);
        this.scan.setMaxResultSize(1L);
        try (MockClientScanner scanner = new MockClientScanner(this.conf, this.scan, TableName.valueOf((String)"table"), this.clusterConn, this.rpcFactory, this.controllerFactory, this.pool, Integer.MAX_VALUE);){
            InOrder inOrder = Mockito.inOrder((Object[])new Object[]{caller});
            scanner.loadCache();
            ((RpcRetryingCaller)inOrder.verify((Object)caller, Mockito.times((int)1))).callWithoutRetries((RetryingCallable)Mockito.any(RetryingCallable.class), Mockito.anyInt());
            Assert.assertEquals((long)1L, (long)scanner.cache.size());
            Result r = (Result)scanner.cache.poll();
            Assert.assertNotNull((Object)r);
            CellScanner cs = r.cellScanner();
            Assert.assertTrue((boolean)cs.advance());
            Assert.assertEquals((Object)kv1, (Object)cs.current());
            Assert.assertFalse((boolean)cs.advance());
        }
    }

    @Test
    public void testCacheLimit() throws IOException {
        KeyValue kv1 = new KeyValue(Bytes.toBytes((String)"row1"), Bytes.toBytes((String)"cf"), Bytes.toBytes((String)"cq"), 1L, KeyValue.Type.Maximum);
        KeyValue kv2 = new KeyValue(Bytes.toBytes((String)"row2"), Bytes.toBytes((String)"cf"), Bytes.toBytes((String)"cq"), 1L, KeyValue.Type.Maximum);
        KeyValue kv3 = new KeyValue(Bytes.toBytes((String)"row3"), Bytes.toBytes((String)"cf"), Bytes.toBytes((String)"cq"), 1L, KeyValue.Type.Maximum);
        final Result[] results = new Result[]{Result.create((Cell[])new Cell[]{kv1}), Result.create((Cell[])new Cell[]{kv2}), Result.create((Cell[])new Cell[]{kv3})};
        RpcRetryingCaller caller = (RpcRetryingCaller)Mockito.mock(RpcRetryingCaller.class);
        Mockito.when((Object)this.rpcFactory.newCaller()).thenReturn((Object)caller);
        Mockito.when((Object)caller.callWithoutRetries((RetryingCallable)Mockito.any(RetryingCallable.class), Mockito.anyInt())).thenAnswer((Answer)new Answer<Result[]>(){
            private int count = 0;

            public Result[] answer(InvocationOnMock invocation) throws Throwable {
                ScannerCallableWithReplicas callable = (ScannerCallableWithReplicas)invocation.getArgumentAt(0, ScannerCallableWithReplicas.class);
                switch (this.count) {
                    case 0: {
                        ++this.count;
                        callable.currentScannerCallable.setMoreResultsInRegion(ScannerCallable.MoreResults.YES);
                        return results;
                    }
                    case 1: {
                        ++this.count;
                        return null;
                    }
                }
                throw new RuntimeException("Expected only 2 invocations");
            }
        });
        Mockito.when((Object)this.rpcFactory.newCaller()).thenReturn((Object)caller);
        this.scan.setCaching(1);
        this.scan.setMaxResultSize(1000000L);
        try (MockClientScanner scanner = new MockClientScanner(this.conf, this.scan, TableName.valueOf((String)"table"), this.clusterConn, this.rpcFactory, this.controllerFactory, this.pool, Integer.MAX_VALUE);){
            InOrder inOrder = Mockito.inOrder((Object[])new Object[]{caller});
            scanner.loadCache();
            ((RpcRetryingCaller)inOrder.verify((Object)caller, Mockito.times((int)1))).callWithoutRetries((RetryingCallable)Mockito.any(RetryingCallable.class), Mockito.anyInt());
            Assert.assertEquals((long)3L, (long)scanner.cache.size());
            Result r = (Result)scanner.cache.poll();
            Assert.assertNotNull((Object)r);
            CellScanner cs = r.cellScanner();
            Assert.assertTrue((boolean)cs.advance());
            Assert.assertEquals((Object)kv1, (Object)cs.current());
            Assert.assertFalse((boolean)cs.advance());
            r = (Result)scanner.cache.poll();
            Assert.assertNotNull((Object)r);
            cs = r.cellScanner();
            Assert.assertTrue((boolean)cs.advance());
            Assert.assertEquals((Object)kv2, (Object)cs.current());
            Assert.assertFalse((boolean)cs.advance());
            r = (Result)scanner.cache.poll();
            Assert.assertNotNull((Object)r);
            cs = r.cellScanner();
            Assert.assertTrue((boolean)cs.advance());
            Assert.assertEquals((Object)kv3, (Object)cs.current());
            Assert.assertFalse((boolean)cs.advance());
        }
    }

    @Test
    public void testNoMoreResults() throws IOException {
        final Result[] results = new Result[1];
        KeyValue kv1 = new KeyValue(Bytes.toBytes((String)"row"), Bytes.toBytes((String)"cf"), Bytes.toBytes((String)"cq"), 1L, KeyValue.Type.Maximum);
        results[0] = Result.create((Cell[])new Cell[]{kv1});
        RpcRetryingCaller caller = (RpcRetryingCaller)Mockito.mock(RpcRetryingCaller.class);
        Mockito.when((Object)this.rpcFactory.newCaller()).thenReturn((Object)caller);
        Mockito.when((Object)caller.callWithoutRetries((RetryingCallable)Mockito.any(RetryingCallable.class), Mockito.anyInt())).thenAnswer((Answer)new Answer<Result[]>(){
            private int count = 0;

            public Result[] answer(InvocationOnMock invocation) throws Throwable {
                ScannerCallableWithReplicas callable = (ScannerCallableWithReplicas)invocation.getArgumentAt(0, ScannerCallableWithReplicas.class);
                switch (this.count) {
                    case 0: {
                        ++this.count;
                        callable.currentScannerCallable.setMoreResultsInRegion(ScannerCallable.MoreResults.NO);
                        return results;
                    }
                    case 1: {
                        ++this.count;
                        return null;
                    }
                }
                throw new RuntimeException("Expected only 2 invocations");
            }
        });
        Mockito.when((Object)this.rpcFactory.newCaller()).thenReturn((Object)caller);
        this.scan.setCaching(100);
        this.scan.setMaxResultSize(1000000L);
        try (MockClientScanner scanner = new MockClientScanner(this.conf, this.scan, TableName.valueOf((String)"table"), this.clusterConn, this.rpcFactory, this.controllerFactory, this.pool, Integer.MAX_VALUE);){
            scanner.setRpcFinished(true);
            InOrder inOrder = Mockito.inOrder((Object[])new Object[]{caller});
            scanner.loadCache();
            ((RpcRetryingCaller)inOrder.verify((Object)caller, Mockito.times((int)1))).callWithoutRetries((RetryingCallable)Mockito.any(RetryingCallable.class), Mockito.anyInt());
            Assert.assertEquals((long)1L, (long)scanner.cache.size());
            Result r = (Result)scanner.cache.poll();
            Assert.assertNotNull((Object)r);
            CellScanner cs = r.cellScanner();
            Assert.assertTrue((boolean)cs.advance());
            Assert.assertEquals((Object)kv1, (Object)cs.current());
            Assert.assertFalse((boolean)cs.advance());
        }
    }

    @Test
    public void testMoreResults() throws IOException {
        final Result[] results1 = new Result[1];
        KeyValue kv1 = new KeyValue(Bytes.toBytes((String)"row"), Bytes.toBytes((String)"cf"), Bytes.toBytes((String)"cq"), 1L, KeyValue.Type.Maximum);
        results1[0] = Result.create((Cell[])new Cell[]{kv1});
        final Result[] results2 = new Result[1];
        KeyValue kv2 = new KeyValue(Bytes.toBytes((String)"row2"), Bytes.toBytes((String)"cf"), Bytes.toBytes((String)"cq"), 1L, KeyValue.Type.Maximum);
        results2[0] = Result.create((Cell[])new Cell[]{kv2});
        RpcRetryingCaller caller = (RpcRetryingCaller)Mockito.mock(RpcRetryingCaller.class);
        Mockito.when((Object)this.rpcFactory.newCaller()).thenReturn((Object)caller);
        Mockito.when((Object)caller.callWithoutRetries((RetryingCallable)Mockito.any(RetryingCallable.class), Mockito.anyInt())).thenAnswer((Answer)new Answer<Result[]>(){
            private int count = 0;

            public Result[] answer(InvocationOnMock invocation) throws Throwable {
                ScannerCallableWithReplicas callable = (ScannerCallableWithReplicas)invocation.getArgumentAt(0, ScannerCallableWithReplicas.class);
                switch (this.count) {
                    case 0: {
                        ++this.count;
                        callable.currentScannerCallable.setMoreResultsInRegion(ScannerCallable.MoreResults.YES);
                        return results1;
                    }
                    case 1: {
                        ++this.count;
                        callable.currentScannerCallable.setMoreResultsInRegion(ScannerCallable.MoreResults.NO);
                        return results2;
                    }
                    case 2: {
                        ++this.count;
                        return null;
                    }
                }
                throw new RuntimeException("Expected only 3 invocations");
            }
        });
        this.scan.setCaching(100);
        this.scan.setMaxResultSize(1000000L);
        try (MockClientScanner scanner = new MockClientScanner(this.conf, this.scan, TableName.valueOf((String)"table"), this.clusterConn, this.rpcFactory, this.controllerFactory, this.pool, Integer.MAX_VALUE);){
            InOrder inOrder = Mockito.inOrder((Object[])new Object[]{caller});
            scanner.setRpcFinished(true);
            scanner.loadCache();
            ((RpcRetryingCaller)inOrder.verify((Object)caller, Mockito.times((int)2))).callWithoutRetries((RetryingCallable)Mockito.any(RetryingCallable.class), Mockito.anyInt());
            Assert.assertEquals((long)2L, (long)scanner.cache.size());
            Result r = (Result)scanner.cache.poll();
            Assert.assertNotNull((Object)r);
            CellScanner cs = r.cellScanner();
            Assert.assertTrue((boolean)cs.advance());
            Assert.assertEquals((Object)kv1, (Object)cs.current());
            Assert.assertFalse((boolean)cs.advance());
            r = (Result)scanner.cache.poll();
            Assert.assertNotNull((Object)r);
            cs = r.cellScanner();
            Assert.assertTrue((boolean)cs.advance());
            Assert.assertEquals((Object)kv2, (Object)cs.current());
            Assert.assertFalse((boolean)cs.advance());
        }
    }

    @Test(timeout=30000L)
    public void testExceptionsFromReplicasArePropagated() throws IOException {
        this.scan.setConsistency(Consistency.TIMELINE);
        this.rpcFactory = new MockRpcRetryingCallerFactory(this.conf);
        this.conf.set("hbase.rpc.callerfactory.class", MockRpcRetryingCallerFactory.class.getName());
        Mockito.when((Object)this.clusterConn.locateRegion((TableName)Matchers.any(), (byte[])Matchers.any(), Matchers.anyBoolean(), Matchers.anyBoolean(), Matchers.anyInt())).thenReturn((Object)new RegionLocations(new HRegionLocation[]{null, null, null}));
        try (MockClientScanner scanner = new MockClientScanner(this.conf, this.scan, TableName.valueOf((String)"table"), this.clusterConn, this.rpcFactory, new RpcControllerFactory(this.conf), this.pool, Integer.MAX_VALUE);){
            Iterator iter = scanner.iterator();
            while (iter.hasNext()) {
                iter.next();
            }
            Assert.fail((String)"Should have failed with RetriesExhaustedException");
        }
        catch (RuntimeException expected) {
            Assert.assertThat((Object)expected.getCause(), (Matcher)CoreMatchers.instanceOf(RetriesExhaustedException.class));
        }
    }

    public static class MockRpcRetryingCallerFactory
    extends RpcRetryingCallerFactory {
        public MockRpcRetryingCallerFactory(Configuration conf) {
            super(conf);
        }

        public <T> RpcRetryingCaller<T> newCaller() {
            return new RpcRetryingCaller<T>(0L, 0L, 0, 0){

                public void cancel() {
                }

                public T callWithRetries(RetryingCallable<T> callable, int callTimeout) throws IOException, RuntimeException {
                    throw new IOException("Scanner exception");
                }

                public T callWithoutRetries(RetryingCallable<T> callable, int callTimeout) throws IOException, RuntimeException {
                    try {
                        return callable.call(callTimeout);
                    }
                    catch (IOException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            };
        }
    }

    private static class MockClientScanner
    extends ClientSimpleScanner {
        private boolean rpcFinished = false;
        private boolean rpcFinishedFired = false;
        private boolean initialized = false;

        public MockClientScanner(Configuration conf, Scan scan, TableName tableName, ClusterConnection connection, RpcRetryingCallerFactory rpcFactory, RpcControllerFactory controllerFactory, ExecutorService pool, int primaryOperationTimeout) throws IOException {
            super(conf, scan, tableName, connection, rpcFactory, controllerFactory, pool, primaryOperationTimeout);
        }

        protected boolean moveToNextRegion() {
            if (!this.initialized) {
                this.initialized = true;
                return super.moveToNextRegion();
            }
            if (!this.rpcFinished) {
                return super.moveToNextRegion();
            }
            if (this.rpcFinishedFired) {
                throw new RuntimeException("Expected nextScanner to only be called once after  short-circuit was triggered.");
            }
            this.rpcFinishedFired = true;
            return false;
        }

        public void setRpcFinished(boolean rpcFinished) {
            this.rpcFinished = rpcFinished;
        }
    }
}

