/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.protobuf.generated.MasterProtos;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Mockito;

@Category(value={SmallTests.class})
public class TestProcedureFuture {
    @Test(timeout=60000L)
    public void testWithProcId() throws Exception {
        HBaseAdmin admin = (HBaseAdmin)Mockito.mock(HBaseAdmin.class);
        TestFuture f = new TestFuture(admin, 100L);
        f.get(1L, TimeUnit.MINUTES);
        Assert.assertTrue((String)"expected getProcedureResult() to be called", (boolean)f.wasGetProcedureResultCalled());
        Assert.assertTrue((String)"expected convertResult() to be called", (boolean)f.wasConvertResultCalled());
        Assert.assertFalse((String)"unexpected waitOperationResult() called", (boolean)f.wasWaitOperationResultCalled());
        Assert.assertTrue((String)"expected postOperationResult() to be called", (boolean)f.wasPostOperationResultCalled());
    }

    @Test(timeout=60000L)
    public void testWithProcIdAndSpinning() throws Exception {
        final AtomicInteger spinCount = new AtomicInteger(0);
        HBaseAdmin admin = (HBaseAdmin)Mockito.mock(HBaseAdmin.class);
        TestFuture f = new TestFuture(admin, 100L){

            @Override
            protected MasterProtos.GetProcedureResultResponse getProcedureResult(MasterProtos.GetProcedureResultRequest request) throws IOException {
                boolean done = spinCount.incrementAndGet() >= 10;
                return MasterProtos.GetProcedureResultResponse.newBuilder().setState(done ? MasterProtos.GetProcedureResultResponse.State.FINISHED : MasterProtos.GetProcedureResultResponse.State.RUNNING).build();
            }
        };
        f.get(1L, TimeUnit.MINUTES);
        Assert.assertEquals((long)10L, (long)spinCount.get());
        Assert.assertTrue((String)"expected convertResult() to be called", (boolean)f.wasConvertResultCalled());
        Assert.assertFalse((String)"unexpected waitOperationResult() called", (boolean)f.wasWaitOperationResultCalled());
        Assert.assertTrue((String)"expected postOperationResult() to be called", (boolean)f.wasPostOperationResultCalled());
    }

    @Test(timeout=60000L)
    public void testWithoutProcId() throws Exception {
        HBaseAdmin admin = (HBaseAdmin)Mockito.mock(HBaseAdmin.class);
        TestFuture f = new TestFuture(admin, null);
        f.get(1L, TimeUnit.MINUTES);
        Assert.assertFalse((String)"unexpected getProcedureResult() called", (boolean)f.wasGetProcedureResultCalled());
        Assert.assertFalse((String)"unexpected convertResult() called", (boolean)f.wasConvertResultCalled());
        Assert.assertTrue((String)"expected waitOperationResult() to be called", (boolean)f.wasWaitOperationResultCalled());
        Assert.assertTrue((String)"expected postOperationResult() to be called", (boolean)f.wasPostOperationResultCalled());
    }

    @Test(timeout=60000L)
    public void testOnServerWithNoProcedureSupport() throws Exception {
        HBaseAdmin admin = (HBaseAdmin)Mockito.mock(HBaseAdmin.class);
        TestFuture f = new TestFuture(admin, 100L){

            @Override
            protected MasterProtos.GetProcedureResultResponse getProcedureResult(MasterProtos.GetProcedureResultRequest request) throws IOException {
                super.getProcedureResult(request);
                throw new DoNotRetryIOException((Throwable)new UnsupportedOperationException("getProcedureResult"));
            }
        };
        f.get(1L, TimeUnit.MINUTES);
        Assert.assertTrue((String)"expected getProcedureResult() to be called", (boolean)f.wasGetProcedureResultCalled());
        Assert.assertFalse((String)"unexpected convertResult() called", (boolean)f.wasConvertResultCalled());
        Assert.assertTrue((String)"expected waitOperationResult() to be called", (boolean)f.wasWaitOperationResultCalled());
        Assert.assertTrue((String)"expected postOperationResult() to be called", (boolean)f.wasPostOperationResultCalled());
    }

    @Test(timeout=60000L)
    public void testWaitOperationResult() throws Exception {
        HBaseAdmin admin = (HBaseAdmin)Mockito.mock(HBaseAdmin.class);
        TestFuture f = new TestFuture(admin, 100L, true){

            @Override
            protected MasterProtos.GetProcedureResultResponse getProcedureResult(MasterProtos.GetProcedureResultRequest request) throws IOException {
                return MasterProtos.GetProcedureResultResponse.newBuilder().setState(MasterProtos.GetProcedureResultResponse.State.FINISHED).build();
            }
        };
        f.get(1L, TimeUnit.MINUTES);
        Assert.assertTrue((String)"expected waitOperationResult() to be called", (boolean)f.wasWaitOperationResultCalled());
    }

    private static class TestFuture
    extends HBaseAdmin.ProcedureFuture<Void> {
        private boolean postOperationResultCalled = false;
        private boolean waitOperationResultCalled = false;
        private boolean getProcedureResultCalled = false;
        private boolean convertResultCalled = false;

        public TestFuture(HBaseAdmin admin, Long procId) {
            super(admin, procId);
        }

        public TestFuture(HBaseAdmin admin, Long procId, boolean waitForOpResult) {
            super(admin, procId, waitForOpResult);
        }

        public boolean wasPostOperationResultCalled() {
            return this.postOperationResultCalled;
        }

        public boolean wasWaitOperationResultCalled() {
            return this.waitOperationResultCalled;
        }

        public boolean wasGetProcedureResultCalled() {
            return this.getProcedureResultCalled;
        }

        public boolean wasConvertResultCalled() {
            return this.convertResultCalled;
        }

        protected MasterProtos.GetProcedureResultResponse getProcedureResult(MasterProtos.GetProcedureResultRequest request) throws IOException {
            this.getProcedureResultCalled = true;
            return MasterProtos.GetProcedureResultResponse.newBuilder().setState(MasterProtos.GetProcedureResultResponse.State.FINISHED).build();
        }

        protected Void convertResult(MasterProtos.GetProcedureResultResponse response) throws IOException {
            this.convertResultCalled = true;
            return null;
        }

        protected Void waitOperationResult(long deadlineTs) throws IOException, TimeoutException {
            this.waitOperationResultCalled = true;
            return null;
        }

        protected Void postOperationResult(Void result, long deadlineTs) throws IOException, TimeoutException {
            this.postOperationResultCalled = true;
            return result;
        }
    }
}

