/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.util.Arrays;
import java.util.Set;
import org.apache.hadoop.hbase.client.Consistency;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.IsolationLevel;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterList;
import org.apache.hadoop.hbase.io.TimeRange;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.security.visibility.Authorizations;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestScan {
    @Test
    public void testAttributesSerialization() throws IOException {
        Scan scan = new Scan();
        scan.setAttribute("attribute1", Bytes.toBytes((String)"value1"));
        scan.setAttribute("attribute2", Bytes.toBytes((String)"value2"));
        scan.setAttribute("attribute3", Bytes.toBytes((String)"value3"));
        ClientProtos.Scan scanProto = ProtobufUtil.toScan((Scan)scan);
        Scan scan2 = ProtobufUtil.toScan((ClientProtos.Scan)scanProto);
        Assert.assertNull((Object)scan2.getAttribute("absent"));
        Assert.assertTrue((boolean)Arrays.equals(Bytes.toBytes((String)"value1"), scan2.getAttribute("attribute1")));
        Assert.assertTrue((boolean)Arrays.equals(Bytes.toBytes((String)"value2"), scan2.getAttribute("attribute2")));
        Assert.assertTrue((boolean)Arrays.equals(Bytes.toBytes((String)"value3"), scan2.getAttribute("attribute3")));
        Assert.assertEquals((long)3L, (long)scan2.getAttributesMap().size());
    }

    @Test
    public void testGetToScan() throws IOException {
        Get get = new Get(Bytes.toBytes((int)1));
        get.setCacheBlocks(true).setConsistency(Consistency.TIMELINE).setFilter((Filter)new FilterList(new Filter[0])).setId("get").setIsolationLevel(IsolationLevel.READ_COMMITTED).setLoadColumnFamiliesOnDemand(false).setMaxResultsPerColumnFamily(1000).setMaxVersions(9999).setRowOffsetPerColumnFamily(5).setTimeRange(0L, 13L).setAttribute("att_v0", Bytes.toBytes((String)"att_v0")).setColumnFamilyTimeRange(Bytes.toBytes((String)"cf"), 0L, 123L);
        Scan scan = new Scan(get);
        Assert.assertEquals((Object)get.getCacheBlocks(), (Object)scan.getCacheBlocks());
        Assert.assertEquals((Object)get.getConsistency(), (Object)scan.getConsistency());
        Assert.assertEquals((Object)get.getFilter(), (Object)scan.getFilter());
        Assert.assertEquals((Object)get.getId(), (Object)scan.getId());
        Assert.assertEquals((Object)get.getIsolationLevel(), (Object)scan.getIsolationLevel());
        Assert.assertEquals((Object)get.getLoadColumnFamiliesOnDemandValue(), (Object)scan.getLoadColumnFamiliesOnDemandValue());
        Assert.assertEquals((long)get.getMaxResultsPerColumnFamily(), (long)scan.getMaxResultsPerColumnFamily());
        Assert.assertEquals((long)get.getMaxVersions(), (long)scan.getMaxVersions());
        Assert.assertEquals((long)get.getRowOffsetPerColumnFamily(), (long)scan.getRowOffsetPerColumnFamily());
        Assert.assertEquals((long)get.getTimeRange().getMin(), (long)scan.getTimeRange().getMin());
        Assert.assertEquals((long)get.getTimeRange().getMax(), (long)scan.getTimeRange().getMax());
        Assert.assertTrue((boolean)Bytes.equals((byte[])get.getAttribute("att_v0"), (byte[])scan.getAttribute("att_v0")));
        Assert.assertEquals((long)((TimeRange)get.getColumnFamilyTimeRange().get(Bytes.toBytes((String)"cf"))).getMin(), (long)((TimeRange)scan.getColumnFamilyTimeRange().get(Bytes.toBytes((String)"cf"))).getMin());
        Assert.assertEquals((long)((TimeRange)get.getColumnFamilyTimeRange().get(Bytes.toBytes((String)"cf"))).getMax(), (long)((TimeRange)scan.getColumnFamilyTimeRange().get(Bytes.toBytes((String)"cf"))).getMax());
    }

    @Test
    public void testScanAttributes() {
        Scan scan = new Scan();
        Assert.assertTrue((boolean)scan.getAttributesMap().isEmpty());
        Assert.assertNull((Object)scan.getAttribute("absent"));
        scan.setAttribute("absent", null);
        Assert.assertTrue((boolean)scan.getAttributesMap().isEmpty());
        Assert.assertNull((Object)scan.getAttribute("absent"));
        scan.setAttribute("attribute1", Bytes.toBytes((String)"value1"));
        Assert.assertTrue((boolean)Arrays.equals(Bytes.toBytes((String)"value1"), scan.getAttribute("attribute1")));
        Assert.assertEquals((long)1L, (long)scan.getAttributesMap().size());
        Assert.assertTrue((boolean)Arrays.equals(Bytes.toBytes((String)"value1"), (byte[])scan.getAttributesMap().get("attribute1")));
        scan.setAttribute("attribute1", Bytes.toBytes((String)"value12"));
        Assert.assertTrue((boolean)Arrays.equals(Bytes.toBytes((String)"value12"), scan.getAttribute("attribute1")));
        Assert.assertEquals((long)1L, (long)scan.getAttributesMap().size());
        Assert.assertTrue((boolean)Arrays.equals(Bytes.toBytes((String)"value12"), (byte[])scan.getAttributesMap().get("attribute1")));
        scan.setAttribute("attribute2", Bytes.toBytes((String)"value2"));
        Assert.assertTrue((boolean)Arrays.equals(Bytes.toBytes((String)"value2"), scan.getAttribute("attribute2")));
        Assert.assertEquals((long)2L, (long)scan.getAttributesMap().size());
        Assert.assertTrue((boolean)Arrays.equals(Bytes.toBytes((String)"value2"), (byte[])scan.getAttributesMap().get("attribute2")));
        scan.setAttribute("attribute2", null);
        Assert.assertNull((Object)scan.getAttribute("attribute2"));
        Assert.assertEquals((long)1L, (long)scan.getAttributesMap().size());
        Assert.assertNull(scan.getAttributesMap().get("attribute2"));
        scan.setAttribute("attribute2", null);
        Assert.assertNull((Object)scan.getAttribute("attribute2"));
        Assert.assertEquals((long)1L, (long)scan.getAttributesMap().size());
        Assert.assertNull(scan.getAttributesMap().get("attribute2"));
        scan.setAttribute("attribute1", null);
        Assert.assertNull((Object)scan.getAttribute("attribute1"));
        Assert.assertTrue((boolean)scan.getAttributesMap().isEmpty());
        Assert.assertNull(scan.getAttributesMap().get("attribute1"));
    }

    @Test
    public void testNullQualifier() {
        Scan scan = new Scan();
        byte[] family = Bytes.toBytes((String)"family");
        scan.addColumn(family, null);
        Set qualifiers = (Set)scan.getFamilyMap().get(family);
        Assert.assertEquals((long)1L, (long)qualifiers.size());
    }

    @Test
    public void testSetAuthorizations() {
        Scan scan = new Scan();
        try {
            scan.setAuthorizations(new Authorizations(new String[]{"+|)"}));
            scan.setAuthorizations(new Authorizations(new String[]{"A", "B", "0123", "A0", "1A1", "_a"}));
            scan.setAuthorizations(new Authorizations(new String[]{"A|B"}));
            scan.setAuthorizations(new Authorizations(new String[]{"A&B"}));
            scan.setAuthorizations(new Authorizations(new String[]{"!B"}));
            scan.setAuthorizations(new Authorizations(new String[]{"A", "(A)"}));
            scan.setAuthorizations(new Authorizations(new String[]{"A", "{A"}));
            scan.setAuthorizations(new Authorizations(new String[]{" "}));
            scan.setAuthorizations(new Authorizations(new String[]{":B"}));
            scan.setAuthorizations(new Authorizations(new String[]{"-B"}));
            scan.setAuthorizations(new Authorizations(new String[]{".B"}));
            scan.setAuthorizations(new Authorizations(new String[]{"/B"}));
        }
        catch (IllegalArgumentException e) {
            Assert.fail((String)"should not throw exception");
        }
    }

    @Test
    public void testSetStartRowAndSetStopRow() {
        Scan scan = new Scan();
        scan.setStartRow(null);
        scan.setStartRow(new byte[1]);
        scan.setStartRow(new byte[Short.MAX_VALUE]);
        try {
            scan.setStartRow(new byte[32768]);
            Assert.fail((String)"should've thrown exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (Exception e) {
            Assert.fail((String)"expected IllegalArgumentException to be thrown");
        }
        scan.setStopRow(null);
        scan.setStopRow(new byte[1]);
        scan.setStopRow(new byte[Short.MAX_VALUE]);
        try {
            scan.setStopRow(new byte[32768]);
            Assert.fail((String)"should've thrown exception");
        }
        catch (IllegalArgumentException e) {
        }
        catch (Exception e) {
            Assert.fail((String)"expected IllegalArgumentException to be thrown");
        }
    }
}

