/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import io.netty.util.HashedWheelTimer;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.client.AsyncConnectionImpl;
import org.apache.hadoop.hbase.client.AsyncRpcRetryingCaller;
import org.apache.hadoop.hbase.ipc.HBaseRpcController;
import org.apache.hadoop.hbase.shaded.protobuf.generated.AdminProtos;

@InterfaceAudience.Private
public class AsyncAdminRequestRetryingCaller<T>
extends AsyncRpcRetryingCaller<T> {
    private final Callable<T> callable;
    private ServerName serverName;

    public AsyncAdminRequestRetryingCaller(HashedWheelTimer retryTimer, AsyncConnectionImpl conn, long pauseNs, int maxAttempts, long operationTimeoutNs, long rpcTimeoutNs, int startLogErrorsCnt, ServerName serverName, Callable<T> callable) {
        super(retryTimer, conn, pauseNs, maxAttempts, operationTimeoutNs, rpcTimeoutNs, startLogErrorsCnt);
        this.serverName = serverName;
        this.callable = callable;
    }

    @Override
    protected void doCall() {
        AdminProtos.AdminService.Interface adminStub;
        try {
            adminStub = this.conn.getAdminStub(this.serverName);
        }
        catch (IOException e) {
            this.onError(e, () -> "Get async admin stub to " + this.serverName + " failed", err -> {});
            return;
        }
        this.resetCallTimeout();
        this.callable.call(this.controller, adminStub).whenComplete((result, error) -> {
            if (error != null) {
                this.onError((Throwable)error, () -> "Call to admin stub failed", err -> {});
                return;
            }
            this.future.complete(result);
        });
    }

    @Override
    CompletableFuture<T> call() {
        this.doCall();
        return this.future;
    }

    @FunctionalInterface
    public static interface Callable<T> {
        public CompletableFuture<T> call(HBaseRpcController var1, AdminProtos.AdminService.Interface var2);
    }
}

