/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.lang.management.ManagementFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.util.Addressing;
import org.apache.hadoop.hbase.util.Bytes;

@InterfaceAudience.Private
final class ClientIdGenerator {
    private static final Log LOG = LogFactory.getLog(ClientIdGenerator.class);

    private ClientIdGenerator() {
    }

    public static byte[] generateClientId() {
        byte[] selfBytes = ClientIdGenerator.getIpAddressBytes();
        Long pid = ClientIdGenerator.getPid();
        long tid = Thread.currentThread().getId();
        long ts = System.currentTimeMillis();
        byte[] id = new byte[selfBytes.length + ((pid != null ? 1 : 0) + 2) * 8];
        int offset = Bytes.putBytes((byte[])id, (int)0, (byte[])selfBytes, (int)0, (int)selfBytes.length);
        if (pid != null) {
            offset = Bytes.putLong((byte[])id, (int)offset, (long)pid);
        }
        offset = Bytes.putLong((byte[])id, (int)offset, (long)tid);
        offset = Bytes.putLong((byte[])id, (int)offset, (long)ts);
        assert (offset == id.length);
        return id;
    }

    public static Long getPid() {
        String name = ManagementFactory.getRuntimeMXBean().getName();
        String[] nameParts = name.split("@");
        if (nameParts.length == 2) {
            try {
                return Long.parseLong(nameParts[0]);
            }
            catch (NumberFormatException ex) {
                LOG.warn((Object)("Failed to get PID from [" + name + "]"), (Throwable)ex);
            }
        } else {
            LOG.warn((Object)("Don't know how to get PID from [" + name + "]"));
        }
        return null;
    }

    public static byte[] getIpAddressBytes() {
        try {
            return Addressing.getIpAddress().getAddress();
        }
        catch (IOException ex) {
            LOG.warn((Object)"Failed to get IP address bytes", (Throwable)ex);
            return new byte[0];
        }
    }
}

