/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.MasterNotRunningException;
import org.apache.hadoop.hbase.RegionLocations;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.ZooKeeperConnectionException;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.client.AsyncProcess;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionConfiguration;
import org.apache.hadoop.hbase.client.MasterKeepAliveConnection;
import org.apache.hadoop.hbase.client.MetricsConnection;
import org.apache.hadoop.hbase.client.NonceGenerator;
import org.apache.hadoop.hbase.client.RpcRetryingCallerFactory;
import org.apache.hadoop.hbase.client.ServerStatisticTracker;
import org.apache.hadoop.hbase.client.TableState;
import org.apache.hadoop.hbase.client.backoff.ClientBackoffPolicy;
import org.apache.hadoop.hbase.ipc.RpcControllerFactory;
import org.apache.hadoop.hbase.shaded.protobuf.generated.AdminProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.MasterProtos;

@InterfaceAudience.Private
public interface ClusterConnection
extends Connection {
    public static final String HBASE_CLIENT_CONNECTION_IMPL = "hbase.client.connection.impl";

    @Deprecated
    public boolean isMasterRunning() throws MasterNotRunningException, ZooKeeperConnectionException;

    public boolean isTableAvailable(TableName var1, byte[][] var2) throws IOException;

    public boolean isTableEnabled(TableName var1) throws IOException;

    public boolean isTableDisabled(TableName var1) throws IOException;

    public TableState getTableState(TableName var1) throws IOException;

    public HRegionLocation locateRegion(TableName var1, byte[] var2) throws IOException;

    public void clearRegionCache();

    public void cacheLocation(TableName var1, RegionLocations var2);

    public void clearRegionCache(TableName var1);

    public void deleteCachedRegionLocation(HRegionLocation var1);

    public HRegionLocation relocateRegion(TableName var1, byte[] var2) throws IOException;

    public RegionLocations relocateRegion(TableName var1, byte[] var2, int var3) throws IOException;

    public void updateCachedLocations(TableName var1, byte[] var2, byte[] var3, Object var4, ServerName var5);

    public HRegionLocation locateRegion(byte[] var1) throws IOException;

    public List<HRegionLocation> locateRegions(TableName var1) throws IOException;

    public List<HRegionLocation> locateRegions(TableName var1, boolean var2, boolean var3) throws IOException;

    public RegionLocations locateRegion(TableName var1, byte[] var2, boolean var3, boolean var4) throws IOException;

    public RegionLocations locateRegion(TableName var1, byte[] var2, boolean var3, boolean var4, int var5) throws IOException;

    public MasterProtos.MasterService.BlockingInterface getMaster() throws IOException;

    public AdminProtos.AdminService.BlockingInterface getAdmin(ServerName var1) throws IOException;

    public ClientProtos.ClientService.BlockingInterface getClient(ServerName var1) throws IOException;

    public HRegionLocation getRegionLocation(TableName var1, byte[] var2, boolean var3) throws IOException;

    public void clearCaches(ServerName var1);

    @Deprecated
    public MasterKeepAliveConnection getKeepAliveMasterService() throws MasterNotRunningException;

    @Deprecated
    public boolean isDeadServer(ServerName var1);

    public NonceGenerator getNonceGenerator();

    public AsyncProcess getAsyncProcess();

    public RpcRetryingCallerFactory getNewRpcRetryingCallerFactory(Configuration var1);

    public RpcRetryingCallerFactory getRpcRetryingCallerFactory();

    public RpcControllerFactory getRpcControllerFactory();

    public ConnectionConfiguration getConnectionConfiguration();

    public ServerStatisticTracker getStatisticsTracker();

    public ClientBackoffPolicy getBackoffPolicy();

    public MetricsConnection getConnectionMetrics();

    public boolean hasCellBlockSupport();

    public int getCurrentNrHRS() throws IOException;
}

