/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.client.ClusterConnection;
import org.apache.hadoop.hbase.client.RegionAdminServiceCallable;
import org.apache.hadoop.hbase.ipc.HBaseRpcController;
import org.apache.hadoop.hbase.ipc.RpcControllerFactory;
import org.apache.hadoop.hbase.shaded.com.google.protobuf.RpcController;
import org.apache.hadoop.hbase.shaded.protobuf.RequestConverter;
import org.apache.hadoop.hbase.shaded.protobuf.generated.AdminProtos;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;

@InterfaceAudience.Private
public class FlushRegionCallable
extends RegionAdminServiceCallable<AdminProtos.FlushRegionResponse> {
    private static final Log LOG = LogFactory.getLog(FlushRegionCallable.class);
    private final byte[] regionName;
    private final boolean writeFlushWalMarker;
    private boolean reload;

    public FlushRegionCallable(ClusterConnection connection, RpcControllerFactory rpcControllerFactory, TableName tableName, byte[] regionName, byte[] regionStartKey, boolean writeFlushWalMarker) {
        super(connection, rpcControllerFactory, tableName, regionStartKey);
        this.regionName = regionName;
        this.writeFlushWalMarker = writeFlushWalMarker;
    }

    public FlushRegionCallable(ClusterConnection connection, RpcControllerFactory rpcControllerFactory, HRegionInfo regionInfo, boolean writeFlushWalMarker) {
        this(connection, rpcControllerFactory, regionInfo.getTable(), regionInfo.getRegionName(), regionInfo.getStartKey(), writeFlushWalMarker);
    }

    @Override
    public void prepare(boolean reload) throws IOException {
        super.prepare(reload);
        this.reload = reload;
    }

    @Override
    protected AdminProtos.FlushRegionResponse call(HBaseRpcController controller) throws Exception {
        if (!Bytes.equals((byte[])this.location.getRegionInfo().getRegionName(), (byte[])this.regionName)) {
            if (!this.reload) {
                throw new IOException("Cached location seems to be different than requested region.");
            }
            LOG.info((Object)("Skipping flush region, because the located region " + Bytes.toStringBinary((byte[])this.location.getRegionInfo().getRegionName()) + " is different than  requested region " + Bytes.toStringBinary((byte[])this.regionName)));
            return AdminProtos.FlushRegionResponse.newBuilder().setLastFlushTime(EnvironmentEdgeManager.currentTime()).setFlushed(false).setWroteFlushWalMarker(false).build();
        }
        AdminProtos.FlushRegionRequest request = RequestConverter.buildFlushRegionRequest(this.regionName, this.writeFlushWalMarker);
        return this.stub.flushRegion((RpcController)controller, request);
    }
}

