/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import java.util.UUID;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.IndividualBytesFieldCell;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.Tag;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Row;
import org.apache.hadoop.hbase.client.WrongRowIOException;
import org.apache.hadoop.hbase.io.HeapSize;
import org.apache.hadoop.hbase.security.access.Permission;
import org.apache.hadoop.hbase.security.visibility.CellVisibility;
import org.apache.hadoop.hbase.util.Bytes;

@InterfaceAudience.Public
public class Put
extends Mutation
implements HeapSize,
Comparable<Row> {
    public Put(byte[] row) {
        this(row, Long.MAX_VALUE);
    }

    public Put(byte[] row, long ts) {
        this(row, 0, row.length, ts);
    }

    public Put(byte[] rowArray, int rowOffset, int rowLength) {
        this(rowArray, rowOffset, rowLength, Long.MAX_VALUE);
    }

    public Put(ByteBuffer row, long ts) {
        if (ts < 0L) {
            throw new IllegalArgumentException("Timestamp cannot be negative. ts=" + ts);
        }
        Put.checkRow(row);
        this.row = new byte[row.remaining()];
        row.get(this.row);
        this.ts = ts;
    }

    public Put(ByteBuffer row) {
        this(row, Long.MAX_VALUE);
    }

    public Put(byte[] rowArray, int rowOffset, int rowLength, long ts) {
        Put.checkRow(rowArray, rowOffset, rowLength);
        this.row = Bytes.copy((byte[])rowArray, (int)rowOffset, (int)rowLength);
        this.ts = ts;
        if (ts < 0L) {
            throw new IllegalArgumentException("Timestamp cannot be negative. ts=" + ts);
        }
    }

    public Put(byte[] row, boolean rowIsImmutable) {
        this(row, Long.MAX_VALUE, rowIsImmutable);
    }

    public Put(byte[] row, long ts, boolean rowIsImmutable) {
        if (ts < 0L) {
            throw new IllegalArgumentException("Timestamp cannot be negative. ts=" + ts);
        }
        this.ts = ts;
        Put.checkRow(row);
        this.row = rowIsImmutable ? row : Bytes.copy((byte[])row, (int)0, (int)row.length);
    }

    public Put(Put putToCopy) {
        this(putToCopy.getRow(), putToCopy.ts);
        this.familyMap = new TreeMap(Bytes.BYTES_COMPARATOR);
        for (Map.Entry entry : putToCopy.getFamilyCellMap().entrySet()) {
            this.familyMap.put(entry.getKey(), new ArrayList((Collection)entry.getValue()));
        }
        this.durability = putToCopy.durability;
        for (Map.Entry<Object, Object> entry : putToCopy.getAttributesMap().entrySet()) {
            this.setAttribute((String)entry.getKey(), (byte[])entry.getValue());
        }
    }

    public Put addColumn(byte[] family, byte[] qualifier, byte[] value) {
        return this.addColumn(family, qualifier, this.ts, value);
    }

    public Put addImmutable(byte[] family, byte[] qualifier, byte[] value) {
        return this.addImmutable(family, qualifier, this.ts, value);
    }

    @InterfaceAudience.Private
    public Put addImmutable(byte[] family, byte[] qualifier, byte[] value, Tag[] tag) {
        return this.addImmutable(family, qualifier, this.ts, value, tag);
    }

    public Put addColumn(byte[] family, byte[] qualifier, long ts, byte[] value) {
        if (ts < 0L) {
            throw new IllegalArgumentException("Timestamp cannot be negative. ts=" + ts);
        }
        List<Cell> list = this.getCellList(family);
        KeyValue kv = this.createPutKeyValue(family, qualifier, ts, value);
        list.add((Cell)kv);
        this.familyMap.put(CellUtil.cloneFamily((Cell)kv), list);
        return this;
    }

    public Put addImmutable(byte[] family, byte[] qualifier, long ts, byte[] value) {
        if (family == null) {
            throw new IllegalArgumentException("Family cannot be null");
        }
        if (ts < 0L) {
            throw new IllegalArgumentException("Timestamp cannot be negative. ts=" + ts);
        }
        List<Cell> list = this.getCellList(family);
        list.add((Cell)new IndividualBytesFieldCell(this.row, family, qualifier, ts, KeyValue.Type.Put, value));
        this.familyMap.put(family, list);
        return this;
    }

    @InterfaceAudience.Private
    public Put addImmutable(byte[] family, byte[] qualifier, long ts, byte[] value, Tag[] tag) {
        List<Cell> list = this.getCellList(family);
        KeyValue kv = this.createPutKeyValue(family, qualifier, ts, value, tag);
        list.add((Cell)kv);
        this.familyMap.put(family, list);
        return this;
    }

    @InterfaceAudience.Private
    public Put addImmutable(byte[] family, ByteBuffer qualifier, long ts, ByteBuffer value, Tag[] tag) {
        if (ts < 0L) {
            throw new IllegalArgumentException("Timestamp cannot be negative. ts=" + ts);
        }
        List<Cell> list = this.getCellList(family);
        KeyValue kv = this.createPutKeyValue(family, qualifier, ts, value, tag);
        list.add((Cell)kv);
        this.familyMap.put(family, list);
        return this;
    }

    public Put addColumn(byte[] family, ByteBuffer qualifier, long ts, ByteBuffer value) {
        if (ts < 0L) {
            throw new IllegalArgumentException("Timestamp cannot be negative. ts=" + ts);
        }
        List<Cell> list = this.getCellList(family);
        KeyValue kv = this.createPutKeyValue(family, qualifier, ts, value, null);
        list.add((Cell)kv);
        this.familyMap.put(CellUtil.cloneFamily((Cell)kv), list);
        return this;
    }

    public Put addImmutable(byte[] family, ByteBuffer qualifier, long ts, ByteBuffer value) {
        if (ts < 0L) {
            throw new IllegalArgumentException("Timestamp cannot be negative. ts=" + ts);
        }
        List<Cell> list = this.getCellList(family);
        KeyValue kv = this.createPutKeyValue(family, qualifier, ts, value, null);
        list.add((Cell)kv);
        this.familyMap.put(family, list);
        return this;
    }

    public Put add(Cell kv) throws IOException {
        byte[] family = CellUtil.cloneFamily((Cell)kv);
        List<Cell> list = this.getCellList(family);
        if (!CellUtil.matchingRow((Cell)kv, (byte[])this.row)) {
            throw new WrongRowIOException("The row in " + kv.toString() + " doesn't match the original one " + Bytes.toStringBinary((byte[])this.row));
        }
        list.add(kv);
        this.familyMap.put(family, list);
        return this;
    }

    public boolean has(byte[] family, byte[] qualifier) {
        return this.has(family, qualifier, this.ts, new byte[0], true, true);
    }

    public boolean has(byte[] family, byte[] qualifier, long ts) {
        return this.has(family, qualifier, ts, new byte[0], false, true);
    }

    public boolean has(byte[] family, byte[] qualifier, byte[] value) {
        return this.has(family, qualifier, this.ts, value, true, false);
    }

    public boolean has(byte[] family, byte[] qualifier, long ts, byte[] value) {
        return this.has(family, qualifier, ts, value, false, false);
    }

    private boolean has(byte[] family, byte[] qualifier, long ts, byte[] value, boolean ignoreTS, boolean ignoreValue) {
        List<Cell> list = this.getCellList(family);
        if (list.isEmpty()) {
            return false;
        }
        if (!ignoreTS && !ignoreValue) {
            for (Cell cell : list) {
                if (!CellUtil.matchingFamily((Cell)cell, (byte[])family) || !CellUtil.matchingQualifier((Cell)cell, (byte[])qualifier) || !CellUtil.matchingValue((Cell)cell, (byte[])value) || cell.getTimestamp() != ts) continue;
                return true;
            }
        } else if (ignoreValue && !ignoreTS) {
            for (Cell cell : list) {
                if (!CellUtil.matchingFamily((Cell)cell, (byte[])family) || !CellUtil.matchingQualifier((Cell)cell, (byte[])qualifier) || cell.getTimestamp() != ts) continue;
                return true;
            }
        } else if (!ignoreValue && ignoreTS) {
            for (Cell cell : list) {
                if (!CellUtil.matchingFamily((Cell)cell, (byte[])family) || !CellUtil.matchingQualifier((Cell)cell, (byte[])qualifier) || !CellUtil.matchingValue((Cell)cell, (byte[])value)) continue;
                return true;
            }
        } else {
            for (Cell cell : list) {
                if (!CellUtil.matchingFamily((Cell)cell, (byte[])family) || !CellUtil.matchingQualifier((Cell)cell, (byte[])qualifier)) continue;
                return true;
            }
        }
        return false;
    }

    public List<Cell> get(byte[] family, byte[] qualifier) {
        ArrayList<Cell> filteredList = new ArrayList<Cell>();
        for (Cell cell : this.getCellList(family)) {
            if (!CellUtil.matchingQualifier((Cell)cell, (byte[])qualifier)) continue;
            filteredList.add(cell);
        }
        return filteredList;
    }

    @Override
    public Put setAttribute(String name, byte[] value) {
        return (Put)super.setAttribute(name, value);
    }

    @Override
    public Put setId(String id) {
        return (Put)super.setId(id);
    }

    @Override
    public Put setDurability(Durability d) {
        return (Put)super.setDurability(d);
    }

    @Override
    public Put setFamilyCellMap(NavigableMap<byte[], List<Cell>> map) {
        return (Put)super.setFamilyCellMap(map);
    }

    @Override
    public Put setClusterIds(List<UUID> clusterIds) {
        return (Put)super.setClusterIds(clusterIds);
    }

    @Override
    public Put setCellVisibility(CellVisibility expression) {
        return (Put)super.setCellVisibility(expression);
    }

    @Override
    public Put setACL(String user, Permission perms) {
        return (Put)super.setACL(user, perms);
    }

    @Override
    public Put setACL(Map<String, Permission> perms) {
        return (Put)super.setACL(perms);
    }

    @Override
    public Put setTTL(long ttl) {
        return (Put)super.setTTL(ttl);
    }
}

