/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import org.apache.hadoop.hbase.CellScanner;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableNotEnabledException;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.client.ClusterConnection;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionUtils;
import org.apache.hadoop.hbase.client.RegionLocator;
import org.apache.hadoop.hbase.client.RetryingCallable;
import org.apache.hadoop.hbase.ipc.HBaseRpcController;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.com.google.protobuf.RpcController;
import org.apache.hadoop.hbase.util.Bytes;

@InterfaceAudience.Private
public abstract class RegionServerCallable<T, S>
implements RetryingCallable<T> {
    private final Connection connection;
    private final TableName tableName;
    private final byte[] row;
    protected HRegionLocation location;
    protected static final int MIN_WAIT_DEAD_SERVER = 10000;
    protected S stub;
    protected final RpcController rpcController;

    public RegionServerCallable(Connection connection, TableName tableName, byte[] row, RpcController rpcController) {
        this.connection = connection;
        this.tableName = tableName;
        this.row = row;
        this.rpcController = rpcController;
    }

    protected RpcController getRpcController() {
        return this.rpcController;
    }

    protected void setStub(S stub) {
        this.stub = stub;
    }

    protected S getStub() {
        return this.stub;
    }

    @Override
    public T call(int callTimeout) throws IOException {
        try {
            if (this.getRpcController() != null) {
                RpcController shadedRpcController = this.getRpcController();
                shadedRpcController.reset();
                if (shadedRpcController instanceof HBaseRpcController) {
                    HBaseRpcController hrc = (HBaseRpcController)this.getRpcController();
                    hrc.setPriority(this.tableName);
                    hrc.setCallTimeout(callTimeout);
                }
            }
            return this.rpcCall();
        }
        catch (Exception e) {
            throw ProtobufUtil.handleRemoteException(e);
        }
    }

    protected abstract T rpcCall() throws Exception;

    protected CellScanner getRpcControllerCellScanner() {
        return this.getRpcController() != null && this.getRpcController() instanceof HBaseRpcController ? ((HBaseRpcController)this.getRpcController()).cellScanner() : null;
    }

    protected void setRpcControllerCellScanner(CellScanner cellScanner) {
        if (this.getRpcController() != null && this.getRpcController() instanceof HBaseRpcController) {
            ((HBaseRpcController)this.rpcController).setCellScanner(cellScanner);
        }
    }

    protected ClusterConnection getConnection() {
        return (ClusterConnection)this.connection;
    }

    protected HRegionLocation getLocation() {
        return this.location;
    }

    protected void setLocation(HRegionLocation location) {
        this.location = location;
    }

    public TableName getTableName() {
        return this.tableName;
    }

    public byte[] getRow() {
        return this.row;
    }

    @Override
    public void throwable(Throwable t, boolean retrying) {
        if (this.location != null) {
            this.getConnection().updateCachedLocations(this.tableName, this.location.getRegionInfo().getRegionName(), this.row, t, this.location.getServerName());
        }
    }

    @Override
    public String getExceptionMessageAdditionalDetail() {
        return "row '" + Bytes.toString((byte[])this.row) + "' on table '" + this.tableName + "' at " + this.location;
    }

    @Override
    public long sleep(long pause, int tries) {
        long sleep = ConnectionUtils.getPauseTime(pause, tries);
        if (sleep < 10000L && (this.location == null || this.getConnection().isDeadServer(this.location.getServerName()))) {
            sleep = ConnectionUtils.addJitter(10000L, 0.1f);
        }
        return sleep;
    }

    public HRegionInfo getHRegionInfo() {
        if (this.location == null) {
            return null;
        }
        return this.location.getRegionInfo();
    }

    @Override
    public void prepare(boolean reload) throws IOException {
        if (reload && this.tableName != null && !this.tableName.equals((Object)TableName.META_TABLE_NAME) && this.getConnection().isTableDisabled(this.tableName)) {
            throw new TableNotEnabledException(this.tableName.getNameAsString() + " is disabled.");
        }
        try (RegionLocator regionLocator = this.connection.getRegionLocator(this.tableName);){
            this.location = regionLocator.getRegionLocation(this.row);
        }
        if (this.location == null) {
            throw new IOException("Failed to find location, tableName=" + this.tableName + ", row=" + Bytes.toString((byte[])this.row) + ", reload=" + reload);
        }
        this.setStubByServiceName(this.location.getServerName());
    }

    protected abstract void setStubByServiceName(ServerName var1) throws IOException;
}

