/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.regex.Matcher;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.shaded.com.google.protobuf.Message;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.util.Bytes;

@InterfaceAudience.Public
public class TableDescriptorBuilder {
    private static final Log LOG = LogFactory.getLog(TableDescriptorBuilder.class);
    @InterfaceAudience.Private
    public static final String SPLIT_POLICY = "SPLIT_POLICY";
    @InterfaceAudience.Private
    public static final String MAX_FILESIZE = "MAX_FILESIZE";
    private static final Bytes MAX_FILESIZE_KEY = new Bytes(Bytes.toBytes((String)"MAX_FILESIZE"));
    @InterfaceAudience.Private
    public static final String OWNER = "OWNER";
    @InterfaceAudience.Private
    public static final Bytes OWNER_KEY = new Bytes(Bytes.toBytes((String)"OWNER"));
    @InterfaceAudience.Private
    public static final String READONLY = "READONLY";
    private static final Bytes READONLY_KEY = new Bytes(Bytes.toBytes((String)"READONLY"));
    @InterfaceAudience.Private
    public static final String COMPACTION_ENABLED = "COMPACTION_ENABLED";
    private static final Bytes COMPACTION_ENABLED_KEY = new Bytes(Bytes.toBytes((String)"COMPACTION_ENABLED"));
    @InterfaceAudience.Private
    public static final String MEMSTORE_FLUSHSIZE = "MEMSTORE_FLUSHSIZE";
    private static final Bytes MEMSTORE_FLUSHSIZE_KEY = new Bytes(Bytes.toBytes((String)"MEMSTORE_FLUSHSIZE"));
    @InterfaceAudience.Private
    public static final String FLUSH_POLICY = "FLUSH_POLICY";
    @InterfaceAudience.Private
    public static final String IS_META = "IS_META";
    private static final Bytes IS_META_KEY = new Bytes(Bytes.toBytes((String)"IS_META"));
    @InterfaceAudience.Private
    public static final String DURABILITY = "DURABILITY";
    private static final Bytes DURABILITY_KEY = new Bytes(Bytes.toBytes((String)"DURABILITY"));
    @InterfaceAudience.Private
    public static final String REGION_REPLICATION = "REGION_REPLICATION";
    private static final Bytes REGION_REPLICATION_KEY = new Bytes(Bytes.toBytes((String)"REGION_REPLICATION"));
    @InterfaceAudience.Private
    public static final String REGION_MEMSTORE_REPLICATION = "REGION_MEMSTORE_REPLICATION";
    private static final Bytes REGION_MEMSTORE_REPLICATION_KEY = new Bytes(Bytes.toBytes((String)"REGION_MEMSTORE_REPLICATION"));
    @InterfaceAudience.Private
    public static final String NORMALIZATION_ENABLED = "NORMALIZATION_ENABLED";
    private static final Bytes NORMALIZATION_ENABLED_KEY = new Bytes(Bytes.toBytes((String)"NORMALIZATION_ENABLED"));
    private static final Durability DEFAULT_DURABLITY = Durability.USE_DEFAULT;
    @InterfaceAudience.Private
    public static final String PRIORITY = "PRIORITY";
    private static final Bytes PRIORITY_KEY = new Bytes(Bytes.toBytes((String)"PRIORITY"));
    private static final int DEFAULT_PRIORITY = 0;
    private static final Bytes FALSE = new Bytes(Bytes.toBytes((String)Boolean.FALSE.toString()));
    private static final Bytes TRUE = new Bytes(Bytes.toBytes((String)Boolean.TRUE.toString()));
    public static final boolean DEFAULT_READONLY = false;
    public static final boolean DEFAULT_COMPACTION_ENABLED = true;
    public static final boolean DEFAULT_NORMALIZATION_ENABLED = false;
    public static final long DEFAULT_MEMSTORE_FLUSH_SIZE = 0x8000000L;
    public static final int DEFAULT_REGION_REPLICATION = 1;
    public static final boolean DEFAULT_REGION_MEMSTORE_REPLICATION = true;
    private static final Map<String, String> DEFAULT_VALUES = new HashMap<String, String>();
    private static final Set<Bytes> RESERVED_KEYWORDS = new HashSet<Bytes>();
    @InterfaceAudience.Private
    public static final String NAMESPACE_FAMILY_INFO = "info";
    @InterfaceAudience.Private
    public static final byte[] NAMESPACE_FAMILY_INFO_BYTES;
    @InterfaceAudience.Private
    public static final byte[] NAMESPACE_COL_DESC_BYTES;
    public static final TableDescriptor NAMESPACE_TABLEDESC;
    private final ModifyableTableDescriptor desc;

    public static byte[] toByteArray(TableDescriptor desc) {
        if (desc instanceof ModifyableTableDescriptor) {
            return ((ModifyableTableDescriptor)desc).toByteArray();
        }
        if (desc instanceof HTableDescriptor) {
            return ((HTableDescriptor)desc).toByteArray();
        }
        return new ModifyableTableDescriptor(desc).toByteArray();
    }

    public static TableDescriptorBuilder newBuilder(byte[] pbBytes) throws DeserializationException {
        return new TableDescriptorBuilder(ModifyableTableDescriptor.parseFrom(pbBytes));
    }

    public static TableDescriptorBuilder newBuilder(TableName name) {
        return new TableDescriptorBuilder(name);
    }

    public static TableDescriptorBuilder newBuilder(TableDescriptor desc) {
        return new TableDescriptorBuilder(desc);
    }

    private TableDescriptorBuilder(TableName name) {
        this.desc = new ModifyableTableDescriptor(name);
    }

    private TableDescriptorBuilder(TableDescriptor desc) {
        this.desc = new ModifyableTableDescriptor(desc);
    }

    public TableDescriptorBuilder addCoprocessor(String className) throws IOException {
        return this.addCoprocessor(className, null, 0x3FFFFFFF, null);
    }

    public TableDescriptorBuilder addCoprocessor(String className, Path jarFilePath, int priority, Map<String, String> kvs) throws IOException {
        this.desc.addCoprocessor(className, jarFilePath, priority, kvs);
        return this;
    }

    public TableDescriptorBuilder addCoprocessorWithSpec(String specStr) throws IOException {
        this.desc.addCoprocessorWithSpec(specStr);
        return this;
    }

    public TableDescriptorBuilder addFamily(HColumnDescriptor family) {
        this.desc.addFamily(family);
        return this;
    }

    public TableDescriptorBuilder modifyFamily(HColumnDescriptor family) {
        this.desc.modifyFamily(family);
        return this;
    }

    public TableDescriptorBuilder remove(Bytes key) {
        this.desc.remove(key);
        return this;
    }

    public TableDescriptorBuilder remove(byte[] key) {
        this.desc.remove(key);
        return this;
    }

    public TableDescriptorBuilder removeConfiguration(String key) {
        this.desc.removeConfiguration(key);
        return this;
    }

    public TableDescriptorBuilder removeFamily(byte[] column) {
        this.desc.removeFamily(column);
        return this;
    }

    public TableDescriptorBuilder removeCoprocessor(String className) {
        this.desc.removeCoprocessor(className);
        return this;
    }

    public TableDescriptorBuilder setCompactionEnabled(boolean isEnable) {
        this.desc.setCompactionEnabled(isEnable);
        return this;
    }

    public TableDescriptorBuilder setConfiguration(String key, String value) {
        this.desc.setConfiguration(key, value);
        return this;
    }

    public TableDescriptorBuilder setDurability(Durability durability) {
        this.desc.setDurability(durability);
        return this;
    }

    public TableDescriptorBuilder setFlushPolicyClassName(String clazz) {
        this.desc.setFlushPolicyClassName(clazz);
        return this;
    }

    public TableDescriptorBuilder setMaxFileSize(long maxFileSize) {
        this.desc.setMaxFileSize(maxFileSize);
        return this;
    }

    public TableDescriptorBuilder setMemStoreFlushSize(long memstoreFlushSize) {
        this.desc.setMemStoreFlushSize(memstoreFlushSize);
        return this;
    }

    public TableDescriptorBuilder setNormalizationEnabled(boolean isEnable) {
        this.desc.setNormalizationEnabled(isEnable);
        return this;
    }

    @Deprecated
    public TableDescriptorBuilder setOwner(User owner) {
        this.desc.setOwner(owner);
        return this;
    }

    @Deprecated
    public TableDescriptorBuilder setOwnerString(String ownerString) {
        this.desc.setOwnerString(ownerString);
        return this;
    }

    public TableDescriptorBuilder setPriority(int priority) {
        this.desc.setPriority(priority);
        return this;
    }

    public TableDescriptorBuilder setReadOnly(boolean readOnly) {
        this.desc.setReadOnly(readOnly);
        return this;
    }

    public TableDescriptorBuilder setRegionMemstoreReplication(boolean memstoreReplication) {
        this.desc.setRegionMemstoreReplication(memstoreReplication);
        return this;
    }

    public TableDescriptorBuilder setRegionReplication(int regionReplication) {
        this.desc.setRegionReplication(regionReplication);
        return this;
    }

    public TableDescriptorBuilder setRegionSplitPolicyClassName(String clazz) {
        this.desc.setRegionSplitPolicyClassName(clazz);
        return this;
    }

    public TableDescriptorBuilder setValue(Bytes key, Bytes value) {
        this.desc.setValue(key, value);
        return this;
    }

    public TableDescriptorBuilder setValue(byte[] key, byte[] value) {
        this.desc.setValue(key, value);
        return this;
    }

    public HTableDescriptor build() {
        return new HTableDescriptor((TableDescriptor)this.desc);
    }

    private TableDescriptor doBuild() {
        return new ModifyableTableDescriptor(this.desc);
    }

    static {
        DEFAULT_VALUES.put(MAX_FILESIZE, String.valueOf(0x280000000L));
        DEFAULT_VALUES.put(READONLY, String.valueOf(false));
        DEFAULT_VALUES.put(MEMSTORE_FLUSHSIZE, String.valueOf(0x8000000L));
        DEFAULT_VALUES.put(DURABILITY, DEFAULT_DURABLITY.name());
        DEFAULT_VALUES.put(REGION_REPLICATION, String.valueOf(1));
        DEFAULT_VALUES.put(NORMALIZATION_ENABLED, String.valueOf(false));
        DEFAULT_VALUES.put(PRIORITY, String.valueOf(0));
        DEFAULT_VALUES.keySet().stream().map(s -> new Bytes(Bytes.toBytes((String)s))).forEach(RESERVED_KEYWORDS::add);
        RESERVED_KEYWORDS.add(IS_META_KEY);
        NAMESPACE_FAMILY_INFO_BYTES = Bytes.toBytes((String)NAMESPACE_FAMILY_INFO);
        NAMESPACE_COL_DESC_BYTES = Bytes.toBytes((String)"d");
        NAMESPACE_TABLEDESC = TableDescriptorBuilder.newBuilder(TableName.NAMESPACE_TABLE_NAME).addFamily(new HColumnDescriptor(NAMESPACE_FAMILY_INFO).setMaxVersions(10).setInMemory(true).setBlocksize(8192).setScope(0).setCacheDataInL1(true)).doBuild();
    }

    @InterfaceAudience.Private
    public static class ModifyableTableDescriptor
    implements TableDescriptor,
    Comparable<ModifyableTableDescriptor> {
        private final TableName name;
        private final Map<Bytes, Bytes> values = new HashMap<Bytes, Bytes>();
        private final Map<String, String> configuration = new HashMap<String, String>();
        private final Map<byte[], HColumnDescriptor> families = new TreeMap<byte[], HColumnDescriptor>((Comparator<byte[]>)Bytes.BYTES_RAWCOMPARATOR);

        private ModifyableTableDescriptor(TableName name) {
            this(name, Collections.EMPTY_LIST, Collections.EMPTY_MAP, Collections.EMPTY_MAP);
        }

        @InterfaceAudience.Private
        protected ModifyableTableDescriptor(TableDescriptor desc) {
            this(desc.getTableName(), desc.getFamilies(), desc.getValues(), desc.getConfiguration());
        }

        @InterfaceAudience.Private
        public ModifyableTableDescriptor(TableName name, Collection<HColumnDescriptor> families, Map<Bytes, Bytes> values, Map<String, String> configuration) {
            this.name = name;
            families.forEach(c -> this.families.put(c.getName(), new HColumnDescriptor((HColumnDescriptor)c)));
            values.forEach(this.values::put);
            configuration.forEach(this.configuration::put);
            this.setMetaFlags(name);
        }

        private void setMetaFlags(TableName name) {
            this.values.put(IS_META_KEY, name.equals((Object)TableName.META_TABLE_NAME) ? TRUE : FALSE);
        }

        @Override
        public boolean isMetaRegion() {
            return this.isSomething(IS_META_KEY, false);
        }

        private boolean isSomething(Bytes key, boolean valueIfNull) {
            byte[] value = this.getValue(key);
            if (value != null) {
                return Boolean.valueOf(Bytes.toString((byte[])value));
            }
            return valueIfNull;
        }

        @Override
        public boolean isMetaTable() {
            return this.isMetaRegion();
        }

        @Override
        public byte[] getValue(byte[] key) {
            return this.getValue(new Bytes(key));
        }

        private byte[] getValue(Bytes key) {
            Bytes ibw = this.values.get(key);
            if (ibw == null) {
                return null;
            }
            return ibw.get();
        }

        public String getValue(String key) {
            byte[] value = this.getValue(Bytes.toBytes((String)key));
            if (value == null) {
                return null;
            }
            return Bytes.toString((byte[])value);
        }

        @Override
        public Map<Bytes, Bytes> getValues() {
            return Collections.unmodifiableMap(this.values);
        }

        public ModifyableTableDescriptor setValue(byte[] key, byte[] value) {
            return this.setValue(ModifyableTableDescriptor.toBytesOrNull(key, v -> v), ModifyableTableDescriptor.toBytesOrNull(value, v -> v));
        }

        private ModifyableTableDescriptor setValue(Bytes key, String value) {
            return this.setValue(key, ModifyableTableDescriptor.toBytesOrNull(value, Bytes::toBytes));
        }

        public ModifyableTableDescriptor setValue(Bytes key, Bytes value) {
            if (value == null) {
                this.remove(key);
            } else {
                this.values.put(key, value);
            }
            return this;
        }

        public ModifyableTableDescriptor setValue(String key, String value) {
            return this.setValue(ModifyableTableDescriptor.toBytesOrNull(key, Bytes::toBytes), ModifyableTableDescriptor.toBytesOrNull(value, Bytes::toBytes));
        }

        private static <T> Bytes toBytesOrNull(T t, Function<T, byte[]> f) {
            if (t == null) {
                return null;
            }
            return new Bytes(f.apply(t));
        }

        public void remove(String key) {
            this.remove(new Bytes(Bytes.toBytes((String)key)));
        }

        public void remove(Bytes key) {
            this.values.remove(key);
        }

        public void remove(byte[] key) {
            this.remove(new Bytes(key));
        }

        @Override
        public boolean isReadOnly() {
            return this.isSomething(READONLY_KEY, false);
        }

        public ModifyableTableDescriptor setReadOnly(boolean readOnly) {
            return this.setValue(READONLY_KEY, readOnly ? TRUE : FALSE);
        }

        @Override
        public boolean isCompactionEnabled() {
            return this.isSomething(COMPACTION_ENABLED_KEY, true);
        }

        public ModifyableTableDescriptor setCompactionEnabled(boolean isEnable) {
            return this.setValue(COMPACTION_ENABLED_KEY, isEnable ? TRUE : FALSE);
        }

        @Override
        public boolean isNormalizationEnabled() {
            return this.isSomething(NORMALIZATION_ENABLED_KEY, false);
        }

        public ModifyableTableDescriptor setNormalizationEnabled(boolean isEnable) {
            return this.setValue(NORMALIZATION_ENABLED_KEY, isEnable ? TRUE : FALSE);
        }

        public ModifyableTableDescriptor setDurability(Durability durability) {
            return this.setValue(DURABILITY_KEY, durability.name());
        }

        @Override
        public Durability getDurability() {
            byte[] durabilityValue = this.getValue(DURABILITY_KEY);
            if (durabilityValue == null) {
                return DEFAULT_DURABLITY;
            }
            try {
                return Durability.valueOf(Bytes.toString((byte[])durabilityValue));
            }
            catch (IllegalArgumentException ex) {
                LOG.warn((Object)("Received " + ex + " because Durability value for TableDescriptor is not known. Durability:" + Bytes.toString((byte[])durabilityValue)));
                return DEFAULT_DURABLITY;
            }
        }

        @Override
        public TableName getTableName() {
            return this.name;
        }

        public ModifyableTableDescriptor setRegionSplitPolicyClassName(String clazz) {
            return this.setValue(TableDescriptorBuilder.SPLIT_POLICY, clazz);
        }

        @Override
        public String getRegionSplitPolicyClassName() {
            return this.getValue(TableDescriptorBuilder.SPLIT_POLICY);
        }

        @Override
        public long getMaxFileSize() {
            byte[] value = this.getValue(MAX_FILESIZE_KEY);
            if (value != null) {
                return Long.parseLong(Bytes.toString((byte[])value));
            }
            return -1L;
        }

        public ModifyableTableDescriptor setMaxFileSize(long maxFileSize) {
            return this.setValue(MAX_FILESIZE_KEY, Long.toString(maxFileSize));
        }

        @Override
        public long getMemStoreFlushSize() {
            byte[] value = this.getValue(MEMSTORE_FLUSHSIZE_KEY);
            if (value != null) {
                return Long.parseLong(Bytes.toString((byte[])value));
            }
            return -1L;
        }

        public ModifyableTableDescriptor setMemStoreFlushSize(long memstoreFlushSize) {
            return this.setValue(MEMSTORE_FLUSHSIZE_KEY, Long.toString(memstoreFlushSize));
        }

        public ModifyableTableDescriptor setFlushPolicyClassName(String clazz) {
            return this.setValue(TableDescriptorBuilder.FLUSH_POLICY, clazz);
        }

        @Override
        public String getFlushPolicyClassName() {
            return this.getValue(TableDescriptorBuilder.FLUSH_POLICY);
        }

        public ModifyableTableDescriptor addFamily(HColumnDescriptor family) {
            if (family.getName() == null || family.getName().length <= 0) {
                throw new IllegalArgumentException("Family name cannot be null or empty");
            }
            if (this.hasFamily(family.getName())) {
                throw new IllegalArgumentException("Family '" + family.getNameAsString() + "' already exists so cannot be added");
            }
            return this.setFamily(family);
        }

        public ModifyableTableDescriptor modifyFamily(HColumnDescriptor family) {
            if (family.getName() == null || family.getName().length <= 0) {
                throw new IllegalArgumentException("Family name cannot be null or empty");
            }
            if (!this.hasFamily(family.getName())) {
                throw new IllegalArgumentException("Column family '" + family.getNameAsString() + "' does not exist");
            }
            return this.setFamily(family);
        }

        protected ModifyableTableDescriptor setFamily(HColumnDescriptor family) {
            this.families.put(family.getName(), family);
            return this;
        }

        @Override
        public boolean hasFamily(byte[] familyName) {
            return this.families.containsKey(familyName);
        }

        public String toString() {
            StringBuilder s = new StringBuilder();
            s.append('\'').append(Bytes.toString((byte[])this.name.getName())).append('\'');
            s.append((CharSequence)this.getValues(true));
            this.families.values().forEach(f -> s.append(", ").append(f));
            return s.toString();
        }

        public String toStringCustomizedValues() {
            StringBuilder s = new StringBuilder();
            s.append('\'').append(Bytes.toString((byte[])this.name.getName())).append('\'');
            s.append((CharSequence)this.getValues(false));
            this.families.values().forEach(hcd -> s.append(", ").append(hcd.toStringCustomizedValues()));
            return s.toString();
        }

        public String toStringTableAttributes() {
            return this.getValues(true).toString();
        }

        private StringBuilder getValues(boolean printDefaults) {
            boolean hasAttributes;
            StringBuilder s = new StringBuilder();
            TreeSet<Bytes> reservedKeys = new TreeSet<Bytes>();
            TreeSet<Bytes> userKeys = new TreeSet<Bytes>();
            for (Map.Entry<Bytes, Bytes> entry : this.values.entrySet()) {
                if (entry.getKey() == null || entry.getKey().get() == null) continue;
                String key = Bytes.toString((byte[])entry.getKey().get());
                if (!RESERVED_KEYWORDS.contains(entry.getKey()) && !key.startsWith("coprocessor$")) {
                    userKeys.add(entry.getKey());
                    continue;
                }
                String string = Bytes.toString((byte[])entry.getValue().get());
                if (key.equalsIgnoreCase(TableDescriptorBuilder.IS_META) && !Boolean.valueOf(string).booleanValue() || !printDefaults && DEFAULT_VALUES.containsKey(key) && ((String)DEFAULT_VALUES.get(key)).equalsIgnoreCase(string)) continue;
                reservedKeys.add(entry.getKey());
            }
            boolean bl = hasAttributes = !reservedKeys.isEmpty() || !userKeys.isEmpty();
            if (!hasAttributes && this.configuration.isEmpty()) {
                return s;
            }
            s.append(", {");
            if (hasAttributes) {
                s.append("TABLE_ATTRIBUTES => {");
                boolean printCommaForAttr = false;
                for (Bytes bytes : reservedKeys) {
                    String key = Bytes.toString((byte[])bytes.get());
                    String value = Bytes.toStringBinary((byte[])this.values.get(bytes).get());
                    if (printCommaForAttr) {
                        s.append(", ");
                    }
                    printCommaForAttr = true;
                    s.append(key);
                    s.append(" => ");
                    s.append('\'').append(value).append('\'');
                }
                if (!userKeys.isEmpty()) {
                    if (printCommaForAttr) {
                        s.append(", ");
                    }
                    s.append("METADATA").append(" => ");
                    s.append("{");
                    boolean printCommaForCfg = false;
                    for (Bytes k : userKeys) {
                        String key = Bytes.toString((byte[])k.get());
                        String value = Bytes.toStringBinary((byte[])this.values.get(k).get());
                        if (printCommaForCfg) {
                            s.append(", ");
                        }
                        printCommaForCfg = true;
                        s.append('\'').append(key).append('\'');
                        s.append(" => ");
                        s.append('\'').append(value).append('\'');
                    }
                    s.append("}");
                }
            }
            if (!this.configuration.isEmpty()) {
                if (hasAttributes) {
                    s.append(", ");
                }
                s.append("CONFIGURATION").append(" => ");
                s.append('{');
                boolean printCommaForConfig = false;
                for (Map.Entry<String, String> entry : this.configuration.entrySet()) {
                    if (printCommaForConfig) {
                        s.append(", ");
                    }
                    printCommaForConfig = true;
                    s.append('\'').append(entry.getKey()).append('\'');
                    s.append(" => ");
                    s.append('\'').append(entry.getValue()).append('\'');
                }
                s.append("}");
            }
            s.append("}");
            return s;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof ModifyableTableDescriptor)) {
                return false;
            }
            return this.compareTo((ModifyableTableDescriptor)obj) == 0;
        }

        public int hashCode() {
            int result = this.name.hashCode();
            if (this.families.size() > 0) {
                for (HColumnDescriptor e : this.families.values()) {
                    result ^= e.hashCode();
                }
            }
            result ^= this.values.hashCode();
            return result ^= this.configuration.hashCode();
        }

        @Override
        public int compareTo(ModifyableTableDescriptor other) {
            int result = this.name.compareTo(other.name);
            if (result == 0) {
                result = this.families.size() - other.families.size();
            }
            if (result == 0 && this.families.size() != other.families.size()) {
                result = Integer.valueOf(this.families.size()).compareTo(other.families.size());
            }
            if (result == 0) {
                Iterator<HColumnDescriptor> it = this.families.values().iterator();
                Iterator<HColumnDescriptor> it2 = other.families.values().iterator();
                while (it.hasNext() && (result = it.next().compareTo(it2.next())) == 0) {
                }
            }
            if (result == 0) {
                result = this.values.hashCode() - other.values.hashCode();
                if (result < 0) {
                    result = -1;
                } else if (result > 0) {
                    result = 1;
                }
            }
            if (result == 0) {
                result = this.configuration.hashCode() - other.configuration.hashCode();
                if (result < 0) {
                    result = -1;
                } else if (result > 0) {
                    result = 1;
                }
            }
            return result;
        }

        @Override
        public Collection<HColumnDescriptor> getFamilies() {
            return Collections.unmodifiableCollection(this.families.values());
        }

        @Override
        public boolean hasSerialReplicationScope() {
            return this.getFamilies().stream().anyMatch(column -> column.getScope() == 2);
        }

        @Override
        public int getRegionReplication() {
            return this.getIntValue(REGION_REPLICATION_KEY, 1);
        }

        private int getIntValue(Bytes key, int defaultVal) {
            byte[] val = this.getValue(key);
            if (val == null || val.length == 0) {
                return defaultVal;
            }
            return Integer.parseInt(Bytes.toString((byte[])val));
        }

        public ModifyableTableDescriptor setRegionReplication(int regionReplication) {
            return this.setValue(REGION_REPLICATION_KEY, new Bytes(Bytes.toBytes((String)Integer.toString(regionReplication))));
        }

        @Override
        public boolean hasRegionMemstoreReplication() {
            return this.isSomething(REGION_MEMSTORE_REPLICATION_KEY, true);
        }

        public ModifyableTableDescriptor setRegionMemstoreReplication(boolean memstoreReplication) {
            this.setValue(REGION_MEMSTORE_REPLICATION_KEY, memstoreReplication ? TRUE : FALSE);
            return this.setConfiguration("hbase.region.replica.wait.for.primary.flush", Boolean.toString(memstoreReplication));
        }

        public ModifyableTableDescriptor setPriority(int priority) {
            return this.setValue(PRIORITY_KEY, Integer.toString(priority));
        }

        @Override
        public int getPriority() {
            return this.getIntValue(PRIORITY_KEY, 0);
        }

        @Override
        public Set<byte[]> getFamiliesKeys() {
            return Collections.unmodifiableSet(this.families.keySet());
        }

        @Override
        public int getColumnFamilyCount() {
            return this.families.size();
        }

        @Override
        public HColumnDescriptor[] getColumnFamilies() {
            Collection<HColumnDescriptor> hColumnDescriptors = this.getFamilies();
            return hColumnDescriptors.toArray(new HColumnDescriptor[hColumnDescriptors.size()]);
        }

        @Override
        public HColumnDescriptor getFamily(byte[] column) {
            return this.families.get(column);
        }

        public HColumnDescriptor removeFamily(byte[] column) {
            return this.families.remove(column);
        }

        public ModifyableTableDescriptor addCoprocessor(String className) throws IOException {
            return this.addCoprocessor(className, null, 0x3FFFFFFF, null);
        }

        public ModifyableTableDescriptor addCoprocessor(String className, Path jarFilePath, int priority, Map<String, String> kvs) throws IOException {
            this.checkHasCoprocessor(className);
            StringBuilder kvString = new StringBuilder();
            if (kvs != null) {
                for (Map.Entry<String, String> e : kvs.entrySet()) {
                    if (!e.getKey().matches("[^=,]+")) {
                        throw new IOException("Illegal parameter key = " + e.getKey());
                    }
                    if (!e.getValue().matches("[^,]+")) {
                        throw new IOException("Illegal parameter (" + e.getKey() + ") value = " + e.getValue());
                    }
                    if (kvString.length() != 0) {
                        kvString.append(',');
                    }
                    kvString.append(e.getKey());
                    kvString.append('=');
                    kvString.append(e.getValue());
                }
            }
            String value = (jarFilePath == null ? "" : jarFilePath.toString()) + "|" + className + "|" + Integer.toString(priority) + "|" + kvString.toString();
            return this.addCoprocessorToMap(value);
        }

        public ModifyableTableDescriptor addCoprocessorWithSpec(String specStr) throws IOException {
            String className = ModifyableTableDescriptor.getCoprocessorClassNameFromSpecStr(specStr);
            if (className == null) {
                throw new IllegalArgumentException("Format does not match " + HConstants.CP_HTD_ATTR_VALUE_PATTERN + ": " + specStr);
            }
            this.checkHasCoprocessor(className);
            return this.addCoprocessorToMap(specStr);
        }

        private void checkHasCoprocessor(String className) throws IOException {
            if (this.hasCoprocessor(className)) {
                throw new IOException("Coprocessor " + className + " already exists.");
            }
        }

        private ModifyableTableDescriptor addCoprocessorToMap(String specStr) {
            if (specStr == null) {
                return this;
            }
            int maxCoprocessorNumber = 0;
            for (Map.Entry<Bytes, Bytes> e : this.values.entrySet()) {
                Matcher keyMatcher = HConstants.CP_HTD_ATTR_KEY_PATTERN.matcher(Bytes.toString((byte[])e.getKey().get()));
                if (!keyMatcher.matches()) continue;
                maxCoprocessorNumber = Math.max(Integer.parseInt(keyMatcher.group(1)), maxCoprocessorNumber);
            }
            String key = "coprocessor$" + Integer.toString(++maxCoprocessorNumber);
            return this.setValue(new Bytes(Bytes.toBytes((String)key)), new Bytes(Bytes.toBytes((String)specStr)));
        }

        @Override
        public boolean hasCoprocessor(String classNameToMatch) {
            for (Map.Entry<Bytes, Bytes> e : this.values.entrySet()) {
                String className;
                Matcher keyMatcher = HConstants.CP_HTD_ATTR_KEY_PATTERN.matcher(Bytes.toString((byte[])e.getKey().get()));
                if (!keyMatcher.matches() || (className = ModifyableTableDescriptor.getCoprocessorClassNameFromSpecStr(Bytes.toString((byte[])e.getValue().get()))) == null || !className.equals(classNameToMatch.trim())) continue;
                return true;
            }
            return false;
        }

        public List<String> getCoprocessors() {
            ArrayList<String> result = new ArrayList<String>(this.values.entrySet().size());
            for (Map.Entry<Bytes, Bytes> e : this.values.entrySet()) {
                String className;
                Matcher keyMatcher = HConstants.CP_HTD_ATTR_KEY_PATTERN.matcher(Bytes.toString((byte[])e.getKey().get()));
                if (!keyMatcher.matches() || (className = ModifyableTableDescriptor.getCoprocessorClassNameFromSpecStr(Bytes.toString((byte[])e.getValue().get()))) == null) continue;
                result.add(className);
            }
            return result;
        }

        private static String getCoprocessorClassNameFromSpecStr(String spec) {
            Matcher matcher = HConstants.CP_HTD_ATTR_VALUE_PATTERN.matcher(spec);
            return matcher != null && matcher.matches() ? matcher.group(2).trim() : null;
        }

        public void removeCoprocessor(String className) {
            Bytes match = null;
            for (Map.Entry<Bytes, Bytes> e : this.values.entrySet()) {
                String clazz;
                Matcher valueMatcher;
                Matcher keyMatcher = HConstants.CP_HTD_ATTR_KEY_PATTERN.matcher(Bytes.toString((byte[])e.getKey().get()));
                if (!keyMatcher.matches() || !(valueMatcher = HConstants.CP_HTD_ATTR_VALUE_PATTERN.matcher(Bytes.toString((byte[])e.getValue().get()))).matches() || !(clazz = valueMatcher.group(2).trim()).equals(className.trim())) continue;
                match = e.getKey();
                break;
            }
            if (match != null) {
                this.remove(match);
            }
        }

        @Deprecated
        public ModifyableTableDescriptor setOwner(User owner) {
            return this.setOwnerString(owner != null ? owner.getShortName() : null);
        }

        @Deprecated
        public ModifyableTableDescriptor setOwnerString(String ownerString) {
            if (ownerString != null) {
                this.setValue(OWNER_KEY, ownerString);
            } else {
                this.remove(OWNER_KEY);
            }
            return this;
        }

        @Override
        @Deprecated
        public String getOwnerString() {
            if (this.getValue(OWNER_KEY) != null) {
                return Bytes.toString((byte[])this.getValue(OWNER_KEY));
            }
            return null;
        }

        public byte[] toByteArray() {
            return ProtobufUtil.prependPBMagic(ProtobufUtil.convertToTableSchema(this).toByteArray());
        }

        public static TableDescriptor parseFrom(byte[] bytes) throws DeserializationException {
            if (!ProtobufUtil.isPBMagicPrefix(bytes)) {
                throw new DeserializationException("Expected PB encoded ModifyableTableDescriptor");
            }
            int pblen = ProtobufUtil.lengthOfPBMagic();
            HBaseProtos.TableSchema.Builder builder = HBaseProtos.TableSchema.newBuilder();
            try {
                ProtobufUtil.mergeFrom((Message.Builder)builder, bytes, pblen, bytes.length - pblen);
                return ProtobufUtil.convertToTableDesc(builder.build());
            }
            catch (IOException e) {
                throw new DeserializationException((Throwable)e);
            }
        }

        @Override
        public String getConfigurationValue(String key) {
            return this.configuration.get(key);
        }

        @Override
        public Map<String, String> getConfiguration() {
            return Collections.unmodifiableMap(this.configuration);
        }

        public ModifyableTableDescriptor setConfiguration(String key, String value) {
            if (value == null) {
                this.removeConfiguration(key);
            } else {
                this.configuration.put(key, value);
            }
            return this;
        }

        public void removeConfiguration(String key) {
            this.configuration.remove(key);
        }
    }
}

