/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.ipc;

import com.google.common.base.Preconditions;
import io.netty.channel.Channel;
import io.netty.channel.EventLoopGroup;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.ipc.DefaultNettyEventLoopConfig;
import org.apache.hadoop.hbase.util.Pair;

@InterfaceAudience.Public
public class NettyRpcClientConfigHelper {
    public static final String EVENT_LOOP_CONFIG = "hbase.rpc.client.event-loop.config";
    private static final String CONFIG_NAME = "global-event-loop";
    private static final Map<String, Pair<EventLoopGroup, Class<? extends Channel>>> EVENT_LOOP_CONFIG_MAP = new HashMap<String, Pair<EventLoopGroup, Class<? extends Channel>>>();

    public static void setEventLoopConfig(Configuration conf, EventLoopGroup group, Class<? extends Channel> channelClass) {
        Preconditions.checkNotNull((Object)group, (Object)"group is null");
        Preconditions.checkNotNull(channelClass, (Object)"channel class is null");
        conf.set(EVENT_LOOP_CONFIG, CONFIG_NAME);
        EVENT_LOOP_CONFIG_MAP.put(CONFIG_NAME, (Pair<EventLoopGroup, Class<? extends Channel>>)Pair.newPair((Object)group, channelClass));
    }

    public static void createEventLoopPerClient(Configuration conf) {
        conf.set(EVENT_LOOP_CONFIG, "");
        EVENT_LOOP_CONFIG_MAP.clear();
    }

    static Pair<EventLoopGroup, Class<? extends Channel>> getEventLoopConfig(Configuration conf) {
        String name = conf.get(EVENT_LOOP_CONFIG);
        if (name == null) {
            return DefaultNettyEventLoopConfig.GROUP_AND_CHANNEL_CLASS;
        }
        if (StringUtils.isBlank((String)name)) {
            return null;
        }
        return EVENT_LOOP_CONFIG_MAP.get(name);
    }
}

