/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.ipc;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.LengthFieldBasedFrameDecoder;
import io.netty.handler.timeout.IdleStateHandler;
import io.netty.handler.timeout.ReadTimeoutHandler;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.FutureListener;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.Promise;
import java.io.IOException;
import java.io.OutputStream;
import java.net.SocketAddress;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.ipc.AbstractRpcClient;
import org.apache.hadoop.hbase.ipc.BufferCallBeforeInitHandler;
import org.apache.hadoop.hbase.ipc.Call;
import org.apache.hadoop.hbase.ipc.CallEvent;
import org.apache.hadoop.hbase.ipc.ConnectionId;
import org.apache.hadoop.hbase.ipc.FallbackDisallowedException;
import org.apache.hadoop.hbase.ipc.FatalConnectionException;
import org.apache.hadoop.hbase.ipc.HBaseRpcController;
import org.apache.hadoop.hbase.ipc.IPCUtil;
import org.apache.hadoop.hbase.ipc.NettyRpcClient;
import org.apache.hadoop.hbase.ipc.NettyRpcDuplexHandler;
import org.apache.hadoop.hbase.ipc.RpcConnection;
import org.apache.hadoop.hbase.security.NettyHBaseRpcConnectionHeaderHandler;
import org.apache.hadoop.hbase.security.NettyHBaseSaslRpcClientHandler;
import org.apache.hadoop.hbase.security.SaslChallengeDecoder;
import org.apache.hadoop.hbase.shaded.com.google.protobuf.RpcCallback;
import org.apache.hadoop.hbase.shaded.protobuf.generated.RPCProtos;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;

@InterfaceAudience.Private
class NettyRpcConnection
extends RpcConnection {
    private static final Log LOG = LogFactory.getLog(NettyRpcConnection.class);
    private static final ScheduledExecutorService RELOGIN_EXECUTOR = Executors.newSingleThreadScheduledExecutor(Threads.newDaemonThreadFactory((String)"Relogin"));
    private final NettyRpcClient rpcClient;
    private ByteBuf connectionHeaderPreamble;
    private ByteBuf connectionHeaderWithLength;
    @SuppressWarnings(value={"IS2_INCONSISTENT_SYNC"}, justification="connect is also under lock as notifyOnCancel will call our action directly")
    private Channel channel;
    private boolean reloginInProgress;

    NettyRpcConnection(NettyRpcClient rpcClient, ConnectionId remoteId) throws IOException {
        super(rpcClient.conf, AbstractRpcClient.WHEEL_TIMER, remoteId, rpcClient.clusterId, rpcClient.userProvider.isHBaseSecurityEnabled(), rpcClient.codec, rpcClient.compressor);
        this.rpcClient = rpcClient;
        byte[] connectionHeaderPreamble = this.getConnectionHeaderPreamble();
        this.connectionHeaderPreamble = Unpooled.directBuffer((int)connectionHeaderPreamble.length).writeBytes(connectionHeaderPreamble);
        RPCProtos.ConnectionHeader header = this.getConnectionHeader();
        this.connectionHeaderWithLength = Unpooled.directBuffer((int)(4 + header.getSerializedSize()));
        this.connectionHeaderWithLength.writeInt(header.getSerializedSize());
        header.writeTo((OutputStream)new ByteBufOutputStream(this.connectionHeaderWithLength));
    }

    @Override
    protected synchronized void callTimeout(Call call) {
        if (this.channel != null) {
            this.channel.pipeline().fireUserEventTriggered((Object)new CallEvent(CallEvent.Type.TIMEOUT, call));
        }
    }

    @Override
    public synchronized boolean isActive() {
        return this.channel != null;
    }

    private void shutdown0() {
        if (this.channel != null) {
            this.channel.close();
            this.channel = null;
        }
    }

    @Override
    public synchronized void shutdown() {
        this.shutdown0();
    }

    @Override
    public synchronized void cleanupConnection() {
        if (this.connectionHeaderPreamble != null) {
            ReferenceCountUtil.safeRelease((Object)this.connectionHeaderPreamble);
        }
        if (this.connectionHeaderWithLength != null) {
            ReferenceCountUtil.safeRelease((Object)this.connectionHeaderWithLength);
        }
    }

    private void established(Channel ch) throws IOException {
        ChannelPipeline p = ch.pipeline();
        String addBeforeHandler = p.context(BufferCallBeforeInitHandler.class).name();
        p.addBefore(addBeforeHandler, null, (ChannelHandler)new IdleStateHandler(0L, (long)this.rpcClient.minIdleTimeBeforeClose, 0L, TimeUnit.MILLISECONDS));
        p.addBefore(addBeforeHandler, null, (ChannelHandler)new LengthFieldBasedFrameDecoder(Integer.MAX_VALUE, 0, 4));
        p.addBefore(addBeforeHandler, null, (ChannelHandler)new NettyRpcDuplexHandler(this, this.rpcClient.cellBlockBuilder, this.codec, this.compressor));
        p.fireUserEventTriggered((Object)BufferCallBeforeInitHandler.BufferCallEvent.success());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleRelogin(Throwable error) {
        if (error instanceof FallbackDisallowedException) {
            return;
        }
        NettyRpcConnection nettyRpcConnection = this;
        synchronized (nettyRpcConnection) {
            if (this.reloginInProgress) {
                return;
            }
            this.reloginInProgress = true;
            RELOGIN_EXECUTOR.schedule(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        if (NettyRpcConnection.this.shouldAuthenticateOverKrb()) {
                            NettyRpcConnection.this.relogin();
                        }
                    }
                    catch (IOException e) {
                        LOG.warn((Object)"relogin failed", (Throwable)e);
                    }
                    1 var1_2 = this;
                    synchronized (var1_2) {
                        NettyRpcConnection.this.reloginInProgress = false;
                    }
                }
            }, (long)ThreadLocalRandom.current().nextInt(this.reloginMaxBackoff), TimeUnit.MILLISECONDS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void failInit(Channel ch, IOException e) {
        NettyRpcConnection nettyRpcConnection = this;
        synchronized (nettyRpcConnection) {
            ch.pipeline().fireUserEventTriggered((Object)BufferCallBeforeInitHandler.BufferCallEvent.fail(e));
            this.shutdown0();
            return;
        }
    }

    private void saslNegotiate(final Channel ch) {
        NettyHBaseSaslRpcClientHandler saslHandler;
        UserGroupInformation ticket = this.getUGI();
        if (ticket == null) {
            this.failInit(ch, (IOException)((Object)new FatalConnectionException("ticket/user is null")));
            return;
        }
        Promise saslPromise = ch.eventLoop().newPromise();
        try {
            saslHandler = new NettyHBaseSaslRpcClientHandler((Promise<Boolean>)saslPromise, ticket, this.authMethod, (Token<? extends TokenIdentifier>)this.token, this.serverPrincipal, this.rpcClient.fallbackAllowed, this.rpcClient.conf);
        }
        catch (IOException e) {
            this.failInit(ch, e);
            return;
        }
        ch.pipeline().addFirst(new ChannelHandler[]{new SaslChallengeDecoder(), saslHandler});
        saslPromise.addListener((GenericFutureListener)new FutureListener<Boolean>(){

            public void operationComplete(Future<Boolean> future) throws Exception {
                if (future.isSuccess()) {
                    ChannelPipeline p = ch.pipeline();
                    p.remove(SaslChallengeDecoder.class);
                    p.remove(NettyHBaseSaslRpcClientHandler.class);
                    if (saslHandler.isNeedProcessConnectionHeader()) {
                        Promise connectionHeaderPromise = ch.eventLoop().newPromise();
                        NettyHBaseRpcConnectionHeaderHandler chHandler = new NettyHBaseRpcConnectionHeaderHandler((Promise<Boolean>)connectionHeaderPromise, NettyRpcConnection.this.conf, NettyRpcConnection.this.connectionHeaderWithLength);
                        p.addFirst(new ChannelHandler[]{new ReadTimeoutHandler(20000L, TimeUnit.MILLISECONDS)});
                        p.addLast(new ChannelHandler[]{chHandler});
                        connectionHeaderPromise.addListener((GenericFutureListener)new FutureListener<Boolean>(){

                            public void operationComplete(Future<Boolean> future) throws Exception {
                                if (future.isSuccess()) {
                                    ChannelPipeline p = ch.pipeline();
                                    p.remove(ReadTimeoutHandler.class);
                                    p.remove(NettyHBaseRpcConnectionHeaderHandler.class);
                                    NettyRpcConnection.this.established(ch);
                                } else {
                                    Throwable error = future.cause();
                                    NettyRpcConnection.this.scheduleRelogin(error);
                                    NettyRpcConnection.this.failInit(ch, IPCUtil.toIOE(error));
                                }
                            }
                        });
                    } else {
                        ch.write((Object)NettyRpcConnection.this.connectionHeaderWithLength.retainedDuplicate());
                        NettyRpcConnection.this.established(ch);
                    }
                } else {
                    Throwable error = future.cause();
                    NettyRpcConnection.this.scheduleRelogin(error);
                    NettyRpcConnection.this.failInit(ch, IPCUtil.toIOE(error));
                }
            }
        });
    }

    private void connect() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Connecting to " + this.remoteId.address));
        }
        this.channel = ((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group(this.rpcClient.group)).channel(this.rpcClient.channelClass)).option(ChannelOption.TCP_NODELAY, (Object)this.rpcClient.isTcpNoDelay())).option(ChannelOption.SO_KEEPALIVE, (Object)this.rpcClient.tcpKeepAlive)).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)this.rpcClient.connectTO)).handler((ChannelHandler)new BufferCallBeforeInitHandler())).localAddress(this.rpcClient.localAddr)).remoteAddress((SocketAddress)this.remoteId.address).connect().addListener((GenericFutureListener)new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) throws Exception {
                Channel ch = future.channel();
                if (!future.isSuccess()) {
                    NettyRpcConnection.this.failInit(ch, IPCUtil.toIOE(future.cause()));
                    ((NettyRpcConnection)NettyRpcConnection.this).rpcClient.failedServers.addToFailedServers(NettyRpcConnection.this.remoteId.address);
                    return;
                }
                ch.writeAndFlush((Object)NettyRpcConnection.this.connectionHeaderPreamble.retainedDuplicate());
                if (NettyRpcConnection.this.useSasl) {
                    NettyRpcConnection.this.saslNegotiate(ch);
                } else {
                    ch.write((Object)NettyRpcConnection.this.connectionHeaderWithLength.retainedDuplicate());
                    NettyRpcConnection.this.established(ch);
                }
            }
        }).channel();
    }

    @Override
    public synchronized void sendRequest(final Call call, HBaseRpcController hrc) throws IOException {
        if (this.reloginInProgress) {
            throw new IOException("Can not send request because relogin is in progress.");
        }
        hrc.notifyOnCancel(new RpcCallback<Object>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run(Object parameter) {
                IPCUtil.setCancelled(call);
                4 var2_2 = this;
                synchronized (var2_2) {
                    if (NettyRpcConnection.this.channel != null) {
                        NettyRpcConnection.this.channel.pipeline().fireUserEventTriggered((Object)new CallEvent(CallEvent.Type.CANCELLED, call));
                    }
                }
            }
        }, new HBaseRpcController.CancellationCallback(){

            @Override
            public void run(boolean cancelled) throws IOException {
                if (cancelled) {
                    IPCUtil.setCancelled(call);
                } else {
                    if (NettyRpcConnection.this.channel == null) {
                        NettyRpcConnection.this.connect();
                    }
                    NettyRpcConnection.this.scheduleTimeoutTask(call);
                    NettyRpcConnection.this.channel.writeAndFlush((Object)call).addListener((GenericFutureListener)new ChannelFutureListener(){

                        public void operationComplete(ChannelFuture future) throws Exception {
                            if (!future.isSuccess()) {
                                call.setException(IPCUtil.toIOE(future.cause()));
                            }
                        }
                    });
                }
            }
        });
    }
}

