/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.protobuf;

import com.google.protobuf.ByteString;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.Parser;
import com.google.protobuf.RpcChannel;
import com.google.protobuf.RpcController;
import com.google.protobuf.Service;
import com.google.protobuf.TextFormat;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellScanner;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HBaseIOException;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.Tag;
import org.apache.hadoop.hbase.TagUtil;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.client.Append;
import org.apache.hadoop.hbase.client.Consistency;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.PackagePrivateFieldAccessor;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.SnapshotType;
import org.apache.hadoop.hbase.client.metrics.ScanMetrics;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.filter.ByteArrayComparable;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.io.TimeRange;
import org.apache.hadoop.hbase.protobuf.ProtobufMagic;
import org.apache.hadoop.hbase.protobuf.generated.AdminProtos;
import org.apache.hadoop.hbase.protobuf.generated.CellProtos;
import org.apache.hadoop.hbase.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.protobuf.generated.ComparatorProtos;
import org.apache.hadoop.hbase.protobuf.generated.FilterProtos;
import org.apache.hadoop.hbase.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.protobuf.generated.MapReduceProtos;
import org.apache.hadoop.hbase.protobuf.generated.ZooKeeperProtos;
import org.apache.hadoop.hbase.shaded.com.google.protobuf.ServiceException;
import org.apache.hadoop.hbase.util.Addressing;
import org.apache.hadoop.hbase.util.ByteStringer;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.DynamicClassLoader;
import org.apache.hadoop.hbase.util.ExceptionUtil;
import org.apache.hadoop.hbase.util.Methods;
import org.apache.hadoop.ipc.RemoteException;

@InterfaceAudience.Private
@SuppressWarnings(value={"DP_CREATE_CLASSLOADER_INSIDE_DO_PRIVILEGED"}, justification="None. Address sometime.")
public final class ProtobufUtil {
    private static final Map<String, Class<?>> PRIMITIVES = new HashMap();
    private static final Cell[] EMPTY_CELL_ARRAY = new Cell[0];
    private static final Result EMPTY_RESULT = Result.create(EMPTY_CELL_ARRAY);
    static final Result EMPTY_RESULT_EXISTS_TRUE = Result.create(null, true);
    static final Result EMPTY_RESULT_EXISTS_FALSE = Result.create(null, false);
    private static final Result EMPTY_RESULT_STALE = Result.create(EMPTY_CELL_ARRAY, null, true);
    private static final Result EMPTY_RESULT_EXISTS_TRUE_STALE = Result.create((Cell[])null, (Boolean)true, true);
    private static final Result EMPTY_RESULT_EXISTS_FALSE_STALE = Result.create((Cell[])null, (Boolean)false, true);
    private static final ClientProtos.Result EMPTY_RESULT_PB;
    private static final ClientProtos.Result EMPTY_RESULT_PB_EXISTS_TRUE;
    private static final ClientProtos.Result EMPTY_RESULT_PB_EXISTS_FALSE;
    private static final ClientProtos.Result EMPTY_RESULT_PB_STALE;
    private static final ClientProtos.Result EMPTY_RESULT_PB_EXISTS_TRUE_STALE;
    private static final ClientProtos.Result EMPTY_RESULT_PB_EXISTS_FALSE_STALE;
    private static final ClassLoader CLASS_LOADER;
    private static AdminProtos.GetServerInfoRequest GET_SERVER_INFO_REQUEST;

    private ProtobufUtil() {
    }

    public static byte[] prependPBMagic(byte[] bytes) {
        return Bytes.add((byte[])ProtobufMagic.PB_MAGIC, (byte[])bytes);
    }

    public static boolean isPBMagicPrefix(byte[] bytes) {
        return ProtobufMagic.isPBMagicPrefix(bytes);
    }

    public static boolean isPBMagicPrefix(byte[] bytes, int offset, int len) {
        return ProtobufMagic.isPBMagicPrefix(bytes, offset, len);
    }

    public static void expectPBMagicPrefix(byte[] bytes) throws DeserializationException {
        if (!ProtobufUtil.isPBMagicPrefix(bytes)) {
            throw new DeserializationException("Missing pb magic " + Bytes.toString((byte[])ProtobufMagic.PB_MAGIC) + " prefix");
        }
    }

    public static int lengthOfPBMagic() {
        return ProtobufMagic.lengthOfPBMagic();
    }

    public static IOException getRemoteException(com.google.protobuf.ServiceException se) {
        return ProtobufUtil.makeIOExceptionOfException((Exception)se);
    }

    public static IOException handleRemoteException(Exception e) {
        return ProtobufUtil.makeIOExceptionOfException(e);
    }

    private static IOException makeIOExceptionOfException(Exception e) {
        Throwable t = e;
        if (e instanceof com.google.protobuf.ServiceException || e instanceof ServiceException) {
            t = e.getCause();
        }
        if (ExceptionUtil.isInterrupt((Throwable)t)) {
            return ExceptionUtil.asInterrupt((Throwable)t);
        }
        if (t instanceof RemoteException) {
            t = ((RemoteException)t).unwrapRemoteException();
        }
        return t instanceof IOException ? (IOException)t : new HBaseIOException(t);
    }

    public static HBaseProtos.ServerName toServerName(ServerName serverName) {
        if (serverName == null) {
            return null;
        }
        HBaseProtos.ServerName.Builder builder = HBaseProtos.ServerName.newBuilder();
        builder.setHostName(serverName.getHostname());
        if (serverName.getPort() >= 0) {
            builder.setPort(serverName.getPort());
        }
        if (serverName.getStartcode() >= 0L) {
            builder.setStartCode(serverName.getStartcode());
        }
        return builder.build();
    }

    public static ServerName toServerName(HBaseProtos.ServerName proto) {
        if (proto == null) {
            return null;
        }
        String hostName = proto.getHostName();
        long startCode = -1L;
        int port = -1;
        if (proto.hasPort()) {
            port = proto.getPort();
        }
        if (proto.hasStartCode()) {
            startCode = proto.getStartCode();
        }
        return ServerName.valueOf((String)hostName, (int)port, (long)startCode);
    }

    public static Durability toDurability(ClientProtos.MutationProto.Durability proto) {
        switch (proto) {
            case USE_DEFAULT: {
                return Durability.USE_DEFAULT;
            }
            case SKIP_WAL: {
                return Durability.SKIP_WAL;
            }
            case ASYNC_WAL: {
                return Durability.ASYNC_WAL;
            }
            case SYNC_WAL: {
                return Durability.SYNC_WAL;
            }
            case FSYNC_WAL: {
                return Durability.FSYNC_WAL;
            }
        }
        return Durability.USE_DEFAULT;
    }

    public static ClientProtos.MutationProto.Durability toDurability(Durability d) {
        switch (d) {
            case USE_DEFAULT: {
                return ClientProtos.MutationProto.Durability.USE_DEFAULT;
            }
            case SKIP_WAL: {
                return ClientProtos.MutationProto.Durability.SKIP_WAL;
            }
            case ASYNC_WAL: {
                return ClientProtos.MutationProto.Durability.ASYNC_WAL;
            }
            case SYNC_WAL: {
                return ClientProtos.MutationProto.Durability.SYNC_WAL;
            }
            case FSYNC_WAL: {
                return ClientProtos.MutationProto.Durability.FSYNC_WAL;
            }
        }
        return ClientProtos.MutationProto.Durability.USE_DEFAULT;
    }

    public static Get toGet(ClientProtos.Get proto) throws IOException {
        if (proto == null) {
            return null;
        }
        byte[] row = proto.getRow().toByteArray();
        Get get = new Get(row);
        if (proto.hasCacheBlocks()) {
            get.setCacheBlocks(proto.getCacheBlocks());
        }
        if (proto.hasMaxVersions()) {
            get.setMaxVersions(proto.getMaxVersions());
        }
        if (proto.hasStoreLimit()) {
            get.setMaxResultsPerColumnFamily(proto.getStoreLimit());
        }
        if (proto.hasStoreOffset()) {
            get.setRowOffsetPerColumnFamily(proto.getStoreOffset());
        }
        if (proto.getCfTimeRangeCount() > 0) {
            for (HBaseProtos.ColumnFamilyTimeRange cftr : proto.getCfTimeRangeList()) {
                TimeRange timeRange = ProtobufUtil.protoToTimeRange(cftr.getTimeRange());
                get.setColumnFamilyTimeRange(cftr.getColumnFamily().toByteArray(), timeRange);
            }
        }
        if (proto.hasTimeRange()) {
            TimeRange timeRange = ProtobufUtil.protoToTimeRange(proto.getTimeRange());
            get.setTimeRange(timeRange);
        }
        if (proto.hasFilter()) {
            FilterProtos.Filter filter = proto.getFilter();
            get.setFilter(ProtobufUtil.toFilter(filter));
        }
        for (HBaseProtos.NameBytesPair attribute : proto.getAttributeList()) {
            get.setAttribute(attribute.getName(), attribute.getValue().toByteArray());
        }
        if (proto.getColumnCount() > 0) {
            for (ClientProtos.Column column : proto.getColumnList()) {
                byte[] family = column.getFamily().toByteArray();
                if (column.getQualifierCount() > 0) {
                    for (ByteString qualifier : column.getQualifierList()) {
                        get.addColumn(family, qualifier.toByteArray());
                    }
                    continue;
                }
                get.addFamily(family);
            }
        }
        if (proto.hasExistenceOnly() && proto.getExistenceOnly()) {
            get.setCheckExistenceOnly(true);
        }
        if (proto.hasConsistency()) {
            get.setConsistency(ProtobufUtil.toConsistency(proto.getConsistency()));
        }
        if (proto.hasLoadColumnFamiliesOnDemand()) {
            get.setLoadColumnFamiliesOnDemand(proto.getLoadColumnFamiliesOnDemand());
        }
        return get;
    }

    public static Consistency toConsistency(ClientProtos.Consistency consistency) {
        switch (consistency) {
            case STRONG: {
                return Consistency.STRONG;
            }
            case TIMELINE: {
                return Consistency.TIMELINE;
            }
        }
        return Consistency.STRONG;
    }

    public static ClientProtos.Consistency toConsistency(Consistency consistency) {
        switch (consistency) {
            case STRONG: {
                return ClientProtos.Consistency.STRONG;
            }
            case TIMELINE: {
                return ClientProtos.Consistency.TIMELINE;
            }
        }
        return ClientProtos.Consistency.STRONG;
    }

    public static Put toPut(ClientProtos.MutationProto proto) throws IOException {
        return ProtobufUtil.toPut(proto, null);
    }

    public static Put toPut(ClientProtos.MutationProto proto, CellScanner cellScanner) throws IOException {
        int cellCount;
        ClientProtos.MutationProto.MutationType type = proto.getMutateType();
        assert (type == ClientProtos.MutationProto.MutationType.PUT) : type.name();
        long timestamp = proto.hasTimestamp() ? proto.getTimestamp() : Long.MAX_VALUE;
        Put put = proto.hasRow() ? new Put(proto.getRow().toByteArray(), timestamp) : null;
        int n = cellCount = proto.hasAssociatedCellCount() ? proto.getAssociatedCellCount() : 0;
        if (cellCount > 0) {
            if (cellScanner == null) {
                throw new DoNotRetryIOException("Cell count of " + cellCount + " but no cellScanner: " + ProtobufUtil.toShortString(proto));
            }
            for (int i = 0; i < cellCount; ++i) {
                if (!cellScanner.advance()) {
                    throw new DoNotRetryIOException("Cell count of " + cellCount + " but at index " + i + " no cell returned: " + ProtobufUtil.toShortString(proto));
                }
                Cell cell = cellScanner.current();
                if (put == null) {
                    put = new Put(cell.getRowArray(), cell.getRowOffset(), cell.getRowLength(), timestamp);
                }
                put.add(cell);
            }
        } else {
            if (put == null) {
                throw new IllegalArgumentException("row cannot be null");
            }
            for (ClientProtos.MutationProto.ColumnValue column : proto.getColumnValueList()) {
                byte[] family = column.getFamily().toByteArray();
                for (ClientProtos.MutationProto.ColumnValue.QualifierValue qv : column.getQualifierValueList()) {
                    byte[] qual;
                    if (!qv.hasValue()) {
                        throw new DoNotRetryIOException("Missing required field: qualifier value");
                    }
                    ByteBuffer qualifier = qv.hasQualifier() ? qv.getQualifier().asReadOnlyByteBuffer() : null;
                    ByteBuffer value = qv.hasValue() ? qv.getValue().asReadOnlyByteBuffer() : null;
                    long ts = timestamp;
                    if (qv.hasTimestamp()) {
                        ts = qv.getTimestamp();
                    }
                    if (qv.hasTags()) {
                        byte[] allTagsBytes = qv.getTags().toByteArray();
                        if (qv.hasDeleteType()) {
                            qual = qv.hasQualifier() ? qv.getQualifier().toByteArray() : null;
                            put.add((Cell)new KeyValue(proto.getRow().toByteArray(), family, qual, ts, ProtobufUtil.fromDeleteType(qv.getDeleteType()), null, allTagsBytes));
                            continue;
                        }
                        List tags = TagUtil.asList((byte[])allTagsBytes, (int)0, (int)((short)allTagsBytes.length));
                        Tag[] tagsArray = new Tag[tags.size()];
                        put.addImmutable(family, qualifier, ts, value, tags.toArray(tagsArray));
                        continue;
                    }
                    if (qv.hasDeleteType()) {
                        qual = qv.hasQualifier() ? qv.getQualifier().toByteArray() : null;
                        put.add((Cell)new KeyValue(proto.getRow().toByteArray(), family, qual, ts, ProtobufUtil.fromDeleteType(qv.getDeleteType())));
                        continue;
                    }
                    put.addImmutable(family, qualifier, ts, value);
                }
            }
        }
        put.setDurability(ProtobufUtil.toDurability(proto.getDurability()));
        for (HBaseProtos.NameBytesPair attribute : proto.getAttributeList()) {
            put.setAttribute(attribute.getName(), attribute.getValue().toByteArray());
        }
        return put;
    }

    public static Delete toDelete(ClientProtos.MutationProto proto) throws IOException {
        return ProtobufUtil.toDelete(proto, null);
    }

    public static Delete toDelete(ClientProtos.MutationProto proto, CellScanner cellScanner) throws IOException {
        int cellCount;
        ClientProtos.MutationProto.MutationType type = proto.getMutateType();
        assert (type == ClientProtos.MutationProto.MutationType.DELETE) : type.name();
        long timestamp = proto.hasTimestamp() ? proto.getTimestamp() : Long.MAX_VALUE;
        Delete delete = proto.hasRow() ? new Delete(proto.getRow().toByteArray(), timestamp) : null;
        int n = cellCount = proto.hasAssociatedCellCount() ? proto.getAssociatedCellCount() : 0;
        if (cellCount > 0) {
            if (cellScanner == null) {
                throw new DoNotRetryIOException("Cell count of " + cellCount + " but no cellScanner: " + TextFormat.shortDebugString((MessageOrBuilder)proto));
            }
            for (int i = 0; i < cellCount; ++i) {
                if (!cellScanner.advance()) {
                    throw new DoNotRetryIOException("Cell count of " + cellCount + " but at index " + i + " no cell returned: " + TextFormat.shortDebugString((MessageOrBuilder)proto));
                }
                Cell cell = cellScanner.current();
                if (delete == null) {
                    delete = new Delete(cell.getRowArray(), cell.getRowOffset(), cell.getRowLength(), timestamp);
                }
                delete.addDeleteMarker(cell);
            }
        } else {
            if (delete == null) {
                throw new IllegalArgumentException("row cannot be null");
            }
            for (ClientProtos.MutationProto.ColumnValue column : proto.getColumnValueList()) {
                byte[] family = column.getFamily().toByteArray();
                for (ClientProtos.MutationProto.ColumnValue.QualifierValue qv : column.getQualifierValueList()) {
                    ClientProtos.MutationProto.DeleteType deleteType = qv.getDeleteType();
                    byte[] qualifier = null;
                    if (qv.hasQualifier()) {
                        qualifier = qv.getQualifier().toByteArray();
                    }
                    long ts = Long.MAX_VALUE;
                    if (qv.hasTimestamp()) {
                        ts = qv.getTimestamp();
                    }
                    if (deleteType == ClientProtos.MutationProto.DeleteType.DELETE_ONE_VERSION) {
                        delete.addColumn(family, qualifier, ts);
                        continue;
                    }
                    if (deleteType == ClientProtos.MutationProto.DeleteType.DELETE_MULTIPLE_VERSIONS) {
                        delete.addColumns(family, qualifier, ts);
                        continue;
                    }
                    if (deleteType == ClientProtos.MutationProto.DeleteType.DELETE_FAMILY_VERSION) {
                        delete.addFamilyVersion(family, ts);
                        continue;
                    }
                    delete.addFamily(family, ts);
                }
            }
        }
        delete.setDurability(ProtobufUtil.toDurability(proto.getDurability()));
        for (HBaseProtos.NameBytesPair attribute : proto.getAttributeList()) {
            delete.setAttribute(attribute.getName(), attribute.getValue().toByteArray());
        }
        return delete;
    }

    public static Append toAppend(ClientProtos.MutationProto proto, CellScanner cellScanner) throws IOException {
        int cellCount;
        ClientProtos.MutationProto.MutationType type = proto.getMutateType();
        assert (type == ClientProtos.MutationProto.MutationType.APPEND) : type.name();
        byte[] row = proto.hasRow() ? proto.getRow().toByteArray() : null;
        Append append = null;
        int n = cellCount = proto.hasAssociatedCellCount() ? proto.getAssociatedCellCount() : 0;
        if (cellCount > 0) {
            if (cellScanner == null) {
                throw new DoNotRetryIOException("Cell count of " + cellCount + " but no cellScanner: " + ProtobufUtil.toShortString(proto));
            }
            for (int i = 0; i < cellCount; ++i) {
                if (!cellScanner.advance()) {
                    throw new DoNotRetryIOException("Cell count of " + cellCount + " but at index " + i + " no cell returned: " + ProtobufUtil.toShortString(proto));
                }
                Cell cell = cellScanner.current();
                if (append == null) {
                    append = new Append(cell.getRowArray(), cell.getRowOffset(), cell.getRowLength());
                }
                append.add(cell);
            }
        } else {
            append = new Append(row);
            for (ClientProtos.MutationProto.ColumnValue column : proto.getColumnValueList()) {
                byte[] family = column.getFamily().toByteArray();
                for (ClientProtos.MutationProto.ColumnValue.QualifierValue qv : column.getQualifierValueList()) {
                    byte[] qualifier = qv.getQualifier().toByteArray();
                    if (!qv.hasValue()) {
                        throw new DoNotRetryIOException("Missing required field: qualifier value");
                    }
                    byte[] value = qv.getValue().toByteArray();
                    byte[] tags = null;
                    if (qv.hasTags()) {
                        tags = qv.getTags().toByteArray();
                    }
                    append.add(CellUtil.createCell((byte[])row, (byte[])family, (byte[])qualifier, (long)qv.getTimestamp(), (KeyValue.Type)KeyValue.Type.Put, (byte[])value, (byte[])tags));
                }
            }
        }
        append.setDurability(ProtobufUtil.toDurability(proto.getDurability()));
        for (HBaseProtos.NameBytesPair attribute : proto.getAttributeList()) {
            append.setAttribute(attribute.getName(), attribute.getValue().toByteArray());
        }
        return append;
    }

    public static Mutation toMutation(ClientProtos.MutationProto proto) throws IOException {
        ClientProtos.MutationProto.MutationType type = proto.getMutateType();
        if (type == ClientProtos.MutationProto.MutationType.APPEND) {
            return ProtobufUtil.toAppend(proto, null);
        }
        if (type == ClientProtos.MutationProto.MutationType.DELETE) {
            return ProtobufUtil.toDelete(proto, null);
        }
        if (type == ClientProtos.MutationProto.MutationType.PUT) {
            return ProtobufUtil.toPut(proto, null);
        }
        throw new IOException("Unknown mutation type " + type);
    }

    public static Increment toIncrement(ClientProtos.MutationProto proto, CellScanner cellScanner) throws IOException {
        int cellCount;
        ClientProtos.MutationProto.MutationType type = proto.getMutateType();
        assert (type == ClientProtos.MutationProto.MutationType.INCREMENT) : type.name();
        byte[] row = proto.hasRow() ? proto.getRow().toByteArray() : null;
        Increment increment = null;
        int n = cellCount = proto.hasAssociatedCellCount() ? proto.getAssociatedCellCount() : 0;
        if (cellCount > 0) {
            if (cellScanner == null) {
                throw new DoNotRetryIOException("Cell count of " + cellCount + " but no cellScanner: " + TextFormat.shortDebugString((MessageOrBuilder)proto));
            }
            for (int i = 0; i < cellCount; ++i) {
                if (!cellScanner.advance()) {
                    throw new DoNotRetryIOException("Cell count of " + cellCount + " but at index " + i + " no cell returned: " + TextFormat.shortDebugString((MessageOrBuilder)proto));
                }
                Cell cell = cellScanner.current();
                if (increment == null) {
                    increment = new Increment(cell.getRowArray(), cell.getRowOffset(), cell.getRowLength());
                }
                increment.add(cell);
            }
        } else {
            increment = new Increment(row);
            for (ClientProtos.MutationProto.ColumnValue column : proto.getColumnValueList()) {
                byte[] family = column.getFamily().toByteArray();
                for (ClientProtos.MutationProto.ColumnValue.QualifierValue qv : column.getQualifierValueList()) {
                    byte[] qualifier = qv.getQualifier().toByteArray();
                    if (!qv.hasValue()) {
                        throw new DoNotRetryIOException("Missing required field: qualifier value");
                    }
                    byte[] value = qv.getValue().toByteArray();
                    byte[] tags = null;
                    if (qv.hasTags()) {
                        tags = qv.getTags().toByteArray();
                    }
                    increment.add(CellUtil.createCell((byte[])row, (byte[])family, (byte[])qualifier, (long)qv.getTimestamp(), (KeyValue.Type)KeyValue.Type.Put, (byte[])value, (byte[])tags));
                }
            }
        }
        if (proto.hasTimeRange()) {
            TimeRange timeRange = ProtobufUtil.protoToTimeRange(proto.getTimeRange());
            increment.setTimeRange(timeRange.getMin(), timeRange.getMax());
        }
        increment.setDurability(ProtobufUtil.toDurability(proto.getDurability()));
        for (HBaseProtos.NameBytesPair attribute : proto.getAttributeList()) {
            increment.setAttribute(attribute.getName(), attribute.getValue().toByteArray());
        }
        return increment;
    }

    public static Get toGet(ClientProtos.MutationProto proto, CellScanner cellScanner) throws IOException {
        int cellCount;
        ClientProtos.MutationProto.MutationType type = proto.getMutateType();
        assert (type == ClientProtos.MutationProto.MutationType.INCREMENT || type == ClientProtos.MutationProto.MutationType.APPEND) : type.name();
        byte[] row = proto.hasRow() ? proto.getRow().toByteArray() : null;
        Get get = null;
        int n = cellCount = proto.hasAssociatedCellCount() ? proto.getAssociatedCellCount() : 0;
        if (cellCount > 0) {
            if (cellScanner == null) {
                throw new DoNotRetryIOException("Cell count of " + cellCount + " but no cellScanner: " + TextFormat.shortDebugString((MessageOrBuilder)proto));
            }
            for (int i = 0; i < cellCount; ++i) {
                if (!cellScanner.advance()) {
                    throw new DoNotRetryIOException("Cell count of " + cellCount + " but at index " + i + " no cell returned: " + TextFormat.shortDebugString((MessageOrBuilder)proto));
                }
                Cell cell = cellScanner.current();
                if (get == null) {
                    get = new Get(Bytes.copy((byte[])cell.getRowArray(), (int)cell.getRowOffset(), (int)cell.getRowLength()));
                }
                get.addColumn(Bytes.copy((byte[])cell.getFamilyArray(), (int)cell.getFamilyOffset(), (int)cell.getFamilyLength()), Bytes.copy((byte[])cell.getQualifierArray(), (int)cell.getQualifierOffset(), (int)cell.getQualifierLength()));
            }
        } else {
            get = new Get(row);
            for (ClientProtos.MutationProto.ColumnValue column : proto.getColumnValueList()) {
                byte[] family = column.getFamily().toByteArray();
                for (ClientProtos.MutationProto.ColumnValue.QualifierValue qv : column.getQualifierValueList()) {
                    byte[] qualifier = qv.getQualifier().toByteArray();
                    if (!qv.hasValue()) {
                        throw new DoNotRetryIOException("Missing required field: qualifier value");
                    }
                    get.addColumn(family, qualifier);
                }
            }
        }
        if (proto.hasTimeRange()) {
            TimeRange timeRange = ProtobufUtil.protoToTimeRange(proto.getTimeRange());
            get.setTimeRange(timeRange);
        }
        for (HBaseProtos.NameBytesPair attribute : proto.getAttributeList()) {
            get.setAttribute(attribute.getName(), attribute.getValue().toByteArray());
        }
        return get;
    }

    public static ClientProtos.Scan.ReadType toReadType(Scan.ReadType readType) {
        switch (readType) {
            case DEFAULT: {
                return ClientProtos.Scan.ReadType.DEFAULT;
            }
            case STREAM: {
                return ClientProtos.Scan.ReadType.STREAM;
            }
            case PREAD: {
                return ClientProtos.Scan.ReadType.PREAD;
            }
        }
        throw new IllegalArgumentException("Unknown ReadType: " + (Object)((Object)readType));
    }

    public static Scan.ReadType toReadType(ClientProtos.Scan.ReadType readType) {
        switch (readType) {
            case DEFAULT: {
                return Scan.ReadType.DEFAULT;
            }
            case STREAM: {
                return Scan.ReadType.STREAM;
            }
            case PREAD: {
                return Scan.ReadType.PREAD;
            }
        }
        throw new IllegalArgumentException("Unknown ReadType: " + readType);
    }

    public static ClientProtos.Scan toScan(Scan scan) throws IOException {
        long mvccReadPoint;
        byte[] stopRow;
        byte[] startRow;
        Map<String, byte[]> attributes;
        Boolean loadColumnFamiliesOnDemand;
        ClientProtos.Scan.Builder scanBuilder = ClientProtos.Scan.newBuilder();
        scanBuilder.setCacheBlocks(scan.getCacheBlocks());
        if (scan.getBatch() > 0) {
            scanBuilder.setBatchSize(scan.getBatch());
        }
        if (scan.getMaxResultSize() > 0L) {
            scanBuilder.setMaxResultSize(scan.getMaxResultSize());
        }
        if (scan.isSmall()) {
            scanBuilder.setSmall(scan.isSmall());
        }
        if (scan.getAllowPartialResults()) {
            scanBuilder.setAllowPartialResults(scan.getAllowPartialResults());
        }
        if ((loadColumnFamiliesOnDemand = scan.getLoadColumnFamiliesOnDemandValue()) != null) {
            scanBuilder.setLoadColumnFamiliesOnDemand(loadColumnFamiliesOnDemand.booleanValue());
        }
        scanBuilder.setMaxVersions(scan.getMaxVersions());
        for (Map.Entry<byte[], TimeRange> cftr : scan.getColumnFamilyTimeRange().entrySet()) {
            HBaseProtos.ColumnFamilyTimeRange.Builder b = HBaseProtos.ColumnFamilyTimeRange.newBuilder();
            b.setColumnFamily(ByteStringer.wrap((byte[])cftr.getKey()));
            b.setTimeRange(ProtobufUtil.timeRangeToProto(cftr.getValue()));
            scanBuilder.addCfTimeRange(b);
        }
        TimeRange timeRange = scan.getTimeRange();
        if (!timeRange.isAllTime()) {
            HBaseProtos.TimeRange.Builder timeRangeBuilder = HBaseProtos.TimeRange.newBuilder();
            timeRangeBuilder.setFrom(timeRange.getMin());
            timeRangeBuilder.setTo(timeRange.getMax());
            scanBuilder.setTimeRange(timeRangeBuilder.build());
        }
        if (!(attributes = scan.getAttributesMap()).isEmpty()) {
            HBaseProtos.NameBytesPair.Builder attributeBuilder = HBaseProtos.NameBytesPair.newBuilder();
            for (Map.Entry<String, byte[]> attribute : attributes.entrySet()) {
                attributeBuilder.setName(attribute.getKey());
                attributeBuilder.setValue(ByteStringer.wrap((byte[])attribute.getValue()));
                scanBuilder.addAttribute(attributeBuilder.build());
            }
        }
        if ((startRow = scan.getStartRow()) != null && startRow.length > 0) {
            scanBuilder.setStartRow(ByteStringer.wrap((byte[])startRow));
        }
        if ((stopRow = scan.getStopRow()) != null && stopRow.length > 0) {
            scanBuilder.setStopRow(ByteStringer.wrap((byte[])stopRow));
        }
        if (scan.hasFilter()) {
            scanBuilder.setFilter(ProtobufUtil.toFilter(scan.getFilter()));
        }
        if (scan.hasFamilies()) {
            ClientProtos.Column.Builder columnBuilder = ClientProtos.Column.newBuilder();
            for (Map.Entry<byte[], NavigableSet<byte[]>> family : scan.getFamilyMap().entrySet()) {
                columnBuilder.setFamily(ByteStringer.wrap((byte[])family.getKey()));
                NavigableSet<byte[]> qualifiers = family.getValue();
                columnBuilder.clearQualifier();
                if (qualifiers != null && qualifiers.size() > 0) {
                    for (byte[] qualifier : qualifiers) {
                        columnBuilder.addQualifier(ByteStringer.wrap((byte[])qualifier));
                    }
                }
                scanBuilder.addColumn(columnBuilder.build());
            }
        }
        if (scan.getMaxResultsPerColumnFamily() >= 0) {
            scanBuilder.setStoreLimit(scan.getMaxResultsPerColumnFamily());
        }
        if (scan.getRowOffsetPerColumnFamily() > 0) {
            scanBuilder.setStoreOffset(scan.getRowOffsetPerColumnFamily());
        }
        if (scan.isReversed()) {
            scanBuilder.setReversed(scan.isReversed());
        }
        if (scan.getConsistency() == Consistency.TIMELINE) {
            scanBuilder.setConsistency(ProtobufUtil.toConsistency(scan.getConsistency()));
        }
        if (scan.getCaching() > 0) {
            scanBuilder.setCaching(scan.getCaching());
        }
        if ((mvccReadPoint = PackagePrivateFieldAccessor.getMvccReadPoint(scan)) > 0L) {
            scanBuilder.setMvccReadPoint(mvccReadPoint);
        }
        if (!scan.includeStartRow()) {
            scanBuilder.setIncludeStartRow(false);
        }
        if (scan.includeStopRow()) {
            scanBuilder.setIncludeStopRow(true);
        }
        if (scan.getReadType() != Scan.ReadType.DEFAULT) {
            scanBuilder.setReadType(ProtobufUtil.toReadType(scan.getReadType()));
        }
        return scanBuilder.build();
    }

    public static Scan toScan(ClientProtos.Scan proto) throws IOException {
        byte[] startRow = HConstants.EMPTY_START_ROW;
        byte[] stopRow = HConstants.EMPTY_END_ROW;
        boolean includeStartRow = true;
        boolean includeStopRow = false;
        if (proto.hasStartRow()) {
            startRow = proto.getStartRow().toByteArray();
        }
        if (proto.hasStopRow()) {
            stopRow = proto.getStopRow().toByteArray();
        }
        if (proto.hasIncludeStartRow()) {
            includeStartRow = proto.getIncludeStartRow();
        }
        if (proto.hasIncludeStopRow()) {
            includeStopRow = proto.getIncludeStopRow();
        }
        Scan scan = new Scan().withStartRow(startRow, includeStartRow).withStopRow(stopRow, includeStopRow);
        if (proto.hasCacheBlocks()) {
            scan.setCacheBlocks(proto.getCacheBlocks());
        }
        if (proto.hasMaxVersions()) {
            scan.setMaxVersions(proto.getMaxVersions());
        }
        if (proto.hasStoreLimit()) {
            scan.setMaxResultsPerColumnFamily(proto.getStoreLimit());
        }
        if (proto.hasStoreOffset()) {
            scan.setRowOffsetPerColumnFamily(proto.getStoreOffset());
        }
        if (proto.hasLoadColumnFamiliesOnDemand()) {
            scan.setLoadColumnFamiliesOnDemand(proto.getLoadColumnFamiliesOnDemand());
        }
        if (proto.getCfTimeRangeCount() > 0) {
            for (HBaseProtos.ColumnFamilyTimeRange cftr : proto.getCfTimeRangeList()) {
                TimeRange timeRange = ProtobufUtil.protoToTimeRange(cftr.getTimeRange());
                scan.setColumnFamilyTimeRange(cftr.getColumnFamily().toByteArray(), timeRange);
            }
        }
        if (proto.hasTimeRange()) {
            TimeRange timeRange = ProtobufUtil.protoToTimeRange(proto.getTimeRange());
            scan.setTimeRange(timeRange);
        }
        if (proto.hasFilter()) {
            FilterProtos.Filter filter = proto.getFilter();
            scan.setFilter(ProtobufUtil.toFilter(filter));
        }
        if (proto.hasBatchSize()) {
            scan.setBatch(proto.getBatchSize());
        }
        if (proto.hasMaxResultSize()) {
            scan.setMaxResultSize(proto.getMaxResultSize());
        }
        if (proto.hasSmall()) {
            scan.setSmall(proto.getSmall());
        }
        if (proto.hasAllowPartialResults()) {
            scan.setAllowPartialResults(proto.getAllowPartialResults());
        }
        for (HBaseProtos.NameBytesPair attribute : proto.getAttributeList()) {
            scan.setAttribute(attribute.getName(), attribute.getValue().toByteArray());
        }
        if (proto.getColumnCount() > 0) {
            for (ClientProtos.Column column : proto.getColumnList()) {
                byte[] family = column.getFamily().toByteArray();
                if (column.getQualifierCount() > 0) {
                    for (ByteString qualifier : column.getQualifierList()) {
                        scan.addColumn(family, qualifier.toByteArray());
                    }
                    continue;
                }
                scan.addFamily(family);
            }
        }
        if (proto.hasReversed()) {
            scan.setReversed(proto.getReversed());
        }
        if (proto.hasConsistency()) {
            scan.setConsistency(ProtobufUtil.toConsistency(proto.getConsistency()));
        }
        if (proto.hasCaching()) {
            scan.setCaching(proto.getCaching());
        }
        if (proto.hasMvccReadPoint()) {
            PackagePrivateFieldAccessor.setMvccReadPoint(scan, proto.getMvccReadPoint());
        }
        if (scan.isSmall()) {
            scan.setReadType(Scan.ReadType.PREAD);
        } else if (proto.hasReadType()) {
            scan.setReadType(ProtobufUtil.toReadType(proto.getReadType()));
        }
        return scan;
    }

    public static ClientProtos.Get toGet(Get get) throws IOException {
        Boolean loadColumnFamiliesOnDemand;
        Map<String, byte[]> attributes;
        ClientProtos.Get.Builder builder = ClientProtos.Get.newBuilder();
        builder.setRow(ByteStringer.wrap((byte[])get.getRow()));
        builder.setCacheBlocks(get.getCacheBlocks());
        builder.setMaxVersions(get.getMaxVersions());
        if (get.getFilter() != null) {
            builder.setFilter(ProtobufUtil.toFilter(get.getFilter()));
        }
        for (Map.Entry<byte[], TimeRange> cftr : get.getColumnFamilyTimeRange().entrySet()) {
            HBaseProtos.ColumnFamilyTimeRange.Builder b = HBaseProtos.ColumnFamilyTimeRange.newBuilder();
            b.setColumnFamily(ByteStringer.wrap((byte[])cftr.getKey()));
            b.setTimeRange(ProtobufUtil.timeRangeToProto(cftr.getValue()));
            builder.addCfTimeRange(b);
        }
        TimeRange timeRange = get.getTimeRange();
        if (!timeRange.isAllTime()) {
            HBaseProtos.TimeRange.Builder timeRangeBuilder = HBaseProtos.TimeRange.newBuilder();
            timeRangeBuilder.setFrom(timeRange.getMin());
            timeRangeBuilder.setTo(timeRange.getMax());
            builder.setTimeRange(timeRangeBuilder.build());
        }
        if (!(attributes = get.getAttributesMap()).isEmpty()) {
            HBaseProtos.NameBytesPair.Builder attributeBuilder = HBaseProtos.NameBytesPair.newBuilder();
            for (Map.Entry<String, byte[]> attribute : attributes.entrySet()) {
                attributeBuilder.setName(attribute.getKey());
                attributeBuilder.setValue(ByteStringer.wrap((byte[])attribute.getValue()));
                builder.addAttribute(attributeBuilder.build());
            }
        }
        if (get.hasFamilies()) {
            ClientProtos.Column.Builder columnBuilder = ClientProtos.Column.newBuilder();
            Map<byte[], NavigableSet<byte[]>> families = get.getFamilyMap();
            for (Map.Entry<byte[], NavigableSet<byte[]>> family : families.entrySet()) {
                NavigableSet<byte[]> qualifiers = family.getValue();
                columnBuilder.setFamily(ByteStringer.wrap((byte[])family.getKey()));
                columnBuilder.clearQualifier();
                if (qualifiers != null && qualifiers.size() > 0) {
                    for (byte[] qualifier : qualifiers) {
                        columnBuilder.addQualifier(ByteStringer.wrap((byte[])qualifier));
                    }
                }
                builder.addColumn(columnBuilder.build());
            }
        }
        if (get.getMaxResultsPerColumnFamily() >= 0) {
            builder.setStoreLimit(get.getMaxResultsPerColumnFamily());
        }
        if (get.getRowOffsetPerColumnFamily() > 0) {
            builder.setStoreOffset(get.getRowOffsetPerColumnFamily());
        }
        if (get.isCheckExistenceOnly()) {
            builder.setExistenceOnly(true);
        }
        if (get.getConsistency() != null && get.getConsistency() != Consistency.STRONG) {
            builder.setConsistency(ProtobufUtil.toConsistency(get.getConsistency()));
        }
        if ((loadColumnFamiliesOnDemand = get.getLoadColumnFamiliesOnDemandValue()) != null) {
            builder.setLoadColumnFamiliesOnDemand(loadColumnFamiliesOnDemand.booleanValue());
        }
        return builder.build();
    }

    static void setTimeRange(ClientProtos.MutationProto.Builder builder, TimeRange timeRange) {
        if (!timeRange.isAllTime()) {
            HBaseProtos.TimeRange.Builder timeRangeBuilder = HBaseProtos.TimeRange.newBuilder();
            timeRangeBuilder.setFrom(timeRange.getMin());
            timeRangeBuilder.setTo(timeRange.getMax());
            builder.setTimeRange(timeRangeBuilder.build());
        }
    }

    public static ClientProtos.MutationProto toMutation(Increment increment, ClientProtos.MutationProto.Builder builder, long nonce) {
        builder.setRow(ByteStringer.wrap((byte[])increment.getRow()));
        builder.setMutateType(ClientProtos.MutationProto.MutationType.INCREMENT);
        builder.setDurability(ProtobufUtil.toDurability(increment.getDurability()));
        if (nonce != 0L) {
            builder.setNonce(nonce);
        }
        TimeRange timeRange = increment.getTimeRange();
        ProtobufUtil.setTimeRange(builder, timeRange);
        ClientProtos.MutationProto.ColumnValue.Builder columnBuilder = ClientProtos.MutationProto.ColumnValue.newBuilder();
        ClientProtos.MutationProto.ColumnValue.QualifierValue.Builder valueBuilder = ClientProtos.MutationProto.ColumnValue.QualifierValue.newBuilder();
        for (Map.Entry family : increment.getFamilyCellMap().entrySet()) {
            columnBuilder.setFamily(ByteStringer.wrap((byte[])((byte[])family.getKey())));
            columnBuilder.clearQualifierValue();
            List values = (List)family.getValue();
            if (values != null && values.size() > 0) {
                for (Cell cell : values) {
                    valueBuilder.clear();
                    valueBuilder.setQualifier(ByteStringer.wrap((byte[])cell.getQualifierArray(), (int)cell.getQualifierOffset(), (int)cell.getQualifierLength()));
                    valueBuilder.setValue(ByteStringer.wrap((byte[])cell.getValueArray(), (int)cell.getValueOffset(), (int)cell.getValueLength()));
                    if (cell.getTagsLength() > 0) {
                        valueBuilder.setTags(ByteStringer.wrap((byte[])cell.getTagsArray(), (int)cell.getTagsOffset(), (int)cell.getTagsLength()));
                    }
                    columnBuilder.addQualifierValue(valueBuilder.build());
                }
            }
            builder.addColumnValue(columnBuilder.build());
        }
        Map<String, byte[]> attributes = increment.getAttributesMap();
        if (!attributes.isEmpty()) {
            HBaseProtos.NameBytesPair.Builder attributeBuilder = HBaseProtos.NameBytesPair.newBuilder();
            for (Map.Entry<String, byte[]> attribute : attributes.entrySet()) {
                attributeBuilder.setName(attribute.getKey());
                attributeBuilder.setValue(ByteStringer.wrap((byte[])attribute.getValue()));
                builder.addAttribute(attributeBuilder.build());
            }
        }
        return builder.build();
    }

    public static ClientProtos.MutationProto toMutation(ClientProtos.MutationProto.MutationType type, Mutation mutation) throws IOException {
        return ProtobufUtil.toMutation(type, mutation, 0L);
    }

    public static ClientProtos.MutationProto toMutation(ClientProtos.MutationProto.MutationType type, Mutation mutation, long nonce) throws IOException {
        return ProtobufUtil.toMutation(type, mutation, ClientProtos.MutationProto.newBuilder(), nonce);
    }

    public static ClientProtos.MutationProto toMutation(ClientProtos.MutationProto.MutationType type, Mutation mutation, ClientProtos.MutationProto.Builder builder) throws IOException {
        return ProtobufUtil.toMutation(type, mutation, builder, 0L);
    }

    public static ClientProtos.MutationProto toMutation(ClientProtos.MutationProto.MutationType type, Mutation mutation, ClientProtos.MutationProto.Builder builder, long nonce) throws IOException {
        builder = ProtobufUtil.getMutationBuilderAndSetCommonFields(type, mutation, builder);
        if (nonce != 0L) {
            builder.setNonce(nonce);
        }
        ClientProtos.MutationProto.ColumnValue.Builder columnBuilder = ClientProtos.MutationProto.ColumnValue.newBuilder();
        ClientProtos.MutationProto.ColumnValue.QualifierValue.Builder valueBuilder = ClientProtos.MutationProto.ColumnValue.QualifierValue.newBuilder();
        for (Map.Entry family : mutation.getFamilyCellMap().entrySet()) {
            columnBuilder.clear();
            columnBuilder.setFamily(ByteStringer.wrap((byte[])((byte[])family.getKey())));
            for (Cell cell : (List)family.getValue()) {
                valueBuilder.clear();
                valueBuilder.setQualifier(ByteStringer.wrap((byte[])cell.getQualifierArray(), (int)cell.getQualifierOffset(), (int)cell.getQualifierLength()));
                valueBuilder.setValue(ByteStringer.wrap((byte[])cell.getValueArray(), (int)cell.getValueOffset(), (int)cell.getValueLength()));
                valueBuilder.setTimestamp(cell.getTimestamp());
                if (type == ClientProtos.MutationProto.MutationType.DELETE || type == ClientProtos.MutationProto.MutationType.PUT && CellUtil.isDelete((Cell)cell)) {
                    KeyValue.Type keyValueType = KeyValue.Type.codeToType((byte)cell.getTypeByte());
                    valueBuilder.setDeleteType(ProtobufUtil.toDeleteType(keyValueType));
                }
                columnBuilder.addQualifierValue(valueBuilder.build());
            }
            builder.addColumnValue(columnBuilder.build());
        }
        return builder.build();
    }

    public static ClientProtos.MutationProto toMutationNoData(ClientProtos.MutationProto.MutationType type, Mutation mutation, ClientProtos.MutationProto.Builder builder) throws IOException {
        return ProtobufUtil.toMutationNoData(type, mutation, builder, 0L);
    }

    public static ClientProtos.MutationProto toMutationNoData(ClientProtos.MutationProto.MutationType type, Mutation mutation) throws IOException {
        ClientProtos.MutationProto.Builder builder = ClientProtos.MutationProto.newBuilder();
        return ProtobufUtil.toMutationNoData(type, mutation, builder);
    }

    public static ClientProtos.MutationProto toMutationNoData(ClientProtos.MutationProto.MutationType type, Mutation mutation, ClientProtos.MutationProto.Builder builder, long nonce) throws IOException {
        ProtobufUtil.getMutationBuilderAndSetCommonFields(type, mutation, builder);
        builder.setAssociatedCellCount(mutation.size());
        if (mutation instanceof Increment) {
            ProtobufUtil.setTimeRange(builder, ((Increment)mutation).getTimeRange());
        }
        if (nonce != 0L) {
            builder.setNonce(nonce);
        }
        return builder.build();
    }

    private static ClientProtos.MutationProto.Builder getMutationBuilderAndSetCommonFields(ClientProtos.MutationProto.MutationType type, Mutation mutation, ClientProtos.MutationProto.Builder builder) {
        builder.setRow(ByteStringer.wrap((byte[])mutation.getRow()));
        builder.setMutateType(type);
        builder.setDurability(ProtobufUtil.toDurability(mutation.getDurability()));
        builder.setTimestamp(mutation.getTimeStamp());
        Map<String, byte[]> attributes = mutation.getAttributesMap();
        if (!attributes.isEmpty()) {
            HBaseProtos.NameBytesPair.Builder attributeBuilder = HBaseProtos.NameBytesPair.newBuilder();
            for (Map.Entry<String, byte[]> attribute : attributes.entrySet()) {
                attributeBuilder.setName(attribute.getKey());
                attributeBuilder.setValue(ByteStringer.wrap((byte[])attribute.getValue()));
                builder.addAttribute(attributeBuilder.build());
            }
        }
        return builder;
    }

    public static ClientProtos.Result toResult(Result result) {
        if (result.getExists() != null) {
            return ProtobufUtil.toResult(result.getExists(), result.isStale());
        }
        Cell[] cells = result.rawCells();
        if (cells == null || cells.length == 0) {
            return result.isStale() ? EMPTY_RESULT_PB_STALE : EMPTY_RESULT_PB;
        }
        ClientProtos.Result.Builder builder = ClientProtos.Result.newBuilder();
        for (Cell c : cells) {
            builder.addCell(ProtobufUtil.toCell(c));
        }
        builder.setStale(result.isStale());
        builder.setPartial(result.mayHaveMoreCellsInRow());
        return builder.build();
    }

    public static ClientProtos.Result toResult(boolean existence, boolean stale) {
        if (stale) {
            return existence ? EMPTY_RESULT_PB_EXISTS_TRUE_STALE : EMPTY_RESULT_PB_EXISTS_FALSE_STALE;
        }
        return existence ? EMPTY_RESULT_PB_EXISTS_TRUE : EMPTY_RESULT_PB_EXISTS_FALSE;
    }

    public static ClientProtos.Result toResultNoData(Result result) {
        if (result.getExists() != null) {
            return ProtobufUtil.toResult(result.getExists(), result.isStale());
        }
        int size = result.size();
        if (size == 0) {
            return result.isStale() ? EMPTY_RESULT_PB_STALE : EMPTY_RESULT_PB;
        }
        ClientProtos.Result.Builder builder = ClientProtos.Result.newBuilder();
        builder.setAssociatedCellCount(size);
        builder.setStale(result.isStale());
        return builder.build();
    }

    public static Result toResult(ClientProtos.Result proto) {
        if (proto.hasExists()) {
            if (proto.getStale()) {
                return proto.getExists() ? EMPTY_RESULT_EXISTS_TRUE_STALE : EMPTY_RESULT_EXISTS_FALSE_STALE;
            }
            return proto.getExists() ? EMPTY_RESULT_EXISTS_TRUE : EMPTY_RESULT_EXISTS_FALSE;
        }
        List values = proto.getCellList();
        if (values.isEmpty()) {
            return proto.getStale() ? EMPTY_RESULT_STALE : EMPTY_RESULT;
        }
        ArrayList<Cell> cells = new ArrayList<Cell>(values.size());
        for (CellProtos.Cell c : values) {
            cells.add(ProtobufUtil.toCell(c));
        }
        return Result.create(cells, null, proto.getStale(), proto.getPartial());
    }

    public static Result toResult(ClientProtos.Result proto, CellScanner scanner) throws IOException {
        List values = proto.getCellList();
        if (proto.hasExists()) {
            if (values != null && !values.isEmpty() || proto.hasAssociatedCellCount() && proto.getAssociatedCellCount() > 0) {
                throw new IllegalArgumentException("bad proto: exists with cells is no allowed " + proto);
            }
            if (proto.getStale()) {
                return proto.getExists() ? EMPTY_RESULT_EXISTS_TRUE_STALE : EMPTY_RESULT_EXISTS_FALSE_STALE;
            }
            return proto.getExists() ? EMPTY_RESULT_EXISTS_TRUE : EMPTY_RESULT_EXISTS_FALSE;
        }
        ArrayList<Cell> cells = null;
        if (proto.hasAssociatedCellCount()) {
            int count = proto.getAssociatedCellCount();
            cells = new ArrayList<Cell>(count + values.size());
            for (int i = 0; i < count; ++i) {
                if (!scanner.advance()) {
                    throw new IOException("Failed get " + i + " of " + count);
                }
                cells.add(scanner.current());
            }
        }
        if (!values.isEmpty()) {
            if (cells == null) {
                cells = new ArrayList(values.size());
            }
            for (CellProtos.Cell c : values) {
                cells.add(ProtobufUtil.toCell(c));
            }
        }
        return cells == null || cells.isEmpty() ? (proto.getStale() ? EMPTY_RESULT_STALE : EMPTY_RESULT) : Result.create(cells, null, proto.getStale());
    }

    public static ComparatorProtos.Comparator toComparator(ByteArrayComparable comparator) {
        ComparatorProtos.Comparator.Builder builder = ComparatorProtos.Comparator.newBuilder();
        builder.setName(comparator.getClass().getName());
        builder.setSerializedComparator(ByteStringer.wrap((byte[])comparator.toByteArray()));
        return builder.build();
    }

    public static ByteArrayComparable toComparator(ComparatorProtos.Comparator proto) throws IOException {
        String type = proto.getName();
        String funcName = "parseFrom";
        byte[] value = proto.getSerializedComparator().toByteArray();
        try {
            Class<?> c = Class.forName(type, true, CLASS_LOADER);
            Method parseFrom = c.getMethod(funcName, byte[].class);
            if (parseFrom == null) {
                throw new IOException("Unable to locate function: " + funcName + " in type: " + type);
            }
            return (ByteArrayComparable)parseFrom.invoke(null, new Object[]{value});
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public static Filter toFilter(FilterProtos.Filter proto) throws IOException {
        String type = proto.getName();
        byte[] value = proto.getSerializedFilter().toByteArray();
        String funcName = "parseFrom";
        try {
            Class<?> c = Class.forName(type, true, CLASS_LOADER);
            Method parseFrom = c.getMethod(funcName, byte[].class);
            if (parseFrom == null) {
                throw new IOException("Unable to locate function: " + funcName + " in type: " + type);
            }
            return (Filter)parseFrom.invoke(c, new Object[]{value});
        }
        catch (Exception e) {
            throw new DoNotRetryIOException(e);
        }
    }

    public static FilterProtos.Filter toFilter(Filter filter) throws IOException {
        FilterProtos.Filter.Builder builder = FilterProtos.Filter.newBuilder();
        builder.setName(filter.getClass().getName());
        builder.setSerializedFilter(ByteStringer.wrap((byte[])filter.toByteArray()));
        return builder.build();
    }

    public static ClientProtos.MutationProto.DeleteType toDeleteType(KeyValue.Type type) throws IOException {
        switch (type) {
            case Delete: {
                return ClientProtos.MutationProto.DeleteType.DELETE_ONE_VERSION;
            }
            case DeleteColumn: {
                return ClientProtos.MutationProto.DeleteType.DELETE_MULTIPLE_VERSIONS;
            }
            case DeleteFamily: {
                return ClientProtos.MutationProto.DeleteType.DELETE_FAMILY;
            }
            case DeleteFamilyVersion: {
                return ClientProtos.MutationProto.DeleteType.DELETE_FAMILY_VERSION;
            }
        }
        throw new IOException("Unknown delete type: " + type);
    }

    public static KeyValue.Type fromDeleteType(ClientProtos.MutationProto.DeleteType type) throws IOException {
        switch (type) {
            case DELETE_ONE_VERSION: {
                return KeyValue.Type.Delete;
            }
            case DELETE_MULTIPLE_VERSIONS: {
                return KeyValue.Type.DeleteColumn;
            }
            case DELETE_FAMILY: {
                return KeyValue.Type.DeleteFamily;
            }
            case DELETE_FAMILY_VERSION: {
                return KeyValue.Type.DeleteFamilyVersion;
            }
        }
        throw new IOException("Unknown delete type: " + type);
    }

    public static Throwable toException(HBaseProtos.NameBytesPair parameter) throws IOException {
        if (parameter == null || !parameter.hasValue()) {
            return null;
        }
        String desc = parameter.getValue().toStringUtf8();
        String type = parameter.getName();
        try {
            Class<?> c = Class.forName(type, true, CLASS_LOADER);
            Constructor<?> cn = null;
            try {
                cn = c.getDeclaredConstructor(String.class);
                return (Throwable)cn.newInstance(desc);
            }
            catch (NoSuchMethodException e) {
                cn = c.getDeclaredConstructor(String.class, String.class);
                return (Throwable)cn.newInstance(type, desc);
            }
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public static <T extends Service> T newServiceStub(Class<T> service, RpcChannel channel) throws Exception {
        return (T)((Service)Methods.call(service, null, (String)"newStub", (Class[])new Class[]{RpcChannel.class}, (Object[])new Object[]{channel}));
    }

    public static AdminProtos.ServerInfo getServerInfo(RpcController controller, AdminProtos.AdminService.BlockingInterface admin) throws IOException {
        AdminProtos.GetServerInfoRequest request = ProtobufUtil.buildGetServerInfoRequest();
        try {
            AdminProtos.GetServerInfoResponse response = admin.getServerInfo(controller, request);
            return response.getServerInfo();
        }
        catch (com.google.protobuf.ServiceException se) {
            throw ProtobufUtil.getRemoteException(se);
        }
    }

    public static AdminProtos.GetServerInfoRequest buildGetServerInfoRequest() {
        return GET_SERVER_INFO_REQUEST;
    }

    public static ScanMetrics toScanMetrics(byte[] bytes) {
        Parser parser = MapReduceProtos.ScanMetrics.PARSER;
        MapReduceProtos.ScanMetrics pScanMetrics = null;
        try {
            pScanMetrics = (MapReduceProtos.ScanMetrics)parser.parseFrom(bytes);
        }
        catch (InvalidProtocolBufferException invalidProtocolBufferException) {
            // empty catch block
        }
        ScanMetrics scanMetrics = new ScanMetrics();
        if (pScanMetrics != null) {
            for (HBaseProtos.NameInt64Pair pair : pScanMetrics.getMetricsList()) {
                if (!pair.hasName() || !pair.hasValue()) continue;
                scanMetrics.setCounter(pair.getName(), pair.getValue());
            }
        }
        return scanMetrics;
    }

    public static void toIOException(com.google.protobuf.ServiceException se) throws IOException {
        if (se == null) {
            throw new NullPointerException("Null service exception passed!");
        }
        Throwable cause = se.getCause();
        if (cause != null && cause instanceof IOException) {
            throw (IOException)cause;
        }
        throw new IOException(se);
    }

    public static CellProtos.Cell toCell(Cell kv) {
        CellProtos.Cell.Builder kvbuilder = CellProtos.Cell.newBuilder();
        kvbuilder.setRow(ByteStringer.wrap((byte[])kv.getRowArray(), (int)kv.getRowOffset(), (int)kv.getRowLength()));
        kvbuilder.setFamily(ByteStringer.wrap((byte[])kv.getFamilyArray(), (int)kv.getFamilyOffset(), (int)kv.getFamilyLength()));
        kvbuilder.setQualifier(ByteStringer.wrap((byte[])kv.getQualifierArray(), (int)kv.getQualifierOffset(), (int)kv.getQualifierLength()));
        kvbuilder.setCellType(CellProtos.CellType.valueOf((int)kv.getTypeByte()));
        kvbuilder.setTimestamp(kv.getTimestamp());
        kvbuilder.setValue(ByteStringer.wrap((byte[])kv.getValueArray(), (int)kv.getValueOffset(), (int)kv.getValueLength()));
        return kvbuilder.build();
    }

    public static Cell toCell(CellProtos.Cell cell) {
        return CellUtil.createCell((byte[])cell.getRow().toByteArray(), (byte[])cell.getFamily().toByteArray(), (byte[])cell.getQualifier().toByteArray(), (long)cell.getTimestamp(), (byte)((byte)cell.getCellType().getNumber()), (byte[])cell.getValue().toByteArray());
    }

    static String toShortString(ClientProtos.MutationProto proto) {
        return "row=" + Bytes.toString((byte[])proto.getRow().toByteArray()) + ", type=" + proto.getMutateType().toString();
    }

    public static TableName toTableName(HBaseProtos.TableName tableNamePB) {
        return TableName.valueOf((ByteBuffer)tableNamePB.getNamespace().asReadOnlyByteBuffer(), (ByteBuffer)tableNamePB.getQualifier().asReadOnlyByteBuffer());
    }

    public static HBaseProtos.TableName toProtoTableName(TableName tableName) {
        return HBaseProtos.TableName.newBuilder().setNamespace(ByteStringer.wrap((byte[])tableName.getNamespace())).setQualifier(ByteStringer.wrap((byte[])tableName.getQualifier())).build();
    }

    public static void mergeFrom(Message.Builder builder, byte[] b) throws IOException {
        CodedInputStream codedInput = CodedInputStream.newInstance((byte[])b);
        codedInput.setSizeLimit(b.length);
        builder.mergeFrom(codedInput);
        codedInput.checkLastTagWas(0);
    }

    public static void mergeFrom(Message.Builder builder, byte[] b, int offset, int length) throws IOException {
        CodedInputStream codedInput = CodedInputStream.newInstance((byte[])b, (int)offset, (int)length);
        codedInput.setSizeLimit(length);
        builder.mergeFrom(codedInput);
        codedInput.checkLastTagWas(0);
    }

    private static HBaseProtos.TimeRange.Builder timeRangeToProto(TimeRange timeRange) {
        HBaseProtos.TimeRange.Builder timeRangeBuilder = HBaseProtos.TimeRange.newBuilder();
        timeRangeBuilder.setFrom(timeRange.getMin());
        timeRangeBuilder.setTo(timeRange.getMax());
        return timeRangeBuilder;
    }

    private static TimeRange protoToTimeRange(HBaseProtos.TimeRange timeRange) throws IOException {
        long minStamp = 0L;
        long maxStamp = Long.MAX_VALUE;
        if (timeRange.hasFrom()) {
            minStamp = timeRange.getFrom();
        }
        if (timeRange.hasTo()) {
            maxStamp = timeRange.getTo();
        }
        return new TimeRange(minStamp, maxStamp);
    }

    public static HBaseProtos.SnapshotDescription.Type createProtosSnapShotDescType(SnapshotType type) {
        return HBaseProtos.SnapshotDescription.Type.valueOf((String)type.name());
    }

    public static HBaseProtos.RegionSpecifier buildRegionSpecifier(HBaseProtos.RegionSpecifier.RegionSpecifierType type, byte[] value) {
        HBaseProtos.RegionSpecifier.Builder regionBuilder = HBaseProtos.RegionSpecifier.newBuilder();
        regionBuilder.setValue(ByteStringer.wrap((byte[])value));
        regionBuilder.setType(type);
        return regionBuilder.build();
    }

    public static ServerName toServerName(byte[] data) throws DeserializationException {
        if (data == null || data.length <= 0) {
            return null;
        }
        if (ProtobufMagic.isPBMagicPrefix(data)) {
            int prefixLen = ProtobufMagic.lengthOfPBMagic();
            try {
                ZooKeeperProtos.Master rss = (ZooKeeperProtos.Master)ZooKeeperProtos.Master.PARSER.parseFrom(data, prefixLen, data.length - prefixLen);
                HBaseProtos.ServerName sn = rss.getMaster();
                return ServerName.valueOf((String)sn.getHostName(), (int)sn.getPort(), (long)sn.getStartCode());
            }
            catch (IOException e) {
                throw new DeserializationException((Throwable)e);
            }
        }
        String str = Bytes.toString((byte[])data);
        int index = str.indexOf(",");
        if (index != -1) {
            return ServerName.parseVersionedServerName((byte[])data);
        }
        String hostname = Addressing.parseHostname((String)str);
        int port = Addressing.parsePort((String)str);
        return ServerName.valueOf((String)hostname, (int)port, (long)-1L);
    }

    static {
        ClientProtos.Result.Builder builder = ClientProtos.Result.newBuilder();
        builder.setExists(true);
        builder.setAssociatedCellCount(0);
        EMPTY_RESULT_PB_EXISTS_TRUE = builder.build();
        builder.setStale(true);
        EMPTY_RESULT_PB_EXISTS_TRUE_STALE = builder.build();
        builder.clear();
        builder.setExists(false);
        builder.setAssociatedCellCount(0);
        EMPTY_RESULT_PB_EXISTS_FALSE = builder.build();
        builder.setStale(true);
        EMPTY_RESULT_PB_EXISTS_FALSE_STALE = builder.build();
        builder.clear();
        builder.setAssociatedCellCount(0);
        EMPTY_RESULT_PB = builder.build();
        builder.setStale(true);
        EMPTY_RESULT_PB_STALE = builder.build();
        ClassLoader parent = ProtobufUtil.class.getClassLoader();
        Configuration conf = HBaseConfiguration.create();
        CLASS_LOADER = new DynamicClassLoader(conf, parent);
        PRIMITIVES.put(Boolean.TYPE.getName(), Boolean.TYPE);
        PRIMITIVES.put(Byte.TYPE.getName(), Byte.TYPE);
        PRIMITIVES.put(Character.TYPE.getName(), Character.TYPE);
        PRIMITIVES.put(Short.TYPE.getName(), Short.TYPE);
        PRIMITIVES.put(Integer.TYPE.getName(), Integer.TYPE);
        PRIMITIVES.put(Long.TYPE.getName(), Long.TYPE);
        PRIMITIVES.put(Float.TYPE.getName(), Float.TYPE);
        PRIMITIVES.put(Double.TYPE.getName(), Double.TYPE);
        PRIMITIVES.put(Void.TYPE.getName(), Void.TYPE);
        GET_SERVER_INFO_REQUEST = AdminProtos.GetServerInfoRequest.newBuilder().build();
    }
}

