/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.io.crypto.aes.CryptoAES;

@InterfaceAudience.Private
public class CryptoAESUnwrapHandler
extends SimpleChannelInboundHandler<ByteBuf> {
    private final CryptoAES cryptoAES;

    public CryptoAESUnwrapHandler(CryptoAES cryptoAES) {
        this.cryptoAES = cryptoAES;
    }

    protected void channelRead0(ChannelHandlerContext ctx, ByteBuf msg) throws Exception {
        byte[] bytes = new byte[msg.readableBytes()];
        msg.readBytes(bytes);
        ctx.fireChannelRead((Object)Unpooled.wrappedBuffer((byte[])this.cryptoAES.unwrap(bytes, 0, bytes.length)));
    }
}

