/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.LengthFieldBasedFrameDecoder;
import io.netty.util.concurrent.Promise;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.io.crypto.aes.CryptoAES;
import org.apache.hadoop.hbase.security.CryptoAESUnwrapHandler;
import org.apache.hadoop.hbase.security.CryptoAESWrapHandler;
import org.apache.hadoop.hbase.security.EncryptionUtil;
import org.apache.hadoop.hbase.security.SaslUnwrapHandler;
import org.apache.hadoop.hbase.security.SaslWrapHandler;
import org.apache.hadoop.hbase.shaded.protobuf.generated.RPCProtos;

@InterfaceAudience.Private
public class NettyHBaseRpcConnectionHeaderHandler
extends SimpleChannelInboundHandler<ByteBuf> {
    private final Promise<Boolean> saslPromise;
    private final Configuration conf;
    private final ByteBuf connectionHeaderWithLength;

    public NettyHBaseRpcConnectionHeaderHandler(Promise<Boolean> saslPromise, Configuration conf, ByteBuf connectionHeaderWithLength) {
        this.saslPromise = saslPromise;
        this.conf = conf;
        this.connectionHeaderWithLength = connectionHeaderWithLength;
    }

    protected void channelRead0(ChannelHandlerContext ctx, ByteBuf msg) throws Exception {
        int len = msg.readInt();
        byte[] buff = new byte[len];
        msg.readBytes(buff);
        RPCProtos.ConnectionHeaderResponse connectionHeaderResponse = RPCProtos.ConnectionHeaderResponse.parseFrom((byte[])buff);
        if (connectionHeaderResponse.hasCryptoCipherMeta()) {
            CryptoAES cryptoAES = EncryptionUtil.createCryptoAES(connectionHeaderResponse.getCryptoCipherMeta(), this.conf);
            this.setupCryptoAESHandler(ctx.pipeline(), cryptoAES);
        }
        this.saslPromise.setSuccess((Object)true);
    }

    public void handlerAdded(ChannelHandlerContext ctx) {
        try {
            ctx.writeAndFlush((Object)this.connectionHeaderWithLength.retainedDuplicate());
        }
        catch (Exception e) {
            this.exceptionCaught(ctx, e);
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        this.saslPromise.tryFailure(cause);
    }

    private void setupCryptoAESHandler(ChannelPipeline p, CryptoAES cryptoAES) {
        p.remove(SaslWrapHandler.class);
        p.remove(SaslUnwrapHandler.class);
        String lengthDecoder = p.context(LengthFieldBasedFrameDecoder.class).name();
        p.addAfter(lengthDecoder, null, (ChannelHandler)new CryptoAESUnwrapHandler(cryptoAES));
        p.addAfter(lengthDecoder, null, (ChannelHandler)new CryptoAESWrapHandler(cryptoAES));
    }
}

