/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security.visibility;

import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.util.Bytes;

@InterfaceAudience.Public
public class CellVisibility {
    private String expression;

    public CellVisibility(String expression) {
        this.expression = expression;
    }

    public String getExpression() {
        return this.expression;
    }

    public String toString() {
        return this.expression;
    }

    public static String quote(String auth) {
        return CellVisibility.quote(Bytes.toBytes((String)auth));
    }

    public static String quote(byte[] auth) {
        int escapeChars = 0;
        for (int i = 0; i < auth.length; ++i) {
            if (auth[i] != 34 && auth[i] != 92) continue;
            ++escapeChars;
        }
        byte[] escapedAuth = new byte[auth.length + escapeChars + 2];
        int index = 1;
        for (int i = 0; i < auth.length; ++i) {
            if (auth[i] == 34 || auth[i] == 92) {
                escapedAuth[index++] = 92;
            }
            escapedAuth[index++] = auth[i];
        }
        escapedAuth[0] = 34;
        escapedAuth[escapedAuth.length - 1] = 34;
        return Bytes.toString((byte[])escapedAuth);
    }
}

