/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.shaded.protobuf;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NavigableSet;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.ByteBufferCell;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellScanner;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.ClusterId;
import org.apache.hadoop.hbase.ClusterStatus;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HBaseIOException;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.ProcedureInfo;
import org.apache.hadoop.hbase.ProcedureState;
import org.apache.hadoop.hbase.RegionLoad;
import org.apache.hadoop.hbase.ServerLoad;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.Tag;
import org.apache.hadoop.hbase.TagUtil;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.client.Append;
import org.apache.hadoop.hbase.client.ClientUtil;
import org.apache.hadoop.hbase.client.CompactionState;
import org.apache.hadoop.hbase.client.Consistency;
import org.apache.hadoop.hbase.client.Cursor;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.ImmutableHTableDescriptor;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.PackagePrivateFieldAccessor;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionLoadStats;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.SnapshotDescription;
import org.apache.hadoop.hbase.client.SnapshotType;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.client.metrics.ScanMetrics;
import org.apache.hadoop.hbase.client.security.SecurityCapability;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.filter.ByteArrayComparable;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.io.LimitInputStream;
import org.apache.hadoop.hbase.io.TimeRange;
import org.apache.hadoop.hbase.master.RegionState;
import org.apache.hadoop.hbase.procedure2.LockInfo;
import org.apache.hadoop.hbase.protobuf.ProtobufMagic;
import org.apache.hadoop.hbase.quotas.QuotaScope;
import org.apache.hadoop.hbase.quotas.QuotaType;
import org.apache.hadoop.hbase.quotas.SpaceViolationPolicy;
import org.apache.hadoop.hbase.quotas.ThrottleType;
import org.apache.hadoop.hbase.replication.ReplicationLoadSink;
import org.apache.hadoop.hbase.replication.ReplicationLoadSource;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.security.visibility.Authorizations;
import org.apache.hadoop.hbase.security.visibility.CellVisibility;
import org.apache.hadoop.hbase.shaded.com.google.protobuf.ByteString;
import org.apache.hadoop.hbase.shaded.com.google.protobuf.CodedInputStream;
import org.apache.hadoop.hbase.shaded.com.google.protobuf.InvalidProtocolBufferException;
import org.apache.hadoop.hbase.shaded.com.google.protobuf.Message;
import org.apache.hadoop.hbase.shaded.com.google.protobuf.MessageOrBuilder;
import org.apache.hadoop.hbase.shaded.com.google.protobuf.RpcChannel;
import org.apache.hadoop.hbase.shaded.com.google.protobuf.RpcController;
import org.apache.hadoop.hbase.shaded.com.google.protobuf.Service;
import org.apache.hadoop.hbase.shaded.com.google.protobuf.ServiceException;
import org.apache.hadoop.hbase.shaded.com.google.protobuf.TextFormat;
import org.apache.hadoop.hbase.shaded.com.google.protobuf.UnsafeByteOperations;
import org.apache.hadoop.hbase.shaded.protobuf.RequestConverter;
import org.apache.hadoop.hbase.shaded.protobuf.ResponseConverter;
import org.apache.hadoop.hbase.shaded.protobuf.generated.AdminProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.CellProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ClusterStatusProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ComparatorProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ErrorHandlingProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.FSProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.FilterProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.LockServiceProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.MapReduceProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.MasterProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ProcedureProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.QuotaProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.RegionServerStatusProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.SnapshotProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.WALProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ZooKeeperProtos;
import org.apache.hadoop.hbase.util.Addressing;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.DynamicClassLoader;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.ExceptionUtil;
import org.apache.hadoop.hbase.util.ForeignExceptionUtil;
import org.apache.hadoop.hbase.util.Methods;
import org.apache.hadoop.hbase.util.NonceKey;
import org.apache.hadoop.hbase.util.VersionInfo;
import org.apache.hadoop.ipc.RemoteException;

@InterfaceAudience.Private
@SuppressWarnings(value={"DP_CREATE_CLASSLOADER_INSIDE_DO_PRIVILEGED"}, justification="None. Address sometime.")
public final class ProtobufUtil {
    private static final Map<String, Class<?>> PRIMITIVES = new HashMap();
    private static final Cell[] EMPTY_CELL_ARRAY = new Cell[0];
    private static final Result EMPTY_RESULT = Result.create(EMPTY_CELL_ARRAY);
    static final Result EMPTY_RESULT_EXISTS_TRUE = Result.create(null, true);
    static final Result EMPTY_RESULT_EXISTS_FALSE = Result.create(null, false);
    private static final Result EMPTY_RESULT_STALE = Result.create(EMPTY_CELL_ARRAY, null, true);
    private static final Result EMPTY_RESULT_EXISTS_TRUE_STALE = Result.create((Cell[])null, (Boolean)true, true);
    private static final Result EMPTY_RESULT_EXISTS_FALSE_STALE = Result.create((Cell[])null, (Boolean)false, true);
    private static final ClientProtos.Result EMPTY_RESULT_PB;
    private static final ClientProtos.Result EMPTY_RESULT_PB_EXISTS_TRUE;
    private static final ClientProtos.Result EMPTY_RESULT_PB_EXISTS_FALSE;
    private static final ClientProtos.Result EMPTY_RESULT_PB_STALE;
    private static final ClientProtos.Result EMPTY_RESULT_PB_EXISTS_TRUE_STALE;
    private static final ClientProtos.Result EMPTY_RESULT_PB_EXISTS_FALSE_STALE;
    private static final ClassLoader CLASS_LOADER;

    private ProtobufUtil() {
    }

    public static byte[] prependPBMagic(byte[] bytes) {
        return Bytes.add((byte[])ProtobufMagic.PB_MAGIC, (byte[])bytes);
    }

    public static boolean isPBMagicPrefix(byte[] bytes) {
        return ProtobufMagic.isPBMagicPrefix(bytes);
    }

    public static boolean isPBMagicPrefix(byte[] bytes, int offset, int len) {
        return ProtobufMagic.isPBMagicPrefix(bytes, offset, len);
    }

    public static void expectPBMagicPrefix(byte[] bytes) throws DeserializationException {
        if (!ProtobufUtil.isPBMagicPrefix(bytes)) {
            throw new DeserializationException("Missing pb magic " + Bytes.toString((byte[])ProtobufMagic.PB_MAGIC) + " prefix");
        }
    }

    public static int lengthOfPBMagic() {
        return ProtobufMagic.lengthOfPBMagic();
    }

    public static ComparatorProtos.ByteArrayComparable toByteArrayComparable(byte[] value) {
        ComparatorProtos.ByteArrayComparable.Builder builder = ComparatorProtos.ByteArrayComparable.newBuilder();
        if (value != null) {
            builder.setValue(UnsafeByteOperations.unsafeWrap((byte[])value));
        }
        return builder.build();
    }

    public static IOException getRemoteException(ServiceException se) {
        return ProtobufUtil.makeIOExceptionOfException((Exception)se);
    }

    public static IOException handleRemoteException(Exception e) {
        return ProtobufUtil.makeIOExceptionOfException(e);
    }

    private static IOException makeIOExceptionOfException(Exception e) {
        Throwable t = e;
        if (e instanceof ServiceException) {
            t = e.getCause();
        }
        if (ExceptionUtil.isInterrupt((Throwable)t)) {
            return ExceptionUtil.asInterrupt((Throwable)t);
        }
        if (t instanceof RemoteException) {
            t = ((RemoteException)t).unwrapRemoteException();
        }
        return t instanceof IOException ? (IOException)t : new HBaseIOException(t);
    }

    public static HBaseProtos.ServerName toServerName(ServerName serverName) {
        if (serverName == null) {
            return null;
        }
        HBaseProtos.ServerName.Builder builder = HBaseProtos.ServerName.newBuilder();
        builder.setHostName(serverName.getHostname());
        if (serverName.getPort() >= 0) {
            builder.setPort(serverName.getPort());
        }
        if (serverName.getStartcode() >= 0L) {
            builder.setStartCode(serverName.getStartcode());
        }
        return builder.build();
    }

    public static ServerName toServerName(HBaseProtos.ServerName proto) {
        if (proto == null) {
            return null;
        }
        String hostName = proto.getHostName();
        long startCode = -1L;
        int port = -1;
        if (proto.hasPort()) {
            port = proto.getPort();
        }
        if (proto.hasStartCode()) {
            startCode = proto.getStartCode();
        }
        return ServerName.valueOf((String)hostName, (int)port, (long)startCode);
    }

    public static NamespaceDescriptor[] getNamespaceDescriptorArray(MasterProtos.ListNamespaceDescriptorsResponse proto) {
        List list = proto.getNamespaceDescriptorList();
        NamespaceDescriptor[] res = new NamespaceDescriptor[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            res[i] = ProtobufUtil.toNamespaceDescriptor((HBaseProtos.NamespaceDescriptor)list.get(i));
        }
        return res;
    }

    @Deprecated
    public static HTableDescriptor[] getHTableDescriptorArray(MasterProtos.GetTableDescriptorsResponse proto) {
        if (proto == null) {
            return null;
        }
        HTableDescriptor[] ret = new HTableDescriptor[proto.getTableSchemaCount()];
        for (int i = 0; i < proto.getTableSchemaCount(); ++i) {
            ret[i] = new ImmutableHTableDescriptor(ProtobufUtil.convertToHTableDesc(proto.getTableSchema(i)));
        }
        return ret;
    }

    public static TableDescriptor[] getTableDescriptorArray(MasterProtos.GetTableDescriptorsResponse proto) {
        if (proto == null) {
            return new TableDescriptor[0];
        }
        return (TableDescriptor[])proto.getTableSchemaList().stream().map(ProtobufUtil::convertToTableDesc).toArray(TableDescriptor[]::new);
    }

    public static byte[][] getSplitKeysArray(MasterProtos.CreateTableRequest proto) {
        byte[][] splitKeys = new byte[proto.getSplitKeysCount()][];
        for (int i = 0; i < proto.getSplitKeysCount(); ++i) {
            splitKeys[i] = proto.getSplitKeys(i).toByteArray();
        }
        return splitKeys;
    }

    public static Durability toDurability(ClientProtos.MutationProto.Durability proto) {
        switch (proto) {
            case USE_DEFAULT: {
                return Durability.USE_DEFAULT;
            }
            case SKIP_WAL: {
                return Durability.SKIP_WAL;
            }
            case ASYNC_WAL: {
                return Durability.ASYNC_WAL;
            }
            case SYNC_WAL: {
                return Durability.SYNC_WAL;
            }
            case FSYNC_WAL: {
                return Durability.FSYNC_WAL;
            }
        }
        return Durability.USE_DEFAULT;
    }

    public static ClientProtos.MutationProto.Durability toDurability(Durability d) {
        switch (d) {
            case USE_DEFAULT: {
                return ClientProtos.MutationProto.Durability.USE_DEFAULT;
            }
            case SKIP_WAL: {
                return ClientProtos.MutationProto.Durability.SKIP_WAL;
            }
            case ASYNC_WAL: {
                return ClientProtos.MutationProto.Durability.ASYNC_WAL;
            }
            case SYNC_WAL: {
                return ClientProtos.MutationProto.Durability.SYNC_WAL;
            }
            case FSYNC_WAL: {
                return ClientProtos.MutationProto.Durability.FSYNC_WAL;
            }
        }
        return ClientProtos.MutationProto.Durability.USE_DEFAULT;
    }

    public static Get toGet(ClientProtos.Get proto) throws IOException {
        if (proto == null) {
            return null;
        }
        byte[] row = proto.getRow().toByteArray();
        Get get = new Get(row);
        if (proto.hasCacheBlocks()) {
            get.setCacheBlocks(proto.getCacheBlocks());
        }
        if (proto.hasMaxVersions()) {
            get.setMaxVersions(proto.getMaxVersions());
        }
        if (proto.hasStoreLimit()) {
            get.setMaxResultsPerColumnFamily(proto.getStoreLimit());
        }
        if (proto.hasStoreOffset()) {
            get.setRowOffsetPerColumnFamily(proto.getStoreOffset());
        }
        if (proto.getCfTimeRangeCount() > 0) {
            for (HBaseProtos.ColumnFamilyTimeRange cftr : proto.getCfTimeRangeList()) {
                TimeRange timeRange = ProtobufUtil.protoToTimeRange(cftr.getTimeRange());
                get.setColumnFamilyTimeRange(cftr.getColumnFamily().toByteArray(), timeRange);
            }
        }
        if (proto.hasTimeRange()) {
            TimeRange timeRange = ProtobufUtil.protoToTimeRange(proto.getTimeRange());
            get.setTimeRange(timeRange);
        }
        if (proto.hasFilter()) {
            FilterProtos.Filter filter = proto.getFilter();
            get.setFilter(ProtobufUtil.toFilter(filter));
        }
        for (HBaseProtos.NameBytesPair attribute : proto.getAttributeList()) {
            get.setAttribute(attribute.getName(), attribute.getValue().toByteArray());
        }
        if (proto.getColumnCount() > 0) {
            for (ClientProtos.Column column : proto.getColumnList()) {
                byte[] family = column.getFamily().toByteArray();
                if (column.getQualifierCount() > 0) {
                    for (ByteString qualifier : column.getQualifierList()) {
                        get.addColumn(family, qualifier.toByteArray());
                    }
                    continue;
                }
                get.addFamily(family);
            }
        }
        if (proto.hasExistenceOnly() && proto.getExistenceOnly()) {
            get.setCheckExistenceOnly(true);
        }
        if (proto.hasConsistency()) {
            get.setConsistency(ProtobufUtil.toConsistency(proto.getConsistency()));
        }
        if (proto.hasLoadColumnFamiliesOnDemand()) {
            get.setLoadColumnFamiliesOnDemand(proto.getLoadColumnFamiliesOnDemand());
        }
        return get;
    }

    public static Consistency toConsistency(ClientProtos.Consistency consistency) {
        switch (consistency) {
            case STRONG: {
                return Consistency.STRONG;
            }
            case TIMELINE: {
                return Consistency.TIMELINE;
            }
        }
        return Consistency.STRONG;
    }

    public static ClientProtos.Consistency toConsistency(Consistency consistency) {
        switch (consistency) {
            case STRONG: {
                return ClientProtos.Consistency.STRONG;
            }
            case TIMELINE: {
                return ClientProtos.Consistency.TIMELINE;
            }
        }
        return ClientProtos.Consistency.STRONG;
    }

    public static Put toPut(ClientProtos.MutationProto proto) throws IOException {
        return ProtobufUtil.toPut(proto, null);
    }

    public static Put toPut(ClientProtos.MutationProto proto, CellScanner cellScanner) throws IOException {
        int cellCount;
        ClientProtos.MutationProto.MutationType type = proto.getMutateType();
        assert (type == ClientProtos.MutationProto.MutationType.PUT) : type.name();
        long timestamp = proto.hasTimestamp() ? proto.getTimestamp() : Long.MAX_VALUE;
        Put put = proto.hasRow() ? new Put(proto.getRow().toByteArray(), timestamp) : null;
        int n = cellCount = proto.hasAssociatedCellCount() ? proto.getAssociatedCellCount() : 0;
        if (cellCount > 0) {
            if (cellScanner == null) {
                throw new DoNotRetryIOException("Cell count of " + cellCount + " but no cellScanner: " + ProtobufUtil.toShortString(proto));
            }
            for (int i = 0; i < cellCount; ++i) {
                if (!cellScanner.advance()) {
                    throw new DoNotRetryIOException("Cell count of " + cellCount + " but at index " + i + " no cell returned: " + ProtobufUtil.toShortString(proto));
                }
                Cell cell = cellScanner.current();
                if (put == null) {
                    put = new Put(cell.getRowArray(), cell.getRowOffset(), cell.getRowLength(), timestamp);
                }
                put.add(cell);
            }
        } else {
            if (put == null) {
                throw new IllegalArgumentException("row cannot be null");
            }
            for (ClientProtos.MutationProto.ColumnValue column : proto.getColumnValueList()) {
                byte[] family = column.getFamily().toByteArray();
                for (ClientProtos.MutationProto.ColumnValue.QualifierValue qv : column.getQualifierValueList()) {
                    byte[] qual;
                    if (!qv.hasValue()) {
                        throw new DoNotRetryIOException("Missing required field: qualifier value");
                    }
                    ByteBuffer qualifier = qv.hasQualifier() ? qv.getQualifier().asReadOnlyByteBuffer() : null;
                    ByteBuffer value = qv.hasValue() ? qv.getValue().asReadOnlyByteBuffer() : null;
                    long ts = timestamp;
                    if (qv.hasTimestamp()) {
                        ts = qv.getTimestamp();
                    }
                    if (qv.hasTags()) {
                        byte[] allTagsBytes = qv.getTags().toByteArray();
                        if (qv.hasDeleteType()) {
                            qual = qv.hasQualifier() ? qv.getQualifier().toByteArray() : null;
                            put.add((Cell)new KeyValue(proto.getRow().toByteArray(), family, qual, ts, ProtobufUtil.fromDeleteType(qv.getDeleteType()), null, allTagsBytes));
                            continue;
                        }
                        List tags = TagUtil.asList((byte[])allTagsBytes, (int)0, (int)((short)allTagsBytes.length));
                        Tag[] tagsArray = new Tag[tags.size()];
                        put.addImmutable(family, qualifier, ts, value, tags.toArray(tagsArray));
                        continue;
                    }
                    if (qv.hasDeleteType()) {
                        qual = qv.hasQualifier() ? qv.getQualifier().toByteArray() : null;
                        put.add((Cell)new KeyValue(proto.getRow().toByteArray(), family, qual, ts, ProtobufUtil.fromDeleteType(qv.getDeleteType())));
                        continue;
                    }
                    put.addImmutable(family, qualifier, ts, value);
                }
            }
        }
        put.setDurability(ProtobufUtil.toDurability(proto.getDurability()));
        for (HBaseProtos.NameBytesPair attribute : proto.getAttributeList()) {
            put.setAttribute(attribute.getName(), attribute.getValue().toByteArray());
        }
        return put;
    }

    public static Delete toDelete(ClientProtos.MutationProto proto) throws IOException {
        return ProtobufUtil.toDelete(proto, null);
    }

    public static Delete toDelete(ClientProtos.MutationProto proto, CellScanner cellScanner) throws IOException {
        int cellCount;
        ClientProtos.MutationProto.MutationType type = proto.getMutateType();
        assert (type == ClientProtos.MutationProto.MutationType.DELETE) : type.name();
        long timestamp = proto.hasTimestamp() ? proto.getTimestamp() : Long.MAX_VALUE;
        Delete delete = proto.hasRow() ? new Delete(proto.getRow().toByteArray(), timestamp) : null;
        int n = cellCount = proto.hasAssociatedCellCount() ? proto.getAssociatedCellCount() : 0;
        if (cellCount > 0) {
            if (cellScanner == null) {
                throw new DoNotRetryIOException("Cell count of " + cellCount + " but no cellScanner: " + TextFormat.shortDebugString((MessageOrBuilder)proto));
            }
            for (int i = 0; i < cellCount; ++i) {
                if (!cellScanner.advance()) {
                    throw new DoNotRetryIOException("Cell count of " + cellCount + " but at index " + i + " no cell returned: " + TextFormat.shortDebugString((MessageOrBuilder)proto));
                }
                Cell cell = cellScanner.current();
                if (delete == null) {
                    delete = new Delete(cell.getRowArray(), cell.getRowOffset(), cell.getRowLength(), timestamp);
                }
                delete.addDeleteMarker(cell);
            }
        } else {
            if (delete == null) {
                throw new IllegalArgumentException("row cannot be null");
            }
            for (ClientProtos.MutationProto.ColumnValue column : proto.getColumnValueList()) {
                byte[] family = column.getFamily().toByteArray();
                for (ClientProtos.MutationProto.ColumnValue.QualifierValue qv : column.getQualifierValueList()) {
                    ClientProtos.MutationProto.DeleteType deleteType = qv.getDeleteType();
                    byte[] qualifier = null;
                    if (qv.hasQualifier()) {
                        qualifier = qv.getQualifier().toByteArray();
                    }
                    long ts = Long.MAX_VALUE;
                    if (qv.hasTimestamp()) {
                        ts = qv.getTimestamp();
                    }
                    if (deleteType == ClientProtos.MutationProto.DeleteType.DELETE_ONE_VERSION) {
                        delete.addColumn(family, qualifier, ts);
                        continue;
                    }
                    if (deleteType == ClientProtos.MutationProto.DeleteType.DELETE_MULTIPLE_VERSIONS) {
                        delete.addColumns(family, qualifier, ts);
                        continue;
                    }
                    if (deleteType == ClientProtos.MutationProto.DeleteType.DELETE_FAMILY_VERSION) {
                        delete.addFamilyVersion(family, ts);
                        continue;
                    }
                    delete.addFamily(family, ts);
                }
            }
        }
        delete.setDurability(ProtobufUtil.toDurability(proto.getDurability()));
        for (HBaseProtos.NameBytesPair attribute : proto.getAttributeList()) {
            delete.setAttribute(attribute.getName(), attribute.getValue().toByteArray());
        }
        return delete;
    }

    public static Append toAppend(ClientProtos.MutationProto proto, CellScanner cellScanner) throws IOException {
        int cellCount;
        ClientProtos.MutationProto.MutationType type = proto.getMutateType();
        assert (type == ClientProtos.MutationProto.MutationType.APPEND) : type.name();
        byte[] row = proto.hasRow() ? proto.getRow().toByteArray() : null;
        Append append = row != null ? new Append(row) : null;
        int n = cellCount = proto.hasAssociatedCellCount() ? proto.getAssociatedCellCount() : 0;
        if (cellCount > 0) {
            if (cellScanner == null) {
                throw new DoNotRetryIOException("Cell count of " + cellCount + " but no cellScanner: " + ProtobufUtil.toShortString(proto));
            }
            for (int i = 0; i < cellCount; ++i) {
                if (!cellScanner.advance()) {
                    throw new DoNotRetryIOException("Cell count of " + cellCount + " but at index " + i + " no cell returned: " + ProtobufUtil.toShortString(proto));
                }
                Cell cell = cellScanner.current();
                if (append == null) {
                    append = new Append(cell.getRowArray(), cell.getRowOffset(), cell.getRowLength());
                }
                append.add(cell);
            }
        } else {
            if (append == null) {
                throw new IllegalArgumentException("row cannot be null");
            }
            for (ClientProtos.MutationProto.ColumnValue column : proto.getColumnValueList()) {
                byte[] family = column.getFamily().toByteArray();
                for (ClientProtos.MutationProto.ColumnValue.QualifierValue qv : column.getQualifierValueList()) {
                    byte[] qualifier = qv.getQualifier().toByteArray();
                    if (!qv.hasValue()) {
                        throw new DoNotRetryIOException("Missing required field: qualifier value");
                    }
                    byte[] value = qv.getValue().toByteArray();
                    byte[] tags = null;
                    if (qv.hasTags()) {
                        tags = qv.getTags().toByteArray();
                    }
                    append.add(CellUtil.createCell((byte[])row, (byte[])family, (byte[])qualifier, (long)qv.getTimestamp(), (KeyValue.Type)KeyValue.Type.Put, (byte[])value, (byte[])tags));
                }
            }
        }
        append.setDurability(ProtobufUtil.toDurability(proto.getDurability()));
        for (HBaseProtos.NameBytesPair attribute : proto.getAttributeList()) {
            append.setAttribute(attribute.getName(), attribute.getValue().toByteArray());
        }
        return append;
    }

    public static Mutation toMutation(ClientProtos.MutationProto proto) throws IOException {
        ClientProtos.MutationProto.MutationType type = proto.getMutateType();
        if (type == ClientProtos.MutationProto.MutationType.APPEND) {
            return ProtobufUtil.toAppend(proto, null);
        }
        if (type == ClientProtos.MutationProto.MutationType.DELETE) {
            return ProtobufUtil.toDelete(proto, null);
        }
        if (type == ClientProtos.MutationProto.MutationType.PUT) {
            return ProtobufUtil.toPut(proto, null);
        }
        throw new IOException("Unknown mutation type " + type);
    }

    public static Increment toIncrement(ClientProtos.MutationProto proto, CellScanner cellScanner) throws IOException {
        int cellCount;
        ClientProtos.MutationProto.MutationType type = proto.getMutateType();
        assert (type == ClientProtos.MutationProto.MutationType.INCREMENT) : type.name();
        byte[] row = proto.hasRow() ? proto.getRow().toByteArray() : null;
        Increment increment = row != null ? new Increment(row) : null;
        int n = cellCount = proto.hasAssociatedCellCount() ? proto.getAssociatedCellCount() : 0;
        if (cellCount > 0) {
            if (cellScanner == null) {
                throw new DoNotRetryIOException("Cell count of " + cellCount + " but no cellScanner: " + TextFormat.shortDebugString((MessageOrBuilder)proto));
            }
            for (int i = 0; i < cellCount; ++i) {
                if (!cellScanner.advance()) {
                    throw new DoNotRetryIOException("Cell count of " + cellCount + " but at index " + i + " no cell returned: " + TextFormat.shortDebugString((MessageOrBuilder)proto));
                }
                Cell cell = cellScanner.current();
                if (increment == null) {
                    increment = new Increment(cell.getRowArray(), cell.getRowOffset(), cell.getRowLength());
                }
                increment.add(cell);
            }
        } else {
            if (increment == null) {
                throw new IllegalArgumentException("row cannot be null");
            }
            for (ClientProtos.MutationProto.ColumnValue column : proto.getColumnValueList()) {
                byte[] family = column.getFamily().toByteArray();
                for (ClientProtos.MutationProto.ColumnValue.QualifierValue qv : column.getQualifierValueList()) {
                    byte[] qualifier = qv.getQualifier().toByteArray();
                    if (!qv.hasValue()) {
                        throw new DoNotRetryIOException("Missing required field: qualifier value");
                    }
                    byte[] value = qv.getValue().toByteArray();
                    byte[] tags = null;
                    if (qv.hasTags()) {
                        tags = qv.getTags().toByteArray();
                    }
                    increment.add(CellUtil.createCell((byte[])row, (byte[])family, (byte[])qualifier, (long)qv.getTimestamp(), (KeyValue.Type)KeyValue.Type.Put, (byte[])value, (byte[])tags));
                }
            }
        }
        if (proto.hasTimeRange()) {
            TimeRange timeRange = ProtobufUtil.protoToTimeRange(proto.getTimeRange());
            increment.setTimeRange(timeRange.getMin(), timeRange.getMax());
        }
        increment.setDurability(ProtobufUtil.toDurability(proto.getDurability()));
        for (HBaseProtos.NameBytesPair attribute : proto.getAttributeList()) {
            increment.setAttribute(attribute.getName(), attribute.getValue().toByteArray());
        }
        return increment;
    }

    public static Get toGet(ClientProtos.MutationProto proto, CellScanner cellScanner) throws IOException {
        int cellCount;
        ClientProtos.MutationProto.MutationType type = proto.getMutateType();
        assert (type == ClientProtos.MutationProto.MutationType.INCREMENT || type == ClientProtos.MutationProto.MutationType.APPEND) : type.name();
        byte[] row = proto.hasRow() ? proto.getRow().toByteArray() : null;
        Get get = null;
        int n = cellCount = proto.hasAssociatedCellCount() ? proto.getAssociatedCellCount() : 0;
        if (cellCount > 0) {
            if (cellScanner == null) {
                throw new DoNotRetryIOException("Cell count of " + cellCount + " but no cellScanner: " + TextFormat.shortDebugString((MessageOrBuilder)proto));
            }
            for (int i = 0; i < cellCount; ++i) {
                if (!cellScanner.advance()) {
                    throw new DoNotRetryIOException("Cell count of " + cellCount + " but at index " + i + " no cell returned: " + TextFormat.shortDebugString((MessageOrBuilder)proto));
                }
                Cell cell = cellScanner.current();
                if (get == null) {
                    get = new Get(CellUtil.cloneRow((Cell)cell));
                }
                get.addColumn(CellUtil.cloneFamily((Cell)cell), CellUtil.cloneQualifier((Cell)cell));
            }
        } else {
            get = new Get(row);
            for (ClientProtos.MutationProto.ColumnValue column : proto.getColumnValueList()) {
                byte[] family = column.getFamily().toByteArray();
                for (ClientProtos.MutationProto.ColumnValue.QualifierValue qv : column.getQualifierValueList()) {
                    byte[] qualifier = qv.getQualifier().toByteArray();
                    if (!qv.hasValue()) {
                        throw new DoNotRetryIOException("Missing required field: qualifier value");
                    }
                    get.addColumn(family, qualifier);
                }
            }
        }
        if (proto.hasTimeRange()) {
            TimeRange timeRange = ProtobufUtil.protoToTimeRange(proto.getTimeRange());
            get.setTimeRange(timeRange);
        }
        for (HBaseProtos.NameBytesPair attribute : proto.getAttributeList()) {
            get.setAttribute(attribute.getName(), attribute.getValue().toByteArray());
        }
        return get;
    }

    public static ClientProtos.Scan.ReadType toReadType(Scan.ReadType readType) {
        switch (readType) {
            case DEFAULT: {
                return ClientProtos.Scan.ReadType.DEFAULT;
            }
            case STREAM: {
                return ClientProtos.Scan.ReadType.STREAM;
            }
            case PREAD: {
                return ClientProtos.Scan.ReadType.PREAD;
            }
        }
        throw new IllegalArgumentException("Unknown ReadType: " + (Object)((Object)readType));
    }

    public static Scan.ReadType toReadType(ClientProtos.Scan.ReadType readType) {
        switch (readType) {
            case DEFAULT: {
                return Scan.ReadType.DEFAULT;
            }
            case STREAM: {
                return Scan.ReadType.STREAM;
            }
            case PREAD: {
                return Scan.ReadType.PREAD;
            }
        }
        throw new IllegalArgumentException("Unknown ReadType: " + readType);
    }

    public static ClientProtos.Scan toScan(Scan scan) throws IOException {
        long mvccReadPoint;
        byte[] stopRow;
        byte[] startRow;
        Map<String, byte[]> attributes;
        Boolean loadColumnFamiliesOnDemand;
        ClientProtos.Scan.Builder scanBuilder = ClientProtos.Scan.newBuilder();
        scanBuilder.setCacheBlocks(scan.getCacheBlocks());
        if (scan.getBatch() > 0) {
            scanBuilder.setBatchSize(scan.getBatch());
        }
        if (scan.getMaxResultSize() > 0L) {
            scanBuilder.setMaxResultSize(scan.getMaxResultSize());
        }
        if (scan.isSmall()) {
            scanBuilder.setSmall(scan.isSmall());
        }
        if (scan.getAllowPartialResults()) {
            scanBuilder.setAllowPartialResults(scan.getAllowPartialResults());
        }
        if ((loadColumnFamiliesOnDemand = scan.getLoadColumnFamiliesOnDemandValue()) != null) {
            scanBuilder.setLoadColumnFamiliesOnDemand(loadColumnFamiliesOnDemand.booleanValue());
        }
        scanBuilder.setMaxVersions(scan.getMaxVersions());
        for (Map.Entry<byte[], TimeRange> cftr : scan.getColumnFamilyTimeRange().entrySet()) {
            HBaseProtos.ColumnFamilyTimeRange.Builder b = HBaseProtos.ColumnFamilyTimeRange.newBuilder();
            b.setColumnFamily(UnsafeByteOperations.unsafeWrap((byte[])cftr.getKey()));
            b.setTimeRange(ProtobufUtil.timeRangeToProto(cftr.getValue()));
            scanBuilder.addCfTimeRange(b);
        }
        TimeRange timeRange = scan.getTimeRange();
        if (!timeRange.isAllTime()) {
            HBaseProtos.TimeRange.Builder timeRangeBuilder = HBaseProtos.TimeRange.newBuilder();
            timeRangeBuilder.setFrom(timeRange.getMin());
            timeRangeBuilder.setTo(timeRange.getMax());
            scanBuilder.setTimeRange(timeRangeBuilder.build());
        }
        if (!(attributes = scan.getAttributesMap()).isEmpty()) {
            HBaseProtos.NameBytesPair.Builder attributeBuilder = HBaseProtos.NameBytesPair.newBuilder();
            for (Map.Entry<String, byte[]> attribute : attributes.entrySet()) {
                attributeBuilder.setName(attribute.getKey());
                attributeBuilder.setValue(UnsafeByteOperations.unsafeWrap((byte[])attribute.getValue()));
                scanBuilder.addAttribute(attributeBuilder.build());
            }
        }
        if ((startRow = scan.getStartRow()) != null && startRow.length > 0) {
            scanBuilder.setStartRow(UnsafeByteOperations.unsafeWrap((byte[])startRow));
        }
        if ((stopRow = scan.getStopRow()) != null && stopRow.length > 0) {
            scanBuilder.setStopRow(UnsafeByteOperations.unsafeWrap((byte[])stopRow));
        }
        if (scan.hasFilter()) {
            scanBuilder.setFilter(ProtobufUtil.toFilter(scan.getFilter()));
        }
        if (scan.hasFamilies()) {
            ClientProtos.Column.Builder columnBuilder = ClientProtos.Column.newBuilder();
            for (Map.Entry<byte[], NavigableSet<byte[]>> family : scan.getFamilyMap().entrySet()) {
                columnBuilder.setFamily(UnsafeByteOperations.unsafeWrap((byte[])family.getKey()));
                NavigableSet<byte[]> qualifiers = family.getValue();
                columnBuilder.clearQualifier();
                if (qualifiers != null && qualifiers.size() > 0) {
                    for (byte[] qualifier : qualifiers) {
                        columnBuilder.addQualifier(UnsafeByteOperations.unsafeWrap((byte[])qualifier));
                    }
                }
                scanBuilder.addColumn(columnBuilder.build());
            }
        }
        if (scan.getMaxResultsPerColumnFamily() >= 0) {
            scanBuilder.setStoreLimit(scan.getMaxResultsPerColumnFamily());
        }
        if (scan.getRowOffsetPerColumnFamily() > 0) {
            scanBuilder.setStoreOffset(scan.getRowOffsetPerColumnFamily());
        }
        if (scan.isReversed()) {
            scanBuilder.setReversed(scan.isReversed());
        }
        if (scan.getConsistency() == Consistency.TIMELINE) {
            scanBuilder.setConsistency(ProtobufUtil.toConsistency(scan.getConsistency()));
        }
        if (scan.getCaching() > 0) {
            scanBuilder.setCaching(scan.getCaching());
        }
        if ((mvccReadPoint = PackagePrivateFieldAccessor.getMvccReadPoint(scan)) > 0L) {
            scanBuilder.setMvccReadPoint(mvccReadPoint);
        }
        if (!scan.includeStartRow()) {
            scanBuilder.setIncludeStartRow(false);
        }
        if (scan.includeStopRow()) {
            scanBuilder.setIncludeStopRow(true);
        }
        if (scan.getReadType() != Scan.ReadType.DEFAULT) {
            scanBuilder.setReadType(ProtobufUtil.toReadType(scan.getReadType()));
        }
        if (scan.isNeedCursorResult()) {
            scanBuilder.setNeedCursorResult(true);
        }
        return scanBuilder.build();
    }

    public static Scan toScan(ClientProtos.Scan proto) throws IOException {
        byte[] startRow = HConstants.EMPTY_START_ROW;
        byte[] stopRow = HConstants.EMPTY_END_ROW;
        boolean includeStartRow = true;
        boolean includeStopRow = false;
        if (proto.hasStartRow()) {
            startRow = proto.getStartRow().toByteArray();
        }
        if (proto.hasStopRow()) {
            stopRow = proto.getStopRow().toByteArray();
        }
        if (proto.hasIncludeStartRow()) {
            includeStartRow = proto.getIncludeStartRow();
        }
        if (proto.hasIncludeStopRow()) {
            includeStopRow = proto.getIncludeStopRow();
        } else if (ClientUtil.areScanStartRowAndStopRowEqual(startRow, stopRow)) {
            includeStopRow = true;
        }
        Scan scan = new Scan().withStartRow(startRow, includeStartRow).withStopRow(stopRow, includeStopRow);
        if (proto.hasCacheBlocks()) {
            scan.setCacheBlocks(proto.getCacheBlocks());
        }
        if (proto.hasMaxVersions()) {
            scan.setMaxVersions(proto.getMaxVersions());
        }
        if (proto.hasStoreLimit()) {
            scan.setMaxResultsPerColumnFamily(proto.getStoreLimit());
        }
        if (proto.hasStoreOffset()) {
            scan.setRowOffsetPerColumnFamily(proto.getStoreOffset());
        }
        if (proto.hasLoadColumnFamiliesOnDemand()) {
            scan.setLoadColumnFamiliesOnDemand(proto.getLoadColumnFamiliesOnDemand());
        }
        if (proto.getCfTimeRangeCount() > 0) {
            for (HBaseProtos.ColumnFamilyTimeRange cftr : proto.getCfTimeRangeList()) {
                TimeRange timeRange = ProtobufUtil.protoToTimeRange(cftr.getTimeRange());
                scan.setColumnFamilyTimeRange(cftr.getColumnFamily().toByteArray(), timeRange);
            }
        }
        if (proto.hasTimeRange()) {
            TimeRange timeRange = ProtobufUtil.protoToTimeRange(proto.getTimeRange());
            scan.setTimeRange(timeRange);
        }
        if (proto.hasFilter()) {
            FilterProtos.Filter filter = proto.getFilter();
            scan.setFilter(ProtobufUtil.toFilter(filter));
        }
        if (proto.hasBatchSize()) {
            scan.setBatch(proto.getBatchSize());
        }
        if (proto.hasMaxResultSize()) {
            scan.setMaxResultSize(proto.getMaxResultSize());
        }
        if (proto.hasSmall()) {
            scan.setSmall(proto.getSmall());
        }
        if (proto.hasAllowPartialResults()) {
            scan.setAllowPartialResults(proto.getAllowPartialResults());
        }
        for (HBaseProtos.NameBytesPair attribute : proto.getAttributeList()) {
            scan.setAttribute(attribute.getName(), attribute.getValue().toByteArray());
        }
        if (proto.getColumnCount() > 0) {
            for (ClientProtos.Column column : proto.getColumnList()) {
                byte[] family = column.getFamily().toByteArray();
                if (column.getQualifierCount() > 0) {
                    for (ByteString qualifier : column.getQualifierList()) {
                        scan.addColumn(family, qualifier.toByteArray());
                    }
                    continue;
                }
                scan.addFamily(family);
            }
        }
        if (proto.hasReversed()) {
            scan.setReversed(proto.getReversed());
        }
        if (proto.hasConsistency()) {
            scan.setConsistency(ProtobufUtil.toConsistency(proto.getConsistency()));
        }
        if (proto.hasCaching()) {
            scan.setCaching(proto.getCaching());
        }
        if (proto.hasMvccReadPoint()) {
            PackagePrivateFieldAccessor.setMvccReadPoint(scan, proto.getMvccReadPoint());
        }
        if (scan.isSmall()) {
            scan.setReadType(Scan.ReadType.PREAD);
        } else if (proto.hasReadType()) {
            scan.setReadType(ProtobufUtil.toReadType(proto.getReadType()));
        }
        if (proto.getNeedCursorResult()) {
            scan.setNeedCursorResult(true);
        }
        return scan;
    }

    public static ClientProtos.Cursor toCursor(Cursor cursor) {
        ClientProtos.Cursor.Builder builder = ClientProtos.Cursor.newBuilder();
        ClientProtos.Cursor.newBuilder().setRow(ByteString.copyFrom((byte[])cursor.getRow()));
        return builder.build();
    }

    public static ClientProtos.Cursor toCursor(Cell cell) {
        return ClientProtos.Cursor.newBuilder().setRow(ByteString.copyFrom((byte[])cell.getRowArray(), (int)cell.getRowOffset(), (int)cell.getRowLength())).build();
    }

    public static Cursor toCursor(ClientProtos.Cursor cursor) {
        return ClientUtil.createCursor(cursor.getRow().toByteArray());
    }

    public static ClientProtos.Get toGet(Get get) throws IOException {
        Boolean loadColumnFamiliesOnDemand;
        Map<String, byte[]> attributes;
        ClientProtos.Get.Builder builder = ClientProtos.Get.newBuilder();
        builder.setRow(UnsafeByteOperations.unsafeWrap((byte[])get.getRow()));
        builder.setCacheBlocks(get.getCacheBlocks());
        builder.setMaxVersions(get.getMaxVersions());
        if (get.getFilter() != null) {
            builder.setFilter(ProtobufUtil.toFilter(get.getFilter()));
        }
        for (Map.Entry<byte[], TimeRange> cftr : get.getColumnFamilyTimeRange().entrySet()) {
            HBaseProtos.ColumnFamilyTimeRange.Builder b = HBaseProtos.ColumnFamilyTimeRange.newBuilder();
            b.setColumnFamily(UnsafeByteOperations.unsafeWrap((byte[])cftr.getKey()));
            b.setTimeRange(ProtobufUtil.timeRangeToProto(cftr.getValue()));
            builder.addCfTimeRange(b);
        }
        TimeRange timeRange = get.getTimeRange();
        if (!timeRange.isAllTime()) {
            HBaseProtos.TimeRange.Builder timeRangeBuilder = HBaseProtos.TimeRange.newBuilder();
            timeRangeBuilder.setFrom(timeRange.getMin());
            timeRangeBuilder.setTo(timeRange.getMax());
            builder.setTimeRange(timeRangeBuilder.build());
        }
        if (!(attributes = get.getAttributesMap()).isEmpty()) {
            HBaseProtos.NameBytesPair.Builder attributeBuilder = HBaseProtos.NameBytesPair.newBuilder();
            for (Map.Entry<String, byte[]> attribute : attributes.entrySet()) {
                attributeBuilder.setName(attribute.getKey());
                attributeBuilder.setValue(UnsafeByteOperations.unsafeWrap((byte[])attribute.getValue()));
                builder.addAttribute(attributeBuilder.build());
            }
        }
        if (get.hasFamilies()) {
            ClientProtos.Column.Builder columnBuilder = ClientProtos.Column.newBuilder();
            Map<byte[], NavigableSet<byte[]>> families = get.getFamilyMap();
            for (Map.Entry<byte[], NavigableSet<byte[]>> family : families.entrySet()) {
                NavigableSet<byte[]> qualifiers = family.getValue();
                columnBuilder.setFamily(UnsafeByteOperations.unsafeWrap((byte[])family.getKey()));
                columnBuilder.clearQualifier();
                if (qualifiers != null && qualifiers.size() > 0) {
                    for (byte[] qualifier : qualifiers) {
                        columnBuilder.addQualifier(UnsafeByteOperations.unsafeWrap((byte[])qualifier));
                    }
                }
                builder.addColumn(columnBuilder.build());
            }
        }
        if (get.getMaxResultsPerColumnFamily() >= 0) {
            builder.setStoreLimit(get.getMaxResultsPerColumnFamily());
        }
        if (get.getRowOffsetPerColumnFamily() > 0) {
            builder.setStoreOffset(get.getRowOffsetPerColumnFamily());
        }
        if (get.isCheckExistenceOnly()) {
            builder.setExistenceOnly(true);
        }
        if (get.getConsistency() != null && get.getConsistency() != Consistency.STRONG) {
            builder.setConsistency(ProtobufUtil.toConsistency(get.getConsistency()));
        }
        if ((loadColumnFamiliesOnDemand = get.getLoadColumnFamiliesOnDemandValue()) != null) {
            builder.setLoadColumnFamiliesOnDemand(loadColumnFamiliesOnDemand.booleanValue());
        }
        return builder.build();
    }

    static void setTimeRange(ClientProtos.MutationProto.Builder builder, TimeRange timeRange) {
        if (!timeRange.isAllTime()) {
            HBaseProtos.TimeRange.Builder timeRangeBuilder = HBaseProtos.TimeRange.newBuilder();
            timeRangeBuilder.setFrom(timeRange.getMin());
            timeRangeBuilder.setTo(timeRange.getMax());
            builder.setTimeRange(timeRangeBuilder.build());
        }
    }

    public static ClientProtos.MutationProto toMutation(Increment increment, ClientProtos.MutationProto.Builder builder, long nonce) {
        builder.setRow(UnsafeByteOperations.unsafeWrap((byte[])increment.getRow()));
        builder.setMutateType(ClientProtos.MutationProto.MutationType.INCREMENT);
        builder.setDurability(ProtobufUtil.toDurability(increment.getDurability()));
        if (nonce != 0L) {
            builder.setNonce(nonce);
        }
        TimeRange timeRange = increment.getTimeRange();
        ProtobufUtil.setTimeRange(builder, timeRange);
        ClientProtos.MutationProto.ColumnValue.Builder columnBuilder = ClientProtos.MutationProto.ColumnValue.newBuilder();
        ClientProtos.MutationProto.ColumnValue.QualifierValue.Builder valueBuilder = ClientProtos.MutationProto.ColumnValue.QualifierValue.newBuilder();
        for (Map.Entry family : increment.getFamilyCellMap().entrySet()) {
            columnBuilder.setFamily(UnsafeByteOperations.unsafeWrap((byte[])((byte[])family.getKey())));
            columnBuilder.clearQualifierValue();
            List values = (List)family.getValue();
            if (values != null && values.size() > 0) {
                for (Cell cell : values) {
                    valueBuilder.clear();
                    valueBuilder.setQualifier(UnsafeByteOperations.unsafeWrap((byte[])cell.getQualifierArray(), (int)cell.getQualifierOffset(), (int)cell.getQualifierLength()));
                    valueBuilder.setValue(UnsafeByteOperations.unsafeWrap((byte[])cell.getValueArray(), (int)cell.getValueOffset(), (int)cell.getValueLength()));
                    if (cell.getTagsLength() > 0) {
                        valueBuilder.setTags(UnsafeByteOperations.unsafeWrap((byte[])cell.getTagsArray(), (int)cell.getTagsOffset(), (int)cell.getTagsLength()));
                    }
                    columnBuilder.addQualifierValue(valueBuilder.build());
                }
            }
            builder.addColumnValue(columnBuilder.build());
        }
        Map<String, byte[]> attributes = increment.getAttributesMap();
        if (!attributes.isEmpty()) {
            HBaseProtos.NameBytesPair.Builder attributeBuilder = HBaseProtos.NameBytesPair.newBuilder();
            for (Map.Entry<String, byte[]> attribute : attributes.entrySet()) {
                attributeBuilder.setName(attribute.getKey());
                attributeBuilder.setValue(UnsafeByteOperations.unsafeWrap((byte[])attribute.getValue()));
                builder.addAttribute(attributeBuilder.build());
            }
        }
        return builder.build();
    }

    public static ClientProtos.MutationProto toMutation(ClientProtos.MutationProto.MutationType type, Mutation mutation) throws IOException {
        return ProtobufUtil.toMutation(type, mutation, 0L);
    }

    public static ClientProtos.MutationProto toMutation(ClientProtos.MutationProto.MutationType type, Mutation mutation, long nonce) throws IOException {
        return ProtobufUtil.toMutation(type, mutation, ClientProtos.MutationProto.newBuilder(), nonce);
    }

    public static ClientProtos.MutationProto toMutation(ClientProtos.MutationProto.MutationType type, Mutation mutation, ClientProtos.MutationProto.Builder builder) throws IOException {
        return ProtobufUtil.toMutation(type, mutation, builder, 0L);
    }

    public static ClientProtos.MutationProto toMutation(ClientProtos.MutationProto.MutationType type, Mutation mutation, ClientProtos.MutationProto.Builder builder, long nonce) throws IOException {
        builder = ProtobufUtil.getMutationBuilderAndSetCommonFields(type, mutation, builder);
        if (nonce != 0L) {
            builder.setNonce(nonce);
        }
        ClientProtos.MutationProto.ColumnValue.Builder columnBuilder = ClientProtos.MutationProto.ColumnValue.newBuilder();
        ClientProtos.MutationProto.ColumnValue.QualifierValue.Builder valueBuilder = ClientProtos.MutationProto.ColumnValue.QualifierValue.newBuilder();
        for (Map.Entry family : mutation.getFamilyCellMap().entrySet()) {
            columnBuilder.clear();
            columnBuilder.setFamily(UnsafeByteOperations.unsafeWrap((byte[])((byte[])family.getKey())));
            for (Cell cell : (List)family.getValue()) {
                valueBuilder.clear();
                valueBuilder.setQualifier(UnsafeByteOperations.unsafeWrap((byte[])cell.getQualifierArray(), (int)cell.getQualifierOffset(), (int)cell.getQualifierLength()));
                valueBuilder.setValue(UnsafeByteOperations.unsafeWrap((byte[])cell.getValueArray(), (int)cell.getValueOffset(), (int)cell.getValueLength()));
                valueBuilder.setTimestamp(cell.getTimestamp());
                if (type == ClientProtos.MutationProto.MutationType.DELETE || type == ClientProtos.MutationProto.MutationType.PUT && CellUtil.isDelete((Cell)cell)) {
                    KeyValue.Type keyValueType = KeyValue.Type.codeToType((byte)cell.getTypeByte());
                    valueBuilder.setDeleteType(ProtobufUtil.toDeleteType(keyValueType));
                }
                columnBuilder.addQualifierValue(valueBuilder.build());
            }
            builder.addColumnValue(columnBuilder.build());
        }
        return builder.build();
    }

    public static ClientProtos.MutationProto toMutationNoData(ClientProtos.MutationProto.MutationType type, Mutation mutation, ClientProtos.MutationProto.Builder builder) throws IOException {
        return ProtobufUtil.toMutationNoData(type, mutation, builder, 0L);
    }

    public static ClientProtos.MutationProto toMutationNoData(ClientProtos.MutationProto.MutationType type, Mutation mutation) throws IOException {
        ClientProtos.MutationProto.Builder builder = ClientProtos.MutationProto.newBuilder();
        return ProtobufUtil.toMutationNoData(type, mutation, builder);
    }

    public static ClientProtos.MutationProto toMutationNoData(ClientProtos.MutationProto.MutationType type, Mutation mutation, ClientProtos.MutationProto.Builder builder, long nonce) throws IOException {
        ProtobufUtil.getMutationBuilderAndSetCommonFields(type, mutation, builder);
        builder.setAssociatedCellCount(mutation.size());
        if (mutation instanceof Increment) {
            ProtobufUtil.setTimeRange(builder, ((Increment)mutation).getTimeRange());
        }
        if (nonce != 0L) {
            builder.setNonce(nonce);
        }
        return builder.build();
    }

    private static ClientProtos.MutationProto.Builder getMutationBuilderAndSetCommonFields(ClientProtos.MutationProto.MutationType type, Mutation mutation, ClientProtos.MutationProto.Builder builder) {
        builder.setRow(UnsafeByteOperations.unsafeWrap((byte[])mutation.getRow()));
        builder.setMutateType(type);
        builder.setDurability(ProtobufUtil.toDurability(mutation.getDurability()));
        builder.setTimestamp(mutation.getTimeStamp());
        Map<String, byte[]> attributes = mutation.getAttributesMap();
        if (!attributes.isEmpty()) {
            HBaseProtos.NameBytesPair.Builder attributeBuilder = HBaseProtos.NameBytesPair.newBuilder();
            for (Map.Entry<String, byte[]> attribute : attributes.entrySet()) {
                attributeBuilder.setName(attribute.getKey());
                attributeBuilder.setValue(UnsafeByteOperations.unsafeWrap((byte[])attribute.getValue()));
                builder.addAttribute(attributeBuilder.build());
            }
        }
        return builder;
    }

    public static ClientProtos.Result toResult(Result result) {
        if (result.getExists() != null) {
            return ProtobufUtil.toResult(result.getExists(), result.isStale());
        }
        Cell[] cells = result.rawCells();
        if (cells == null || cells.length == 0) {
            return result.isStale() ? EMPTY_RESULT_PB_STALE : EMPTY_RESULT_PB;
        }
        ClientProtos.Result.Builder builder = ClientProtos.Result.newBuilder();
        for (Cell c : cells) {
            builder.addCell(ProtobufUtil.toCell(c));
        }
        builder.setStale(result.isStale());
        builder.setPartial(result.mayHaveMoreCellsInRow());
        return builder.build();
    }

    public static ClientProtos.Result toResult(boolean existence, boolean stale) {
        if (stale) {
            return existence ? EMPTY_RESULT_PB_EXISTS_TRUE_STALE : EMPTY_RESULT_PB_EXISTS_FALSE_STALE;
        }
        return existence ? EMPTY_RESULT_PB_EXISTS_TRUE : EMPTY_RESULT_PB_EXISTS_FALSE;
    }

    public static ClientProtos.Result toResultNoData(Result result) {
        if (result.getExists() != null) {
            return ProtobufUtil.toResult(result.getExists(), result.isStale());
        }
        int size = result.size();
        if (size == 0) {
            return result.isStale() ? EMPTY_RESULT_PB_STALE : EMPTY_RESULT_PB;
        }
        ClientProtos.Result.Builder builder = ClientProtos.Result.newBuilder();
        builder.setAssociatedCellCount(size);
        builder.setStale(result.isStale());
        return builder.build();
    }

    public static Result toResult(ClientProtos.Result proto) {
        if (proto.hasExists()) {
            if (proto.getStale()) {
                return proto.getExists() ? EMPTY_RESULT_EXISTS_TRUE_STALE : EMPTY_RESULT_EXISTS_FALSE_STALE;
            }
            return proto.getExists() ? EMPTY_RESULT_EXISTS_TRUE : EMPTY_RESULT_EXISTS_FALSE;
        }
        List values = proto.getCellList();
        if (values.isEmpty()) {
            return proto.getStale() ? EMPTY_RESULT_STALE : EMPTY_RESULT;
        }
        ArrayList<Cell> cells = new ArrayList<Cell>(values.size());
        for (CellProtos.Cell c : values) {
            cells.add(ProtobufUtil.toCell(c));
        }
        return Result.create(cells, null, proto.getStale(), proto.getPartial());
    }

    public static Result toResult(ClientProtos.Result proto, CellScanner scanner) throws IOException {
        List values = proto.getCellList();
        if (proto.hasExists()) {
            if (values != null && !values.isEmpty() || proto.hasAssociatedCellCount() && proto.getAssociatedCellCount() > 0) {
                throw new IllegalArgumentException("bad proto: exists with cells is no allowed " + proto);
            }
            if (proto.getStale()) {
                return proto.getExists() ? EMPTY_RESULT_EXISTS_TRUE_STALE : EMPTY_RESULT_EXISTS_FALSE_STALE;
            }
            return proto.getExists() ? EMPTY_RESULT_EXISTS_TRUE : EMPTY_RESULT_EXISTS_FALSE;
        }
        ArrayList<Cell> cells = null;
        if (proto.hasAssociatedCellCount()) {
            int count = proto.getAssociatedCellCount();
            cells = new ArrayList<Cell>(count + values.size());
            for (int i = 0; i < count; ++i) {
                if (!scanner.advance()) {
                    throw new IOException("Failed get " + i + " of " + count);
                }
                cells.add(scanner.current());
            }
        }
        if (!values.isEmpty()) {
            if (cells == null) {
                cells = new ArrayList(values.size());
            }
            for (CellProtos.Cell c : values) {
                cells.add(ProtobufUtil.toCell(c));
            }
        }
        return cells == null || cells.isEmpty() ? (proto.getStale() ? EMPTY_RESULT_STALE : EMPTY_RESULT) : Result.create(cells, null, proto.getStale());
    }

    public static ComparatorProtos.Comparator toComparator(ByteArrayComparable comparator) {
        ComparatorProtos.Comparator.Builder builder = ComparatorProtos.Comparator.newBuilder();
        builder.setName(comparator.getClass().getName());
        builder.setSerializedComparator(UnsafeByteOperations.unsafeWrap((byte[])comparator.toByteArray()));
        return builder.build();
    }

    public static ByteArrayComparable toComparator(ComparatorProtos.Comparator proto) throws IOException {
        String type = proto.getName();
        String funcName = "parseFrom";
        byte[] value = proto.getSerializedComparator().toByteArray();
        try {
            Class<?> c = Class.forName(type, true, CLASS_LOADER);
            Method parseFrom = c.getMethod(funcName, byte[].class);
            if (parseFrom == null) {
                throw new IOException("Unable to locate function: " + funcName + " in type: " + type);
            }
            return (ByteArrayComparable)parseFrom.invoke(null, new Object[]{value});
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public static Filter toFilter(FilterProtos.Filter proto) throws IOException {
        String type = proto.getName();
        byte[] value = proto.getSerializedFilter().toByteArray();
        String funcName = "parseFrom";
        try {
            Class<?> c = Class.forName(type, true, CLASS_LOADER);
            Method parseFrom = c.getMethod(funcName, byte[].class);
            if (parseFrom == null) {
                throw new IOException("Unable to locate function: " + funcName + " in type: " + type);
            }
            return (Filter)parseFrom.invoke(c, new Object[]{value});
        }
        catch (Exception e) {
            throw new DoNotRetryIOException(e);
        }
    }

    public static FilterProtos.Filter toFilter(Filter filter) throws IOException {
        FilterProtos.Filter.Builder builder = FilterProtos.Filter.newBuilder();
        builder.setName(filter.getClass().getName());
        builder.setSerializedFilter(UnsafeByteOperations.unsafeWrap((byte[])filter.toByteArray()));
        return builder.build();
    }

    public static ClientProtos.MutationProto.DeleteType toDeleteType(KeyValue.Type type) throws IOException {
        switch (type) {
            case Delete: {
                return ClientProtos.MutationProto.DeleteType.DELETE_ONE_VERSION;
            }
            case DeleteColumn: {
                return ClientProtos.MutationProto.DeleteType.DELETE_MULTIPLE_VERSIONS;
            }
            case DeleteFamily: {
                return ClientProtos.MutationProto.DeleteType.DELETE_FAMILY;
            }
            case DeleteFamilyVersion: {
                return ClientProtos.MutationProto.DeleteType.DELETE_FAMILY_VERSION;
            }
        }
        throw new IOException("Unknown delete type: " + type);
    }

    public static KeyValue.Type fromDeleteType(ClientProtos.MutationProto.DeleteType type) throws IOException {
        switch (type) {
            case DELETE_ONE_VERSION: {
                return KeyValue.Type.Delete;
            }
            case DELETE_MULTIPLE_VERSIONS: {
                return KeyValue.Type.DeleteColumn;
            }
            case DELETE_FAMILY: {
                return KeyValue.Type.DeleteFamily;
            }
            case DELETE_FAMILY_VERSION: {
                return KeyValue.Type.DeleteFamilyVersion;
            }
        }
        throw new IOException("Unknown delete type: " + type);
    }

    public static Throwable toException(HBaseProtos.NameBytesPair parameter) throws IOException {
        if (parameter == null || !parameter.hasValue()) {
            return null;
        }
        String desc = parameter.getValue().toStringUtf8();
        String type = parameter.getName();
        try {
            Class<?> c = Class.forName(type, true, CLASS_LOADER);
            Constructor<?> cn = null;
            try {
                cn = c.getDeclaredConstructor(String.class);
                return (Throwable)cn.newInstance(desc);
            }
            catch (NoSuchMethodException e) {
                cn = c.getDeclaredConstructor(String.class, String.class);
                return (Throwable)cn.newInstance(type, desc);
            }
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public static <T extends Service> T newServiceStub(Class<T> service, RpcChannel channel) throws Exception {
        return (T)((Service)Methods.call(service, null, (String)"newStub", (Class[])new Class[]{RpcChannel.class}, (Object[])new Object[]{channel}));
    }

    public static HRegionInfo getRegionInfo(RpcController controller, AdminProtos.AdminService.BlockingInterface admin, byte[] regionName) throws IOException {
        try {
            AdminProtos.GetRegionInfoRequest request = RequestConverter.buildGetRegionInfoRequest(regionName);
            AdminProtos.GetRegionInfoResponse response = admin.getRegionInfo(controller, request);
            return HRegionInfo.convert(response.getRegionInfo());
        }
        catch (ServiceException se) {
            throw ProtobufUtil.getRemoteException(se);
        }
    }

    public static List<RegionLoad> getRegionLoad(RpcController controller, AdminProtos.AdminService.BlockingInterface admin, TableName tableName) throws IOException {
        AdminProtos.GetRegionLoadResponse response;
        AdminProtos.GetRegionLoadRequest request = RequestConverter.buildGetRegionLoadRequest(tableName);
        try {
            response = admin.getRegionLoad(controller, request);
        }
        catch (ServiceException se) {
            throw ProtobufUtil.getRemoteException(se);
        }
        return ProtobufUtil.getRegionLoadInfo(response);
    }

    static List<RegionLoad> getRegionLoadInfo(AdminProtos.GetRegionLoadResponse regionLoadResponse) {
        ArrayList<RegionLoad> regionLoadList = new ArrayList<RegionLoad>(regionLoadResponse.getRegionLoadsCount());
        for (ClusterStatusProtos.RegionLoad regionLoad : regionLoadResponse.getRegionLoadsList()) {
            regionLoadList.add(new RegionLoad(regionLoad));
        }
        return regionLoadList;
    }

    public static void closeRegion(RpcController controller, AdminProtos.AdminService.BlockingInterface admin, ServerName server, byte[] regionName) throws IOException {
        AdminProtos.CloseRegionRequest closeRegionRequest = ProtobufUtil.buildCloseRegionRequest(server, regionName);
        try {
            admin.closeRegion(controller, closeRegionRequest);
        }
        catch (ServiceException se) {
            throw ProtobufUtil.getRemoteException(se);
        }
    }

    public static boolean closeRegion(RpcController controller, AdminProtos.AdminService.BlockingInterface admin, ServerName server, byte[] regionName, ServerName destinationServer) throws IOException {
        AdminProtos.CloseRegionRequest closeRegionRequest = ProtobufUtil.buildCloseRegionRequest(server, regionName, destinationServer);
        try {
            AdminProtos.CloseRegionResponse response = admin.closeRegion(controller, closeRegionRequest);
            return ResponseConverter.isClosed(response);
        }
        catch (ServiceException se) {
            throw ProtobufUtil.getRemoteException(se);
        }
    }

    public static void warmupRegion(RpcController controller, AdminProtos.AdminService.BlockingInterface admin, HRegionInfo regionInfo) throws IOException {
        try {
            AdminProtos.WarmupRegionRequest warmupRegionRequest = RequestConverter.buildWarmupRegionRequest(regionInfo);
            admin.warmupRegion(controller, warmupRegionRequest);
        }
        catch (ServiceException e) {
            throw ProtobufUtil.getRemoteException(e);
        }
    }

    public static void openRegion(RpcController controller, AdminProtos.AdminService.BlockingInterface admin, ServerName server, HRegionInfo region) throws IOException {
        AdminProtos.OpenRegionRequest request = RequestConverter.buildOpenRegionRequest(server, region, null, null);
        try {
            admin.openRegion(controller, request);
        }
        catch (ServiceException se) {
            throw ProtobufUtil.getRemoteException(se);
        }
    }

    public static List<HRegionInfo> getOnlineRegions(AdminProtos.AdminService.BlockingInterface admin) throws IOException {
        return ProtobufUtil.getOnlineRegions(null, admin);
    }

    public static List<HRegionInfo> getOnlineRegions(RpcController controller, AdminProtos.AdminService.BlockingInterface admin) throws IOException {
        AdminProtos.GetOnlineRegionRequest request = RequestConverter.buildGetOnlineRegionRequest();
        AdminProtos.GetOnlineRegionResponse response = null;
        try {
            response = admin.getOnlineRegion(controller, request);
        }
        catch (ServiceException se) {
            throw ProtobufUtil.getRemoteException(se);
        }
        return ProtobufUtil.getRegionInfos(response);
    }

    public static List<HRegionInfo> getRegionInfos(AdminProtos.GetOnlineRegionResponse proto) {
        if (proto == null) {
            return null;
        }
        ArrayList<HRegionInfo> regionInfos = new ArrayList<HRegionInfo>(proto.getRegionInfoList().size());
        for (HBaseProtos.RegionInfo regionInfo : proto.getRegionInfoList()) {
            regionInfos.add(HRegionInfo.convert(regionInfo));
        }
        return regionInfos;
    }

    public static AdminProtos.ServerInfo getServerInfo(RpcController controller, AdminProtos.AdminService.BlockingInterface admin) throws IOException {
        AdminProtos.GetServerInfoRequest request = RequestConverter.buildGetServerInfoRequest();
        try {
            AdminProtos.GetServerInfoResponse response = admin.getServerInfo(controller, request);
            return response.getServerInfo();
        }
        catch (ServiceException se) {
            throw ProtobufUtil.getRemoteException(se);
        }
    }

    public static List<String> getStoreFiles(AdminProtos.AdminService.BlockingInterface admin, byte[] regionName, byte[] family) throws IOException {
        return ProtobufUtil.getStoreFiles(null, admin, regionName, family);
    }

    public static List<String> getStoreFiles(RpcController controller, AdminProtos.AdminService.BlockingInterface admin, byte[] regionName, byte[] family) throws IOException {
        AdminProtos.GetStoreFileRequest request = ProtobufUtil.buildGetStoreFileRequest(regionName, family);
        try {
            AdminProtos.GetStoreFileResponse response = admin.getStoreFile(controller, request);
            return response.getStoreFileList();
        }
        catch (ServiceException se) {
            throw ProtobufUtil.getRemoteException(se);
        }
    }

    public static void split(RpcController controller, AdminProtos.AdminService.BlockingInterface admin, HRegionInfo hri, byte[] splitPoint) throws IOException {
        AdminProtos.SplitRegionRequest request = ProtobufUtil.buildSplitRegionRequest(hri.getRegionName(), splitPoint);
        try {
            admin.splitRegion(controller, request);
        }
        catch (ServiceException se) {
            throw ProtobufUtil.getRemoteException(se);
        }
    }

    public static void mergeRegions(final RpcController controller, final AdminProtos.AdminService.BlockingInterface admin, HRegionInfo region_a, HRegionInfo region_b, boolean forcible, User user) throws IOException {
        final AdminProtos.MergeRegionsRequest request = ProtobufUtil.buildMergeRegionsRequest(region_a.getRegionName(), region_b.getRegionName(), forcible);
        if (user != null) {
            try {
                user.runAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

                    @Override
                    public Void run() throws Exception {
                        admin.mergeRegions(controller, request);
                        return null;
                    }
                });
            }
            catch (InterruptedException ie) {
                InterruptedIOException iioe = new InterruptedIOException();
                iioe.initCause(ie);
                throw iioe;
            }
        }
        try {
            admin.mergeRegions(controller, request);
        }
        catch (ServiceException se) {
            throw ProtobufUtil.getRemoteException(se);
        }
    }

    public static long getTotalRequestsCount(ClusterStatusProtos.RegionLoad rl) {
        if (rl == null) {
            return 0L;
        }
        return rl.getReadRequestsCount() + rl.getWriteRequestsCount();
    }

    public static byte[] toDelimitedByteArray(Message m) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(4096);
        baos.write(ProtobufMagic.PB_MAGIC);
        m.writeDelimitedTo((OutputStream)baos);
        return baos.toByteArray();
    }

    public static String getRegionEncodedName(HBaseProtos.RegionSpecifier regionSpecifier) throws DoNotRetryIOException {
        ByteString value = regionSpecifier.getValue();
        HBaseProtos.RegionSpecifier.RegionSpecifierType type = regionSpecifier.getType();
        switch (type) {
            case REGION_NAME: {
                return HRegionInfo.encodeRegionName(value.toByteArray());
            }
            case ENCODED_REGION_NAME: {
                return value.toStringUtf8();
            }
        }
        throw new DoNotRetryIOException("Unsupported region specifier type: " + type);
    }

    public static ScanMetrics toScanMetrics(byte[] bytes) {
        MapReduceProtos.ScanMetrics pScanMetrics = null;
        try {
            pScanMetrics = MapReduceProtos.ScanMetrics.parseFrom((byte[])bytes);
        }
        catch (InvalidProtocolBufferException invalidProtocolBufferException) {
            // empty catch block
        }
        ScanMetrics scanMetrics = new ScanMetrics();
        if (pScanMetrics != null) {
            for (HBaseProtos.NameInt64Pair pair : pScanMetrics.getMetricsList()) {
                if (!pair.hasName() || !pair.hasValue()) continue;
                scanMetrics.setCounter(pair.getName(), pair.getValue());
            }
        }
        return scanMetrics;
    }

    public static MapReduceProtos.ScanMetrics toScanMetrics(ScanMetrics scanMetrics, boolean reset) {
        MapReduceProtos.ScanMetrics.Builder builder = MapReduceProtos.ScanMetrics.newBuilder();
        Map<String, Long> metrics = scanMetrics.getMetricsMap(reset);
        for (Map.Entry<String, Long> e : metrics.entrySet()) {
            HBaseProtos.NameInt64Pair nameInt64Pair = HBaseProtos.NameInt64Pair.newBuilder().setName(e.getKey()).setValue(e.getValue().longValue()).build();
            builder.addMetrics(nameInt64Pair);
        }
        return builder.build();
    }

    public static void toIOException(ServiceException se) throws IOException {
        if (se == null) {
            throw new NullPointerException("Null service exception passed!");
        }
        Throwable cause = se.getCause();
        if (cause != null && cause instanceof IOException) {
            throw (IOException)cause;
        }
        throw new IOException(se);
    }

    public static CellProtos.Cell toCell(Cell kv) {
        CellProtos.Cell.Builder kvbuilder = CellProtos.Cell.newBuilder();
        if (kv instanceof ByteBufferCell) {
            kvbuilder.setRow(ProtobufUtil.wrap(((ByteBufferCell)kv).getRowByteBuffer(), ((ByteBufferCell)kv).getRowPosition(), kv.getRowLength()));
            kvbuilder.setFamily(ProtobufUtil.wrap(((ByteBufferCell)kv).getFamilyByteBuffer(), ((ByteBufferCell)kv).getFamilyPosition(), kv.getFamilyLength()));
            kvbuilder.setQualifier(ProtobufUtil.wrap(((ByteBufferCell)kv).getQualifierByteBuffer(), ((ByteBufferCell)kv).getQualifierPosition(), kv.getQualifierLength()));
            kvbuilder.setCellType(CellProtos.CellType.valueOf((int)kv.getTypeByte()));
            kvbuilder.setTimestamp(kv.getTimestamp());
            kvbuilder.setValue(ProtobufUtil.wrap(((ByteBufferCell)kv).getValueByteBuffer(), ((ByteBufferCell)kv).getValuePosition(), kv.getValueLength()));
        } else {
            kvbuilder.setRow(UnsafeByteOperations.unsafeWrap((byte[])kv.getRowArray(), (int)kv.getRowOffset(), (int)kv.getRowLength()));
            kvbuilder.setFamily(UnsafeByteOperations.unsafeWrap((byte[])kv.getFamilyArray(), (int)kv.getFamilyOffset(), (int)kv.getFamilyLength()));
            kvbuilder.setQualifier(UnsafeByteOperations.unsafeWrap((byte[])kv.getQualifierArray(), (int)kv.getQualifierOffset(), (int)kv.getQualifierLength()));
            kvbuilder.setCellType(CellProtos.CellType.valueOf((int)kv.getTypeByte()));
            kvbuilder.setTimestamp(kv.getTimestamp());
            kvbuilder.setValue(UnsafeByteOperations.unsafeWrap((byte[])kv.getValueArray(), (int)kv.getValueOffset(), (int)kv.getValueLength()));
        }
        return kvbuilder.build();
    }

    private static ByteString wrap(ByteBuffer b, int offset, int length) {
        ByteBuffer dup = b.duplicate();
        dup.position(offset);
        dup.limit(offset + length);
        return UnsafeByteOperations.unsafeWrap((ByteBuffer)dup);
    }

    public static Cell toCell(CellProtos.Cell cell) {
        return CellUtil.createCell((byte[])cell.getRow().toByteArray(), (byte[])cell.getFamily().toByteArray(), (byte[])cell.getQualifier().toByteArray(), (long)cell.getTimestamp(), (byte)((byte)cell.getCellType().getNumber()), (byte[])cell.getValue().toByteArray());
    }

    public static HBaseProtos.NamespaceDescriptor toProtoNamespaceDescriptor(NamespaceDescriptor ns) {
        HBaseProtos.NamespaceDescriptor.Builder b = HBaseProtos.NamespaceDescriptor.newBuilder().setName(ByteString.copyFromUtf8((String)ns.getName()));
        for (Map.Entry entry : ns.getConfiguration().entrySet()) {
            b.addConfiguration(HBaseProtos.NameStringPair.newBuilder().setName((String)entry.getKey()).setValue((String)entry.getValue()));
        }
        return b.build();
    }

    public static NamespaceDescriptor toNamespaceDescriptor(HBaseProtos.NamespaceDescriptor desc) {
        NamespaceDescriptor.Builder b = NamespaceDescriptor.create((String)desc.getName().toStringUtf8());
        for (HBaseProtos.NameStringPair prop : desc.getConfigurationList()) {
            b.addConfiguration(prop.getName(), prop.getValue());
        }
        return b.build();
    }

    public static WALProtos.CompactionDescriptor toCompactionDescriptor(HRegionInfo info, byte[] family, List<Path> inputPaths, List<Path> outputPaths, Path storeDir) {
        return ProtobufUtil.toCompactionDescriptor(info, null, family, inputPaths, outputPaths, storeDir);
    }

    public static WALProtos.CompactionDescriptor toCompactionDescriptor(HRegionInfo info, byte[] regionName, byte[] family, List<Path> inputPaths, List<Path> outputPaths, Path storeDir) {
        WALProtos.CompactionDescriptor.Builder builder = WALProtos.CompactionDescriptor.newBuilder().setTableName(UnsafeByteOperations.unsafeWrap((byte[])info.getTable().toBytes())).setEncodedRegionName(UnsafeByteOperations.unsafeWrap((byte[])(regionName == null ? info.getEncodedNameAsBytes() : regionName))).setFamilyName(UnsafeByteOperations.unsafeWrap((byte[])family)).setStoreHomeDir(storeDir.getName());
        for (Path inputPath : inputPaths) {
            builder.addCompactionInput(inputPath.getName());
        }
        for (Path outputPath : outputPaths) {
            builder.addCompactionOutput(outputPath.getName());
        }
        builder.setRegionName(UnsafeByteOperations.unsafeWrap((byte[])info.getRegionName()));
        return builder.build();
    }

    public static WALProtos.FlushDescriptor toFlushDescriptor(WALProtos.FlushDescriptor.FlushAction action, HRegionInfo hri, long flushSeqId, Map<byte[], List<Path>> committedFiles) {
        WALProtos.FlushDescriptor.Builder desc = WALProtos.FlushDescriptor.newBuilder().setAction(action).setEncodedRegionName(UnsafeByteOperations.unsafeWrap((byte[])hri.getEncodedNameAsBytes())).setRegionName(UnsafeByteOperations.unsafeWrap((byte[])hri.getRegionName())).setFlushSequenceNumber(flushSeqId).setTableName(UnsafeByteOperations.unsafeWrap((byte[])hri.getTable().getName()));
        for (Map.Entry<byte[], List<Path>> entry : committedFiles.entrySet()) {
            WALProtos.FlushDescriptor.StoreFlushDescriptor.Builder builder = WALProtos.FlushDescriptor.StoreFlushDescriptor.newBuilder().setFamilyName(UnsafeByteOperations.unsafeWrap((byte[])entry.getKey())).setStoreHomeDir(Bytes.toString((byte[])entry.getKey()));
            if (entry.getValue() != null) {
                for (Path path : entry.getValue()) {
                    builder.addFlushOutput(path.getName());
                }
            }
            desc.addStoreFlushes(builder);
        }
        return desc.build();
    }

    public static WALProtos.RegionEventDescriptor toRegionEventDescriptor(WALProtos.RegionEventDescriptor.EventType eventType, HRegionInfo hri, long seqId, ServerName server, Map<byte[], List<Path>> storeFiles) {
        byte[] tableNameAsBytes = hri.getTable().getName();
        byte[] encodedNameAsBytes = hri.getEncodedNameAsBytes();
        byte[] regionNameAsBytes = hri.getRegionName();
        return ProtobufUtil.toRegionEventDescriptor(eventType, tableNameAsBytes, encodedNameAsBytes, regionNameAsBytes, seqId, server, storeFiles);
    }

    public static WALProtos.RegionEventDescriptor toRegionEventDescriptor(WALProtos.RegionEventDescriptor.EventType eventType, byte[] tableNameAsBytes, byte[] encodedNameAsBytes, byte[] regionNameAsBytes, long seqId, ServerName server, Map<byte[], List<Path>> storeFiles) {
        WALProtos.RegionEventDescriptor.Builder desc = WALProtos.RegionEventDescriptor.newBuilder().setEventType(eventType).setTableName(UnsafeByteOperations.unsafeWrap((byte[])tableNameAsBytes)).setEncodedRegionName(UnsafeByteOperations.unsafeWrap((byte[])encodedNameAsBytes)).setRegionName(UnsafeByteOperations.unsafeWrap((byte[])regionNameAsBytes)).setLogSequenceNumber(seqId).setServer(ProtobufUtil.toServerName(server));
        for (Map.Entry<byte[], List<Path>> entry : storeFiles.entrySet()) {
            WALProtos.StoreDescriptor.Builder builder = WALProtos.StoreDescriptor.newBuilder().setFamilyName(UnsafeByteOperations.unsafeWrap((byte[])entry.getKey())).setStoreHomeDir(Bytes.toString((byte[])entry.getKey()));
            for (Path path : entry.getValue()) {
                builder.addStoreFile(path.getName());
            }
            desc.addStores(builder);
        }
        return desc.build();
    }

    public static String getShortTextFormat(Message m) {
        if (m == null) {
            return "null";
        }
        if (m instanceof ClientProtos.ScanRequest) {
            return TextFormat.shortDebugString((MessageOrBuilder)m);
        }
        if (m instanceof RegionServerStatusProtos.RegionServerReportRequest) {
            RegionServerStatusProtos.RegionServerReportRequest r = (RegionServerStatusProtos.RegionServerReportRequest)m;
            return "server " + TextFormat.shortDebugString((MessageOrBuilder)r.getServer()) + " load { numberOfRequests: " + r.getLoad().getNumberOfRequests() + " }";
        }
        if (m instanceof RegionServerStatusProtos.RegionServerStartupRequest) {
            return TextFormat.shortDebugString((MessageOrBuilder)m);
        }
        if (m instanceof ClientProtos.MutationProto) {
            return ProtobufUtil.toShortString((ClientProtos.MutationProto)m);
        }
        if (m instanceof ClientProtos.GetRequest) {
            ClientProtos.GetRequest r = (ClientProtos.GetRequest)m;
            return "region= " + ProtobufUtil.getStringForByteString(r.getRegion().getValue()) + ", row=" + ProtobufUtil.getStringForByteString(r.getGet().getRow());
        }
        if (m instanceof ClientProtos.MultiRequest) {
            ClientProtos.MultiRequest r = (ClientProtos.MultiRequest)m;
            ClientProtos.RegionAction actions = (ClientProtos.RegionAction)r.getRegionActionList().get(0);
            String row = actions.getActionCount() <= 0 ? "" : ProtobufUtil.getStringForByteString(actions.getAction(0).hasGet() ? actions.getAction(0).getGet().getRow() : actions.getAction(0).getMutation().getRow());
            return "region= " + ProtobufUtil.getStringForByteString(actions.getRegion().getValue()) + ", for " + r.getRegionActionCount() + " actions and 1st row key=" + row;
        }
        if (m instanceof ClientProtos.MutateRequest) {
            ClientProtos.MutateRequest r = (ClientProtos.MutateRequest)m;
            return "region= " + ProtobufUtil.getStringForByteString(r.getRegion().getValue()) + ", row=" + ProtobufUtil.getStringForByteString(r.getMutation().getRow());
        }
        if (m instanceof ClientProtos.CoprocessorServiceRequest) {
            ClientProtos.CoprocessorServiceRequest r = (ClientProtos.CoprocessorServiceRequest)m;
            return "coprocessorService= " + r.getCall().getServiceName() + ":" + r.getCall().getMethodName();
        }
        return "TODO: " + m.getClass().toString();
    }

    private static String getStringForByteString(ByteString bs) {
        return Bytes.toStringBinary((byte[])bs.toByteArray());
    }

    static String toShortString(ClientProtos.MutationProto proto) {
        return "row=" + Bytes.toString((byte[])proto.getRow().toByteArray()) + ", type=" + proto.getMutateType().toString();
    }

    public static TableName toTableName(HBaseProtos.TableName tableNamePB) {
        return TableName.valueOf((ByteBuffer)tableNamePB.getNamespace().asReadOnlyByteBuffer(), (ByteBuffer)tableNamePB.getQualifier().asReadOnlyByteBuffer());
    }

    public static HBaseProtos.TableName toProtoTableName(TableName tableName) {
        return HBaseProtos.TableName.newBuilder().setNamespace(UnsafeByteOperations.unsafeWrap((byte[])tableName.getNamespace())).setQualifier(UnsafeByteOperations.unsafeWrap((byte[])tableName.getQualifier())).build();
    }

    public static TableName[] getTableNameArray(List<HBaseProtos.TableName> tableNamesList) {
        if (tableNamesList == null) {
            return new TableName[0];
        }
        TableName[] tableNames = new TableName[tableNamesList.size()];
        for (int i = 0; i < tableNamesList.size(); ++i) {
            tableNames[i] = ProtobufUtil.toTableName(tableNamesList.get(i));
        }
        return tableNames;
    }

    public static CellVisibility toCellVisibility(ClientProtos.CellVisibility proto) {
        if (proto == null) {
            return null;
        }
        return new CellVisibility(proto.getExpression());
    }

    public static CellVisibility toCellVisibility(byte[] protoBytes) throws DeserializationException {
        if (protoBytes == null) {
            return null;
        }
        ClientProtos.CellVisibility.Builder builder = ClientProtos.CellVisibility.newBuilder();
        ClientProtos.CellVisibility proto = null;
        try {
            ProtobufUtil.mergeFrom((Message.Builder)builder, protoBytes);
            proto = builder.build();
        }
        catch (IOException e) {
            throw new DeserializationException((Throwable)e);
        }
        return ProtobufUtil.toCellVisibility(proto);
    }

    public static ClientProtos.CellVisibility toCellVisibility(CellVisibility cellVisibility) {
        ClientProtos.CellVisibility.Builder builder = ClientProtos.CellVisibility.newBuilder();
        builder.setExpression(cellVisibility.getExpression());
        return builder.build();
    }

    public static Authorizations toAuthorizations(ClientProtos.Authorizations proto) {
        if (proto == null) {
            return null;
        }
        return new Authorizations((List<String>)proto.getLabelList());
    }

    public static Authorizations toAuthorizations(byte[] protoBytes) throws DeserializationException {
        if (protoBytes == null) {
            return null;
        }
        ClientProtos.Authorizations.Builder builder = ClientProtos.Authorizations.newBuilder();
        ClientProtos.Authorizations proto = null;
        try {
            ProtobufUtil.mergeFrom((Message.Builder)builder, protoBytes);
            proto = builder.build();
        }
        catch (IOException e) {
            throw new DeserializationException((Throwable)e);
        }
        return ProtobufUtil.toAuthorizations(proto);
    }

    public static ClientProtos.Authorizations toAuthorizations(Authorizations authorizations) {
        ClientProtos.Authorizations.Builder builder = ClientProtos.Authorizations.newBuilder();
        for (String label : authorizations.getLabels()) {
            builder.addLabel(label);
        }
        return builder.build();
    }

    public static TimeUnit toTimeUnit(HBaseProtos.TimeUnit proto) {
        switch (proto) {
            case NANOSECONDS: {
                return TimeUnit.NANOSECONDS;
            }
            case MICROSECONDS: {
                return TimeUnit.MICROSECONDS;
            }
            case MILLISECONDS: {
                return TimeUnit.MILLISECONDS;
            }
            case SECONDS: {
                return TimeUnit.SECONDS;
            }
            case MINUTES: {
                return TimeUnit.MINUTES;
            }
            case HOURS: {
                return TimeUnit.HOURS;
            }
            case DAYS: {
                return TimeUnit.DAYS;
            }
        }
        throw new RuntimeException("Invalid TimeUnit " + proto);
    }

    public static HBaseProtos.TimeUnit toProtoTimeUnit(TimeUnit timeUnit) {
        switch (timeUnit) {
            case NANOSECONDS: {
                return HBaseProtos.TimeUnit.NANOSECONDS;
            }
            case MICROSECONDS: {
                return HBaseProtos.TimeUnit.MICROSECONDS;
            }
            case MILLISECONDS: {
                return HBaseProtos.TimeUnit.MILLISECONDS;
            }
            case SECONDS: {
                return HBaseProtos.TimeUnit.SECONDS;
            }
            case MINUTES: {
                return HBaseProtos.TimeUnit.MINUTES;
            }
            case HOURS: {
                return HBaseProtos.TimeUnit.HOURS;
            }
            case DAYS: {
                return HBaseProtos.TimeUnit.DAYS;
            }
        }
        throw new RuntimeException("Invalid TimeUnit " + (Object)((Object)timeUnit));
    }

    public static ThrottleType toThrottleType(QuotaProtos.ThrottleType proto) {
        switch (proto) {
            case REQUEST_NUMBER: {
                return ThrottleType.REQUEST_NUMBER;
            }
            case REQUEST_SIZE: {
                return ThrottleType.REQUEST_SIZE;
            }
            case WRITE_NUMBER: {
                return ThrottleType.WRITE_NUMBER;
            }
            case WRITE_SIZE: {
                return ThrottleType.WRITE_SIZE;
            }
            case READ_NUMBER: {
                return ThrottleType.READ_NUMBER;
            }
            case READ_SIZE: {
                return ThrottleType.READ_SIZE;
            }
        }
        throw new RuntimeException("Invalid ThrottleType " + proto);
    }

    public static QuotaProtos.ThrottleType toProtoThrottleType(ThrottleType type) {
        switch (type) {
            case REQUEST_NUMBER: {
                return QuotaProtos.ThrottleType.REQUEST_NUMBER;
            }
            case REQUEST_SIZE: {
                return QuotaProtos.ThrottleType.REQUEST_SIZE;
            }
            case WRITE_NUMBER: {
                return QuotaProtos.ThrottleType.WRITE_NUMBER;
            }
            case WRITE_SIZE: {
                return QuotaProtos.ThrottleType.WRITE_SIZE;
            }
            case READ_NUMBER: {
                return QuotaProtos.ThrottleType.READ_NUMBER;
            }
            case READ_SIZE: {
                return QuotaProtos.ThrottleType.READ_SIZE;
            }
        }
        throw new RuntimeException("Invalid ThrottleType " + (Object)((Object)type));
    }

    public static QuotaScope toQuotaScope(QuotaProtos.QuotaScope proto) {
        switch (proto) {
            case CLUSTER: {
                return QuotaScope.CLUSTER;
            }
            case MACHINE: {
                return QuotaScope.MACHINE;
            }
        }
        throw new RuntimeException("Invalid QuotaScope " + proto);
    }

    public static QuotaProtos.QuotaScope toProtoQuotaScope(QuotaScope scope) {
        switch (scope) {
            case CLUSTER: {
                return QuotaProtos.QuotaScope.CLUSTER;
            }
            case MACHINE: {
                return QuotaProtos.QuotaScope.MACHINE;
            }
        }
        throw new RuntimeException("Invalid QuotaScope " + (Object)((Object)scope));
    }

    public static QuotaType toQuotaScope(QuotaProtos.QuotaType proto) {
        switch (proto) {
            case THROTTLE: {
                return QuotaType.THROTTLE;
            }
            case SPACE: {
                return QuotaType.SPACE;
            }
        }
        throw new RuntimeException("Invalid QuotaType " + proto);
    }

    public static QuotaProtos.QuotaType toProtoQuotaScope(QuotaType type) {
        switch (type) {
            case THROTTLE: {
                return QuotaProtos.QuotaType.THROTTLE;
            }
            case SPACE: {
                return QuotaProtos.QuotaType.SPACE;
            }
        }
        throw new RuntimeException("Invalid QuotaType " + (Object)((Object)type));
    }

    public static SpaceViolationPolicy toViolationPolicy(QuotaProtos.SpaceViolationPolicy proto) {
        switch (proto) {
            case DISABLE: {
                return SpaceViolationPolicy.DISABLE;
            }
            case NO_WRITES_COMPACTIONS: {
                return SpaceViolationPolicy.NO_WRITES_COMPACTIONS;
            }
            case NO_WRITES: {
                return SpaceViolationPolicy.NO_WRITES;
            }
            case NO_INSERTS: {
                return SpaceViolationPolicy.NO_INSERTS;
            }
        }
        throw new RuntimeException("Invalid SpaceViolationPolicy " + proto);
    }

    public static QuotaProtos.SpaceViolationPolicy toProtoViolationPolicy(SpaceViolationPolicy policy) {
        switch (policy) {
            case DISABLE: {
                return QuotaProtos.SpaceViolationPolicy.DISABLE;
            }
            case NO_WRITES_COMPACTIONS: {
                return QuotaProtos.SpaceViolationPolicy.NO_WRITES_COMPACTIONS;
            }
            case NO_WRITES: {
                return QuotaProtos.SpaceViolationPolicy.NO_WRITES;
            }
            case NO_INSERTS: {
                return QuotaProtos.SpaceViolationPolicy.NO_INSERTS;
            }
        }
        throw new RuntimeException("Invalid SpaceViolationPolicy " + (Object)((Object)policy));
    }

    public static QuotaProtos.TimedQuota toTimedQuota(long limit, TimeUnit timeUnit, QuotaScope scope) {
        return QuotaProtos.TimedQuota.newBuilder().setSoftLimit(limit).setTimeUnit(ProtobufUtil.toProtoTimeUnit(timeUnit)).setScope(ProtobufUtil.toProtoQuotaScope(scope)).build();
    }

    public static QuotaProtos.SpaceQuota toProtoSpaceQuota(long limit, SpaceViolationPolicy violationPolicy) {
        return QuotaProtos.SpaceQuota.newBuilder().setSoftLimit(limit).setViolationPolicy(ProtobufUtil.toProtoViolationPolicy(violationPolicy)).build();
    }

    public static WALProtos.BulkLoadDescriptor toBulkLoadDescriptor(TableName tableName, ByteString encodedRegionName, Map<byte[], List<Path>> storeFiles, Map<String, Long> storeFilesSize, long bulkloadSeqId) {
        WALProtos.BulkLoadDescriptor.Builder desc = WALProtos.BulkLoadDescriptor.newBuilder().setTableName(ProtobufUtil.toProtoTableName(tableName)).setEncodedRegionName(encodedRegionName).setBulkloadSeqNum(bulkloadSeqId);
        for (Map.Entry<byte[], List<Path>> entry : storeFiles.entrySet()) {
            WALProtos.StoreDescriptor.Builder builder = WALProtos.StoreDescriptor.newBuilder().setFamilyName(UnsafeByteOperations.unsafeWrap((byte[])entry.getKey())).setStoreHomeDir(Bytes.toString((byte[])entry.getKey()));
            for (Path path : entry.getValue()) {
                String name = path.getName();
                builder.addStoreFile(name);
                Long size = storeFilesSize.get(name) == null ? Long.valueOf(0L) : storeFilesSize.get(name);
                builder.setStoreFileSizeBytes(size.longValue());
            }
            desc.addStores(builder);
        }
        return desc.build();
    }

    public static void mergeDelimitedFrom(Message.Builder builder, InputStream in) throws IOException {
        int firstByte = in.read();
        if (firstByte != -1) {
            int size = CodedInputStream.readRawVarint32((int)firstByte, (InputStream)in);
            LimitInputStream limitedInput = new LimitInputStream(in, (long)size);
            CodedInputStream codedInput = CodedInputStream.newInstance((InputStream)limitedInput);
            codedInput.setSizeLimit(size);
            builder.mergeFrom(codedInput);
            codedInput.checkLastTagWas(0);
        }
    }

    public static void mergeFrom(Message.Builder builder, InputStream in, int size) throws IOException {
        CodedInputStream codedInput = CodedInputStream.newInstance((InputStream)in);
        codedInput.setSizeLimit(size);
        builder.mergeFrom(codedInput);
        codedInput.checkLastTagWas(0);
    }

    public static void mergeFrom(Message.Builder builder, InputStream in) throws IOException {
        CodedInputStream codedInput = CodedInputStream.newInstance((InputStream)in);
        codedInput.setSizeLimit(Integer.MAX_VALUE);
        builder.mergeFrom(codedInput);
        codedInput.checkLastTagWas(0);
    }

    public static void mergeFrom(Message.Builder builder, ByteString bs) throws IOException {
        CodedInputStream codedInput = bs.newCodedInput();
        codedInput.setSizeLimit(bs.size());
        builder.mergeFrom(codedInput);
        codedInput.checkLastTagWas(0);
    }

    public static void mergeFrom(Message.Builder builder, byte[] b) throws IOException {
        CodedInputStream codedInput = CodedInputStream.newInstance((byte[])b);
        codedInput.setSizeLimit(b.length);
        builder.mergeFrom(codedInput);
        codedInput.checkLastTagWas(0);
    }

    public static void mergeFrom(Message.Builder builder, byte[] b, int offset, int length) throws IOException {
        CodedInputStream codedInput = CodedInputStream.newInstance((byte[])b, (int)offset, (int)length);
        codedInput.setSizeLimit(length);
        builder.mergeFrom(codedInput);
        codedInput.checkLastTagWas(0);
    }

    public static void mergeFrom(Message.Builder builder, CodedInputStream codedInput, int length) throws IOException {
        codedInput.resetSizeCounter();
        int prevLimit = codedInput.setSizeLimit(length);
        int limit = codedInput.pushLimit(length);
        builder.mergeFrom(codedInput);
        codedInput.popLimit(limit);
        codedInput.checkLastTagWas(0);
        codedInput.setSizeLimit(prevLimit);
    }

    public static ReplicationLoadSink toReplicationLoadSink(ClusterStatusProtos.ReplicationLoadSink cls) {
        return new ReplicationLoadSink(cls.getAgeOfLastAppliedOp(), cls.getTimeStampsOfLastAppliedOp());
    }

    public static ReplicationLoadSource toReplicationLoadSource(ClusterStatusProtos.ReplicationLoadSource cls) {
        return new ReplicationLoadSource(cls.getPeerID(), cls.getAgeOfLastShippedOp(), cls.getSizeOfLogQueue(), cls.getTimeStampOfLastShippedOp(), cls.getReplicationLag());
    }

    public static List<ReplicationLoadSource> toReplicationLoadSourceList(List<ClusterStatusProtos.ReplicationLoadSource> clsList) {
        ArrayList<ReplicationLoadSource> rlsList = new ArrayList<ReplicationLoadSource>(clsList.size());
        for (ClusterStatusProtos.ReplicationLoadSource cls : clsList) {
            rlsList.add(ProtobufUtil.toReplicationLoadSource(cls));
        }
        return rlsList;
    }

    public static HBaseProtos.VersionInfo getVersionInfo() {
        HBaseProtos.VersionInfo.Builder builder = HBaseProtos.VersionInfo.newBuilder();
        String version = VersionInfo.getVersion();
        builder.setVersion(version);
        String[] components = version.split("\\.");
        if (components != null && components.length > 2) {
            builder.setVersionMajor(Integer.parseInt(components[0]));
            builder.setVersionMinor(Integer.parseInt(components[1]));
        }
        builder.setUrl(VersionInfo.getUrl());
        builder.setRevision(VersionInfo.getRevision());
        builder.setUser(VersionInfo.getUser());
        builder.setDate(VersionInfo.getDate());
        builder.setSrcChecksum(VersionInfo.getSrcChecksum());
        return builder.build();
    }

    public static List<SecurityCapability> toSecurityCapabilityList(List<MasterProtos.SecurityCapabilitiesResponse.Capability> capabilities) {
        ArrayList<SecurityCapability> scList = new ArrayList<SecurityCapability>(capabilities.size());
        for (MasterProtos.SecurityCapabilitiesResponse.Capability c : capabilities) {
            try {
                scList.add(SecurityCapability.valueOf(c.getNumber()));
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        return scList;
    }

    private static HBaseProtos.TimeRange.Builder timeRangeToProto(TimeRange timeRange) {
        HBaseProtos.TimeRange.Builder timeRangeBuilder = HBaseProtos.TimeRange.newBuilder();
        timeRangeBuilder.setFrom(timeRange.getMin());
        timeRangeBuilder.setTo(timeRange.getMax());
        return timeRangeBuilder;
    }

    private static TimeRange protoToTimeRange(HBaseProtos.TimeRange timeRange) throws IOException {
        long minStamp = 0L;
        long maxStamp = Long.MAX_VALUE;
        if (timeRange.hasFrom()) {
            minStamp = timeRange.getFrom();
        }
        if (timeRange.hasTo()) {
            maxStamp = timeRange.getTo();
        }
        return new TimeRange(minStamp, maxStamp);
    }

    public static HBaseProtos.ColumnFamilySchema convertToColumnFamilySchema(HColumnDescriptor hcd) {
        HBaseProtos.BytesBytesPair.Builder aBuilder;
        HBaseProtos.ColumnFamilySchema.Builder builder = HBaseProtos.ColumnFamilySchema.newBuilder();
        builder.setName(UnsafeByteOperations.unsafeWrap((byte[])hcd.getName()));
        for (Map.Entry<Bytes, Bytes> entry : hcd.getValues().entrySet()) {
            aBuilder = HBaseProtos.BytesBytesPair.newBuilder();
            aBuilder.setFirst(UnsafeByteOperations.unsafeWrap((byte[])entry.getKey().get()));
            aBuilder.setSecond(UnsafeByteOperations.unsafeWrap((byte[])entry.getValue().get()));
            builder.addAttributes(aBuilder.build());
        }
        for (Map.Entry<Object, Object> entry : hcd.getConfiguration().entrySet()) {
            aBuilder = HBaseProtos.NameStringPair.newBuilder();
            aBuilder.setName((String)entry.getKey());
            aBuilder.setValue((String)entry.getValue());
            builder.addConfiguration(aBuilder.build());
        }
        return builder.build();
    }

    public static HColumnDescriptor convertToHColumnDesc(HBaseProtos.ColumnFamilySchema cfs) {
        HColumnDescriptor hcd = new HColumnDescriptor(cfs.getName().toByteArray());
        for (HBaseProtos.BytesBytesPair a : cfs.getAttributesList()) {
            hcd.setValue(a.getFirst().toByteArray(), a.getSecond().toByteArray());
        }
        for (HBaseProtos.BytesBytesPair a : cfs.getConfigurationList()) {
            hcd.setConfiguration(a.getName(), a.getValue());
        }
        return hcd;
    }

    public static HBaseProtos.TableSchema convertToTableSchema(TableDescriptor htd) {
        HBaseProtos.TableSchema.Builder builder = HBaseProtos.TableSchema.newBuilder();
        builder.setTableName(ProtobufUtil.toProtoTableName(htd.getTableName()));
        for (Map.Entry<Bytes, Bytes> entry : htd.getValues().entrySet()) {
            HBaseProtos.BytesBytesPair.Builder aBuilder = HBaseProtos.BytesBytesPair.newBuilder();
            aBuilder.setFirst(UnsafeByteOperations.unsafeWrap((byte[])entry.getKey().get()));
            aBuilder.setSecond(UnsafeByteOperations.unsafeWrap((byte[])entry.getValue().get()));
            builder.addAttributes(aBuilder.build());
        }
        for (HColumnDescriptor hcd : htd.getColumnFamilies()) {
            builder.addColumnFamilies(ProtobufUtil.convertToColumnFamilySchema(hcd));
        }
        for (Map.Entry entry : htd.getConfiguration().entrySet()) {
            HBaseProtos.NameStringPair.Builder aBuilder = HBaseProtos.NameStringPair.newBuilder();
            aBuilder.setName((String)entry.getKey());
            aBuilder.setValue((String)entry.getValue());
            builder.addConfiguration(aBuilder.build());
        }
        return builder.build();
    }

    @Deprecated
    public static HTableDescriptor convertToHTableDesc(HBaseProtos.TableSchema ts) {
        List list = ts.getColumnFamiliesList();
        HColumnDescriptor[] hcds = new HColumnDescriptor[list.size()];
        int index = 0;
        for (HBaseProtos.ColumnFamilySchema cfs : list) {
            hcds[index++] = ProtobufUtil.convertToHColumnDesc(cfs);
        }
        HTableDescriptor htd = new HTableDescriptor(ProtobufUtil.toTableName(ts.getTableName()));
        for (HColumnDescriptor hcd : hcds) {
            htd.addFamily(hcd);
        }
        for (HBaseProtos.BytesBytesPair a : ts.getAttributesList()) {
            htd.setValue(a.getFirst().toByteArray(), a.getSecond().toByteArray());
        }
        for (HBaseProtos.NameStringPair a : ts.getConfigurationList()) {
            htd.setConfiguration(a.getName(), a.getValue());
        }
        return htd;
    }

    public static TableDescriptor convertToTableDesc(HBaseProtos.TableSchema ts) {
        TableDescriptorBuilder builder = TableDescriptorBuilder.newBuilder(ProtobufUtil.toTableName(ts.getTableName()));
        ts.getColumnFamiliesList().stream().map(ProtobufUtil::convertToHColumnDesc).forEach(builder::addFamily);
        ts.getAttributesList().forEach(a -> builder.setValue(a.getFirst().toByteArray(), a.getSecond().toByteArray()));
        ts.getConfigurationList().forEach(a -> builder.setConfiguration(a.getName(), a.getValue()));
        return builder.build();
    }

    public static CompactionState createCompactionState(AdminProtos.GetRegionInfoResponse.CompactionState state) {
        return CompactionState.valueOf(state.toString());
    }

    public static SnapshotProtos.SnapshotDescription.Type createProtosSnapShotDescType(SnapshotType type) {
        return SnapshotProtos.SnapshotDescription.Type.valueOf((String)type.name());
    }

    public static SnapshotProtos.SnapshotDescription.Type createProtosSnapShotDescType(String snapshotDesc) {
        return SnapshotProtos.SnapshotDescription.Type.valueOf((String)snapshotDesc.toUpperCase(Locale.ROOT));
    }

    public static SnapshotType createSnapshotType(SnapshotProtos.SnapshotDescription.Type type) {
        return SnapshotType.valueOf(type.toString());
    }

    public static SnapshotProtos.SnapshotDescription createHBaseProtosSnapshotDesc(SnapshotDescription snapshotDesc) {
        SnapshotProtos.SnapshotDescription.Builder builder = SnapshotProtos.SnapshotDescription.newBuilder();
        if (snapshotDesc.getTableName() != null) {
            builder.setTable(snapshotDesc.getTableNameAsString());
        }
        if (snapshotDesc.getName() != null) {
            builder.setName(snapshotDesc.getName());
        }
        if (snapshotDesc.getOwner() != null) {
            builder.setOwner(snapshotDesc.getOwner());
        }
        if (snapshotDesc.getCreationTime() != -1L) {
            builder.setCreationTime(snapshotDesc.getCreationTime());
        }
        if (snapshotDesc.getVersion() != -1) {
            builder.setVersion(snapshotDesc.getVersion());
        }
        builder.setType(ProtobufUtil.createProtosSnapShotDescType(snapshotDesc.getType()));
        SnapshotProtos.SnapshotDescription snapshot = builder.build();
        return snapshot;
    }

    public static SnapshotDescription createSnapshotDesc(SnapshotProtos.SnapshotDescription snapshotDesc) {
        return new SnapshotDescription(snapshotDesc.getName(), snapshotDesc.hasTable() ? TableName.valueOf((String)snapshotDesc.getTable()) : null, ProtobufUtil.createSnapshotType(snapshotDesc.getType()), snapshotDesc.getOwner(), snapshotDesc.getCreationTime(), snapshotDesc.getVersion());
    }

    public static ClusterStatus convert(ClusterStatusProtos.ClusterStatus proto) {
        HashMap<ServerName, ServerLoad> servers = null;
        servers = new HashMap<ServerName, ServerLoad>(proto.getLiveServersList().size());
        for (Object lsi : proto.getLiveServersList()) {
            servers.put(ProtobufUtil.toServerName(lsi.getServer()), new ServerLoad(lsi.getServerLoad()));
        }
        ArrayList<ServerName> deadServers = null;
        deadServers = new ArrayList<ServerName>(proto.getDeadServersList().size());
        for (Object sn : proto.getDeadServersList()) {
            deadServers.add(ProtobufUtil.toServerName((HBaseProtos.ServerName)sn));
        }
        ArrayList<ServerName> backupMasters = null;
        backupMasters = new ArrayList<ServerName>(proto.getBackupMastersList().size());
        for (Object sn : proto.getBackupMastersList()) {
            backupMasters.add(ProtobufUtil.toServerName((HBaseProtos.ServerName)sn));
        }
        ArrayList<RegionState> rit = new ArrayList<RegionState>(proto.getRegionsInTransitionList().size());
        for (ClusterStatusProtos.RegionInTransition region : proto.getRegionsInTransitionList()) {
            RegionState value = RegionState.convert(region.getRegionState());
            rit.add(value);
        }
        String[] masterCoprocessors = null;
        int numMasterCoprocessors = proto.getMasterCoprocessorsCount();
        masterCoprocessors = new String[numMasterCoprocessors];
        for (int i = 0; i < numMasterCoprocessors; ++i) {
            masterCoprocessors[i] = proto.getMasterCoprocessors(i).getName();
        }
        return new ClusterStatus(proto.getHbaseVersion().getVersion(), ClusterId.convert(proto.getClusterId()).toString(), servers, deadServers, ProtobufUtil.toServerName(proto.getMaster()), backupMasters, rit, masterCoprocessors, proto.getBalancerOn());
    }

    public static ClusterStatusProtos.ClusterStatus convert(ClusterStatus status) {
        ClusterStatusProtos.ClusterStatus.Builder builder = ClusterStatusProtos.ClusterStatus.newBuilder();
        builder.setHbaseVersion(FSProtos.HBaseVersionFileContent.newBuilder().setVersion(status.getHBaseVersion()));
        if (status.getServers() != null) {
            for (ServerName serverName : status.getServers()) {
                ClusterStatusProtos.LiveServerInfo.Builder lsi = ClusterStatusProtos.LiveServerInfo.newBuilder().setServer(ProtobufUtil.toServerName(serverName));
                status.getLoad(serverName);
                lsi.setServerLoad(status.getLoad(serverName).obtainServerLoadPB());
                builder.addLiveServers(lsi.build());
            }
        }
        if (status.getDeadServerNames() != null) {
            for (ServerName deadServer : status.getDeadServerNames()) {
                builder.addDeadServers(ProtobufUtil.toServerName(deadServer));
            }
        }
        if (status.getRegionsInTransition() != null) {
            for (RegionState rit : status.getRegionsInTransition()) {
                ClusterStatusProtos.RegionState rs = rit.convert();
                HBaseProtos.RegionSpecifier.Builder builder2 = HBaseProtos.RegionSpecifier.newBuilder().setType(HBaseProtos.RegionSpecifier.RegionSpecifierType.REGION_NAME);
                builder2.setValue(UnsafeByteOperations.unsafeWrap((byte[])rit.getRegion().getRegionName()));
                ClusterStatusProtos.RegionInTransition pbRIT = ClusterStatusProtos.RegionInTransition.newBuilder().setSpec(builder2.build()).setRegionState(rs).build();
                builder.addRegionsInTransition(pbRIT);
            }
        }
        if (status.getClusterId() != null) {
            builder.setClusterId(new ClusterId(status.getClusterId()).convert());
        }
        if (status.getMasterCoprocessors() != null) {
            for (Iterator<Object> iterator : status.getMasterCoprocessors()) {
                builder.addMasterCoprocessors(HBaseProtos.Coprocessor.newBuilder().setName(iterator));
            }
        }
        if (status.getMaster() != null) {
            builder.setMaster(ProtobufUtil.toServerName(status.getMaster()));
        }
        if (status.getBackupMasters() != null) {
            for (ServerName backup : status.getBackupMasters()) {
                builder.addBackupMasters(ProtobufUtil.toServerName(backup));
            }
        }
        if (status.getBalancerOn() != null) {
            builder.setBalancerOn(status.getBalancerOn().booleanValue());
        }
        return builder.build();
    }

    public static RegionLoadStats createRegionLoadStats(ClientProtos.RegionLoadStats stats) {
        return new RegionLoadStats(stats.getMemstoreLoad(), stats.getHeapOccupancy(), stats.getCompactionPressure());
    }

    public static String toText(Message msg) {
        return TextFormat.shortDebugString((MessageOrBuilder)msg);
    }

    public static byte[] toBytes(ByteString bs) {
        return bs.toByteArray();
    }

    public static <T> T call(Callable<T> callable) throws IOException {
        try {
            return callable.call();
        }
        catch (Exception e) {
            throw ProtobufUtil.handleRemoteException(e);
        }
    }

    public static AdminProtos.GetStoreFileRequest buildGetStoreFileRequest(byte[] regionName, byte[] family) {
        AdminProtos.GetStoreFileRequest.Builder builder = AdminProtos.GetStoreFileRequest.newBuilder();
        HBaseProtos.RegionSpecifier region = RequestConverter.buildRegionSpecifier(HBaseProtos.RegionSpecifier.RegionSpecifierType.REGION_NAME, regionName);
        builder.setRegion(region);
        builder.addFamily(UnsafeByteOperations.unsafeWrap((byte[])family));
        return builder.build();
    }

    public static AdminProtos.CloseRegionRequest buildCloseRegionRequest(ServerName server, byte[] regionName) {
        return ProtobufUtil.buildCloseRegionRequest(server, regionName, null);
    }

    public static AdminProtos.CloseRegionRequest buildCloseRegionRequest(ServerName server, byte[] regionName, ServerName destinationServer) {
        AdminProtos.CloseRegionRequest.Builder builder = AdminProtos.CloseRegionRequest.newBuilder();
        HBaseProtos.RegionSpecifier region = RequestConverter.buildRegionSpecifier(HBaseProtos.RegionSpecifier.RegionSpecifierType.REGION_NAME, regionName);
        builder.setRegion(region);
        if (destinationServer != null) {
            builder.setDestinationServer(ProtobufUtil.toServerName(destinationServer));
        }
        if (server != null) {
            builder.setServerStartCode(server.getStartcode());
        }
        return builder.build();
    }

    public static AdminProtos.CloseRegionRequest buildCloseRegionRequest(ServerName server, String encodedRegionName) {
        AdminProtos.CloseRegionRequest.Builder builder = AdminProtos.CloseRegionRequest.newBuilder();
        HBaseProtos.RegionSpecifier region = RequestConverter.buildRegionSpecifier(HBaseProtos.RegionSpecifier.RegionSpecifierType.ENCODED_REGION_NAME, Bytes.toBytes((String)encodedRegionName));
        builder.setRegion(region);
        if (server != null) {
            builder.setServerStartCode(server.getStartcode());
        }
        return builder.build();
    }

    public static AdminProtos.SplitRegionRequest buildSplitRegionRequest(byte[] regionName, byte[] splitPoint) {
        AdminProtos.SplitRegionRequest.Builder builder = AdminProtos.SplitRegionRequest.newBuilder();
        HBaseProtos.RegionSpecifier region = RequestConverter.buildRegionSpecifier(HBaseProtos.RegionSpecifier.RegionSpecifierType.REGION_NAME, regionName);
        builder.setRegion(region);
        if (splitPoint != null) {
            builder.setSplitPoint(UnsafeByteOperations.unsafeWrap((byte[])splitPoint));
        }
        return builder.build();
    }

    public static HBaseProtos.ProcedureDescription buildProcedureDescription(String signature, String instance, Map<String, String> props) {
        HBaseProtos.ProcedureDescription.Builder builder = HBaseProtos.ProcedureDescription.newBuilder().setSignature(signature).setInstance(instance);
        if (props != null && !props.isEmpty()) {
            props.entrySet().forEach(entry -> builder.addConfiguration(HBaseProtos.NameStringPair.newBuilder().setName((String)entry.getKey()).setValue((String)entry.getValue()).build()));
        }
        return builder.build();
    }

    public static AdminProtos.MergeRegionsRequest buildMergeRegionsRequest(byte[] regionA, byte[] regionB, boolean forcible) {
        AdminProtos.MergeRegionsRequest.Builder builder = AdminProtos.MergeRegionsRequest.newBuilder();
        HBaseProtos.RegionSpecifier regionASpecifier = RequestConverter.buildRegionSpecifier(HBaseProtos.RegionSpecifier.RegionSpecifierType.REGION_NAME, regionA);
        HBaseProtos.RegionSpecifier regionBSpecifier = RequestConverter.buildRegionSpecifier(HBaseProtos.RegionSpecifier.RegionSpecifierType.REGION_NAME, regionB);
        builder.setRegionA(regionASpecifier);
        builder.setRegionB(regionBSpecifier);
        builder.setForcible(forcible);
        builder.setMasterSystemTime(EnvironmentEdgeManager.currentTime());
        return builder.build();
    }

    public static ServerName parseServerNameFrom(byte[] data) throws DeserializationException {
        if (data == null || data.length <= 0) {
            return null;
        }
        if (ProtobufMagic.isPBMagicPrefix(data)) {
            int prefixLen = ProtobufMagic.lengthOfPBMagic();
            try {
                ZooKeeperProtos.Master rss = (ZooKeeperProtos.Master)ZooKeeperProtos.Master.PARSER.parseFrom(data, prefixLen, data.length - prefixLen);
                HBaseProtos.ServerName sn = rss.getMaster();
                return ServerName.valueOf((String)sn.getHostName(), (int)sn.getPort(), (long)sn.getStartCode());
            }
            catch (IOException e) {
                throw new DeserializationException((Throwable)e);
            }
        }
        String str = Bytes.toString((byte[])data);
        int index = str.indexOf(",");
        if (index != -1) {
            return ServerName.parseVersionedServerName((byte[])data);
        }
        String hostname = Addressing.parseHostname((String)str);
        int port = Addressing.parsePort((String)str);
        return ServerName.valueOf((String)hostname, (int)port, (long)-1L);
    }

    public static ProcedureProtos.Procedure toProtoProcedure(ProcedureInfo procedure) {
        ProcedureProtos.Procedure.Builder builder = ProcedureProtos.Procedure.newBuilder();
        builder.setClassName(procedure.getProcName());
        builder.setProcId(procedure.getProcId());
        builder.setSubmittedTime(procedure.getSubmittedTime());
        builder.setState(ProcedureProtos.ProcedureState.valueOf((String)procedure.getProcState().name()));
        builder.setLastUpdate(procedure.getLastUpdate());
        if (procedure.hasParentId()) {
            builder.setParentId(procedure.getParentId());
        }
        if (procedure.hasOwner()) {
            builder.setOwner(procedure.getProcOwner());
        }
        if (procedure.isFailed()) {
            builder.setException(ForeignExceptionUtil.toProtoForeignException((Throwable)procedure.getException()));
        }
        if (procedure.hasResultData()) {
            builder.setResult(UnsafeByteOperations.unsafeWrap((byte[])procedure.getResult()));
        }
        return builder.build();
    }

    public static ProcedureInfo toProcedureInfo(ProcedureProtos.Procedure procedureProto) {
        NonceKey nonceKey = null;
        if (procedureProto.getNonce() != 0L) {
            nonceKey = new NonceKey(procedureProto.getNonceGroup(), procedureProto.getNonce());
        }
        return new ProcedureInfo(procedureProto.getProcId(), procedureProto.getClassName(), procedureProto.hasOwner() ? procedureProto.getOwner() : null, ProcedureState.valueOf((String)procedureProto.getState().name()), procedureProto.hasParentId() ? procedureProto.getParentId() : -1L, nonceKey, procedureProto.hasException() ? ForeignExceptionUtil.toIOException((ErrorHandlingProtos.ForeignExceptionMessage)procedureProto.getException()) : null, procedureProto.getLastUpdate(), procedureProto.getSubmittedTime(), procedureProto.hasResult() ? procedureProto.getResult().toByteArray() : null);
    }

    public static LockServiceProtos.ResourceType toProtoResourceType(LockInfo.ResourceType resourceType) {
        switch (resourceType) {
            case SERVER: {
                return LockServiceProtos.ResourceType.RESOURCE_TYPE_SERVER;
            }
            case NAMESPACE: {
                return LockServiceProtos.ResourceType.RESOURCE_TYPE_NAMESPACE;
            }
            case TABLE: {
                return LockServiceProtos.ResourceType.RESOURCE_TYPE_TABLE;
            }
            case REGION: {
                return LockServiceProtos.ResourceType.RESOURCE_TYPE_REGION;
            }
        }
        throw new IllegalArgumentException("Unknown resource type: " + resourceType);
    }

    public static LockInfo.ResourceType toResourceType(LockServiceProtos.ResourceType resourceTypeProto) {
        switch (resourceTypeProto) {
            case RESOURCE_TYPE_SERVER: {
                return LockInfo.ResourceType.SERVER;
            }
            case RESOURCE_TYPE_NAMESPACE: {
                return LockInfo.ResourceType.NAMESPACE;
            }
            case RESOURCE_TYPE_TABLE: {
                return LockInfo.ResourceType.TABLE;
            }
            case RESOURCE_TYPE_REGION: {
                return LockInfo.ResourceType.REGION;
            }
        }
        throw new IllegalArgumentException("Unknown resource type: " + resourceTypeProto);
    }

    public static LockServiceProtos.LockType toProtoLockType(LockInfo.LockType lockType) {
        return LockServiceProtos.LockType.valueOf((String)lockType.name());
    }

    public static LockInfo.LockType toLockType(LockServiceProtos.LockType lockTypeProto) {
        return LockInfo.LockType.valueOf((String)lockTypeProto.name());
    }

    public static LockServiceProtos.WaitingProcedure toProtoWaitingProcedure(LockInfo.WaitingProcedure waitingProcedure) {
        LockServiceProtos.WaitingProcedure.Builder builder = LockServiceProtos.WaitingProcedure.newBuilder();
        ProcedureProtos.Procedure procedureProto = ProtobufUtil.toProtoProcedure(waitingProcedure.getProcedure());
        builder.setLockType(ProtobufUtil.toProtoLockType(waitingProcedure.getLockType())).setProcedure(procedureProto);
        return builder.build();
    }

    public static LockInfo.WaitingProcedure toWaitingProcedure(LockServiceProtos.WaitingProcedure waitingProcedureProto) {
        LockInfo.WaitingProcedure waiting = new LockInfo.WaitingProcedure();
        waiting.setLockType(ProtobufUtil.toLockType(waitingProcedureProto.getLockType()));
        ProcedureInfo procedure = ProtobufUtil.toProcedureInfo(waitingProcedureProto.getProcedure());
        waiting.setProcedure(procedure);
        return waiting;
    }

    public static LockServiceProtos.LockInfo toProtoLockInfo(LockInfo lock) {
        LockServiceProtos.LockInfo.Builder builder = LockServiceProtos.LockInfo.newBuilder();
        builder.setResourceType(ProtobufUtil.toProtoResourceType(lock.getResourceType())).setResourceName(lock.getResourceName()).setLockType(ProtobufUtil.toProtoLockType(lock.getLockType()));
        ProcedureInfo exclusiveLockOwnerProcedure = lock.getExclusiveLockOwnerProcedure();
        if (exclusiveLockOwnerProcedure != null) {
            ProcedureProtos.Procedure exclusiveLockOwnerProcedureProto = ProtobufUtil.toProtoProcedure(lock.getExclusiveLockOwnerProcedure());
            builder.setExclusiveLockOwnerProcedure(exclusiveLockOwnerProcedureProto);
        }
        builder.setSharedLockCount(lock.getSharedLockCount());
        for (LockInfo.WaitingProcedure waitingProcedure : lock.getWaitingProcedures()) {
            builder.addWaitingProcedures(ProtobufUtil.toProtoWaitingProcedure(waitingProcedure));
        }
        return builder.build();
    }

    public static LockInfo toLockInfo(LockServiceProtos.LockInfo lockProto) {
        LockInfo lock = new LockInfo();
        lock.setResourceType(ProtobufUtil.toResourceType(lockProto.getResourceType()));
        lock.setResourceName(lockProto.getResourceName());
        lock.setLockType(ProtobufUtil.toLockType(lockProto.getLockType()));
        if (lockProto.hasExclusiveLockOwnerProcedure()) {
            ProcedureInfo exclusiveLockOwnerProcedureProto = ProtobufUtil.toProcedureInfo(lockProto.getExclusiveLockOwnerProcedure());
            lock.setExclusiveLockOwnerProcedure(exclusiveLockOwnerProcedureProto);
        }
        lock.setSharedLockCount(lockProto.getSharedLockCount());
        for (LockServiceProtos.WaitingProcedure waitingProcedureProto : lockProto.getWaitingProceduresList()) {
            lock.addWaitingProcedure(ProtobufUtil.toWaitingProcedure(waitingProcedureProto));
        }
        return lock;
    }

    static {
        ClientProtos.Result.Builder builder = ClientProtos.Result.newBuilder();
        builder.setExists(true);
        builder.setAssociatedCellCount(0);
        EMPTY_RESULT_PB_EXISTS_TRUE = builder.build();
        builder.setStale(true);
        EMPTY_RESULT_PB_EXISTS_TRUE_STALE = builder.build();
        builder.clear();
        builder.setExists(false);
        builder.setAssociatedCellCount(0);
        EMPTY_RESULT_PB_EXISTS_FALSE = builder.build();
        builder.setStale(true);
        EMPTY_RESULT_PB_EXISTS_FALSE_STALE = builder.build();
        builder.clear();
        builder.setAssociatedCellCount(0);
        EMPTY_RESULT_PB = builder.build();
        builder.setStale(true);
        EMPTY_RESULT_PB_STALE = builder.build();
        ClassLoader parent = ProtobufUtil.class.getClassLoader();
        Configuration conf = HBaseConfiguration.create();
        CLASS_LOADER = new DynamicClassLoader(conf, parent);
        PRIMITIVES.put(Boolean.TYPE.getName(), Boolean.TYPE);
        PRIMITIVES.put(Byte.TYPE.getName(), Byte.TYPE);
        PRIMITIVES.put(Character.TYPE.getName(), Character.TYPE);
        PRIMITIVES.put(Short.TYPE.getName(), Short.TYPE);
        PRIMITIVES.put(Integer.TYPE.getName(), Integer.TYPE);
        PRIMITIVES.put(Long.TYPE.getName(), Long.TYPE);
        PRIMITIVES.put(Float.TYPE.getName(), Float.TYPE);
        PRIMITIVES.put(Double.TYPE.getName(), Double.TYPE);
        PRIMITIVES.put(Void.TYPE.getName(), Void.TYPE);
    }
}

