/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.filter;

import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FirstKeyOnlyFilter;
import org.apache.hadoop.hbase.shaded.protobuf.generated.FilterProtos;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hbase.thirdparty.com.google.protobuf.ByteString;
import org.apache.hbase.thirdparty.com.google.protobuf.InvalidProtocolBufferException;
import org.apache.hbase.thirdparty.com.google.protobuf.UnsafeByteOperations;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Public
@Deprecated
public class FirstKeyValueMatchingQualifiersFilter
extends FirstKeyOnlyFilter {
    private Set<byte[]> qualifiers;

    public FirstKeyValueMatchingQualifiersFilter(Set<byte[]> qualifiers) {
        this.qualifiers = qualifiers;
    }

    @Override
    @Deprecated
    public Filter.ReturnCode filterKeyValue(Cell c) {
        return this.filterCell(c);
    }

    @Override
    public Filter.ReturnCode filterCell(Cell c) {
        if (this.hasFoundKV()) {
            return Filter.ReturnCode.NEXT_ROW;
        }
        if (this.hasOneMatchingQualifier(c)) {
            this.setFoundKV(true);
        }
        return Filter.ReturnCode.INCLUDE;
    }

    private boolean hasOneMatchingQualifier(Cell c) {
        for (byte[] q : this.qualifiers) {
            if (!CellUtil.matchingQualifier((Cell)c, (byte[])q)) continue;
            return true;
        }
        return false;
    }

    @Override
    public byte[] toByteArray() {
        FilterProtos.FirstKeyValueMatchingQualifiersFilter.Builder builder = FilterProtos.FirstKeyValueMatchingQualifiersFilter.newBuilder();
        for (byte[] qualifier : this.qualifiers) {
            if (qualifier == null) continue;
            builder.addQualifiers(UnsafeByteOperations.unsafeWrap((byte[])qualifier));
        }
        return builder.build().toByteArray();
    }

    public static FirstKeyValueMatchingQualifiersFilter parseFrom(byte[] pbBytes) throws DeserializationException {
        FilterProtos.FirstKeyValueMatchingQualifiersFilter proto;
        try {
            proto = FilterProtos.FirstKeyValueMatchingQualifiersFilter.parseFrom((byte[])pbBytes);
        }
        catch (InvalidProtocolBufferException e) {
            throw new DeserializationException((Throwable)e);
        }
        TreeSet<byte[]> qualifiers = new TreeSet<byte[]>(Bytes.BYTES_COMPARATOR);
        for (ByteString qualifier : proto.getQualifiersList()) {
            qualifiers.add(qualifier.toByteArray());
        }
        return new FirstKeyValueMatchingQualifiersFilter(qualifiers);
    }

    @Override
    boolean areSerializedFieldsEqual(Filter o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FirstKeyValueMatchingQualifiersFilter)) {
            return false;
        }
        FirstKeyValueMatchingQualifiersFilter other = (FirstKeyValueMatchingQualifiersFilter)o;
        return this.qualifiers.equals(other.qualifiers);
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof Filter && this.areSerializedFieldsEqual((Filter)obj);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.qualifiers);
    }
}

