/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.RegionLocations;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.ClusterConnection;
import org.apache.hadoop.hbase.client.ConnectionUtils;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.ScannerCallable;
import org.apache.hadoop.hbase.client.metrics.ScanMetrics;
import org.apache.hadoop.hbase.ipc.RpcControllerFactory;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class ReversedScannerCallable
extends ScannerCallable {
    public ReversedScannerCallable(ClusterConnection connection, TableName tableName, Scan scan, ScanMetrics scanMetrics, RpcControllerFactory rpcFactory, int replicaId) {
        super(connection, tableName, scan, scanMetrics, rpcFactory, replicaId);
    }

    @Override
    public void prepare(boolean reload) throws IOException {
        if (Thread.interrupted()) {
            throw new InterruptedIOException();
        }
        if (!this.instantiated || reload) {
            if (this.scan.includeStartRow() && !ConnectionUtils.isEmptyStartRow(this.getRow())) {
                RegionLocations rl = this.getRegionLocations(reload, this.getRow());
                this.location = this.getLocationForReplica(rl);
                if (this.location == null || this.location.getServerName() == null) {
                    throw new IOException("Failed to find location, tableName=" + this.getTableName() + ", row=" + Bytes.toStringBinary((byte[])this.getRow()) + ", reload=" + reload);
                }
            } else {
                byte[] locateStartRow = ConnectionUtils.createCloseRowBefore(this.getRow());
                List<HRegionLocation> locatedRegions = this.locateRegionsInRange(locateStartRow, this.getRow(), reload);
                if (locatedRegions.isEmpty()) {
                    throw new DoNotRetryIOException("Does hbase:meta exist hole? Couldn't get regions for the range from " + Bytes.toStringBinary((byte[])locateStartRow) + " to " + Bytes.toStringBinary((byte[])this.getRow()));
                }
                this.location = locatedRegions.get(locatedRegions.size() - 1);
            }
            this.setStub(this.getConnection().getClient(this.getLocation().getServerName()));
            this.checkIfRegionServerIsRemote();
            this.instantiated = true;
        }
        if (reload) {
            ConnectionUtils.incRPCRetriesMetrics(this.scanMetrics, this.isRegionServerRemote);
        }
    }

    private List<HRegionLocation> locateRegionsInRange(byte[] startKey, byte[] endKey, boolean reload) throws IOException {
        HRegionLocation regionLocation;
        boolean endKeyIsEndOfTable = Bytes.equals((byte[])endKey, (byte[])HConstants.EMPTY_END_ROW);
        if (Bytes.compareTo((byte[])startKey, (byte[])endKey) > 0 && !endKeyIsEndOfTable) {
            throw new IllegalArgumentException("Invalid range: " + Bytes.toStringBinary((byte[])startKey) + " > " + Bytes.toStringBinary((byte[])endKey));
        }
        ArrayList<HRegionLocation> regionList = new ArrayList<HRegionLocation>();
        byte[] currentKey = startKey;
        do {
            RegionLocations rl;
            if (!(regionLocation = this.getLocationForReplica(rl = this.getRegionLocations(reload, currentKey))).getRegionInfo().containsRow(currentKey)) {
                throw new DoNotRetryIOException("Does hbase:meta exist hole? Locating row " + Bytes.toStringBinary((byte[])currentKey) + " returns incorrect region " + regionLocation.getRegionInfo());
            }
            regionList.add(regionLocation);
        } while (!Bytes.equals((byte[])(currentKey = regionLocation.getRegionInfo().getEndKey()), (byte[])HConstants.EMPTY_END_ROW) && (endKeyIsEndOfTable || Bytes.compareTo((byte[])currentKey, (byte[])endKey) < 0));
        return regionList;
    }

    @Override
    public ScannerCallable getScannerCallableForReplica(int id) {
        ReversedScannerCallable r = new ReversedScannerCallable(this.getConnection(), this.getTableName(), this.getScan(), this.scanMetrics, this.rpcControllerFactory, id);
        r.setCaching(this.getCaching());
        return r;
    }
}

