/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hbase.thirdparty.com.google.common.base.Preconditions;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
final class RegistryEndpointsRefresher {
    private static final Logger LOG = LoggerFactory.getLogger(RegistryEndpointsRefresher.class);
    private static final int PERIODIC_REFRESH_INTERVAL_SECS_DEFAULT = 300;
    private static final int MIN_SECS_BETWEEN_REFRESHES_DEFAULT = 60;
    private final Thread thread;
    private final Refresher refresher;
    private final long initialDelayMs;
    private final long periodicRefreshMs;
    private final long minTimeBetweenRefreshesMs;
    private boolean refreshNow = false;
    private boolean stopped = false;

    synchronized void stop() {
        this.stopped = true;
        this.notifyAll();
    }

    private long getRefreshIntervalMs(boolean firstRefresh) {
        if (this.refreshNow) {
            return this.minTimeBetweenRefreshesMs;
        }
        if (firstRefresh) {
            return this.initialDelayMs;
        }
        return this.periodicRefreshMs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void mainLoop() {
        long lastRefreshTime = EnvironmentEdgeManager.currentTime();
        boolean firstRefresh = true;
        while (true) {
            RegistryEndpointsRefresher registryEndpointsRefresher = this;
            synchronized (registryEndpointsRefresher) {
                while (true) {
                    if (this.stopped) {
                        LOG.info("Registry end points refresher loop exited.");
                        return;
                    }
                    long waitTime = this.getRefreshIntervalMs(firstRefresh) - (EnvironmentEdgeManager.currentTime() - lastRefreshTime);
                    if (waitTime <= 0L) {
                        firstRefresh = false;
                        this.refreshNow = false;
                        // MONITOREXIT @DISABLED, blocks:[3, 6, 7, 8] lbl15 : MonitorExitStatement: MONITOREXIT : var4_3
                        LOG.debug("Attempting to refresh registry end points");
                        try {
                            this.refresher.refresh();
                        }
                        catch (IOException e) {
                            LOG.warn("Error refresh registry end points", (Throwable)e);
                        }
                        break;
                    }
                    try {
                        this.wait(waitTime);
                    }
                    catch (InterruptedException e) {
                        LOG.warn("Interrupted during wait", (Throwable)e);
                        Thread.currentThread().interrupt();
                    }
                }
            }
            lastRefreshTime = EnvironmentEdgeManager.currentTime();
            LOG.debug("Finished refreshing registry end points");
        }
    }

    private RegistryEndpointsRefresher(long initialDelayMs, long periodicRefreshMs, long minTimeBetweenRefreshesMs, Refresher refresher) {
        this.initialDelayMs = initialDelayMs;
        this.periodicRefreshMs = periodicRefreshMs;
        this.minTimeBetweenRefreshesMs = minTimeBetweenRefreshesMs;
        this.refresher = refresher;
        this.thread = new Thread(this::mainLoop);
        this.thread.setName("Registry-endpoints-refresh-end-points");
        this.thread.setDaemon(true);
        this.thread.start();
    }

    synchronized void refreshNow() {
        this.refreshNow = true;
        this.notifyAll();
    }

    static RegistryEndpointsRefresher create(Configuration conf, String initialDelaySecsConfigName, String intervalSecsConfigName, String minIntervalSecsConfigName, Refresher refresher) {
        long periodicRefreshMs = TimeUnit.SECONDS.toMillis(conf.getLong(intervalSecsConfigName, 300L));
        if (periodicRefreshMs <= 0L) {
            return null;
        }
        long initialDelayMs = Math.max(1L, TimeUnit.SECONDS.toMillis(conf.getLong(initialDelaySecsConfigName, periodicRefreshMs / 10L)));
        long minTimeBetweenRefreshesMs = TimeUnit.SECONDS.toMillis(conf.getLong(minIntervalSecsConfigName, 60L));
        Preconditions.checkArgument((minTimeBetweenRefreshesMs < periodicRefreshMs ? 1 : 0) != 0);
        return new RegistryEndpointsRefresher(initialDelayMs, periodicRefreshMs, minTimeBetweenRefreshesMs, refresher);
    }

    @FunctionalInterface
    public static interface Refresher {
        public void refresh() throws IOException;
    }
}

